// QT includes
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qgroupbox.h>
#include <qlabel.h>

// KDE includes
#include <kdatepik.h>
#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>

#include "filterconfigdlg.h"

CFilterConfigDlg::CFilterConfigDlg(QWidget* parent, const char* name) : QDialog(parent, name)
{
  fUseFilterChkBox = new QCheckBox(i18n("Use Mail Filtering to..."), this, "UseFilterChkBox");
  fUseFilterChkBox->setGeometry(10, 10, 140, 20);
  connect(fUseFilterChkBox, SIGNAL( toggled(bool) ), this, SLOT( slotUseFilterToggled(bool) ));

  //  fFilterOptionsGrpBox = new QGroupBox(i18n("Filter Options"), this, "FilterOptionsGrpBox");
  //fFilterOptionsGrpBox->setGeometry(10, 30, 410, 135); 

  fCommand = new QComboBox(false, this, "Command");
  fCommand->setGeometry(15, 35, 100, 20);
  fCommand->insertItem(i18n("Delete"), COMBO_ID_DELETE);
  fCommand->insertItem(i18n("Ignore"), COMBO_ID_IGNORE);
  connect(fCommand, SIGNAL( activated(int) ), this, SLOT( slotCommandActivated(int) ));

  fStaticTextA = new QLabel(i18n("mail in which the"), this, "StaticTextA");
  fStaticTextA->setGeometry(15, 60, 100, 20);

  fField = new QComboBox(false, this, "Field");
  fField->setGeometry(15, 85, 100, 20);
  fField->insertItem(i18n("From"), COMBO_ID_FROM);
  fField->insertItem(i18n("Subject"), COMBO_ID_SUBJECT);
  fField->insertItem(i18n("Date"), COMBO_ID_DATE);
  connect(fField, SIGNAL( activated(int) ), this, SLOT( slotFieldActivated(int) ));

  fStaticTextB = new QLabel(i18n("field contains the text:"), this, "StaticTextB");
  fStaticTextB->setGeometry(15, 110, 140, 20);

  fContainingText = new QLineEdit(this, "ContainingText");
  fContainingText->setGeometry(15, 130, 210, 20);

  fStaticTextC = new QLabel(i18n("is"), this, "StaticTextC");
  fStaticTextC->setGeometry(230, 25, 20, 20);

  fDateOptions = new QComboBox(false, this, "DateOptions");
  fDateOptions->setGeometry(250, 25, 100, 20);
  fDateOptions->insertItem(i18n("Before"), COMBO_ID_BEFORE_DATE);
  fDateOptions->insertItem(i18n("After"), COMBO_ID_AFTER_DATE);
  fDateOptions->insertItem(i18n("Same as"), COMBO_ID_SAMEAS_DATE);

  fDatePicker = new KDatePicker(this);
  fDatePicker->setGeometry(230, 50, 190, 120);
  connect(fDatePicker, SIGNAL( dateSelected(QDate) ), this, SLOT( slotDateSelected(QDate) ));

  fSelectedDate = new QDate;

  init();
}

CFilterConfigDlg::~CFilterConfigDlg()
{
}

void CFilterConfigDlg::writeOptions()
{
  int month, day, year;
  KConfig* config = kapp->getConfig();
  QString dateString, string;

  config->setGroup("FILTER");
  
  config->writeEntry("UseFiltering", fUseFilterChkBox->isChecked());
  config->writeEntry("DateOption", fDateOptions->currentItem());
  config->writeEntry("Command", fCommand->currentItem());
  config->writeEntry("Field", fField->currentItem());
  config->writeEntry("ContainingText", fContainingText->text());

  month = fSelectedDate->month();
  day = fSelectedDate->day();
  year = fSelectedDate->year();

  string.sprintf("%d", year);
  dateString = string;

  if (month < 10)
    string.sprintf("0%d", month);
  else
    string.sprintf("%d", month);
  dateString += string;

  if (day < 10)
    string.sprintf("0%d", day);
  else
    string.sprintf("%d", day);
  dateString += string;

  config->writeEntry("SelectedDate", dateString);
}

void CFilterConfigDlg::init()
{
  QString dateString, yearString, dayString, monthString;
  
  KConfig* config = kapp->getConfig();

  config->setGroup("FILTER");
  
  fUseFilterChkBox->setChecked(config->readBoolEntry("UseFiltering", FALSE));
  fDateOptions->setCurrentItem(config->readNumEntry("DateOption", COMBO_ID_SAMEAS_DATE));
  fCommand->setCurrentItem(config->readNumEntry("Command", COMBO_ID_IGNORE));
  fField->setCurrentItem(config->readNumEntry("Field", COMBO_ID_FROM));
  fContainingText->setText(config->readEntry("ContainingText", ""));
  dateString = config->readEntry("SelectedDate", "");

  if (dateString.isEmpty())
    *fSelectedDate = QDate::currentDate();

  else
    {
      yearString = dateString.left(4);
      dateString = dateString.remove(0, 4);
      monthString = dateString.left(2);
      dateString = dateString.remove(0, 2);
      dayString = dateString;

      fSelectedDate->setYMD(yearString.toInt(), monthString.toInt(), dayString.toInt());
    }

  fDatePicker->setDate(*fSelectedDate);

  slotUseFilterToggled(fUseFilterChkBox->isChecked());
}

/////////////////////////////////////////
//////// SLOTS

void CFilterConfigDlg::slotUseFilterToggled(bool on)
{
  fDatePicker->setEnabled(on);
  fContainingText->setEnabled(on);
  fDateOptions->setEnabled(on);
  fStaticTextB->setEnabled(on);
  fStaticTextC->setEnabled(on);
  fStaticTextA->setEnabled(on);
  fCommand->setEnabled(on);
  fField->setEnabled(on);

  slotFieldActivated(fField->currentItem());
}

void CFilterConfigDlg::slotCommandActivated(int id)
{
}

void CFilterConfigDlg::slotFieldActivated(int id)
{
  fDatePicker->setEnabled(false);
  fContainingText->setEnabled(false);
  fDateOptions->setEnabled(false);
  fStaticTextB->setEnabled(false);
  fStaticTextC->setEnabled(false);
  
  if (fUseFilterChkBox->isChecked())
    {
      
      switch (id)
	{
	case COMBO_ID_FROM:
	case COMBO_ID_SUBJECT:
	  fContainingText->setEnabled( true );
	  fStaticTextB->setEnabled( true );
	  break;
	  
	case COMBO_ID_DATE:
	  fDatePicker->setEnabled( true );
	  fStaticTextC->setEnabled( true );
	  fDateOptions->setEnabled( true );
	  break;
	}
    }
}

void CFilterConfigDlg::slotDateSelected(QDate date)
{
  *fSelectedDate = date;
}

#include "filterconfigdlg.moc"
