/***************************************************************************
                          resource.h  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : Sun Dec  6 16:24:51 EST 1998
                                           
    copyright            : (C) 1998 by Mike Pilone                         
    email                : mpilone@slac.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef RESSOURCE_H
#define RESSOURCE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qlist.h>
#include <qdatetime.h>

#include <kconfig.h>
#include <kapp.h>

#include "errordialog.h"

///////////////////////////////////////////////////////////////////
// resource.h  -- contains macros used for commands


///////////////////////////////////////////////////////////////////
// COMMAND VALUES FOR MENUBAR AND TOOLBAR ENTRIES


///////////////////////////////////////////////////////////////////
// File-menu entries
#define ID_FILE_QUIT                10010

///////////////////////////////////////////////////////////////////
// Options-menu entries
#define ID_OPTIONS_CONFIG           11010
#define ID_OPTIONS_MENUBAR          11020

///////////////////////////////////////////////////////////////////
// Commands-menu entries                    
#define ID_COMMANDS_FORCE_CHECK      12010
#define ID_COMMANDS_LAUNCH_APP       12020
#define ID_COMMANDS_DOCK             12030
#define ID_COMMANDS_ACTIVE_TOG       12040

///////////////////////////////////////////////////////////////////
// General application values
#define ID_APP_EXIT                 1000      
#define ID_HELP                     1001

#define IDS_DEFAULT                 "Ready."

#define IDS_APP_ABOUT               "KNewMail\nVersion " VERSION

///////////////////////////////////////////////////////////////////
// ToolBar position defines

//////////////////////////////////////////////////////////////////
// 'To:' field types
#define TO_TYPE_PARSED       0
#define TO_TYPE_ADDRESS      1
#define TO_TYPE_DISABLED     2

/////////////////////////////////////////////////////////////////
// Config dialog states
#define CONFIG_DIALOG_OPENED  0
#define CONFIG_DIALOG_CLOSED  1

/////////////////////////////////////////////////////////////////
// MAILBOX AND HEADER STRUCTS

// These are the commands you can do with the mailbox
#define MAILBOX_LIST_WRITE 0
#define MAILBOX_LIST_READ  1

// Possible types for a server
enum eServerType { ServerTypePop3 = 0, ServerTypeImap, ServerTypeLocal };

//Used to hold the mailbox information. Multiples of these 
//will be created and stroed in a qlist. 1 for each mailbox.
typedef struct ServerStruct
{
  QString address;
  QString username;
  QString password;
  QString folder;
  eServerType type;
  int port;
  int save;
  int index;
};

// Used to hold the header information. As the engine parses them,
// it will create one of these and store the information in a 
// QList.
typedef struct HeaderStruct
{
  QString subject;
  QString to;
  QString from;
  QString address;
  QDateTime datetime;
};

// Get the pointer to the error dialog
extern CErrorDialog *gErrorDialog;

//////////////////////////////////////////////////////
// ERROR MACRO 
// This macro allows for the displaying 
// of errors through out the program.
#define ERROR(error_message) gErrorDialog->displayError(error_message);
#define ERROR_FORCE_DISPLAY(error_message) gErrorDialog->displayError(error_message, TRUE);


///////////////////////////////////////////////////////////////////
// MACROS FOR THE CONNECT OF YOUR SIGNALS TO CORRESPONDENT SLOTS 
// IN YOUR MAIN IMPLEMENTATION OF MENUBAR AND TOOLBAR


///////////////////////////////////////////////////////////////////
// MENU CONNECTS
#define CONNECT_CMD(submenu)           connect(submenu, SIGNAL(activated(int)), SLOT(commandCallback(int)))


///////////////////////////////////////////////////////////////////
// TOOLBAR CONNECT  
#define CONNECT_TOOLBAR(ToolBar)        connect(ToolBar, SIGNAL(clicked(int)), SLOT(commandCallback(int)))


///////////////////////////////////////////////////////////////////
// MACROS FOR GENERATING THE SWITCH CONSTRUCTION OF THE commandCallback(int) METHOD


///////////////////////////////////////////////////////////////////
// Create class member in implementation for commandCallback
#define BEGIN_CMD(class)         void class::commandCallback(int id_){ switch (id_){

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them with their functions
#define ON_CMD(id, cmd_class_function)   case id:cmd_class_function;break;   

/////////////////////////////////////////////////////////////////// 
// End class member in implementation for commandCallback 
#define END_CMD()      }}


///////////////////////////////////////////////////////////////////
// MACROS FOR GENERATING THE SWITCH CONSTRUCTION OF THE statusCallback(int) METHOD

///////////////////////////////////////////////////////////////////
// Create class member in implementation for statusCallback
#define BEGIN_STATUS_MSG(class) void class::statusCallback(int id_){ switch (id_){

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them to change statusBar entry
#define ON_STATUS_MSG(id, message)     case id:  slotStatusHelpMsg(message);break;
 
///////////////////////////////////////////////////////////////////
// End class member in implementation for statusCallback
#define END_STATUS_MSG()         default: slotStatusMsg(IDS_DEFAULT); }}

#endif // RESOURCE_H









