// -*- C++ -*-

//
//  konserver
//
//  Copyright (C) 1998 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef global_included
#define global_included

#define KEEP_ALIVE_TIME 60

#define LL_LONG 4
#define LL_SHORT 2
#define LL_POINTER 4
#define LL_CHAR 1

#define MAX_MSG_LEN 790
#define MAX_QUEUED_MSG_LEN 256

/* client to server */
#define NEW_CLIENT 1
#define DEL_CLIENT 2
#define CONNECT 3
#define DISCONNECT 4
#define SEARCH_USER 5
#define ADD_WATCHLIST 6
#define REMOVE_WATCHLIST 7
#define SEND_MSG 8
#define CHANGE_CLIENT 9
#define GET_MSG 10
#define GET_USER_INFO 11
/* server to client */
#define USER_ONLINE 20
#define USER_OFFLINE 21
#define SERVER_SHUTDOWN 22
#define INCOMING_MESSAGE 23
#define STILL_ALIVE 24

/* return codes */
#define RE_OK 0
#define RE_FAILURE 1
#define RE_PROTOCOL 2          /* client does not use the right communication protocol */
#define RE_DUPKEY 3            /* couldn't insert new user due to duplicated key */
#define RE_COM 4               /* communication error */
#define RE_NOTFOUND 5          /* query couldn't find any user or no more users match the query */
#define RE_MSG_QUEUED 6        /* message not delivered but queued */
#define RE_MSG_DELIVERED 7     /* message delivered */
#define RE_RECV_BUF_EXCEEDED 8 /* client can't receive more messages at the moment */
#define RE_ACCESS_DENIED 9     /* client IP not accepted */
#define RE_PASSWD 10           /* wrong password */

#define SE_NAME 0
#define SE_NNAME 1
#define SE_EMAIL 2
#define SE_ID 3

/* UDP Packet types */
#define KEEP_ALIVE 0


/* -- NEW_CLIENT --
   String Name
   String VName
   String Nick
   String Email
   String passwd

   returns:
     RE_OK
     unsigned long Id
   or:
     RE_DUPKEY
 */

/* -- CHANGE_CLIENT --
   String passwd
   String Name
   String VName
   String Nick
   String Email
   String new_pass

   returns:
     RE_OK
   or:
     RE_FAILURE
   or:
     RE_DUPKEY
 */

/* -- DEL_CLIENT --
   String passwd

   returns:
     RE_OK
   or:
     RE_FAILURE
 */

/* -- SEARCH_USER --
   short primary_key (SE_NAME | SE_NNAME | SE_EMAIL | SE_ID)
   String Name
   String VName
   String Nick
   String Email
   unsigned long Id

   returns:
     RE_OK
     String Name
     String VName
     String Nick
     String Email
     unsigned long Id
     char  0 := is offline
           1 := is online
     RE_OK
     String Name
      .
      .
     unsigned long id
     char  0 := is offline
           1 := is online
     RE_NOTFOUND
   
   or:
     RE_NOTFOUND
 */

/* -- ADD_WATCHLIST --
   String passwd
   unsigned long id

   returns:
     RE_OK
   or:
     RE_FAILURE
 */

/* -- CONNECT --
   String passwd
   short port         // port of client listen socket

   returns:
     RE_OK
     String Name
     String VName
     String Nick
     String Email
     unsigned long Id
     RE_OK
     String Name
      .
      .
     unsigned long id
     RE_NOTFOUND

   or:
     RE_FAILURE
 */

/* -- DISCONNECT --
   String passwd

   returns:
     RE_OK

   or:
     RE_FAILURE
 */

/* -- REMOVE_WATCHLIST --
   String passwd
   unsigned long id

   returns:
     RE_OK
   or:
     RE_FAILURE
 */

/* -- SEND_MSG --
   unsigned long id
   String message
   String Date

   returns:
     RE_MSG_QUEUED
   or:
     RE_MSG_DELIVERED
 */

/* -- INCOMING_MESSAGE --
   String msg
   String Name
   String VName
   String Nick
   String Email
   String Date
   unsigned long Id   
 */

/* -- GET_MSG --
   no arguments

   returns:
     RE_OK
 */

/* -- STILL_ALIVE --
   from server to client;
   server didn't get any keep alive packages and checks whether 
   the client is still there

   no arguments

   client returns:
     RE_OK
     unsigned long Id
 */

/* -- GET_USER_INFO -- 
   String passwd
   unsigned long Id

   returns:
     RE_OK
     String Name
     String VName
     String Nick
     String Email
   or:
     RE_PASSWD
 */
  

#endif /* global_included */



