// -*- C++ -*-

//
//  konline
//
//  Copyright (C) 1998 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef konline_included
#define konline_included

#include <qapp.h>
#include <qwidget.h>
#include <qstring.h>
#include <qchkbox.h>
#include <qcombo.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qmenubar.h>
#include <qpushbt.h>
#include <qlayout.h>
#include <qtimer.h>
#include <qaccel.h>
#include <qcursor.h>
#include <qpopmenu.h>
#include <qtimer.h>

#include <kapp.h>
#include <ktopwidget.h>


class KProcess;
class KMenuBar;
class KToolBar;
class QStrList;
class QSocketNotifier;
class ConfDialog;
class RegisterUser;
class AddWatchList;
class MainRowTable;
class KHeader;
class SendMsg;
class RecvMsg;
class DetailsDialog;

#define MAX_RECV_WIN 5

class Konline : public KTopLevelWidget
{
  Q_OBJECT
public:
  Konline(const char* name=NULL);
  ~Konline();

public slots:
  void sendMsg(unsigned long id, QString n, QString fn, QString nn);

protected slots:
  void configureKOnline();
  void registerUser();
  void addWatchList();
  void serverConnect();
  void serverDisconnect();
  void dataReceived();
  void popupMenu();
  void sendMsg();
  //void sendEmail();
  void showDetails();
  void hideDetails();
  void removeList();
  void closeMsgWin( int win_id );
  void getMsg();
  void sendKeepAlive();

protected:
  void saveProperties(KConfig*);
  void setConnected( bool status );

  KMenuBar     *menubar;
  KToolBar     *toolbar;
  QFrame       *f_main;
  QPopupMenu   *popup_menu;
  QPopupMenu   *file;

  MainRowTable *lb_watchlist;
  KHeader      *h_list;
  QGridLayout  *top2bottom;
  ConfDialog   *conf_diag;
  AddWatchList *add_watch_list;
  RegisterUser *register_user;

  SendMsg       *send_msg;
  RecvMsg       *recv_msg[MAX_RECV_WIN];
  DetailsDialog *details;

  QString       passwd;
  int           connected;
  QSocketNotifier *notifier;
  QTimer       *keep_timer;
};

#endif /* konline_included */


