// -*- C++ -*-

//
//  konline
//
//  Copyright (C) 1998 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef messages_included
#define messages_included

#include <qdialog.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qmlined.h>

#include "users.h"
class DetailsDialog;

class SendMsg : public QDialog
{
  Q_OBJECT
public:
  SendMsg( QWidget *parent = 0, const char *name = 0 );
  virtual ~SendMsg();

  void setText( QString n ) { l_receiver->setText(n); }
  QString text() { return ml_message->text(); }
  
public slots:

protected slots:

protected:
  void resizeEvent(QResizeEvent *);

  QMultiLineEdit *ml_message;
  QLabel         *l_receiver;
  QPushButton    *b_ok;
  QPushButton    *b_cancel;
};



class RecvMsg : public QDialog
{
  Q_OBJECT
public:
  RecvMsg( short wid, QWidget *parent = 0, const char *name = 0 );
  virtual ~RecvMsg();

  void setRecv( const char *r) { l_receiver->setText(r); }
  void setMsg( const char *m) { ml_message->setText(m); }
  void setDate( const char *d) { l_date->setText(d); }
  void setInfo( const struct users *rec );

signals:
  void close(int);
  void reply(unsigned long, QString, QString, QString);

public slots:

protected slots:
  void okSlot() { emit close(win_id); }
  void showDetails();
  void hideDetails();
  void replySlot() { emit reply(user_data.id, user_data.name, user_data.fname, user_data.nname); }

protected:
  void resizeEvent(QResizeEvent *);

  QMultiLineEdit *ml_message;
  QLabel         *l_receiver;
  QLabel         *l_date;
  QPushButton    *b_details;
  QPushButton    *b_ok;
  QPushButton    *b_reply;
  short           win_id;

  DetailsDialog  *details;
  User            user_data;
};

class DetailsDialog : public QDialog
{
  Q_OBJECT
public:
  DetailsDialog( QWidget *parent = 0, const char *name = 0 );
  virtual ~DetailsDialog();

  void setInfo( User *user_data );
  void setInfo( unsigned long i, QString n, QString nn, QString fn, QString e);
signals:
  void close();

public slots:

protected slots:
  void okSlot() { emit close(); }

protected:
  QLabel      *l_name;
  QLabel      *l_id;
  QLabel      *l_email;
  QLabel      *l_nname;
  QLabel      *l_fname;
  QPushButton *b_ok;
};

#endif /* messages_included */
