// -*- C++ -*-

//
//  konserver
//
//  Copyright (C) 1998 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

extern "C" {
#include <string.h>
#include <typhoon.h>
}

#include <iostream.h>

#include "message.h"
#include "global.h"

#define errlog cerr

int MessageData::add( unsigned long send_id, unsigned long recv_id, const char *msg,
		      const char *date)
{
  short rcode;
  if( d_keyfind(USER_ID, &recv_id) != S_OKAY )
    {
      errlog << "can't find recv_id " << recv_id << endl;
      return -1;
    }
  unsigned long new_id;
  d_getsequence(UMSG_ID , &new_id);
  record.msg_id = new_id;
  record.send_id = send_id;
  record.recv_id = recv_id;
  strncpy(record.msg, msg, MAX_QUEUED_MSG_LEN);
  record.msg[MAX_QUEUED_MSG_LEN-1] = '\0';
  strncpy(record.date, date, 16);
  record.date[16] = '\0';
  if( (rcode = d_fillnew(MESSAGE, &record)) != S_OKAY )
    {
      errlog << "can't add record CODE: " << rcode << endl;
      return -1;
    }
  return S_OKAY;
}

int MessageData::remove( unsigned long msg_id )
{
  short rcode;
  if( d_keyfind(MSG_ID, &msg_id) != S_OKAY )
    {
      errlog << "can't find msg_id " << msg_id << endl;
      return -1;
    }
  if( (rcode = d_delete()) != S_OKAY )
    {
      errlog << "can't remove record CODE: " << rcode << endl;
      return rcode;
    }
  return S_OKAY;
}

int MessageData::firstMsg( unsigned long recv_id, unsigned long *send_id, MyString *msg,
			   unsigned long *msg_id, MyString *date)
{
  if( d_keyfind(RECV_ID, &recv_id) != S_OKAY )
    return S_NOTFOUND;
  else
    {
      d_recread(&record);
      *send_id = record.send_id;
      *msg = record.msg;
      *date = record.date;
      *msg_id = record.msg_id;
    }
  return S_OKAY;
}

int MessageData::nextMsg( unsigned long recv_id, unsigned long *send_id, MyString *msg, 
			  MyString *date )
{

}

int MessageData::removeAll( unsigned long recv_id )
{
  if( d_keyfind(RECV_ID, &recv_id) == S_OKAY )
    {
      do {
	d_recread(&record);
	if( record.recv_id != recv_id )
	  break;
	d_delete();
      } while( d_keynext(RECV_ID) );
      return S_OKAY;
    }
  else
    return S_NOTFOUND;
}
