// -*- C++ -*-

//
//  konserver
//
//  Copyright (C) 1997 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef users_included
#define users_included

//#include <string.h>
#include "mystring.h"
#include <typhoon.h>
#include "konline.h"

class User
{
public:
  User() {}
  ~User() {}

  unsigned long id;
  MyString name;
  MyString vname;
  MyString nick;
  MyString date;
  MyString email;
  MyString passwd;
};

class UserData
{
public:
  UserData();
  ~UserData();

  int checkId(unsigned long id);
  int findId(User *rec, unsigned long id);
  int findName(User *rec, MyString name);
  int findNick(User *rec, MyString nick);
  int findEmail(User *rec, MyString email);
  int findNext(User *rec, int key, MyString kvalue);
  int getFirst(User *rec);
  int getNext(User *rec);
  int add(User *rec);
  int changeRec(User *rec);
  int remove(unsigned long id);
  int checkPasswd(unsigned long id, MyString passwd);

protected:
  struct users record;

};

#endif /* users_included */
