// -*- C++ -*-

//
//  konserver
//
//  Copyright (C) 1997 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

extern "C" {
#include <string.h>
#include <typhoon.h>
}

#include <iostream.h>

#include "watch.h"

#define errlog cerr

int WatchData::add(unsigned long wuser_id, unsigned long watch_id)
{
  short rcode;
  if( d_keyfind(USER_ID, &watch_id) != S_OKAY )
    {
      errlog << "can't find watch_id " << watch_id << endl;
      return -1;
    }
  record.wuser_id = wuser_id;
  record.watch_id = watch_id;
  if( (rcode = d_fillnew(WATCH, &record)) != S_OKAY )
    {
      errlog << "can't add record CODE: " << rcode << endl;
      if( rcode == S_DUPLICATE )
	return S_OKAY;
      return -1;
    }
  return S_OKAY;
}

int WatchData::remove(unsigned long wuser_id, unsigned long watch_id)
{
  short rcode;
  struct watch_key key;
  key.wuser_id = wuser_id;
  key.watch_id = watch_id;
  if( d_keyfind(WATCH_KEY, &key) != S_OKAY )
    {
      errlog << "can't find watch_id " << watch_id << endl;
      return -1;
    }
  if( (rcode = d_delete()) != S_OKAY )
    {
      errlog << "can't remove record CODE: " << rcode << endl;
      return rcode;
    }
  return S_OKAY;
}

int WatchData::firstWUserId(unsigned long cid, unsigned long *id)
{
  if( d_keyfind(WUSER_ID, &cid) != S_OKAY )
    return S_NOTFOUND;
  else
    {
      d_recread(&record);
      *id = record.watch_id;
    }
  return S_OKAY;
}

int WatchData::nextWUserId(unsigned long cid, unsigned long *id)
{
  if( d_keynext(WUSER_ID) != S_OKAY )
    return S_NOTFOUND;
  else
    {
      d_recread(&record);
      if( record.wuser_id != cid )
	return S_NOTFOUND;
      *id = record.watch_id;
    }
  return S_OKAY;
}

int WatchData::firstWatchId(unsigned long cid, unsigned long *id)
{
  if( d_keyfind(WATCH_ID, &cid) != S_OKAY )
    return S_NOTFOUND;
  else
    {
      d_recread(&record);
      *id = record.wuser_id;
    }
  return S_OKAY;
}

int WatchData::nextWatchId(unsigned long cid, unsigned long *id)
{
  if( d_keynext(WATCH_ID) != S_OKAY )
    return S_NOTFOUND;
  else
    {
      d_recread(&record);
      if( record.watch_id != cid )
	return S_NOTFOUND;
      *id = record.wuser_id;
    }
  return S_OKAY;
}

int WatchData::removeAll( unsigned long id )
{
  // wuser_id
  if( d_keyfind(WUSER_ID, &id) == S_OKAY )
    {
      do {
	d_recread(&record);
	if( record.wuser_id != id )
	  break;
	d_delete();
      } while( d_keynext(WUSER_ID) );
    }
  else
    return S_NOTFOUND;
  // watch_id
  if( d_keyfind(WATCH_ID, &id) == S_OKAY )
    {
      do {
	d_recread(&record);
	if( record.watch_id != id )
	  break;
	d_delete();
      } while( d_keynext(WATCH_ID) );
      return S_OKAY;
    }
  else
    return S_NOTFOUND;
}
