/**********************************************************************

	--- Qt Architect generated file ---

	File: PrintManager.cpp
	Last generated: Mon May 17 10:28:01 1999

 *********************************************************************/

#include <qstrlist.h>
#include <kapp.h>
#include "PrintManager.h"
#include "printsettings.h"

#define Inherited PrintManagerData

PrintManager::PrintManager(QWidget* parent,const char* name):
	Inherited( parent, name )
{
	// connect the internal buttons to special signals
	connect(printButton,SIGNAL(clicked()), 						this, SIGNAL(signalPrint()));
	connect(previewButton,SIGNAL(clicked()), 					this, SIGNAL(signalPreview()));
	connect(quitButton,SIGNAL(clicked()), 						this, SIGNAL(signalQuit()));
	connect(changeFileButton,SIGNAL(clicked()), 			this, SIGNAL(signalChangeFile()));
	connect(optionsButton,SIGNAL(clicked()), 					this, SIGNAL(signalOptions()));
	connect(aboutButton,SIGNAL(clicked()), 						this, SIGNAL(signalAbout()));

	// connect internal toggles to slots	
	connect(printerSelect,SIGNAL(activated(int)), 		this, SLOT(slotPrinterChanged(int)));
	connect(paperSelect,SIGNAL(activated(int)), 			this, SLOT(slotPaperChanged(int)));
	connect(fromPage,SIGNAL(valueChanged(int)), 			this, SLOT(slotFromPage(int)));
	connect(toPage,SIGNAL(valueChanged(int)), 				this, SLOT(slotToPage(int)));
	connect(signatureSpin,SIGNAL(valueChanged(int)), 	this, SLOT(slotSignature(int)));
	
	connect(orderGroup,SIGNAL(clicked(int)), 					this, SLOT(slotReverseOrder(int)));
	connect(bookGroup,SIGNAL(clicked(int)), 					this, SLOT(slotBook(int)));
	connect(pagesPerSheetGroup,SIGNAL(clicked(int)), 	this, SLOT(slotPagesPerSheet(int)));
	connect(pageSettingsGroup,SIGNAL(clicked(int)), 	this, SLOT(slotPageSettings(int)));

}

void PrintManager::registerHandler(PrintSettings *s)
{
	settings = s;
	slotWorkFileChanged(settings->getWorkFile());
	slotPrinterListChanged(settings->getPrinterStrList());
	slotPaperListChanged(settings->getPaperStrList());
	paperSelect->setCurrentItem(settings->getPaperNo());
	printerSelect->setCurrentItem(settings->getPrinterNo());
	
	// connect PrintSettings to PrintManager
	connect(settings,SIGNAL(workFileChanged(const QString&)),
					this, SLOT(slotWorkFileChanged(const QString&)));
	connect(settings,SIGNAL(printerListChanged(const QStrList&)),
					this, SLOT(slotPrinterListChanged(const QStrList&)));
	//connect(settings,SIGNAL(paperListChanged(const QStrList&)),
	//				this, SLOT(slotPaperListChanged(const QStrList&)));
	//connect(settings,SIGNAL(paperChanged(int)),
	//				this, SLOT(slotPaperChanged(int)));
	//connect(settings,SIGNAL(printerChanged(int)),
	//				this, SLOT(slotPrinterChanged(int)));
}

PrintManager::~PrintManager()
{
}

void PrintManager::slotWorkFileChanged(const QString& wf)
{
	QString s = i18n("File: ") + wf;
	workFileLabel->setText(s);
}

void PrintManager::slotPrinterListChanged(const QStrList& strlist)
{
	printerSelect->clear();
	printerSelect->insertStrList(&strlist);
}

void PrintManager::slotPaperListChanged(const QStrList& strlist)
{
	paperSelect->clear();
	paperSelect->insertStrList(&strlist);
}

void PrintManager::slotPaperChanged(int p)
{
	if (p >= paperSelect->count())
		p = 0;
		
	paperSelect->setCurrentItem(p);
	if (settings)
		settings->slotSetPaper(p);
}

void PrintManager::slotPrinterChanged(int p)
{
	if (p >= printerSelect->count())
		p = 0;
	
	printerSelect->setCurrentItem(p);
		
	if (settings)
		settings->slotSetPrinter(p);
}

void PrintManager::slotReverseOrder(int o)
{
	if (settings)
		settings->slotSetReverseOrder(reverseOrderCheck->isChecked());
}

void PrintManager::slotBook(int b)
{
	if (settings)
		settings->slotSetBook(bookCheck->isChecked());
}

void PrintManager::slotPagesPerSheet(int p)
{
	PrintSettings::PagesPerSheet pps;
	switch (p)
	{
		case 0: pps = PrintSettings::one; 	break;
		case 1: pps = PrintSettings::two; 	break;
		case 2: pps = PrintSettings::four;	break;
		default: pps = PrintSettings::one;
	}
	if (settings)
		settings->slotSetPagesPerSheet(pps);
}

void PrintManager::slotPageSettings(int p)
{
	PrintSettings::PageSelect ps;
	switch (p)
	{
		case 0: ps = PrintSettings::all; 	break;
		case 1: ps = PrintSettings::even;	break;
		case 2: ps = PrintSettings::odd; 	break;
		default: ps = PrintSettings::all;
	}
	if (settings)
		settings->slotSetPageSelect(ps);
}

void PrintManager::slotSignature(int s)
{
	if (settings)
		settings->slotSetSignature(s);
}

void PrintManager::slotFromPage(int f)
{
	if (settings)
		settings->slotSetFromPage(f);
}

void PrintManager::slotToPage(int t)
{
	if (settings)
		settings->slotSetToPage(t);
}














