/***************************************************************************
                          main.cpp  -  description                              
                             -------------------                                         
    begin                : Tue May 18 16:19:15 MEST 1999
                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <unistd.h>
#include <stdlib.h>
#include "kprima.h"

int main(int argc, char* argv[])
{
	char c;
	QString version = 0;
  KApplication app(argc,argv,"kprima");
 
  if (app.isRestored())
	{
		RESTORE(KPriMaApp);
	}
  else 
  {
		KPriMaApp* kprima = new KPriMaApp;
    debug("Arguments: %d",argc);

		while ( ( c = getopt (argc, argv, "vhP:p:")) != -1)
 		{
			switch (c)
			{
  			case 'h':
					debug("usage: kprima [ [-P Printer] [-p Paper] file ]");
					exit(1);
				case 'P':
					kprima->setDefaultPrinter(atoi(optarg)); break;
				case 'p':
					kprima->setDefaultPaper(atoi(optarg)); break;
				case '?': break;
				case 'v':
					version = "KPriMa v";
					version += (QString) VERSION;
					debug("%s Copyright 1999 Torsten Uhlmann.\n"
								"TUhlmann@gmx.de", version.data());
					exit(1); break;
				default: exit(1);
			}
		}
		if( optind < argc )
		{
			kprima->slotSetWorkFile(argv[optind]);
		} else {
    	kprima->slotFileOpen();
  	}
		kprima->show();
	}
	return app.exec();
}  
 








