#include <qpushbutton.h>
#include <kapp.h>
#include "MimeDlg.h"
#include <iostream.h>

MimeDlg::MimeDlg(KMimeExtension *ext, bool ro, QWidget *parent, const char *name)
	: QDialog(parent->parentWidget()->parentWidget(),name,TRUE)
{
	setCaption(i18n("Mime type properties"));

	QLabel	*lab1 = new QLabel(i18n("Extensions :"),this);
	lab1->setGeometry(10,10,80,25);
	QLabel	*lab2 = new QLabel(i18n("Description :"),this);
	lab2->setGeometry(10,45,80,25);
	QLabel	*lab3 = new QLabel(i18n("Application :"),this);
	lab3->setGeometry(10,80,80,25);
	QLabel	*lab4 = new QLabel(i18n("Icon :"),this);
	lab4->setGeometry(10,115,80,25);
	QLabel	*lab5 = new QLabel(i18n("Mime type :"),this);
	lab5->setGeometry(10,150,80,25);
	QLabel	*lab6 = new QLabel(i18n("File name :"),this);
	lab6->setGeometry(10,185,80,25);

	InShell = new QCheckBox(i18n("open in terminal"),this);
	InShell->setGeometry(10,220,200,30);
	Extensions = new QLineEdit(this);
	Extensions->setGeometry(100,10,0,0);
	Description = new QLineEdit(this);
	Description->setGeometry(100,45,0,0);
	Application = new QLineEdit(this);
	Application->setGeometry(100,80,0,0);
	Icon = new QLineEdit(this);
	Icon->setGeometry(100,115,140,25);
	MimeName = new QLineEdit(this);
	MimeName->setGeometry(100,150,0,0);
	FileName = new QLineEdit(this);
	FileName->setGeometry(100,185,0,0);

	ok = new QPushButton(i18n("Ok"),this);
	ok->setGeometry(0,0,80,30);
	connect(ok,SIGNAL(clicked()),SLOT(accept()));

	cancel = new QPushButton(i18n("Cancel"),this);
	cancel->setGeometry(0,0,80,30);
	connect(cancel,SIGNAL(clicked()),SLOT(reject()));

	if (ext) {
		QString		extStr;
		QStrListIterator	it(ext->Extensions);
		for (;it.current();++it) {extStr += it.current(); extStr += ";";}
		Extensions->setText(extStr.data());
		Description->setText(ext->Description.data());
		Application->setText(ext->Application.data());
		Icon->setText(ext->MimeIcon.data());
		MimeName->setText(ext->MimeName.data());
		FileName->setText(ext->FileName.data());
		InShell->setChecked(ext->inShell);
	}

	if (ro) {
/*		Extensions->setEnabled(FALSE);
		Description->setEnabled(FALSE);
		Application->setEnabled(FALSE);
		Icon->setEnabled(FALSE);
		MimeName->setEnabled(FALSE);
		FileName->setEnabled(FALSE);
		InShell->setEnabled(FALSE);*/
		ok->setEnabled(FALSE);
	}

	resize(300,300);
	setMaximumSize(800,300);
	setMinimumSize(250,300);
}

MimeDlg::~MimeDlg()
{
}

void MimeDlg::resizeEvent(QResizeEvent *)
{
	Extensions->resize(width()-110,25);
	Description->resize(width()-110,25);
	Application->resize(width()-110,25);
	Icon->resize(width()-110,25);
	MimeName->resize(width()-110,25);
	FileName->resize(width()-110,25);
	ok->move(width()-230,height()-40);
	cancel->move(width()-140,height()-40);
}
