#ifndef _OPTIONSVIEW_H_
#define _OPTIONSVIEW_H_

#include <qwidget.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>

#include "protocol.h"

class OptionsView : public QWidget
{
	Q_OBJECT;

public:
	OptionsView(QWidget *parent = 0, const char *name = 0);
	virtual ~OptionsView();

	void setProtList(SubProtList *list);
	void getProtList(SubProtList *list);

protected slots:
	void addClicked();
	void deleteClicked();
	void saveChanged(int);

protected:
	void resizeEvent(QResizeEvent*);

public:
	QListView	*ListView;
	QLineEdit	*Pattern;
	QComboBox	*ProtType;
	QComboBox	*SavingPolicy;
	QCheckBox	*ImageSaveIfSize;
	QLineEdit	*ImageSize;
	bool		Modified;
	QGroupBox	*group1, *group2;
	QLabel		*lab[4];
	QPushButton	*add, *del;
};

#endif