#include "bookm.h"

#include <qfile.h>
#include "mystrlist.h"

void BookmarkDir::save(QTextStream& t)
{
	t << "dir," << Name << ',' << endl;
	for (Childs.first();Childs.current();Childs.next()) Childs.current()->save(t);
	t << "enddir," << endl;
}

bool loadBookmarkFile(const char* filename, BookmarkBase* root)
{
	QFile	f(filename);
	if (!f.exists() || !f.open(IO_ReadOnly)) return false;
	QTextStream	t(&f);
	QString		Buffer, Word;
	MyStrList	list;
	BookmarkBase*	current = root;
	while (!t.eof()) {
		Buffer = t.readLine().data();
		int	p1(0), p2(0);
		list.clear();
		while ((p2=Buffer.find(',',p1)) != -1) {
			list.append(Buffer.mid(p1,p2-p1).data());
			p1 = (p2+1);
		}
		Word = list.first();
		if (Word == "dir")
			current = new BookmarkDir(current,list.at(1));
		else if (Word == "enddir")
			if (current->Parent) current = current->Parent;
			else return false;	// corrupted bookmark file
		else if (Word == "bookmark")
			new BookmarkUrl(list.at(1),current,list.at(2),QString(list.at(3)).toInt(),list.at(4),QString(list.at(5)).toInt());
		else return false;	// corrupted bookmark file
	}
	f.close();
	return true;
}

bool saveBookmarkFile(const char* filename, BookmarkBase* root)
{
	QFile	f(filename);
	if (!f.exists() || !f.open(IO_WriteOnly)) return false;
	QTextStream	t(&f);
	for (root->Childs.first();root->Childs.current();root->Childs.next()) root->Childs.current()->save(t);
	f.close();
	return true;
}
