#include "dircombo.h"
#include <qpainter.h>
#include <qdrawutil.h>
#include <qapplication.h>

ListBoxItem::ListBoxItem(const char *name, QPixmap *pm, int depth)
	: QListBoxItem(), Icon(pm), Depth(depth)
{
	setText(name);
}

int ListBoxItem::height(const QListBox *lb) const
{ return ICON_HEIGHT;}

int ListBoxItem::width(const QListBox *lb) const
{ return (Depth+1)*ICON_HEIGHT + lb->fontMetrics().width(text()) + 4;}

void ListBoxItem::paint(QPainter *p)
{
	p->fillRect(p->viewport(),p->backgroundColor());
	int	offset = Depth * ICON_HEIGHT;
	if (Icon) p->drawPixmap(offset+1,1,*Icon);
	p->drawText(offset+ICON_HEIGHT+3,0,p->fontMetrics().width(text())+2,ICON_HEIGHT,AlignLeft | AlignVCenter,text());
}

//---------------------------------------------------------------------------------------------------------

DirCombo::DirCombo(QWidget *parent, const char *name)
	: QComboBox(parent,name)
{
	setStyle(WindowsStyle);
	ListBox = new DirList(this);
//	ListBox->setBackgroundColor(white);
	setListBox(ListBox);
}

void DirCombo::insertItem(const char *name, QPixmap *pm, int depth)
{
	ListBoxItem	*item = new ListBoxItem(name,pm,depth);
	ListBox->insertItem(item);
}

void DirCombo::setCurrentItem(int index)
{
	ListBox->setCurrentItem(index);
	QComboBox::setCurrentItem(index);
	if (index == 0) update();
}

void DirCombo::paintEvent(QPaintEvent *e)
{
	QPainter p( this );
 	if ( e ) p.setClipRect( e->rect() );
	QColorGroup g  = colorGroup();

	if ( width() < 5 || height() < 5 ) {
		QBrush fill( g.background() );
		qDrawShadePanel( &p, rect(), g, FALSE, 2, &fill );
		return;
	}

	QColor bg = isEnabled() ? g.base() : g.background();
	ListBoxItem	*item = (ListBoxItem*)(ListBox->currentItem());
	const char *str = (item ? item->text() : 0);

	QBrush fill( bg );
	qDrawWinPanel( &p, 0, 0, width(), height(), g, TRUE, &fill );

	QRect arrowR = QRect(width()-2-16,2,16,height()-4);
	qDrawWinPanel(&p, arrowR, g, FALSE );
	qDrawArrow( &p, DownArrow, WindowsStyle, FALSE,
		    arrowR.x() + 2, arrowR.y() + 2,
		    arrowR.width() - 4, arrowR.height() - 4, g , TRUE);

	QRect textR( 5, 4, width()  - 5 - 4 - arrowR.width(),
		     height() - 4 - 4 );
 	QRect textR_t( ICON_HEIGHT + 5, 4, width() - ICON_HEIGHT - 5 - 4 - arrowR.width(),
		     height() - 4 - 4 );

	if ( hasFocus() ) {
	    QBrush fill( QApplication::winStyleHighlightColor() );
	    p.fillRect( textR.x()-1, textR.y(),
			textR.width(), textR.height(), fill );
	    p.drawWinFocusRect( textR.x()-2, textR.y()-1,
				textR.width()+2, textR.height()+2, backgroundColor() );
	}

	p.setClipRect( textR );

	if ( hasFocus() ) {
	    p.setPen( white );
	    p.setBackgroundColor( QApplication::winStyleHighlightColor() );
	} else {
	    p.setPen( g.text() );
	    p.setBackgroundColor( bg );
	}
	if ( str ) {
	    p.drawText( textR_t, AlignLeft | AlignVCenter | SingleLine, str);
	    if (item->icon()) p.drawPixmap(4,(height()-ICON_HEIGHT+2)/2,*(item->icon()));
	} else {
	    const QPixmap *pix = ListBox->pixmap( ListBox->current() );
	    if ( pix )
		p.drawPixmap( 4, (height()-pix->height())/2, *pix );
	}
	p.setClipping( FALSE );
}
