#include "kdetaillist.h"
#include <iostream.h>
#include <kapp.h>
#include <qkeycode.h>
#include <qpopupmenu.h>

#ifndef ICON_HEIGHT
#define ICON_HEIGHT	18
#endif

KDetailList::KDetailList(int format, bool selectionMode, QWidget *parent, const char *name, WFlags f)
	: KFileListBase(parent,name,f)
{
	setTableFlags(Tbl_hScrollBar | Tbl_vScrollBar | Tbl_smoothScrolling);
	setLineWidth(1);
	setFrameStyle(QFrame::Panel | QFrame::Sunken);
	setNumRows(0);
	setCellHeight(ICON_HEIGHT);
	setCellWidth(0);
	DateFormat = format;
	SelectionMode=selectionMode;
	createConnectHeader();
	QObject::connect((const QObject*)horizontalScrollBar(),SIGNAL(sliderPressed()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)horizontalScrollBar(),SIGNAL(nextLine()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)horizontalScrollBar(),SIGNAL(prevLine()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)horizontalScrollBar(),SIGNAL(nextPage()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)horizontalScrollBar(),SIGNAL(prevPage()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)verticalScrollBar(),SIGNAL(sliderPressed()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)verticalScrollBar(),SIGNAL(nextLine()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)verticalScrollBar(),SIGNAL(prevLine()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)verticalScrollBar(),SIGNAL(nextPage()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)verticalScrollBar(),SIGNAL(prevPage()),(const QObject*)this,SLOT(cancelEdit()));
	QObject::connect((const QObject*)horizontalScrollBar(),SIGNAL(sliderMoved(int)),(const QObject*)this,SIGNAL(hScroll(int)));
	QObject::connect((const QObject*)horizontalScrollBar(),SIGNAL(valueChanged(int)),(const QObject*)this,SIGNAL(hScroll(int)));

	mainPop = new QPopupMenu;
	modPop = new QPopupMenu;
	connect(modPop,SIGNAL(activated(int)),SLOT(modifyColumn(int)));
	insPop = new QPopupMenu;
	connect(insPop,SIGNAL(activated(int)),SLOT(insertColumn(int)));
	mainPop->insertItem(i18n("Modify column"),modPop);
	mainPop->insertItem(i18n("Insert column"),insPop);
	mainPop->insertSeparator();
	mainPop->insertItem(i18n("Remove column"),this,SLOT(removeColumn()));
	mainPop->insertSeparator();
	datePop = new QPopupMenu;
	connect(datePop,SIGNAL(activated(int)),SLOT(changeDateFormat(int)));
	mainPop->insertItem(i18n("Change Date Format"), datePop);
	datePop->insertItem(i18n("Date & Time"), 0);
	datePop->insertItem(i18n("Date"), 1);
	datePop->insertItem(i18n("Time"), 2);
	datePop->insertItem(i18n("Condensed"), 3);
	datePop->insertItem(i18n("ISO Format"), 4);
	datePop->insertItem(i18n("Adapted"), 5);
	selectionPop = new QPopupMenu;
	connect(selectionPop,SIGNAL(activated(int)),SLOT(changeSelectionMode(int)));
	mainPop->insertSeparator();
	mainPop->insertItem(i18n("Change Selection Mode"), selectionPop);
	selectionPop->insertItem(i18n("Via name column"),0);
	selectionPop->insertItem(i18n("Via complete row"),1);
}

KDetailList::~KDetailList()
{
	delete Header;
	delete mainPop;
	delete modPop;
	delete insPop;
	delete datePop;
	delete selectionPop;
}

void KDetailList::setColumnWidth(int col, int , int w)
{
	int	actualCol = Header->mapToActual(col);
	cancelEdit();
	ColWidth[actualCol] = w;
	updateTableSize();
	update(Header->cellPos(actualCol)-Header->offset(),Header->height(),-1,-1);
	emit detailPropertiesChanged();
}

void KDetailList::generateDateString(QString& dateString, QDateTime dateTime)
{
			switch (DateFormat) {
			   case 0: dateString = dateTime.toString(); break;
			   case 1: dateString = dateTime.date().toString(); break;
			   case 2: dateString = dateTime.time().toString(); break;
#define	ItemDate	dateTime.date()
#define	ItemTime	dateTime.time()
			   case 3: {
				dateString.sprintf("%.2d/%.2d/%.4d %.2d:%.2d",ItemDate.day(),ItemDate.month(),ItemDate.year(),ItemTime.hour(),ItemTime.minute()); break;
			   }
			   case 4: dateString.sprintf("%.4d-%.2d-%.2d %.2d:%.2d",ItemDate.year(),ItemDate.month(),ItemDate.day(),ItemTime.hour(),ItemTime.minute()); break;
			   case 5: {
				QDate	toDay = QDate::currentDate();
				if (ItemDate.daysTo(toDay) < 6) {
					dateString.sprintf("%s %.2d:%.2d",ItemDate.dayName(ItemDate.dayOfWeek()),ItemTime.hour(),ItemTime.minute());
				}
				else if (ItemDate.daysTo(toDay) < 365) {
					dateString.sprintf("%s %.2d %.2d:%.2d",ItemDate.monthName(ItemDate.month()),ItemDate.day(),ItemTime.hour(),ItemTime.minute());
				}
				else dateString.sprintf("%s %.2d %.4d",ItemDate.monthName(ItemDate.month()),ItemDate.day(),ItemDate.year());
				break;
			   }
#undef	ItemDate
#undef	ItemTime
			}
}

void KDetailList::paintCell(QPainter *p, int row, int col)
{
	if (row == 0) return;
	int		index = row-1;
	FileInfo	*item = index < (int)(FileList->count()) ? FileList->at(index) : 0;
	if (item) {
		bool	needHighlight = (item == TargetItem || Selected->findRef(item) != -1);
		bool	useFocus = (item == TargetItem || hasFocus());
		int	w;
		QString	tmp;
		if (SelectionMode && needHighlight) {
			if (useFocus) p->fillRect(0,0,ColWidth[col],ICON_HEIGHT,QApplication::winStyleHighlightColor());
			p->setPen((useFocus ? white : colorGroup().text()));
		}
		else p->setPen(colorGroup().text());
		switch (ColType[col]) {
		   case 0:
			w = QMIN(cellHeight()+fontMetrics().width(item->fileName().data())+4,ColWidth[col]);
			if (needHighlight) {
				if (useFocus)
					p->fillRect(0,0,w,ICON_HEIGHT,QApplication::winStyleHighlightColor());
				p->setPen((useFocus ? white : colorGroup().text()));
				p->drawText(ICON_HEIGHT,0,w-ICON_HEIGHT-4,ICON_HEIGHT,AlignVCenter,getTruncatedString(item->fileName(),p,ColWidth[col]-ICON_HEIGHT-4).data());
				p->setPen(colorGroup().text());
				p->drawRect(0,0,w,ICON_HEIGHT);
			}
			else p->drawText(ICON_HEIGHT,0,w-ICON_HEIGHT-4,ICON_HEIGHT,AlignVCenter,getTruncatedString(item->fileName(),p,ColWidth[col]-ICON_HEIGHT-4).data());
			if (item->isCutted()) {
				QPixmap	pix(*(item->miniIcon()));
				QPainter	painter(&pix);
				painter.fillRect(0,0,pix.width(),pix.height(),QBrush(colorGroup().base(),Dense4Pattern));
				painter.end();
				p->drawPixmap(1,1,pix);
			}
			else p->drawPixmap(1,1,*(item->miniIcon()));
			if (item->isSymLink() && LinkArrow) {
				p->drawPixmap(1,1,*LinkArrow);
			}
			p->setPen(colorGroup().text());
			break;
		   case 1:
//			tmp.setNum(item->size());
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,processSize(item->size()).data());
			break;
		   case 2:
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,item->description());
			break;
		   case 3: {
			QString		date("N/A");
			if (!item->lastModified().isNull()) generateDateString(date, item->lastModified());
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,date.data());
			break;
		   }
		   case 4: {
			int	w = QMAX(p->fontMetrics().width("w"),p->fontMetrics().width("-"))+1;
			int	x = ColWidth[col]-5;
			for (int i=8;i>=0;i--) {
				x -= w;
				if (x >= 0) p->drawText(x,0,w,ICON_HEIGHT,AlignCenter,item->permissions().mid(i,1).data());
			}
			break;
		   }
		   case 5:
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,item->owner());
			break;
		   case 6:
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,item->group());
			break;
		   case 7: {
			QString		date("N/A");
			if (!item->lastAccessed().isNull()) generateDateString(date, item->lastAccessed());
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,date.data());
			break;
		   }
		   case 8:
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,item->device().data());
			break;
		   case 9: {
			QString		num;
			num.sprintf("%o",item->mode());
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,num.data());
			break;
		   }
		   case 10: {
			QString		num;
			if (item->gid() < 0) num = "N/A";
			else num.sprintf("%d",item->gid());
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,num.data());
			break;
		   }
		   case 11: {
			QString		num;
			if (item->uid() < 0) num = "N/A";
			else num.sprintf("%d",item->uid());
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,num.data());
			break;
		   }
		   case 12: {
			QString		num;
			num.sprintf("%d",item->size());
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,num.data());
			break;
		   }
		   case 13: {
			QString		num;
			if (item->block() < 0) num = "N/A";
			else num.sprintf("%d",item->block());
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,num.data());
			break;
		   }
		   case 14: {
			QString		num("N/A");
			if (item->numberOfLinks() >= 0) num.sprintf("%d",item->numberOfLinks());
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,num.data());
			break;
		   }
		   case 15: {
			QString		date("N/A");
			if (!item->creationDate().isNull()) generateDateString(date, item->creationDate());
			p->drawText(0,0,ColWidth[col],ICON_HEIGHT,AlignVCenter | AlignRight,date.data());
			break;
		   }
		}
	}
}

void KDetailList::updateItem(FileInfo *item)
{
	int	row(0), col(0);
	getTablePosition(item->index(),row,col);
	for (int i=0;i<nCol;i++) updateCell(row,i);
}

void KDetailList::getTablePosition(int index, int& row, int& col)
{
	col = nameCol;
	row = index+1;
}

bool KDetailList::getItemCell(int row, int col, FileInfo **item, QPoint p)
{
	bool	selected = false;
	*item = 0;
	int	index = row-1;
	if (FileList == 0 || index < 0 || index >= (int)(FileList->count())) return selected;
	*item = FileList->at(index);
	int	xPos;

	if (!SelectionMode) {
		if (nameCol == col && ColType[col] == 0 && colXPos(col,&xPos)) {
			QFontMetrics	fm(font());
			if (p.x() > xPos && p.x() < xPos+cellHeight()+fm.width((*item)->fileName().data())+4) selected = true;
		}
	}
	else selected = true;
	return selected;
}

QRect KDetailList::getItemTextRect(FileInfo *item)
{
	int	row,col;
	getTablePosition(item->index(),row,col);
	int	xPos;
	colXPos(col,&xPos);
	return QRect(xPos+cellHeight(),row*cellHeight()+lineWidth()-yOffset(),
		     cellWidth(nameCol)-cellHeight(),cellHeight());
}

void KDetailList::updateListSize()
{
	if (FileList && FileList->count() > 0)
		setNumRows(FileList->count()+1);
	else setNumRows(1);
}

int KDetailList::cellWidth(int col)
{
	return ColWidth[col];
}

void KDetailList::setColumns(QStrList& Type, QStrList& Width, QString *Names)
{
	nCol = Type.count();
	nameCol = 0;
	ColWidth.resize(nCol);
	ColType.resize(nCol);
	ColName = Names;
	QString	num;
	for (int i=0;i<nCol;i++) {
		num = Width.at(i);
		ColWidth[i] = num.toInt();
		ColWidth[i] = QMAX(0,ColWidth[i]);
		num = Type.at(i);
		ColType[i] = num.toInt();
		if (ColType[i] == 0) nameCol = i;
		Header->addLabel(Names[ColType[i]],ColWidth[i]);
//		if (ColType[i] < 0 || ColType[i] > 4) ColType[i] = -1;
	}
/*	for (int i=nCol;i<5;i++) {
		ColWidth[i] = 0;
		ColType[i] = -1;
	}*/
	setNumCols(nCol);
	modPop->clear();
	insPop->clear();
	for (int i=0;i<16;i++) modPop->insertItem(ColName[i],i), insPop->insertItem(ColName[i],i);
}

void KDetailList::getColumns(QStrList& Type, QStrList& Width)
{
	Width.clear();
	Type.clear();
	QString	num;
	for (int i=0;i<nCol;i++) {
		num.setNum(cellWidth(i));
		Width.append(num.data());
		num.setNum(ColType[i]);
		Type.append(num.data());
	}
}

void KDetailList::resizeEvent(QResizeEvent* e)
{
	KFileListBase::resizeEvent(e);
	Header->setGeometry(1,1,width()-16,cellHeight());
}

FileInfo* KDetailList::getNextItem(FileInfo *current, int code)
{
	int	row(0), col(0), lastRow(0), firstRow(0);
	FileInfo	*next(current);
	int	newIndex(-1);
	if (current) getTablePosition(current->index(),row,col);
	lastRow = lastRowVisible();
	firstRow = topCell();
	switch (code) {
	   case Key_Down:
		newIndex = (current ? current->index()+1 : 0);
		break;
	   case Key_Up:
		newIndex = (current ? current->index()-1 : FileList->count()-1);
		break;
	   case Key_Right:
	   case Key_Left:
		break;
	   case Key_PageDown:
		newIndex = row+lastRow-firstRow-1;
		if (newIndex >= (int)(FileList->count())) newIndex = row-1;
		break;
	   case Key_PageUp:
		newIndex = row-lastRow+firstRow-1;
		if (newIndex < 0) newIndex += row-1;
		break;
	}
	if (newIndex >= 0 && newIndex < (int)(FileList->count())) next = FileList->at(newIndex);
	return next;
}

void KDetailList::scroll(FileInfo *item)
{
	if (!rowIsVisible(item->index()+1) || item->index() == topCell()-1) setTopCell(item->index());
}

void KDetailList::slotColumnPressed(int col)
{
	cancelEdit();
	emit selected(this);
	emit columnPressed(ColType[col]);
}

void KDetailList::columnMoved(int from, int to)
{
cout << "from : " << from << "\tto : " << to << endl;
	int	t1(0), t2(0);
	if (from > to) {
		t1 = ColType[from];
		t2 = ColWidth[from];
		for (int i=from;i>to;i--) {
			ColType[i] = ColType[i-1];
			ColWidth[i] = ColWidth[i-1];
		}
		ColType[to] = t1;
		ColWidth[to] = t2;
	}
	else {
		to--;
		t1 = ColType[from];
		t2 = ColWidth[from];
		for (int i=from;i<to;i++) {
			ColType[i] = ColType[i+1];
			ColWidth[i] = ColWidth[i+1];
		}
		ColType[to] = t1;
		ColWidth[to] = t2;
	}
	for (int i=0;i<nCol;i++) if (ColType[i] == 0) { nameCol = i; break;}
	updateTableSize();
	update();
	emit detailPropertiesChanged();
}

void KDetailList::checkPopups()
{
 	for (int i=0;i<16;i++) modPop->setItemChecked(i,false);
	modPop->setItemChecked(ColType[currentColumn],true);
	
	for (int i=0;i<6;i++) datePop->setItemChecked(i,false);
	datePop->setItemChecked(DateFormat,true);

	selectionPop->setItemChecked(0,false);
	selectionPop->setItemChecked(1,false);
	selectionPop->setItemChecked(SelectionMode,true);
}

void KDetailList::columnRightClicked(int col, int positionInCol)
{
	setFocus();
 	currentColumn = col;
	insertToRight = (positionInCol > (Header->cellSize(col)>>1));
	checkPopups();	
	mainPop->popup(QCursor::pos());
}

void KDetailList::columnMidClicked(int col)
{
	setFocus();
	int currentType = ColType[col];
	currentColumn = col;
	checkPopups();
	switch (currentType) {
	   case 3:
	   case 7:
	   case 15:
		datePop->popup(QCursor::pos());
		break;
	   case 0:
		selectionPop->popup(QCursor::pos());
		break;	
	}
}

void KDetailList::changeDateFormat(int format)
{
	if (DateFormat != format) {
		DateFormat = format;
		update(0,Header->height(),-1,-1);
		emit detailPropertiesChanged();
	}
}

void KDetailList::removeColumn()
{
	if (nCol>1) {
		delete Header;
		createConnectHeader();
		nCol--;
		nameCol=0;	
		for (int i=currentColumn; i<nCol; i++) {
			ColType[i]=ColType[i+1];
			ColWidth[i]=ColWidth[i+1];
			if (ColType[i] == 0) nameCol = i;
		}
		ColType.resize(nCol);
		ColWidth.resize(nCol);

		for (int i=0; i<nCol; i++)
			Header->addLabel(ColName[ColType[i]],ColWidth[i]);
	
		setNumCols(nCol);
		Header->show();
		updateTableSize();
		update();
		emit detailPropertiesChanged();
	}
}

void KDetailList::modifyColumn(int id)
{
	if (ColType[currentColumn] != id) {
		ColType[currentColumn] = id;
		Header->setLabel(Header->mapToLogical(currentColumn),ColName[id].data());
		update();
		emit detailPropertiesChanged();
	}
}

void KDetailList::insertColumn(int id)
{
	nCol++;
	ColType.resize(nCol);
	ColWidth.resize(nCol);
	if (insertToRight) currentColumn++;
	for (int i=nCol-1; i > currentColumn; i--) {
		ColType[i]=ColType[i-1];
		ColWidth[i]=ColWidth[i-1];
	}
	ColType[currentColumn] = id;
	ColWidth[currentColumn] = 100;
	Header->insertAddLabel(ColName[id],100,currentColumn);
	setNumCols(nCol);
	update();
	emit detailPropertiesChanged();
}

void KDetailList::createConnectHeader()
{
	Header = new KHeader(this);
	Header->setOrientation(QHeader::Horizontal);
	Header->setGeometry(1,1,width()-16,cellHeight());
	Header->setTracking(true);
	QObject::connect(this,SIGNAL(hScroll(int)),Header,SLOT(setOffset(int)));
	connect(Header,SIGNAL(sizeChange(int,int,int)),SLOT(setColumnWidth(int,int,int)));
	connect(Header,SIGNAL(sectionClicked(int)),SLOT(slotColumnPressed(int)));
	connect(Header,SIGNAL(moved(int,int)),SLOT(columnMoved(int,int)));
	connect(Header,SIGNAL(rightClicked(int,int)),SLOT(columnRightClicked(int,int)));
	connect(Header,SIGNAL(midClicked(int)),SLOT(columnMidClicked(int)));
}

QRect KDetailList::tip(const QPoint& pos, QString& str)
{
  int row = findRow(pos.y());
  int index = row-1;
  FileInfo *item = (FileList != 0 && index >=0 && index < (int)(FileList->count()) ? FileList->at(index) : 0);
  if (item)
    {
      QRect rect = getItemTextRect(item);
      str = item->fileName().data();
      if (fontMetrics().width(item->fileName().data()) >= rect.width()-4) return rect;
    }
  return QRect(0,0,-1,-1);
}

QRect KDetailList::getItemRect(FileInfo *item)
{
	if (!item) return QRect(0,0,-1,-1);
	int	row, col, x, y;
	getTablePosition(item->index(),row,col);
	if (rowYPos(row,&y) && colXPos(col,&x)) {
		int	w = fontMetrics().width(item->fileName().data())+cellHeight();
		return QRect(QPoint(x,y),QSize(w,cellHeight()));
	}
	else return QRect(0,0,-1,-1);
}

//----------------------------------------------------------------------------------------------

char *prefix[] = { "Gb","Mb","Kb","bytes"};

QString processSize(unsigned long long size)
{
	QString	retval;
	unsigned long long	div(1000000000);
	uint	index(0);
	while (1 && index < 4) {
		if (size / div > 0) break;
		index++;
		div /= 1000;
	}
	if (size == 0 || index == 3) retval.sprintf("%d",size);
	else retval.sprintf("%.1f %s",((double)size)/div,prefix[index]);
	return retval;
}
