#ifndef _KHEADER_H_
#define _KHEADER_H_

#include <qheader.h>

class KHeader : public QHeader
{
	Q_OBJECT;

public:
	KHeader(QWidget *parent = 0, const char *name = 0);

	int insertAddLabel(const char *s, int size=-1, int position=-1);

signals:
	void rightClicked(int section, int position_in_section);
	void midClicked(int section);

protected:
	virtual void mousePressEvent(QMouseEvent *e);
};

inline KHeader::KHeader(QWidget *parent, const char *name)
	: QHeader(parent,name)
{}

inline void KHeader::mousePressEvent(QMouseEvent *e)
{
	QHeader::mousePressEvent(e);
	if (e->button() == RightButton)	{
		int section=cellAt(e->x());
		emit rightClicked(section,e->x()-cellPos(section)+offset());
	}
	else if (e->button() == MidButton) emit midClicked(cellAt(e->x()));
}

inline int KHeader::insertAddLabel(const char *s, int size=-1, int position=-1)
{
	if (position<0 || position>=count()) return addLabel(s,size);
	else {
		int i=count()-1;
		int newlabel=addLabel(label(mapToLogical(i)), cellSize(mapToLogical(i)));	
		for (; i > position; i--)
			setLabel(mapToLogical(i),label(mapToLogical(i-1)),cellSize(mapToLogical(i-1)));
		setLabel(mapToLogical(position),s,size);
		return newlabel;
	}
}

#endif
