#ifndef _PROTMGR_H_
#define _PROTMGR_H_

#include <config.h>

#include <pthread.h>
#include <qlist.h>
#include <qstrlist.h>
#include <qtimer.h>
#include "ProgressDlg.h"
#include <qwidget.h>
#include "protocol.h"

void createErrorMsg(QString&);

struct Protocol_Interface;	// forward definition

class ProtocolMgr : public QObject
{
	Q_OBJECT;

public:
	ProtocolMgr(QWidget *parent = 0);
	~ProtocolMgr();
	void setupMime(KMimeExtDict *extDict = 0, KMimeExtList *nameDict = 0, MimeMagic *magic = 0, bool use = TRUE);
	void setupSubProtList(SubProtList *list = 0);
	ProgressDlg* progress();
	bool emptyTrash(Protocol*);

	Protocol* createProtocol(int type, const char *str1 = 0, const char *str2 = 0, const char * str3 = 0, const char *str4 = 0, const char *str5 = 0);
	Protocol* createProtocol(KURL& url);
	void deleteProtocol(KURL& url);
	void deleteProtocol(Protocol *prot);
	Protocol* searchProtocol(const KURL& url);
	bool transfer(Protocol *protSrc, Protocol *protDest, KURL& src, KURL& dest, bool needHide = TRUE, bool move = FALSE);
	bool init_transfer(const QStrList& src, const char *dest, bool move=false);
	bool copy(const QStrList& src, const char *dest);
	bool move(const QStrList& src, const char *dest);
	const char* getFile(const char *filename);
	const char* getFile(Protocol* prot, KURL& url);
	const FileInfoList* list(Protocol *prot, KURL& url, bool hidden, bool dirsOnly = FALSE, bool showArchive = FALSE);
	const FileInfoList* list(const char *url, bool hidden, bool dirsOnly = FALSE, bool showArchive = FALSE);
	const FileInfoList* listSubDirs(Protocol *prot, KURL& url, bool hidden, bool showArchive = FALSE);
	const FileInfoList* listSubDirs(const char *url, bool hidden, bool showArchive = FALSE);
	bool rename(Protocol *prot, const KURL& src, const KURL& dest);
	bool rename(const char *src, const char *dest);
	bool remove(QStrList& src);
	bool remove(Protocol *prot, QStrList& src);
	bool chmod(Protocol *prot, const KURL& url, int perm);
	bool chmod(const char *url, int perm);
	bool chown(Protocol *prot, const KURL& url, const char *owner, const char *group);
	bool chown(const char *url, const char *owner, const char *group);
	bool mkdir(Protocol *prot,const KURL& url);
	bool mkdir(const char *url);

	void abort();
	void showError(const char*);
	bool initProtocol(Protocol *prot);
	bool finishProtocol(Protocol *prot);
	void reset();
	void loadImage(FileInfo *fi, int save, int size);

	// thread specific
	void thread_Dispatcher(Protocol_Interface *p);
	void thread_Cleanup(Protocol_Interface *p);
	void thread_start(Protocol_Interface *p);

signals:
	void message(const char *msg);
	void protocolClosed(Protocol *prot);

protected slots:
	void checkTimer();

protected:
	virtual bool event(QEvent *e);

private:
	pthread_t	th_id;
	const FileInfoList* thread_list(Protocol *prot, KURL* url, bool hidden, bool dirsOnly = FALSE, bool showArchive = FALSE);
	bool thread_rename(Protocol *prot, KURL* src, KURL* dest);
	bool thread_mkdir(Protocol *prot, KURL* url);
	bool thread_chmod(Protocol *prot, KURL* url, int perm);
	bool thread_chown(Protocol *prot, KURL* url, const char *owner, const char *group);
	bool thread_init(Protocol *prot);
	bool thread_finish(Protocol *prot);
//	bool thread_copy(QStrList* src, const char *dest);
//	bool thread_move(QStrList* src, const char *dest);
	bool thread_remove(Protocol *prot, QStrList* src);
	bool thread_emptyTrash(Protocol *prot);
	const char* thread_getFile(Protocol *prot, KURL* url);
	bool thread_transfer(Protocol *protSrc, Protocol *protDest, KURL* src, KURL* dest, bool needHide=true, bool move=false);

	bool thread_routine1(int type, void *p1=0, void *p2=0, void *p3=0, void *p4=0, void *p5=0, void *p6=0);

private:
	QList<Protocol>		*protList;
	QStrList		*tmpList;
	Protocol		*activeProtocol;
	QWidget		*ParentWidget;
	bool		askOverwrite;
	ProgressDlg		*dlg;
	KMimeExtDict		*ExtDict;
	KMimeExtList		*NameDict;
	KMimeAppList		*AppList;
	MimeMagic		*Magic;
	bool			UseMagic;
	SubProtList		*subProtList;
	QString			ErrorMsg;
	QTimer			*CheckTimer;
};

inline const FileInfoList* ProtocolMgr::listSubDirs(Protocol *prot, KURL& url, bool hidden, bool showArchive)
{
	return list(prot,url,hidden,TRUE,showArchive);
}

inline const FileInfoList* ProtocolMgr::listSubDirs(const char *url, bool hidden, bool showArchive)
{
	return list(url,hidden,TRUE,showArchive);
}

inline ProgressDlg* ProtocolMgr::progress()
{ return dlg;}

inline void ProtocolMgr::reset()
{ dlg->reset();}

#endif
