#include "trashprot.h"
#include "mystrlist.h"

TrashProtocol::TrashProtocol(const char *path)
	: FileProtocol(path), TrashPath(path)
{
	Type = Protocol::Trash;
}

TrashProtocol::~TrashProtocol()
{
}

bool TrashProtocol::isEmpty()
{
	_dir = opendir(TrashPath.data());
	if (!_dir) return TRUE;
	int	count(0);
	struct dirent	*file;
	while (count == 0 && (file = readdir(_dir)) != 0)
		if (strcmp(file->d_name,".") != 0 && strcmp(file->d_name,"..") != 0 && strcmp(file->d_name,".directory") != 0) count++;
	closedir(_dir);
	_dir = 0;
	return (count == 0);
}

bool TrashProtocol::empty(ProgressDlg *dlg)
{
	_dir = opendir(TrashPath.data());
	if (!_dir) return FALSE;
	MyStrList	list;
	struct dirent	*file;
	while ((file = readdir(_dir)) != 0) list.append(file->d_name);
	closedir(_dir);
	_dir = 0;
	QStrListIterator	it(list);
	for (;it.current();++it) {
		if (strcmp(it.current(),".") == 0 || strcmp(it.current(),"..") == 0 || strcmp(it.current(),".directory") == 0) continue;
		QString	tmp(TrashPath.data());
		tmp += it.current();
		struct stat	st;
		stat(tmp.data(),&st);
		if (S_ISDIR(st.st_mode)) {
			tmp += '/';
			if (!rmdir(tmp.data(),dlg)) break;
		}
		else if (!remove(tmp.data())) break;
	}
	return (it.current() == 0);
}
