#include"getpath.h"

/*
 * IPTraf working file and directory definitions
 */


/*** 
 *** Directory definitions.  The definitions in the Makefile now override
 *** these directives.
 ***/

/*
 * The IPTraf working directory
 */
 
#ifndef WORKDIR
#define WORKDIR		"/var/local/iptraf/"
#endif

#ifndef LOGDIR
#define LOGDIR		"/var/log/iptraf/"
#endif

#ifndef EXECDIR
#define EXECDIR		"/usr/local/bin/"
#endif


/***
 *** Directory environment variables.  Overrides built in definitions.
 *** You may suit this to your preferences.
 ***/

/*
 * Environment variable for IPTraf working directory.  Overrides builtin.
 */

#define WORKDIR_ENV     "IPTRAF_WORK_PATH"

/*
 * Environment variable for LOGDIR
 */

#define LOGDIR_ENV      "IPTRAF_LOG_PATH"
 
/***
 *** Filename definitions.  They depend on the directory definitions
 *** above.
 ***/

/*
 *  The IPTraf instance identification file.  IPTraf is running if this
 *  file is present, and is deleted afterwards.  As of this version, this
 *  file is used to restrict configuration to only the first instance.
 */

#define IPTIDFILE	get_path(T_WORKDIR, "iptraf.tag")

/*
 * The IPTraf facility identification files.  These are used to tag each
 * individual facility, allowing only one of each kind running at any one
 * time systemwide.
 */
 
#define IPMONIDFILE	get_path(T_WORKDIR, "ipmon.tag")
#define GSTATIDFILE	get_path(T_WORKDIR, "genstat.tag")
#define DSTATIDFILE	get_path(T_WORKDIR, "detstat.tag")
#define TCPUDPIDFILE	get_path(T_WORKDIR, "tcpudp.tag")
#define LANMONIDFILE	get_path(T_WORKDIR, "lanmon.tag")
#define TCPFLTIDFILE	get_path(T_WORKDIR, "tcpfltchg.tag")
#define UDPFLTIDFILE	get_path(T_WORKDIR, "udpfltchg.tag")
#define OTHFLTIDFILE	get_path(T_WORKDIR, "othfltchg.tag")

/*
 * The TCP filter list file
 */
 
#define TCPFLNAME	get_path(T_WORKDIR, "tcpfilters.dat")

/*
 * The UDP filter list file
 */
 
#define UDPFLNAME	get_path(T_WORKDIR, "udpfilters.dat")

/*
 * The other protocol filter data file
 */
 
#define OTHFLNAME	get_path(T_WORKDIR, "othfilter.dat")

/*
 * The IPTraf configuration data file
 */

#define CONFIGFILE	get_path(T_WORKDIR, "iptraf.cfg")

/*
 * The IPTraf log files
 */
 
#define IPMONLOG	get_path(T_LOGDIR, "ip_traffic.log")
#define GSTATLOG	get_path(T_LOGDIR, "iface_stats_general.log")
#define DSTATLOG	get_path(T_LOGDIR, "iface_stats_detailed.log")
#define TCPUDPLOG	get_path(T_LOGDIR, "tcp_udp_services.log")
#define LANLOG		get_path(T_LOGDIR, "lan_statistics.log")

/*
 * The additional TCP/UDP ports file
 */
#define PORTFILE	get_path(T_WORKDIR, "ports.dat")

/*
 * The Ethernet and FDDI host description files
 */
 
#define ETHFILE		get_path(T_WORKDIR, "ethernet.desc")
#define FDDIFILE	get_path(T_WORKDIR, "fddi.desc")

/*
 * The rvnamed program file
 */
 
#define RVNDFILE	get_path(T_EXECDIR, "rvnamed")

/*
 * The rvnamed log file
 */
 
#define RVNDLOGFILE	get_path(T_LOGDIR, "rvnamed.log")

/*
 * File to contain the current TCP filter data file name.  UDP filter
 * data is saved with the other protocols.
 */

#define TCPFILTERSAVE   get_path(T_WORKDIR, "tcpfilter.cur")
