/***

ifaces.c - routine that determines whether a given interface is supported
		by IPTraf
		
Copyright (c) Gerard Paul Java 1998

This software is open source; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License in the included COPYING file for
details.

***/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <linux/if_packet.h>
#include "error.h"
#include "links.h"

#define NUM_SUPPORTED_IFACES 8

char ifaces[NUM_SUPPORTED_IFACES][6] =
{ "lo", "eth", "sl", "ppp", "ippp", "plip", "fddi", "isdn" };

/*
 * Determine if supplied interface is supported.
 */

int iface_supported(char *iface)
{
    int i;

    for (i = 0; i <= NUM_SUPPORTED_IFACES - 1; i++) {
	if (strncmp(ifaces[i], iface, strlen(ifaces[i])) == 0)
	    return 1;
    }

    return 0;
}

void err_iface_unsupported(void)
{
    
/*    errbox("Specified interface not supported",
           "Press a key to abort", &resp); */
}

void isdn_iface_check(int *fd, char *ifname)
{
    if (*fd == -1) {
        if (strncmp(ifname, "isdn", 4) == 0)
            *fd = open("/dev/isdnctrl", O_RDWR);
    }
}
