/***************************************************************************
                          knd_config.h  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 14:26:46 GMT 1999
                                           
    copyright            : (C) 1999 by Mike Richardson                         
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef		KSNUFFLECONFIG_H 
#define		KSNUFFLECONFIG_H 

#ifdef		HAVE_CONFIG_H
#include	<config.h>
#endif 

#include	<kapp.h>
#include	<kfiledialog.h>
#include	<qpushbutton.h>
#include	<qlabel.h>
#include	<qlineedit.h>
#include	<qcombobox.h>
#include	<qcheckbox.h>
#include	<qgroupbox.h>
#include	<qspinbox.h>
#include	<qtooltip.h>

#include	"ksnuffle.h"
#include	"knd_view.h"
#include	"knd_multi.h"
#include	"knd_pcap.h"
#include	"knd_gra.h"
#include	"knd_pkt.h"

class	KNDConf	: public QWidget
{
	Q_OBJECT

protected:

	KNDView		*view		;
	KNDGraphic	*graphic	;
	KNDPacket	*packets	;
	KNDMulti	*multi		;

	int		slot		;

	QGroupBox	g_ctrl		;
	QGroupBox	g_log		;
	QGroupBox	g_pkt		;
	QGroupBox	g_gra		;
	QGroupBox	g_prog		;

	QPushButton	b_set		;
	QPushButton	b_res		;
	QPushButton	b_clr		;
	QPushButton	b_go		;
	QPushButton	b_freeze	;
	QPushButton	b_log		;

	QLabel		l_name		;
	QLineEdit	t_name		;

	QCheckBox	c_time		;
	QCheckBox	c_proto		;
	QCheckBox	c_srce		;
	QCheckBox	c_dest		;
	QCheckBox	c_info		;
	QCheckBox	c_size		;

	QCheckBox	c_multi		;

	QLabel		l_load1		;
	QLabel		l_bar1		;
	QLabel		l_bar2		;
	QSpinBox	s_load1		;
	QSpinBox	s_bar1		;
	QSpinBox	s_bar2		;

	QString		v_name		;

	bool		d_time		;
	bool		d_proto		;
	bool		d_srce		;
	bool		d_dest		;
	bool		d_info		;
	bool		d_size		;

	bool		d_multi		;

	int		v_load1		;
	int		v_bar1		;
	int		v_bar2		;

	bool		going		;
	bool		frozen		;
	FILE		*logfd		;

public	:
	KNDConf (KNDView *, KNDGraphic	*,
			    KNDPacket 	*,
			    KNDMulti	*, int, char *) ;

virtual	~KNDConf ()	 ;

protected slots :

	virtual	void	clickSet    () = 0 ;
	virtual	void	clickReset  () = 0 ;
	virtual	void	clickClear  () = 0 ;
	virtual	void	clickGo     () = 0 ;
	virtual	void	clickFreeze () = 0 ;
	virtual	void	clickLog    () = 0 ;
}	;

#endif	// KSNUFFLECONFIG_H 
