/***************************************************************************
                          knd_confrep.h  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 14:26:46 GMT 1999
                                           
    copyright            : (C) 1999 by Mike Richardson                         
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef		KSNUFFLECONFREP_H 
#define		KSNUFFLECONFREP_H 

#ifdef		HAVE_CONFIG_H
#include	<config.h>
#endif 

#include	<kapp.h>
#include	<kfiledialog.h>
#include	<qpushbutton.h>
#include	<qlabel.h>
#include	<qlineedit.h>
#include	<qcombobox.h>
#include	<qcheckbox.h>
#include	<qgroupbox.h>
#include	<qspinbox.h>
#include	<qtooltip.h>

#include	"ksnuffle.h"
#include	"knd_view.h"
#include	"knd_mon.h"
#include	"knd_multi.h"
#include	"knd_gra.h"
#include	"knd_pkt.h"
#include	"knd_config.h"


/*  KNDSpeedBox								*/
/*  This class is a simple extension of a QSpinBox, and is used to	*/
/*  display a suitable speed-up/slow-down message in the replay speed	*/
/*  spin box.								*/

class	KNDSpeedBox : public QSpinBox
{
	Q_OBJECT	;

	int	speed	;

public	:

	KNDSpeedBox	(QWidget *, int, int, int) ;

	virtual	QString	mapValueToText (int) ;

private slots:

	void	speedChanged (int) ;

}	;


/*  KNDConfRep								*/
/*  This class defines the configuration object for the log file replay	*/
/*  It uses the common buttons and stuff from the KNDConfig class, with	*/
/*  a few additions and modifications of its own.			*/

class	KNDConfRep : public KNDConf
{
	Q_OBJECT

	QLineEdit	t_logb		;
	QLabel		l_if		;
	QLabel		t_if		;
	QLabel		t_prog		;
	KNDSpeedBox	s_speed		;

	QString		v_logb		;

	int		v_speed		;

	int		logfd		;
	int		frec		;
	bool		going		;
	bool		frozen		;

	PktData		pktdata		;
	TVAL		reptime		;
	TVAL		inctime		;
	int		pkttime		;	

	void		halt ()		;
	
public	:
	KNDConfRep  (KNDView *, KNDGraphic *,
				KNDPacket  *,
				KNDMulti   *, int, char *) ;

virtual	~KNDConfRep ()		;

	void	timerTick    (long)	;

	void	replayStart  ()	;
	void	replayStop   () ;
	void	replayFreeze () ;
	void	replayResume () ;

private slots :

	virtual	void	clickSet    () ;
	virtual	void	clickReset  () ;
	virtual	void	clickClear  () ;
	virtual	void	clickGo     () ;
	virtual	void	clickFreeze () ;
	virtual	void	clickLog    () ;
}	;

#endif	// KSNUFFLECONFREP_H 
