/***************************************************************************
                          knd_pkt.h  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 14:26:46 GMT 1999
                                           
    copyright            : (C) 1999 by Mike Richardson                         
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef	KSNUFFLEPACKETS_H 
#define KSNUFFLEPACKETS_H 

#ifdef		HAVE_CONFIG_H
#include	<config.h>
#endif 

#include	<kapp.h>
#include	<ktabctl.h>
#include	<qlabel.h>

#include	<qrect.h>
#include	<qlistview.h>
#include	<qtooltip.h>

#include	<sys/time.h>
#include	<unistd.h>

#include	"ksnuffle.h"

#define	MAXPACK	(100)
#define	MINPACK	(MAXPACK - 20)

/*  KNDPacket	:							*/
/*  Instances of this class handle packet-level display of data coming	*/
/*  from the associated monitor.					*/

class	KNDPacket : public QFrame
{
	Q_OBJECT

	KNDView		*parent		 ;

						/* Labels ...		*/
	QLabel		l_accept	 ;	/* Packets accepted	*/
	QLabel		l_dropped	 ;	/* Packets dropped	*/
	QLabel		l_missed	 ;	/* Packets missed	*/
	QLabel		l_pktbytes	 ;	/* Packet byte count	*/
	QLabel		l_datbytes	 ;	/* Packet data count	*/
						/* Values ...		*/
	QLabel		v_accept	 ;	/* Packets accepted	*/
	QLabel		v_dropped	 ;	/* Packets dropped	*/
	QLabel		v_missed	 ;	/* Packets missed	*/
	QLabel		v_pktbytes	 ;	/* Packet byte count	*/
	QLabel		v_datbytes	 ;	/* Packet data count	*/

	int		s_pktbytes	 ;	/* Total packet bytes	*/
	int		s_datbytes	 ;	/* Total packet data	*/

	int		p_this		 ;	/* Packets this second	*/
	int		p_last		 ;	/* Packets last second	*/
	int		pausefor	 ;	/* Display paused time	*/

	QListView	*plist		 ;	/* Packet display	*/
	QListViewItem	*lastp		 ;	/* Last item added	*/
	int		options		 ;	/* Option flags		*/

	PktInfo		*packets[MAXPACK];	/* Current packet list	*/
	int		offset		 ;	/* Current list offset	*/

	bool		onview		 ;	/* Display on view	*/
	bool		going		 ;	/* Display going	*/
	bool		frozen		 ;

	void	putPacket	(PktInfo *, bool) ;
	void	putDots		()	 ;
	void	redisplay	()	 ;

public	:
	KNDPacket	(KNDView *)	 ;
       ~KNDPacket	() ;

	void	addPacket	(PktInfo *) ;
	void	setOptions	(int )	 ;
	void	setOnview	(bool)	 ;
	void	execute		(bool)	 ;
	void	freeze		(bool)	 ;
	void	timerTick	(long)	 ;

private	:
}	;

#define	PO_TIME		0x0001
#define	PO_PROTO	0x0002
#define	PO_SRC		0x0004
#define	PO_DST		0x0008
#define	PO_INFO		0x0010
#define	PO_SIZE		0x0020

#endif	// KSNUFFLEPACKETS_H 
