#ifndef INCLUDE_KTAIL_H
#define INCLUDE_KTAIL_H

#include <ktopwidget.h>
#include <ktabctl.h>
#include <kapp.h>
#include <kconfig.h>
#include <kfontdialog.h>
#include <ktablistbox.h>
#include <qtimer.h>
#include <qmlined.h>
#include <stdio.h>
#include <fcntl.h>

#include "getcmdline.h"
#include "mytext.h"
#include "ktail_config.h"

#define STA_LINES	1
#define STA_NAME	2

struct file_str {
	char filename[1024];
	char caption[1024];
	int filep;
	long filepos;
	int fstatus;
	bool completelastline;
	mytext *textlist;
	int type;
	pid_t pid;
	};

class ktail : public KTopLevelWidget
{
	Q_OBJECT
public:
	ktail(KApplication *parent=0, const char *name=0);
	~ktail();
//	void resizeEvent (QResizeEvent *);
	void setfont(QFont fo);
	KMenuBar *menubar;
	KStatusBar *statusbar;
	KTabCtl *tabctl;
	KTabListBox *kt;
//	QPopupMenu *kt;
	mybox *w;
	QTimer *tim;
	QFont myfont;
/*	QMultiLineEdit *textlist[MAX_FILES]; */
	QList <file_str> filel;
	int active_tab;
	QPopupMenu *fileMenu,*optionMenu,*helpMenu,*popmenu;
	int addfile(char *pfilename,char *filter,bool filterflag);
	KDNDDropZone *dnd;
	kgetcmdlinedlg *cmdlinedlg;
public slots:
	void closeEvent(QCloseEvent *);
	void saveconfig();

private:
	void setallcwidth(KTabListBox *);
	void setcwidth(KTabListBox *, int);
	int prev_width,prev_height;
	bool reading,do_stop;
	bool showstatusnonactive;
	void createtextbox();
	void stopall();
	void openregfile(file_str *);
	void openspecialfile(file_str *);
	void openipcpipe(file_str *);
	int readregfile(file_str *);
	int readspecialfile(file_str *);
	int readipcpipe(file_str *);

private slots:
	void close();
	void selectfont();
	void addfiledlg();
	void addcmdline();
	void removefile();
	void removeit(int no);
	void removeit(int no,int);
	void togglemenubar();
	void togglestatusbar();
	void toggledecoration();
	void menucallback(int);
	void readintextlist();
	void readintextlistno(file_str *);
	void tabchg(int no);
	void tabchanged(int no);
	void dropslot(KDNDDropZone *);
	void gotcmdline(bool);
	void clearwindow();
	void reloadwindow();
	void dopopup();
};

#endif
