// ----------------------------------------------------------------------------
// Filename:    KTimeclockData.cpp
// $Date: 1999/06/10 15:45:59 $
// $Revision: 1.8 $
// ----------------------------------------------------------------------------

#include <qlayout.h>
#include <kapp.h>
#include <kiconloader.h>

#include "KTimeclockData.h"

#define Inherited QWidget

// ----------------------------------------------------------------------------
// Function:    KTimeclockData (QWidget* parent, const char* name)
// Parameters:  parent  - Handle to parent widget
//              name    - Name of our own widget
// ----------------------------------------------------------------------------
// Constructor.
// ----------------------------------------------------------------------------
KTimeclockData::KTimeclockData( QWidget* parent, const char* name )
	: Inherited( parent, name, 0 )
{
    // ------------------------------------------------------------------------
    // We'll use a layout to manage all of our resizing.
    // ------------------------------------------------------------------------
    QBoxLayout* layout = new QBoxLayout( this, QBoxLayout::TopToBottom );

    // ------------------------------------------------------------------------
    // Create the list view for our projects and get it configured.
    // ------------------------------------------------------------------------
    treeProjects = new QListView( this, "treeProjects" );
    treeProjects->setGeometry( 10, 10, 520, 280 );
    treeProjects->setMinimumSize( 10, 10 );
    treeProjects->setMaximumSize( 32767, 32767 );
    treeProjects->addColumn( "Description", 400 );
    treeProjects->addColumn( "Session", 60 );
    treeProjects->setColumnAlignment( 1, 2 );
    treeProjects->addColumn( "Total", 60 );
    treeProjects->setColumnAlignment( 2, 2 );
    treeProjects->setAllColumnsShowFocus( TRUE );
    treeProjects->setRootIsDecorated( TRUE );
    connect( treeProjects, SIGNAL( selectionChanged(QListViewItem*) ),
             this, SLOT( SelectionChanged(QListViewItem*) )
           );
    layout->addWidget( treeProjects );

    // ------------------------------------------------------------------------
    // Create a popup menu for when users right click on a list item
    // ------------------------------------------------------------------------
    mnuPopup = new QPopupMenu;
    mnuPopup->insertItem( "&Edit", this, SLOT(EditItem()) );
    mnuPopup->insertItem( "&Delete", this, SLOT(DeleteItem()) );
    mnuPopup->insertItem( "&Clear item", this, SLOT(ClearItem()) );
    connect( treeProjects,
             SIGNAL( rightButtonClicked(QListViewItem*, const QPoint&, int) ),
             this,
             SLOT( ShowPopup(QListViewItem*, const QPoint&, int) )
           );

    // ------------------------------------------------------------------------
    // Resize ourselves
    // ------------------------------------------------------------------------
	this->resize( 500,300 );
	this->setMinimumSize( 400, 300 );
	this->setMaximumSize( 32767, 32767 );

    // ------------------------------------------------------------------------
    // Set our default state and emit a signal
    // ------------------------------------------------------------------------
    state = "Disabled";
    emit timerState( state );
}

// ----------------------------------------------------------------------------
// Function:    ~KTimeClockData ()
// ----------------------------------------------------------------------------
// Destructor.
// ----------------------------------------------------------------------------
KTimeclockData::~KTimeclockData()
{
}

// ----------------------------------------------------------------------------
// Function:    AddProject ()
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void KTimeclockData::AddProject ()
{
}

// ----------------------------------------------------------------------------
// Function:    AddSubProject ()
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void KTimeclockData::AddSubProject ()
{
}

// ----------------------------------------------------------------------------
// Function:    AddTask ()
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void KTimeclockData::AddTask ()
{
}

// ----------------------------------------------------------------------------
// Function:    EditItem ()
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void KTimeclockData::EditItem ()
{
}

// ----------------------------------------------------------------------------
// Function:    DeleteItem ()
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void KTimeclockData::DeleteItem ()
{
}

// ----------------------------------------------------------------------------
// Function:    ClearItem ()
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void KTimeclockData::ClearItem ()
{
}

// ----------------------------------------------------------------------------
// Function:    ClearAllItems ()
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void KTimeclockData::ClearAllItems ()
{
}

// ----------------------------------------------------------------------------
// Function:    Preferences ()
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void KTimeclockData::Preferences ()
{
}

// ----------------------------------------------------------------------------
// Function:    StartTimer ()
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void KTimeclockData::StartTimer()
{
}

// ----------------------------------------------------------------------------
// Function:    StopTimer ()
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void KTimeclockData::StopTimer()
{
}

// ----------------------------------------------------------------------------
// Function:    save ()
// ----------------------------------------------------------------------------
// Stub function.  Always returns failure.
// ----------------------------------------------------------------------------
int KTimeclockData::save()
{
    return -1;
}

// ----------------------------------------------------------------------------
// Function:    load ()
// ----------------------------------------------------------------------------
// Stub function.  Always returns failure.
// ----------------------------------------------------------------------------
int KTimeclockData::load()
{
    return -1;
}

// ----------------------------------------------------------------------------
// Function:    ShowPopup (QListViewItem* item, const QPoint& loc, int col)
// Parameters:  item    - Item for which we want to display a popup menu
//              loc     - Co-ordinates of where the mouse was clicked
//              col     - Column which was clicked (unused)
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void KTimeclockData::ShowPopup( QListViewItem*, const QPoint&, int )
{
}

// ----------------------------------------------------------------------------
// Function:    SelectionChanged (QListViewItem* item)
// Parameters:  item    - Handle to the newly selected item
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void KTimeclockData::SelectionChanged( QListViewItem* )
{
}

// ----------------------------------------------------------------------------
// Function:    timerEvent (QTimerEvent* event)
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void KTimeclockData::timerEvent( QTimerEvent* )
{
}
