    /*

    canvas.h  for  ktsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */


#ifndef __CANVAS__
#define __CANVAS__


#include <qwidget.h>
#include <qpixmap.h>

#include "point.h"



class Canvas : public QWidget
  {
  public:
    Canvas( QWidget *parent = 0, const char *name = 0 );
    virtual ~Canvas();
    void setPoints( Point *tsp );
    void setParameters( DBL w, DBL h, DBL mx, DBL my );
    void setGraphicParameters( int pointsShape,
                               int pointsColour,
                               int pointsSize,
                               int linesStyle,
                               int linesColour,
                               int linesWidth );

  protected:
    virtual void paintEvent( QPaintEvent *e );

  private:
    QPixmap *pixmap;
    Point *points;
    DBL _width;
    DBL _height;
    DBL _marginX;
    DBL _marginY;
    int _pointsShape;
    QColor _pointsColour;
    int _pointsSize;
    PenStyle _linesStyle;
    QColor _linesColour;
    int _linesWidth;
  };



#endif   // __CANVAS__
