    /*

    runsdisplay.h  for  KTsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */


#ifndef __RUNSDISPLAY__
#define __RUNSDISPLAY__


#include "graphdisplay.h"


class RunsDisplay : public GraphDisplay
  {
  Q_OBJECT

  public:
    RunsDisplay( QWidget *parent = 0, const char *name = 0 );
    ~RunsDisplay();
    double firstValue();
    double nextValue();

  public slots:
    // prepares the widget for displaying a new
    // set of data
    void slotClearDisplay();
    // sets the number of values to be displayed
    void slotNumberOfRuns( int value );
    // displays the next value
    void slotNextValue( double value );

  protected:
    int receivedValues;
    double sock;
  };




#endif   //  __RUNSDISPLAY__
