#include <qstring.h>

#include "movies.h"
#include "bstar.h"

extern BStarTree *anchor;

//////////////////////////////////////////////////////////////////////
//                                                                  //
//                               B*-Node-Class                      //
//                                                                  //
//////////////////////////////////////////////////////////////////////

// Constructor for the BStar
BStarNode::BStarNode()
{
  isLeaf     = FALSE;
  current    = FALSE;
  movieCount = 0;
  keyCount   = 0;
  for (int i=0; i<=MAX_PTRS;i++)
    sons[i]      = NULL;
  for (int i=0; i< MAX_PTRS;i++)
    key[i]       = "";
  for (int i=0; i<=MAX_MOVIES;i++)
    movieList[i] = NULL;
  nextLeaf=NULL;
  prevLeaf=NULL;
}

// sort the movie-list in a leaf-node
void BStarNode::sortMovieList()
{
  Movie *dummy;
  int i,j,k=0;
  
    for(j=0; j<this->movieCount; j++){
    dummy = this->movieList[j];
    for(i=j,k=j; i<this->movieCount; i++){
      if (compare(this->movieList[i],dummy) < 0){
	dummy = this->movieList[i];
	k=i;
      }
    }
    if(k != j){
      this->movieList[k] = this->movieList[j];
      this->movieList[j] = dummy;
    }
  }
}

// sort the key-list in an inner node
void BStarNode::sortKeyList()
{
  QString    dummy;
  BStarNode *d2;
  int i,j,k=0;
  
  for(j=0; j<this->keyCount; j++){
    dummy = this->key[j];
    for(i=j,k=j; i<this->keyCount; i++){
      if (this->key[i] < dummy.data()){
	dummy = this->key[i];
	k=i;
      }
    }
    if(k != j){
      this->key[k] = this->key[j];
      d2 = this->sons[k+1];
      this->sons[k+1] = this->sons[j+1];
      this->sons[j+1] = d2;
      this->key[j] = dummy;
    }
  }
}


///////////////////////////////////////////////////////////////////////
//                                                                   //
//                              B*-Tree-Class                        //
//                                                                   //
///////////////////////////////////////////////////////////////////////


BStarTree::BStarTree()
{
  root = new BStarNode();
  root->isLeaf=TRUE;
}


int BStarTree::insert(Movie *newMovie)
{
  BStarNode *current = anchor->root;
  BStarNode *curOld  = current;
  int i=0;
  BStarNode *newNode;
  
  /////////////////////////////////////////////////////
  // search the leaf which should receive the new movie
  
  while (!current->isLeaf){
    while((i<current->keyCount) && (current->key[i] <= newMovie->title.data()))
      i++;
    curOld = current;
    current = current->sons[i];
    i=0;
  }

  // insert new movie
  current->movieList[current->movieCount] = newMovie;
  current->movieCount++;
  current->sortMovieList();
  
  if (current->movieCount > MAX_MOVIES){
    //B*-Overflow
    
    // one new leaf
    newNode = new BStarNode();
    newNode->isLeaf = TRUE;
    
    // leaf-pointers
    newNode->nextLeaf = current->nextLeaf;
    if (newNode->nextLeaf)
      newNode->nextLeaf->prevLeaf = newNode;
    current->nextLeaf = newNode;
    newNode->prevLeaf = current;
    
    // copy half the content of current to newNode
    for (int j=MAX_MOVIES/2; j <= MAX_MOVIES; j++){
      newNode->movieList[j-MAX_MOVIES/2] = current->movieList[j];
      current->movieList[j] = NULL;
    }
    current->movieCount  = MAX_MOVIES/2;
    newNode->movieCount = MAX_MOVIES-MAX_MOVIES/2+1;

    if (current==anchor->root){
      anchor->root = new BStarNode();
      anchor->root->isLeaf=FALSE;
      anchor->root->key[0] = newNode->movieList[0]->title;
      anchor->root->keyCount=1;
      anchor->root->sons[0] = current;
      anchor->root->sons[1] = newNode;
    } else {
      curOld->sons[curOld->keyCount+1] = newNode;
      curOld->key[curOld->keyCount] = newNode->movieList[0]->title;
      curOld->keyCount++;
      curOld->sortKeyList();
      if (curOld->keyCount == MAX_PTRS)
	anchor->bOverflow(curOld);
    }
  }
  return 0;
}
void BStarTree::bAusgleichen(BStarNode *wohin, BStarNode *woher, bool leftRight)
{
  BStarNode *current = anchor->root;
  BStarNode *curOld = current;
  int j=0;
  
  /////////////////////////////////////////////////////////
  // go to the father node of wohin
  while (current != wohin){
    j=0;
    while((j<current->keyCount) && (current->key[j] <= wohin->key[0].data()))
      j++;
    curOld = current;
    current = current->sons[j];
  }  
  
  if (leftRight){
    for (int i=wohin->keyCount; i>0;i--){
      wohin->key[i] = wohin->key[i-1];
      wohin->sons[i+1] = wohin->sons[i];
    }
    wohin->sons[1] =wohin->sons[0];
    wohin->key[0] = curOld->key[j-1];
    curOld->key[j-1] = woher->key[woher->keyCount-1];
    wohin->sons[0] = woher->sons[woher->keyCount];
    woher->keyCount--;
    wohin->keyCount++;
  } else {
    wohin->key[wohin->keyCount] = curOld->key[j];
    curOld->key[j] = woher->key[0];
    wohin->sons[wohin->keyCount+1] = woher->sons[0];
    for (int i=1; i < woher->keyCount; i++){
      woher->key[i-1] = woher->key[i];
      woher->sons[i-1] = woher->sons[i];
    }
    woher->sons[woher->keyCount-1] = woher->sons[woher->keyCount];
    woher->keyCount--;
    wohin->keyCount++;
  }
}

void BStarTree::bMischen(BStarNode *wohin, BStarNode *woher, bool leftRight)
{
  BStarNode *current = anchor->root;
  BStarNode *curOld = current;
  int i=0;
  int j=0;
  
  /////////////////////////////////////////////////////////
  // go to the father node of wohin
  while (current != wohin){
    j=0;
    while((j<current->keyCount) && (current->key[j] <= wohin->key[0].data()))
      j++;
    curOld = current;
    current = current->sons[j];
  }  

  wohin->key[wohin->keyCount] = curOld->key[j];
  
  for (i=0; i < woher->keyCount; i++){
    wohin->key[wohin->keyCount+1] = woher->key[i];
    wohin->sons[wohin->keyCount+1] = woher->sons[i];
    wohin->keyCount++;
  }
  wohin->keyCount++;
  wohin->sons[wohin->keyCount] = woher->sons[woher->keyCount];
  
  for (i=j+1; i < curOld->keyCount; i++){
    curOld->key[i-1] = curOld->key[i];
    curOld->sons[i] = curOld->sons[i+1];
  }
  curOld->keyCount--;
  
  if ((curOld != anchor->root) && (curOld->keyCount < (MAX_PTRS/2)))
    anchor->bUnderflow(curOld);
  if ((curOld == anchor->root) && (anchor->root->keyCount == 0))
    anchor->root = wohin;
}

void BStarTree::bUnderflow(BStarNode *curNode)
{
  BStarNode *current = anchor->root;
  BStarNode *curOld = current;
  int j=0;
  
  /////////////////////////////////////////////////////////
  // go to the father node of curNode
  while (current != curNode){
    j=0;
    while((j<current->keyCount) && (current->key[j] <= curNode->key[0].data()))
      j++;
    curOld = current;
    current = current->sons[j];
  }

  ////////////////////////////////////////////////////////
  // go to the position of the pointer to curNode
  j=0;
  while((j<curOld->keyCount) && (curOld->sons[j] != curNode))
    j++;

  ////////////////////////////////////////////////////////
  // B-Ausgleichen
  ////////////////////////////////////////////////////////
  // left brother with more than MAX_MOVIES/2 movies
  if (j>0)
    if (curOld->sons[j-1]->keyCount > (MAX_PTRS/2)){
      anchor->bAusgleichen(curNode,curOld->sons[j-1],TRUE);
      return;
    }
  ///////////////////////////////////////////////////////
  // right brother with more than MAX_MOVES/2 movies
  if ((j<(MAX_PTRS-1)) && (curOld->sons[j+1]))
    if (curOld->sons[j+1]->keyCount > (MAX_PTRS/2)){
      anchor->bAusgleichen(curNode,curOld->sons[j+1],FALSE);
      return;
    }
  ///////////////////////////////////////////////////////
  // B-Mischen
  ///////////////////////////////////////////////////////
  // left brother with MAX_MOVIES/2 movies
  if (j>0)
    if (curOld->sons[j-1]->keyCount == (MAX_PTRS/2)){
      anchor->bMischen(curOld->sons[j-1],curNode,FALSE);
      return;
    }
  ///////////////////////////////////////////////////////
  // right brother with MAX_MOVIES/2 movies
  if ((j<(MAX_PTRS-1)) && (curOld->sons[j+1]))
    if (curOld->sons[j+1]->keyCount == (MAX_PTRS/2)){
      anchor->bMischen(curNode,curOld->sons[j+1],FALSE);
      return;
    }
  if (curOld->keyCount < (MAX_PTRS/2))
    anchor->bUnderflow(curOld);
}

void BStarTree::bStarAusgleichen(BStarNode *wohin, BStarNode *woher, bool leftRight)
{
  BStarNode *current = anchor->root;
  BStarNode *curOld = current;
  int j=0;
  
  //////////////////////////////////////////////////////////
  // go to the father node of wohin
  while (current != wohin){
    j=0;
    while((j<current->keyCount) && (current->key[j] <= wohin->movieList[0]->title.data()))
      j++;
    curOld = current;
    current = current->sons[j];
  }

  /////////////////////////////////////////////////////////
  // copy the last movie of the prev. brother to wohin
  if (leftRight){
    wohin->movieList[wohin->movieCount] = woher->movieList[woher->movieCount-1];
    wohin->movieCount++;
    woher->movieCount--;
    wohin->sortMovieList();
    //////////////////////////////////////////////////////
    // change the key of the father-node
    curOld->key[j-1] = wohin->movieList[0]->title;
  } else {
    wohin->movieList[wohin->movieCount] = woher->movieList[0];
    wohin->movieCount++;
    woher->movieCount--;
    //////////////////////////////////////////////////////
    // move the movies of woher one pos to the right
    for (int i=0; i<woher->movieCount; i++)
      woher->movieList[i] = woher->movieList[i+1];
    //////////////////////////////////////////////////////
    // change the key of the father-node
    curOld->key[j] = woher->movieList[0]->title;
  }
}

void BStarTree::bStarMischen(BStarNode *wohin, BStarNode *woher, bool leftRight)
{
  BStarNode *current = anchor->root;
  BStarNode *curOld = current;
  int j=0;
  
  /////////////////////////////////////////////////////////
  // go to the father node of wohin
  while (current != wohin){
    j=0;
    while((j<current->keyCount) && (current->key[j] <= wohin->movieList[0]->title.data()))
      j++;
    curOld = current;
    current = current->sons[j];
  }

  /////////////////////////////////////////////////////////
  // copy all the movies of woher to wohin
  for (int i=0; i<woher->movieCount; i++){
    wohin->movieList[wohin->movieCount] = woher->movieList[i];
    wohin->movieCount++;
  }
  wohin->sortMovieList();
  
  /////////////////////////////////////////////////////////
  // delete the pointer from the father-node to woher
  if (leftRight){
    for (int i=j-1; i<curOld->keyCount; i++)
      curOld->sons[i] = curOld->sons[i+1];
    curOld->keyCount--;
    for (int i=j-1; i<curOld->keyCount; i++)
      curOld->key[i] = curOld->key[i+1];
    ////////////////////////////////////////////////////////
    // set the leaf-pointers
    wohin->prevLeaf = woher->prevLeaf;
    if (wohin->prevLeaf)
      wohin->prevLeaf->nextLeaf = wohin;
  } else {
    for (int i=j+1; i<curOld->keyCount; i++)
      curOld->sons[i] = curOld->sons[i+1];
    curOld->keyCount--;
    for (int i=j; i<curOld->keyCount; i++)
      curOld->key[i] = curOld->key[i+1];
    wohin->nextLeaf = woher->nextLeaf;
    if (wohin->nextLeaf)
      wohin->nextLeaf->prevLeaf = wohin;
  }
  if ((curOld->keyCount < (MAX_PTRS/2)) && (curOld != anchor->root))
    anchor->bUnderflow(curOld);
  if ((curOld == anchor->root) && (curOld->keyCount == 0))
    anchor->root = wohin;
}

void BStarTree::bStarUnderflow(BStarNode *curNode, BStarNode *curOld)
{
  int i=0;
  
  ////////////////////////////////////////////////////////
  // go to the position of the pointer to the leaf-node
  while ((i<curOld->keyCount) && (curOld->sons[i] != curNode))
    i++;

  ////////////////////////////////////////////////////////
  // B*-Ausgleichen
  ////////////////////////////////////////////////////////
  // left brother with more than MAX_MOVIES/2 movies
  if (i>0)
    if (curOld->sons[i-1]->movieCount > (MAX_MOVIES/2)){
      anchor->bStarAusgleichen(curNode,curOld->sons[i-1],TRUE);
      return;
    }
  ///////////////////////////////////////////////////////
  // right brother with more than MAX_MOVES/2 movies
  if ((i<(MAX_PTRS-1)) && (curOld->sons[i+1]))
    if (curOld->sons[i+1]->movieCount > (MAX_MOVIES/2)){
      anchor->bStarAusgleichen(curNode,curOld->sons[i+1],FALSE);
      return;
    }
  ///////////////////////////////////////////////////////
  // B*-Mischen
  ///////////////////////////////////////////////////////
  // left brother with MAX_MOVIES/2 movies
  if (i>0)
    if (curOld->sons[i-1]->movieCount == (MAX_MOVIES/2)){
      anchor->bStarMischen(curNode,curOld->sons[i-1],TRUE);
      return;
    }
  ///////////////////////////////////////////////////////
  // right brother with MAX_MOVIES/2 movies
  if ((i<(MAX_PTRS-1)) && (curOld->sons[i+1]))
    if (curOld->sons[i+1]->movieCount == (MAX_MOVIES/2)){
      anchor->bStarMischen(curNode,curOld->sons[i+1],FALSE);
      return;
    }
}


int BStarTree::remove(Movie *delMovie)
{
  BStarNode *current = anchor->root;
  BStarNode *curOld  = current;
  int i=0;
  
  /////////////////////////////////////////////////////
  // search the leaf which contains the new movie
  
  while (!current->isLeaf){
    while((i<current->keyCount) && (current->key[i] <= delMovie->title.data()))
      i++;
    curOld = current;
    current = current->sons[i];
    i=0;
  }

  ////////////////////////////////////////////////////
  // go to the position of delMovie in the movieList
  i=0;
  while ((i<current->movieCount) && (current->movieList[i] != delMovie)){
    i++;
  }
  
  ///////////////////////////////////////////////////
  // move the movies after delMovie one position to the left
  for (int j=i; j<current->movieCount-1;j++)
    current->movieList[j] = current->movieList[j+1];
  current->movieList[current->movieCount-1]=NULL;
  current->movieCount--;
  
  //////////////////////////////////////////////////
  // has the number of movies dropped below
  // the minimum number
  if (current->movieCount < (MAX_MOVIES/2))
    anchor->bStarUnderflow(current,curOld);
  
  return 0;
}

////////////////////////////////////////////////////////////
//                                                        //
//                 return first movie                     //
//                                                        //
////////////////////////////////////////////////////////////
Movie *BStarTree::firstMovie()
{
  BStarNode *curNode = anchor->root;

  /////////////////////////////////////////////////
  // go all the way down to the leaves, always turn leftmost
  while (!curNode->isLeaf)
    curNode = curNode->sons[0];

  /////////////////////////////////////////////////
  // set first movie to be current
  if (curNode->movieList[0])
    curNode->movieList[0]->current = TRUE;
  
  /////////////////////////////////////////////////
  // return first movie
  return (curNode->movieList[0]);
}

////////////////////////////////////////////////////////////
//                                                        //
//                 return next movie                      //
//                                                        //
////////////////////////////////////////////////////////////
Movie *BStarTree::nextMovie()
{
  BStarNode *curNode = anchor->root;
  
  /////////////////////////////////////////////////
  // go all the way down to the leaves, always turn leftmost
  while (!curNode->isLeaf)
    curNode = curNode->sons[0];
  
  /////////////////////////////////////////////////
  // go through the leaves until "current" of a
  // movie == TRUE, set the next movie to be current
  // and return that
  while (curNode){
    for (int i=0; i < curNode->movieCount; i++){
      if (curNode->movieList[i]->current == TRUE){
	curNode->movieList[i]->current = FALSE;
	if ((i+1) == curNode->movieCount){
	  if (curNode->nextLeaf){
	    curNode->nextLeaf->movieList[0]->current = TRUE;
	    return (curNode->nextLeaf->movieList[0]);
	  }
	} else {
	  if (curNode->movieList[i+1]){
	    curNode->movieList[i+1]->current = TRUE;
	    return (curNode->movieList[i+1]);
	  }
	}
      }
    }
    curNode = curNode->nextLeaf;
  }
  return NULL;
}


////////////////////////////////////////////////////////////
//                                                        //
//                 return current movie                   //
//                                                        //
////////////////////////////////////////////////////////////
Movie *BStarTree::currentMovie(QString key)
{
  BStarNode *curNode = anchor->root;
  int i=0;
  
  while (!curNode->isLeaf){
    while ((i<curNode->keyCount) && (curNode->key[i]<=key.data()))
      i++;
    curNode = curNode->sons[i];
    i=0;
  }
  
  while ((i<curNode->movieCount) && (curNode->movieList[i]->title != key.data()))
      i++;

  if ((curNode->movieList[i]) && (curNode->movieList[i]->title == key.data()))
    return(curNode->movieList[i]);
  else
    return NULL;
}


////////////////////////////////////////////////////////////
//                                                        //
//                 B-Overflow-Procedure                   //
//                                                        //
////////////////////////////////////////////////////////////
void BStarTree::bOverflow(BStarNode *here)
{
  BStarNode *current = root;
  BStarNode *curOld  = current;
  int i=0;
  BStarNode *newList1;

  ///////////////////////////////////////////////////
  // search the node "here" and its father
  while (current != here){
    while((i<current->keyCount) && (current->key[i] <= here->key[0].data()))
      i++;
    curOld = current;
    current = current->sons[i];
    i=0;
  }
  
  //////////////////////////////////////////////////
  // is current the root-node ??
  if (current == root) {

    ////////////////////////////////////////////////
    // create two new nodes
    newList1     = new BStarNode();
    root = new BStarNode();
    newList1->isLeaf     = FALSE;
    root->isLeaf = FALSE;

    ////////////////////////////////////////////////
    // copy half the keys and pointers to the next node
    for (int j=MAX_PTRS/2+1; j < MAX_PTRS; j++){
      newList1->key[j-(MAX_PTRS/2+1)] = current->key[j];
      current->key[j]="";
      newList1->sons[j-(MAX_PTRS/2+1)] = current->sons[j];
      current->sons[j] = NULL;
      newList1->keyCount++;
    }
    newList1->sons[newList1->keyCount] = current->sons[current->keyCount];
    current->sons[current->keyCount] = NULL;
    current->keyCount -= newList1->keyCount;

    /////////////////////////////////////////////////
    // set key and pointers of new root-node
    root->keyCount = 1;
    root->key[0] = current->key[current->keyCount-1];
    current->key[current->keyCount-1] = "";
    current->keyCount--;
    root->sons[0] = current;
    root->sons[1] = newList1;

  } else {
    ////////////////////////////////////////////////
    // create one new node
    newList1 = new BStarNode();
    newList1->isLeaf = FALSE;
    ////////////////////////////////////////////////
    // copy half the the keys and pointers to the next node
    for (int j=MAX_PTRS/2+1; j < MAX_PTRS; j++){
      newList1->key[j-(MAX_PTRS/2+1)] = current->key[j];
      current->key[j]="";
      newList1->sons[j-(MAX_PTRS/2+1)] = current->sons[j];
      current->sons[j] = NULL;
      newList1->keyCount++;
    }
    newList1->sons[newList1->keyCount] = current->sons[current->keyCount];
    current->sons[current->keyCount] = NULL;
    current->keyCount -= newList1->keyCount;
    
    ////////////////////////////////////////////////
    // add a key and pointer to the father node
    curOld->key[curOld->keyCount] = current->key[current->keyCount-1];
    current->key[current->keyCount-1] = "";
    current->keyCount--;
    curOld->keyCount++;
    curOld->sons[curOld->keyCount] = newList1;
    curOld->sortKeyList();

    ///////////////////////////////////////////////
    // does the number of keys exceed the 
    // maximum number of keys??
    if (curOld->keyCount == MAX_PTRS)
      anchor->bOverflow(curOld);
  }
}

