#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>

#include <kiconloader.h>
#include <kfiledialog.h>
#include <kcombo.h>
#include <kmsgbox.h>

#include <qpushbutton.h>
#include <qfile.h>
#include <qmsgbox.h>
#include <qkeycode.h>
#include <qdialog.h>
#include <qpixmap.h>
#include <qtooltip.h>
#include <qlistbox.h>

#include "cass.h"
#include "hilfsrout.h"
#include "bstar.h"

extern BStarTree *anchor;

cassWindow::cassWindow(KVideoDB* parent, const char *name, int cass)
{
  setMaximumSize(320,170);
  setMinimumSize(320,20);
  resize(320,20);
  papa = parent;
  setCaption(i18n("Cassette-Window"));
  m1 = new QPushButton("",this,"m1");
  m1->setGeometry(10,10,300,25);
  m1->hide();
  m2 = new QPushButton("",this,"m2");
  m2->hide();
  m2->setGeometry(10,35,300,25);
  m3 = new QPushButton("",this,"m3");
  m3->hide();
  m3->setGeometry(10,60,300,25);
  m4 = new QPushButton("",this,"m4");
  m4->hide();
  m4->setGeometry(10,85,300,25);
  m5 = new QPushButton("",this,"m5");
  m5->hide();
  m5->setGeometry(10,110,300,25);
  m6 = new QPushButton("",this,"m6");
  m6->hide();
  m6->setGeometry(10,135,300,25);
  connect( m1, SIGNAL(clicked()), SLOT(slotM1Clicked()));  
  connect( m2, SIGNAL(clicked()), SLOT(slotM2Clicked()));  
  connect( m3, SIGNAL(clicked()), SLOT(slotM3Clicked()));  
  connect( m4, SIGNAL(clicked()), SLOT(slotM4Clicked()));  
  connect( m5, SIGNAL(clicked()), SLOT(slotM5Clicked()));  
  connect( m6, SIGNAL(clicked()), SLOT(slotM6Clicked()));  
  papa->setActiveWindow();
  papa->setFocus();
}

void cassWindow::hideAll()
{
  this->setCaption(i18n("Cassette-Window"));
  this->resize(220,20);
  this->m1->hide();
  this->m2->hide();
  this->m3->hide();
  this->m4->hide();
  this->m5->hide();
  this->m6->hide();
  this->m1->setText("");
  this->m2->setText("");
  this->m3->setText("");
  this->m4->setText("");
  this->m5->setText("");
  this->m6->setText("");
}


void cassWindow::showMovies(QString cass)
{
  Movie *current;
  int count=0;
  int which=0;
  
  QString capt = i18n("Cassette No. ");
  this->setCaption(capt + cass.data());
  
  current = anchor->firstMovie();
  
  while(current){
    if (current->cassette == cass){
      switch(current->index){
      case 1:
	this->m1->show();
	this->m1->setText(current->title);
	if (count < 1)
	  count = 1;
	which += 1;
	break;
      case 2:
	this->m2->show();
	this->m2->setText(current->title);
	if (count < 2)
	  count = 2;
	which += 2;
	break;
      case 3:
	this->m3->show();
	this->m3->setText(current->title);
	if (count < 3)
	  count = 3;
	which += 4;
	break;
      case 4:
	this->m4->show();
	this->m4->setText(current->title);
	if (count < 4)
	  count = 4;
	which += 8;
	break;
      case 5:
	this->m5->show();
	this->m5->setText(current->title);
	if (count < 5)
	  count = 5;
	which += 16;
	break;
      case 6:
	this->m6->show();
	this->m6->setText(current->title);
	if (count < 6)
	  count = 6;
	which += 32;
	break;
      default:
	break;
      }
    }
  current = anchor->nextMovie();
  }
  if (!(which & 1))
    m1->hide();
  if (!(which & 2))
    m2->hide();
  if (!(which & 4))
    m3->hide();
  if (!(which & 8))
    m4->hide();
  if (!(which & 16))
    m5->hide();
  if (!(which & 32))
    m6->hide();
  
  this->resize(220,20+count*25);
}



void cassWindow::slotM1Clicked()
{
  QString bText;
  
  bText = this->m1->text();
  if ((unsigned int)this->papa->gotoCurrent(bText) >= this->papa->movies->count())
    this->papa->movies->inSort(bText);
  this->papa->movies->setCurrentItem(this->papa->gotoCurrent(bText));
  this->papa->movies->centerCurrentItem();
}

void cassWindow::slotM2Clicked()
{
  QString bText;

  bText = this->m2->text();
  if ((unsigned int)this->papa->gotoCurrent(bText) >= this->papa->movies->count())
    this->papa->movies->inSort(bText);
  this->papa->movies->setCurrentItem(this->papa->gotoCurrent(bText));
  this->papa->movies->centerCurrentItem();
}

void cassWindow::slotM3Clicked()
{
  QString bText;
  bText = this->m3->text();
  if ((unsigned int)this->papa->gotoCurrent(bText) >= this->papa->movies->count())
    this->papa->movies->inSort(bText);
  this->papa->movies->setCurrentItem(this->papa->gotoCurrent(bText));
  this->papa->movies->centerCurrentItem();
}

void cassWindow::slotM4Clicked()
{
  QString bText;
  bText = this->m4->text();
  if ((unsigned int)this->papa->gotoCurrent(bText) >= this->papa->movies->count())
    this->papa->movies->inSort(bText);
  this->papa->movies->setCurrentItem(this->papa->gotoCurrent(bText));
  this->papa->movies->centerCurrentItem();
}

void cassWindow::slotM5Clicked()
{
  QString bText;
  bText = this->m5->text();
  if ((unsigned int)this->papa->gotoCurrent(bText) >= this->papa->movies->count())
    this->papa->movies->inSort(bText);
  this->papa->movies->setCurrentItem(this->papa->gotoCurrent(bText));
  this->papa->movies->centerCurrentItem();
}

void cassWindow::slotM6Clicked()
{
  QString bText;
  bText = this->m6->text();
  if ((unsigned int)this->papa->gotoCurrent(bText) >= this->papa->movies->count())
    this->papa->movies->inSort(bText);
  this->papa->movies->setCurrentItem(this->papa->gotoCurrent(bText));
  this->papa->movies->centerCurrentItem();
}

