#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>

#include <kiconloader.h>
#include <kfiledialog.h>
#include <kcombo.h>
#include <kmsgbox.h>

#include <qfile.h>
#include <qmsgbox.h>
#include <qkeycode.h>
#include <qlistbox.h>
#include <qdialog.h>
#include <qpixmap.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qtooltip.h>
#include <qgroupbox.h>

#include "movieWindow.h"
#include "movies.h"
#include "kvideodb.h"
#include "options.h"
#include "hilfsrout.h"
#include "bstar.h"

extern BStarTree *anchor;
extern Config config;
extern bool titleChange;
extern Movie *dummy;
extern char *picPath(char *);
extern char *myIcon(char *);
extern void addToRCFile(const char *,QStrList);
extern bool changed;
bool   gEdit;
Movie *gCurMov;

// Constructor for the Add a Movie Window
addMovieWindow::addMovieWindow(KVideoDB *parent,const char *name, bool edit,Movie *current):QDialog(parent,0,TRUE){
  

  if (edit){
    gEdit = TRUE;
    gCurMov = current;
  }else{
    gEdit = FALSE;
    gCurMov = NULL;
  }
  
  setFixedSize(740,440);
  setCaption(i18n("Add a Movie"));
  
  // create a DropZone over the entire window and connect it
  // to the slotDropEvent
  connect( new KDNDDropZone( this , DndURL), 
	   SIGNAL( dropAction( KDNDDropZone *) ), 
	   SLOT( slotDropEvent( KDNDDropZone *) ) );
  
  // Local Variables used for the positioning of the Widgets
  int xStart     = 20;
  int yStart     = 40;
  int xOffset;
  int yOffset    = 35;
  int xSizeLine  = 200;
  int xSizeLabel = 120;
  int ySize      = 25;

  dataTab = new KTabCtl(this,"dataTab");
  dataTab->setGeometry(0,0,740,405);
  
  page1 = new QWidget(dataTab,"p1");
  page2 = new QWidget(dataTab,"p2");
  page3 = new QWidget(dataTab,"p3");

  dataTab->addTab(page1,i18n("&Data"));
  dataTab->addTab(page2,i18n("&Properties"));
  dataTab->addTab(page3,i18n("&Comment"));
  
  // Dummy Button to be able to access the arrow-buttons
  // via the same key-combination (Page-Down)
  QPushButton *dButton = new QPushButton("", this);
  dButton->setGeometry(1,1,0,0);
  dButton->setAccel(Key_PageDown);
  dButton->setFocusPolicy(QWidget::NoFocus);
  connect(dButton,SIGNAL(clicked()), SLOT(slotPDClicked()));

  // Dummy Button to be able to access the OK Button via shift-return
  QPushButton *d2Button = new QPushButton("", this);
  d2Button->setGeometry(1,2,0,0);
  d2Button->setAccel(SHIFT+Key_Return);
  d2Button->setFocusPolicy(QWidget::NoFocus);
  connect(d2Button,SIGNAL(clicked()), SLOT(slotOK()));

  // Dummy Button to be able to move thorugh the input fields
  // also via return
  QPushButton *d3Button = new QPushButton("", this);
  d3Button->setGeometry(1,3,0,0);
  d3Button->setDefault(TRUE);
  d3Button->setFocusPolicy(QWidget::NoFocus);
  connect(d3Button,SIGNAL(clicked()), SLOT(slotRetPressed()));

  // Frames for a nice look

  QGroupBox *insertFrame = new QGroupBox(page1,"");
  insertFrame->setGeometry(10,15,630,340);
  insertFrame->setFrameStyle(QFrame::Box|QFrame::Raised);
  insertFrame->setTitle(i18n("Fill in Data:"));

  QGroupBox *sepFrame = new QGroupBox(page1,"");
  sepFrame->setGeometry(365,22,355,333);
  sepFrame->setFrameStyle(QFrame::Box|QFrame::Raised);

  QGroupBox *insertFrame2 = new QGroupBox(page2,"");
  insertFrame2->setGeometry(10,15,630,235);
  insertFrame2->setFrameStyle(QFrame::Box|QFrame::Raised);
  insertFrame2->setTitle(i18n("Choose Properties:"));

  QGroupBox *sepFrame2 = new QGroupBox(page2,"");
  sepFrame2->setGeometry(365,15,355,235);
  sepFrame2->setFrameStyle(QFrame::Box|QFrame::Raised);
  sepFrame2->setTitle(i18n("Choose Properties:"));

  QGroupBox *flagFrame = new QGroupBox(page2,"");
  flagFrame->setGeometry(10,260,710,95);
  flagFrame->setFrameStyle(QFrame::Box|QFrame::Raised);
  flagFrame->setTitle(i18n("Choose Flags:"));
 
  QGroupBox *commentFrame = new QGroupBox(page3,"");
  commentFrame->setGeometry(10,15,710,340);
  commentFrame->setFrameStyle(QFrame::Box|QFrame::Raised);
  commentFrame->setTitle(i18n("Type Comments:"));

  // Build LineEdits

  title_e = new QLineEdit(page1,"title_in");
  title_e->setGeometry(xStart+130,yStart,xSizeLine-30,ySize);
  title_e->setFocus();
  title_l = new QLabel(i18n("Movie Name:"),page1,"title_l",0);
  title_l->setGeometry(xStart,yStart,xSizeLabel,ySize);
  
  takeTitle = new QPushButton( "", page1, "tT" );
  takeTitle->setGeometry(xStart+130+xSizeLine-25,yStart,25,ySize);
  takeTitle->setPixmap(QPixmap::QPixmap(Icon("down.xpm")));
  connect(takeTitle,  SIGNAL(clicked()), SLOT(slotCopyTitle()));

  original_e = new QLineEdit(page1,"orig_in");
  original_e->setGeometry(xStart+130,yStart+yOffset,xSizeLine,ySize);
  original_l = new QLabel(i18n("Original Name:"),page1,"title_l",0);
  original_l->setGeometry(xStart,yStart+yOffset,xSizeLabel,ySize);

  kass_e = new QLineEdit(page1,"kass_in");
  kass_e->setGeometry(xStart+130,yStart+2*yOffset,xSizeLine,ySize);
  kass_l = new QLabel(i18n("Cassette:"),page1,"title_l",0);
  kass_l->setGeometry(xStart,yStart+2*yOffset,xSizeLabel,ySize);

  start_e = new QLineEdit(page1,"start_in");
  start_e->setGeometry(xStart+130,yStart+3*yOffset,xSizeLine,ySize);
  start_l = new QLabel(i18n("Start:"),page1,"start_l",0);
  start_l->setGeometry(xStart,yStart+3*yOffset,xSizeLabel,ySize);

  length_e = new QLineEdit(page1,"length_in");
  length_e->setGeometry(xStart+130,yStart+4*yOffset,82,ySize);
  length_l = new QLabel(i18n("Length / orig. Length:"),page1,"title_l",0);
  length_l->setGeometry(xStart,yStart+4*yOffset,xSizeLabel,ySize);

  takeLength = new QPushButton( "", page1, "tL" );
  takeLength->setGeometry(xStart+130+87,yStart+4*yOffset,ySize,ySize);
  takeLength->setPixmap(QPixmap::QPixmap(Icon("forward.xpm")));
  connect(takeLength,  SIGNAL(clicked()), SLOT(slotCopyLength()));

  olength_e = new QLineEdit(page1,"olength_in");
  olength_e->setGeometry(xStart+130+ySize+92,yStart+4*yOffset,83,ySize);

  country_e = new QLineEdit(page1,"country_in");
  country_e->setGeometry(xStart+130,yStart+5*yOffset,xSizeLine/2,ySize);
  country_l = new QLabel(i18n("Country / Year:"),page1,"title_l",0);
  country_l->setGeometry(xStart,yStart+5*yOffset,xSizeLabel,ySize);

  year_e = new QLineEdit(page1,"year_in");
  year_e->setGeometry(xStart+130+xSizeLine/2,yStart+5*yOffset,xSizeLine/2,ySize);
  
  date_e = new QLineEdit(page1,"date_in");
  date_e->setGeometry(xStart+130,yStart+6*yOffset,xSizeLine,ySize);
  date_l = new QLabel(i18n("Date of Recording:"),page1,"title_l",0);
  date_l->setGeometry(xStart,yStart+6*yOffset,xSizeLabel,ySize);

  // Second Column
  xStart = 375;

  director_e = new QLineEdit(page1,"direct_in");
  director_e->setGeometry(xStart+130,yStart,xSizeLine,ySize);
  director_l = new QLabel(i18n("Director:"),page1,"title_l",0);
  director_l->setGeometry(xStart,yStart,xSizeLabel,ySize);

  producer_e = new QLineEdit(page1,"prod_in");
  producer_e->setGeometry(xStart+130,yStart+yOffset,xSizeLine,ySize);
  producer_l = new QLabel(i18n("Producer:"),page1,"title_l",0);
  producer_l->setGeometry(xStart,yStart+yOffset,xSizeLabel,ySize);

  cast1_e = new QLineEdit(page1,"cast1_in");
  cast1_e->setGeometry(xStart+130,yStart+2*yOffset,xSizeLine,ySize);
  cast1_l = new QLabel(i18n("Cast 1:"),page1,"title_l",0);
  cast1_l->setGeometry(xStart,yStart+2*yOffset,xSizeLabel,ySize);

  cast2_e = new QLineEdit(page1,"cast2_in");
  cast2_e->setGeometry(xStart+130,yStart+3*yOffset,xSizeLine,ySize);
  cast2_l = new QLabel(i18n("Cast 2:"),page1,"title_l",0);
  cast2_l->setGeometry(xStart,yStart+3*yOffset,xSizeLabel,ySize);

  cast3_e = new QLineEdit(page1,"cast3_in");
  cast3_e->setGeometry(xStart+130,yStart+4*yOffset,xSizeLine,ySize);
  cast3_l = new QLabel(i18n("Cast 3:"),page1,"title_l",0);
  cast3_l->setGeometry(xStart,yStart+4*yOffset,xSizeLabel,ySize);

  cast4_e = new QLineEdit(page1,"cast4_in");
  cast4_e->setGeometry(xStart+130,yStart+5*yOffset,xSizeLine,ySize);
  cast4_l = new QLabel(i18n("Cast 4:"),page1,"title_l",0);
  cast4_l->setGeometry(xStart,yStart+5*yOffset,xSizeLabel,ySize);

  composer_e = new QLineEdit(page1,"comp_in");
  composer_e->setGeometry(xStart+130,yStart+6*yOffset,xSizeLine,ySize);
  composer_l = new QLabel(i18n("Composer:"),page1,"comp_l",0);
  composer_l->setGeometry(xStart,yStart+6*yOffset,xSizeLabel,ySize);

  // IMDB-Button to search the Movies in the Internet Movie Database
  // to be done in the future

  imdb_b = new QPushButton(page1,"imdbb");
  imdb_b->setGeometry(xStart+130,yStart+7*yOffset,xSizeLine,60);
  QPixmap *imdb_p = new QPixmap(picPath(i18n("imdb.xpm")));
  imdb_b->setPixmap(*imdb_p);
  connect(imdb_b,SIGNAL(clicked()),SLOT(slotNotYet()));

  ////////////////////////////////////
  //                                //
  //        2nd page                //
  //                                //
  ////////////////////////////////////

  xStart  = 20;
  xOffset = 130;

  // Build QComboBoxes and their Labels 

  // Indexes
  index_e = new QComboBox(FALSE,page2,"index_in");
  index_e->setGeometry(xStart+xOffset,yStart,xSizeLine,ySize);
  index_e->insertItem(i18n("<Unknown>"),-1);
  index_e->insertItem(i18n("First Movie"),-1);
  index_e->insertItem(i18n("Second Movie"),-1);
  index_e->insertItem(i18n("Third Movie"),-1);
  index_e->insertItem(i18n("Fourth Movie"),-1);
  index_e->insertItem(i18n("Fifth Movie"),-1);
  index_e->insertItem(i18n("Sixth Movie"),-1);

  index_l = new QLabel(i18n("Index on Tape:"),page2,"index",0);
  index_l->setGeometry(xStart,yStart,xSizeLabel,ySize);
  
  // Category 1

  config.category.first();
  category1_e = new QComboBox(FALSE,page2,"cat1_in");
  category1_e->setGeometry(xStart+xOffset,yStart+yOffset,xSizeLine,ySize);
  category1_e->insertItem(i18n("<Unknown>"),-1);
  category1_e->insertStrList(&(config.category),-1);
  category1_l = new QLabel(i18n("Category 1:"),page2,"cat1",0);
  category1_l->setGeometry(xStart,yStart+yOffset,xSizeLabel,ySize);
  
  // Category 2
  
  config.category.first();
  category2_e = new QComboBox(FALSE,page2,"cat2_in");
  category2_e->setGeometry(xStart+xOffset,yStart+2*yOffset,xSizeLine,ySize);
  category2_e->insertItem(i18n("<Unknown>"),-1);
  category2_e->insertStrList(&(config.category),-1);
  category2_l = new QLabel(i18n("Category 2:"),page2,"cat2",0);
  category2_l->setGeometry(xStart,yStart+2*yOffset,xSizeLabel,ySize);
  
  // Sound

  config.sound.first();
  sound_e = new QComboBox(FALSE,page2,"sound_in");
  sound_e->setGeometry(xStart+xOffset,yStart+3*yOffset,xSizeLine,ySize);
  sound_e->insertItem(i18n("<Unknown>"),-1);
  sound_e->insertStrList(&(config.sound),-1);
  sound_l = new QLabel(i18n("Sound:"),page2,"soundl",0);
  sound_l->setGeometry(xStart,yStart+3*yOffset,xSizeLabel,ySize);
  
  // Speed 

  config.speed.first();
  lp_e = new QComboBox(FALSE,page2,"lp_in");
  lp_e->setGeometry(xStart+xOffset,yStart+4*yOffset,xSizeLine,ySize);
  lp_e->insertItem(i18n("<Unknown>"),-1);
  lp_e->insertStrList(&(config.speed),-1);
  speed_l = new QLabel(i18n("Speed:"),page2,"speedl",0);
  speed_l->setGeometry(xStart,yStart+4*yOffset,xSizeLabel,ySize);
  
  // FSK

  config.fsk.first();
  fsk_e = new QComboBox(FALSE,page2,"fsk_in");
  fsk_e->setGeometry(xStart+xOffset,yStart+5*yOffset,xSizeLine,ySize);
  fsk_e->insertItem(i18n("<Unknown>"),-1);
  fsk_e->insertStrList(&(config.fsk),-1);
  fsk_l = new QLabel(i18n("Rated as:"),page2,"fskl",0);
  fsk_l->setGeometry(xStart,yStart+5*yOffset,xSizeLabel,ySize);

  //////////////////  
  // Second Column
  
  xStart = 375;

  // Source

  config.source.first();
  source_e = new QComboBox(FALSE,page2,"source_in");
  source_e->setGeometry(xStart+xOffset,yStart,xSizeLine,ySize);
  source_e->insertItem(i18n("<Unknown>"),-1);
  source_e->insertStrList(&(config.source),-1);
  source_l = new QLabel(i18n("Recorded from:"),page2,"sourcel",0);
  source_l->setGeometry(xStart,yStart,xSizeLabel,ySize);
  
  // Videonorm

  config.videonorm.first();
  videonorm_e = new QComboBox(FALSE,page2,"videonorm_in");
  videonorm_e->setGeometry(xStart+xOffset,yStart+yOffset,xSizeLine,ySize);
  videonorm_e->insertItem(i18n("<Unknown>"));
  videonorm_e->insertStrList(&(config.videonorm));
  videonorm_l = new QLabel(i18n("Videonorm:"),page2,"videonorm1",0);
  videonorm_l->setGeometry(xStart,yStart+yOffset,xSizeLabel,ySize);
  
  // Rating

  rating_e = new QComboBox(FALSE,page2,"rating_in");
  rating_e->setGeometry(xStart+xOffset,yStart+2*yOffset,xSizeLine,ySize);
  QString rate = i18n("Rating");
  
  rating_e->insertItem(i18n("<Unknown>"),-1);
  rating_e->insertItem(rate + ":  0",-1);
  rating_e->insertItem(rate + ":  1",-1);
  rating_e->insertItem(rate + ":  2",-1);
  rating_e->insertItem(rate + ":  3",-1);
  rating_e->insertItem(rate + ":  4",-1);
  rating_e->insertItem(rate + ":  5",-1);
  rating_e->insertItem(rate + ":  6",-1);
  rating_e->insertItem(rate + ":  7",-1);
  rating_e->insertItem(rate + ":  8",-1);
  rating_e->insertItem(rate + ":  9",-1);
  rating_e->insertItem(rate + ": 10",-1);

  rating_l = new QLabel(i18n("Quality-Points:"),page2,"type1",0);
  rating_l->setGeometry(xStart,yStart+2*yOffset,xSizeLabel,ySize);

  recType_e = new QComboBox(FALSE,page2,"recType_in");
  recType_e->setGeometry(xStart+xOffset,yStart+3*yOffset,xSizeLine,ySize);
  recType_e->insertItem(i18n("<Unknown>"),-1);
  recType_e->insertStrList(&(config.recType),-1);
  recType_l = new QLabel(i18n("Recording-Type:"),page2,"recType_l",0);
  recType_l->setGeometry(xStart,yStart+3*yOffset,xSizeLabel,ySize);

  tapeType_e = new QComboBox(FALSE,page2,"tapeType_in");
  tapeType_e->setGeometry(xStart+xOffset,yStart+4*yOffset,xSizeLine,ySize);
  tapeType_e->insertItem(i18n("<Unknown>"),-1);
  tapeType_e->insertStrList(&(config.tapeType),-1);
  tapeType_l = new QLabel(i18n("Tape-Type:"),page2,"tapeType_l",0);
  tapeType_l->setGeometry(xStart,yStart+4*yOffset,xSizeLabel,ySize);

  tapeLength_e = new QComboBox(FALSE,page2,"tapeType_in");
  tapeLength_e->setGeometry(xStart+xOffset,yStart+5*yOffset,xSizeLine,ySize);
  tapeLength_e->insertItem(i18n("<Unknown>"),-1);
  tapeLength_e->insertStrList(&(config.tapeLength),-1);
  tapeLength_l = new QLabel(i18n("Tape-Length:"),page2,"tapeLength_l",0);
  tapeLength_l->setGeometry(xStart,yStart+5*yOffset,xSizeLabel,ySize);

  // Build ToggleButtons for the Movie-Properties

  xStart = 20;
  xSizeLabel = 120;
  yStart = 280;
  yOffset = 35;
  xOffset = 142;
  // Color

  QLabel *color_l = new QLabel(i18n("Color:"),page2,"col",0);
  color_l->setGeometry(xStart,yStart,xSizeLabel,ySize);
  color_l->setAlignment(AlignCenter);
  
  color_e = new QPushButton(page2,"colore");
  color_e->setToggleButton(TRUE);
  color_e->setGeometry(xStart+46,yStart+yOffset,ySize,ySize);
  color_e->setPixmap(QPixmap::QPixmap(picPath(i18n("color.xpm"))));
  connect(color_e,SIGNAL(clicked()),SLOT(slotColClicked()));
  // Commercial

  QLabel *commercial_l = new QLabel(i18n("Commercial:"),page2,"com",0);
  commercial_l->setGeometry(xStart+xOffset,yStart,xSizeLabel,ySize);
  commercial_l->setAlignment(AlignCenter);
  
  commercial_e = new QPushButton(page2,"commerciale");
  commercial_e->setToggleButton(TRUE);
  commercial_e->setGeometry(xStart+46+xOffset,yStart+yOffset,ySize,ySize);
  commercial_e->setPixmap(QPixmap::QPixmap(picPath(i18n("nocommercial.xpm"))));
  connect(commercial_e,SIGNAL(clicked()),SLOT(slotComClicked()));

  // Widescreen
  
  QLabel *wide_l = new QLabel(i18n("Widescreen:"),page2,"wid",0);
  wide_l->setGeometry(xStart+2*xOffset,yStart,xSizeLabel,ySize);
  wide_l->setAlignment(AlignCenter);
  
  widescreen_e = new QPushButton(page2,"widescreene");
  widescreen_e->setToggleButton(TRUE);
  widescreen_e->setGeometry(xStart+46+2*xOffset,yStart+yOffset,ySize,ySize);
  widescreen_e->setPixmap(QPixmap::QPixmap(picPath(i18n("smallscreen.xpm"))));
  connect(widescreen_e,SIGNAL(clicked()),SLOT(slotWidClicked()));

  // Subtitles

  QLabel *omu_l = new QLabel(i18n("Subtitles:"),page2,"omu",0);
  omu_l->setGeometry(xStart+3*xOffset,yStart,xSizeLabel,ySize);
  omu_l->setAlignment(AlignCenter);
  
  omu_e = new QPushButton(page2,"omue");
  omu_e->setToggleButton(TRUE);
  omu_e->setGeometry(xStart+46+3*xOffset,yStart+yOffset,ySize,ySize);
  omu_e->setPixmap(QPixmap::QPixmap(picPath(i18n("noomu.xpm"))));
  connect(omu_e,SIGNAL(clicked()),SLOT(slotSubClicked()));

  // Closed Caption

  QLabel *caption_l = new QLabel(i18n("Closed Caption:"),page2,"cap",0);
  caption_l->setGeometry(xStart+4*xOffset,yStart,xSizeLabel,ySize);
  caption_l->setAlignment(AlignCenter);
  
  caption_e = new QPushButton(page2,"captione");
  caption_e->setToggleButton(TRUE);
  caption_e->setGeometry(xStart+46+4*xOffset,yStart+yOffset,ySize,ySize);
  caption_e->setPixmap(QPixmap::QPixmap(picPath(i18n("nocaption.xpm"))));
  connect(caption_e,SIGNAL(clicked()),SLOT(slotCapClicked()));

  // Help / ToolTips for ToggleButtons

  QToolTip::add(color_e,i18n("Check if movie is black & white"));
  QToolTip::add(commercial_e,i18n("Check if movie contains commercials"));
  QToolTip::add(widescreen_e,i18n("Check if movie is in widescreen"));
  QToolTip::add(omu_e,i18n("Check if movie has subtitles"));
  QToolTip::add(caption_e,i18n("Check if movie has closed captions"));
  
  ////////////////////////////////////
  //                                //
  //        3rd page                //
  //                                //
  ////////////////////////////////////

  // qmultilineedit for comments

  comments = new QMultiLineEdit(page3,"comment_e");
  comments->setGeometry(25,40,675,265);

  /////////////////////////////////////////////////////////////////

  // OK and Cancel-Button

  ok_b = new QPushButton(i18n("&OK"), this);
  ok_b->setGeometry(510,410,115,25);
  ok_b->setAccel(ALT+Key_O);
  connect(ok_b, SIGNAL(clicked()), SLOT(slotOK()));

  cancel_b = new QPushButton(i18n("Cancel"), this, "cancelb");
  cancel_b->setGeometry(625,410,115,25);
  cancel_b->setAccel(Key_Escape);
  connect(cancel_b, SIGNAL(clicked()), SLOT(slotCancel()));
  

  // set parent 
  // used in the addMovieWindow::slotOK()-Function

  papa = parent;
  
}

///////////////////////////////////////////////////////////////////////////
//                                                                       //
//                                  Slots                                //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

// How to react if the OK-Button is pressed in the Add a movie window
void addMovieWindow::slotOK()
{
  int      buttonPressed;
  char    *fehler;
  char     day[3];
  char     year[5];
  char     month[3];
  QString  kass;

  dummy = new Movie();

  // Copy and verify title
  if (gEdit && (gCurMov->title != this->title_e->text()))
    titleChange = TRUE;
  dummy->title = this->title_e->text();
  if (dummy->title == "") {
    KMsgBox::message(this,i18n("Error in Title Field"),i18n("Please fill out Title Field!"),0,"OK");    
    this->title_e->setFocus();
    return;
  }
  
  if (!gEdit){
    // Does the movie exist already??
    kass = titleExists(dummy->title.data());
    if (kass){
      kass = i18n("Movie exists already on Cassette \"") + kass;
      kass += i18n("\"\nShould it be added anyway?");
      buttonPressed = KMsgBox::yesNo(this,i18n("Question"),kass,8);
    
      switch(buttonPressed){
      case 1:
	// It should be added anyway
	// so add spaces to be able to find it anyway
	do
	  dummy->title += " ";
	while (titleExists(dummy->title.data()));
	break;
      case 2:
	// Dont add it
	// Just go back, to give the user the chance to change the title
	return;
	break;
      default:
	break;
      }
    }
    
  } else {
    anchor->remove(gCurMov);
    //papa->movies->removeItem(papa->movies->currentItem());
  }
  
    
  // Copy original, director, producer, cast, category
  dummy->original=this->original_e->text();
  dummy->director=this->director_e->text();
  dummy->producer=this->producer_e->text();
  dummy->cast.insert(0,this->cast1_e->text());
  dummy->cast.insert(1,this->cast2_e->text());
  dummy->cast.insert(2,this->cast3_e->text());
  dummy->cast.insert(3,this->cast4_e->text());
  dummy->category.clear();
  if (this->category1_e->currentItem() > 0)
    dummy->category.append(this->category1_e->currentText());
  else
    dummy->category.append("<?>");
  if (this->category2_e->currentItem() > 0)
    dummy->category.append(this->category2_e->currentText());
  else
    dummy->category.append("<?>");
    
  // construct property-flags
  // flags are recorded as a single (dual) integer-number
  // 2^0 : b&w
  // 2^1 : commercial
  // 2^2 : widescreen
  // 2^3 : subtitles
  // 2^4 : closed captions
  dummy->flags       = 0;
  if (this->color_e->isOn())
    dummy->flags += 1;
  if (this->commercial_e->isOn())
    dummy->flags += 2;
  if (this->widescreen_e->isOn())
    dummy->flags += 4;
  if (this->omu_e->isOn())
    dummy->flags += 8;
  if (this->caption_e->isOn())
    dummy->flags += 16;
  
  // Copy and verify Cassette-Nr.
  dummy->cassette=this->kass_e->text();
  if (dummy->cassette == "") {
    KMsgBox::message(this,i18n("Error in Cassette Field"),i18n("Please fill out Cassette Field!"),0,"OK");    
    this->kass_e->setFocus();
    return;
  }
  
  // Copy and verify start-time
  if (strlen(this->start_e->text()) > 0){
    dummy->start = strtol(this->start_e->text(),&fehler,10);
    if (strcmp(fehler,"\0")){
      KMsgBox::message(this,i18n("Error in Start Field"),i18n("Only numbers allowed in the Start Field"),0,"OK");    
      this->start_e->setSelection(0,strlen(this->start_e->text()));
      this->start_e->setFocus();
      return;
    }
  } else
    dummy->start=-1;
  
  
  // Copy and verify length and original length
  dummy->length[0]   = strtol(this->length_e->text(),&fehler,10);
  if (strcmp(fehler,"\0")){
    KMsgBox::message(this,i18n("Error in first Length Field"),i18n("Only numbers allowed in the Length Fields"),0,"OK");    
    this->length_e->setSelection(0,strlen(this->length_e->text()));
    this->length_e->setFocus();
    return;
  } 
  
  dummy->length[1]   = strtol(this->olength_e->text(),&fehler,10);
  if (strcmp(fehler,"\0")){
    KMsgBox::message(this,i18n("Error in second Length Field"),i18n("Only numbers allowed in the Length Fields"),0,"OK");    
    this->olength_e->setSelection(0,strlen(this->olength_e->text()));
    this->olength_e->setFocus();
    return;
  }
  
  //index
  dummy->index = this->index_e->currentItem();
  
  // Does the combination Cassette/Index already exist??
  if ((!gEdit) && (!checkCassIndex(dummy->cassette,dummy->index))){
    KMsgBox::message(this,i18n("Error"),i18n("Combination Cassette/Index already exists"),0,"OK");    
    this->kass_e->setSelection(0,strlen(this->kass_e->text()));
    this->kass_e->setFocus();
    return;
  }
  
  // Copy and verify country
  // if country not yet included in config.country then ask whether it should be added
  dummy->country=this->country_e->text();
  if ((!config.country.contains(dummy->country)) && (dummy->country != "")){
    QString countryText;
    countryText = i18n("Unknown Country \"");
    countryText += dummy->country;
    countryText += i18n("\"\nShould it be added to Country-List?");    
    buttonPressed = KMsgBox::yesNo(this,i18n("Question"),countryText,8);
    switch(buttonPressed) {
    case 1:
      config.country.append(dummy->country);
      addToRCFile("country",config.country);
      break;
    case 2:
      return;
      break;
    }
  } else {
  }
  
  // Copy and verify year
  dummy->year        = strtol(this->year_e->text(),&fehler,10);
  if (strcmp(fehler,"\0")){
    KMsgBox::message(this,i18n("Error in the Year Field"),i18n("Only numbers allowed in the Year Field"),0,"OK");    
    this->year_e->setSelection(0,strlen(this->year_e->text()));
    this->year_e->setFocus();
    return;
  }
  
  // Copy and verify date of recording
  if (strcmp(this->date_e->text(),"")) {
    sprintf(day,"%c%c",this->date_e->text()[0],this->date_e->text()[1]);
    sprintf(month,"%c%c",this->date_e->text()[3],this->date_e->text()[4]);
    sprintf(year,"%c%c%c%c",this->date_e->text()[6],this->date_e->text()[7],this->date_e->text()[8],this->date_e->text()[9]);
    // If only 2 digits have been entered for year do the following:
      // if number is smaller than current year, put the current century in front of year
    // else put previous century in front of year
    if (strlen(year) == 2){
      char curYear[5];
      sprintf(curYear,"%d",(QDate::currentDate().year()));
      
      if (atoi(year)<= atoi(curYear+2))
	sprintf(year,"%d",(atoi(curYear)/100)*100+atoi(year));
      else
	sprintf(year,"%d",((atoi(curYear)/100)-1)*100+atoi(year));
    }
    if (QDate::isValid(atoi(year),atoi(month),atoi(day))){
      dummy->date->setYMD(atoi(year),atoi(month),atoi(day));
    }else{
      KMsgBox::message(this,i18n("Error in the Date Field"),i18n("Please check the Date Format.\nIt should be \"dd.mm.yyyy\""),0,"OK");
      this->date_e->setSelection(0,strlen(this->date_e->text()));
      this->date_e->setFocus();
      return;
    }
  } else{
    dummy->date = new QDate();
  }
  
  // Copy sound, speed, source, videonorm
  if (sound_e->currentItem() > 0)
    dummy->sound=this->sound_e->currentText();
  else
    dummy->sound="<?>";
  if (lp_e->currentItem() > 0)
    dummy->speed=this->lp_e->currentText();
  else
    dummy->speed="<?>";
  if (source_e->currentItem() > 0)
    dummy->source=this->source_e->currentText();
  else
    dummy->source="<?>";
  if (videonorm_e->currentItem() > 0)
    dummy->videonorm=this->videonorm_e->currentText();
  else
    dummy->videonorm="<?>";
  if (fsk_e->currentItem() > 0)
    dummy->fsk=this->fsk_e->currentText();
  else
    dummy->fsk="<?>";

  // quality-points
  if (rating_e->currentItem() > 0)
    dummy->rating = this->rating_e->currentItem()-1;
  else
    dummy->rating = -1;
  
  // Tape-Length, Tape-Type, Recording-Type
  if (tapeLength_e->currentItem() > 0)
    dummy->tapeLength = atoi(this->tapeLength_e->currentText());
  else 
    dummy->tapeLength = 0;
  if (tapeType_e->currentItem() > 0)
    dummy->tapeType = this->tapeType_e->currentText();
  else
    dummy->tapeType = "<?>";
  if (recType_e->currentItem() > 0)
    dummy->recType = this->recType_e->currentText();
  else
    dummy->recType = "<?>";

  //////////////////////////////////////////////////
  // check the cassette data
  if (!cassDataOK(dummy)){
    QString cassData = i18n("Conflicting Cassette Data of Cassette No.");
    cassData += " ";
    cassData += dummy->cassette;
    cassData += "\n ";
    cassData += i18n("Tape-Type:");
    cassData += " ";
    if (dummy->tapeType == "<?>")
      cassData += i18n("<Unknown>");
    else
      cassData += dummy->tapeType;
    cassData += "\n ";
    cassData += i18n("Tape-Length:");
    cassData += " ";
    if (dummy->tapeLength == 0){
      cassData += i18n("<Unknown>");
      cassData += "\n";
    }else{
      char len[80];
      sprintf(len,"%d\n",dummy->tapeLength);
      cassData += len;
    }
    cassData += i18n("Is this data correct?");
    int buttonPressed = KMsgBox::yesNo(this,i18n("Question"),cassData,8);
    switch(buttonPressed) {
    case 1:
      changeCassData(dummy);
      break;
    case 2:
      changeThisCassData(dummy);
      break;
    }
  }
  
  // comments
  dummy->comment = this->comments->text();
  
  // Insert Movie in ListBox in MainWindow
  anchor->insert(dummy);
  QStrList movs;
  Movie *curMov = anchor->firstMovie();
  while (curMov){
    movs.inSort(curMov->title);
    curMov = anchor->nextMovie();
  }
  this->papa->movies->clear();
  this->papa->movies->insertStrList(&movs);
  this->papa->movies->setCurrentItem(this->papa->gotoCurrent(dummy->title));
  this->papa->movies->centerCurrentItem();
  gCurMov = dummy;
   
  this->papa->file->setItemEnabled(4,TRUE);
  this->papa->file->setItemEnabled(5,TRUE);
  this->papa->file->setItemEnabled(6,TRUE);
  this->papa->edit->setItemEnabled(this->papa->edit->idAt(4),TRUE);
  this->papa->toolBar()->setItemEnabled(12,TRUE);
  this->papa->toolBar()->setItemEnabled(13,TRUE);
  this->papa->toolBar()->setItemEnabled(30,TRUE);

  // Everything done and accepted - close window
  changed = TRUE;
  this->close();
}

// How to react if Cancel-Button is pressed in Add a movie Window
void addMovieWindow::slotCancel()
{
  // Just close the Window
  this->close();
}


void addMovieWindow::slotPDClicked()
{
  if (title_e->hasFocus())
    slotCopyTitle();
  else if (length_e->hasFocus())
    slotCopyLength();
}


void addMovieWindow::slotDropEvent( KDNDDropZone *zone){
  // the user dropped something on our window.
  // So we simply use KFM to download the stuff wherever it is.

  // Download Procedure to be done in future
  QString u = zone->getURLList().first(),s;
  if (KFM::download(u, s)){
    setCaption(u);
    //    loadFile(s);
    KFM::removeTempFile(s);
  }
}


void addMovieWindow::slotNotYet()
{
  KMsgBox::message(this,i18n("Error"),i18n("Not implemented yet!"),0,"OK");    
}

void addMovieWindow::slotCopyTitle()
{
  original_e->setText(title_e->text());
  kass_e->setFocus();
}

void addMovieWindow::slotCopyLength()
{
  olength_e->setText(length_e->text());
  country_e->setFocus();
}

void addMovieWindow::slotRetPressed()
{
  if (title_e->hasFocus()){
    takeTitle->setFocus();
    return;
  }
  if (takeTitle->hasFocus()){
    original_e->setFocus();
    return;
  }
  if (original_e->hasFocus()){
    kass_e->setFocus();
    return;
  }
  if (kass_e->hasFocus()){
    start_e->setFocus();
    return;
  }
  if (start_e->hasFocus()){
    length_e->setFocus();
    return;
  }
  if (length_e->hasFocus()){
    takeLength->setFocus();
    return;
  }
  if (takeLength->hasFocus()){
    olength_e->setFocus();
    return;
  }
  if (olength_e->hasFocus()){
    country_e->setFocus();
    return;
  }
  if (country_e->hasFocus()){
    year_e->setFocus();
    return;
  }
  if (year_e->hasFocus()){
    date_e->setFocus();
    return;
  }
  if (date_e->hasFocus()){
    director_e->setFocus();
    return;
  }
  if (director_e->hasFocus()){
    producer_e->setFocus();
    return;
  }
  if (producer_e->hasFocus()){
    cast1_e->setFocus();
    return;
  }
  if (cast1_e->hasFocus()){
    cast2_e->setFocus();
    return;
  }
  if (cast2_e->hasFocus()){
    cast3_e->setFocus();
    return;
  }
  if (cast3_e->hasFocus()){
    cast4_e->setFocus();
    return;
  }
  if (cast4_e->hasFocus()){
    index_e->setFocus();
    return;
  }
  if (index_e->hasFocus()){
    category1_e->setFocus();
    return;
  }
  if (category1_e->hasFocus()){
    category2_e->setFocus();
    return;
  }
  if (category2_e->hasFocus()){
    sound_e->setFocus();
    return;
  }
  if (sound_e->hasFocus()){
    lp_e->setFocus();
    return;
  }
  if (lp_e->hasFocus()){
    fsk_e->setFocus();
    return;
  }
  if (fsk_e->hasFocus()){
    source_e->setFocus();
    return;
  }
  if (source_e->hasFocus()){
    videonorm_e->setFocus();
    return;
  }
  if (videonorm_e->hasFocus()){
    rating_e->setFocus();
    return;
  }
  if (rating_e->hasFocus()){
    color_e->setFocus();
    return;
  }
  if (color_e->hasFocus()){
    commercial_e->setFocus();
    return;
  }
  if (commercial_e->hasFocus()){
    widescreen_e->setFocus();
    return;
  }
  if (widescreen_e->hasFocus()){
    omu_e->setFocus();
    return;
  }
  if (omu_e->hasFocus()){
    caption_e->setFocus();
    return;
  }
  if (caption_e->hasFocus()){
    imdb_b->setFocus();
    return;
  }
  if (imdb_b->hasFocus()){
    ok_b->setFocus();
    return;
  }
  if (ok_b->hasFocus()){
    cancel_b->setFocus();
    return;
  }
  if (cancel_b->hasFocus()){
    title_e->setFocus();
    return;
  }
  return;
}

void addMovieWindow::slotColClicked()
{
  if (color_e->isOn())
    color_e->setPixmap(QPixmap::QPixmap(picPath(i18n("bw.xpm"))));
  else
    color_e->setPixmap(QPixmap::QPixmap(picPath(i18n("color.xpm"))));
}

void addMovieWindow::slotComClicked()
{
  if (commercial_e->isOn())
    commercial_e->setPixmap(QPixmap::QPixmap(picPath(i18n("commercial.xpm"))));
  else
    commercial_e->setPixmap(QPixmap::QPixmap(picPath(i18n("nocommercial.xpm"))));
}

void addMovieWindow::slotWidClicked()
{
  if (widescreen_e->isOn())
    widescreen_e->setPixmap(QPixmap::QPixmap(picPath(i18n("widescreen.xpm"))));
  else
    widescreen_e->setPixmap(QPixmap::QPixmap(picPath(i18n("smallscreen.xpm"))));
}

void addMovieWindow::slotSubClicked()
{
  if (omu_e->isOn())
    omu_e->setPixmap(QPixmap::QPixmap(picPath(i18n("omu.xpm"))));
  else
    omu_e->setPixmap(QPixmap::QPixmap(picPath(i18n("noomu.xpm"))));
}

void addMovieWindow::slotCapClicked()
{
  if (caption_e->isOn())
    caption_e->setPixmap(QPixmap::QPixmap(picPath(i18n("caption.xpm"))));
  else
    caption_e->setPixmap(QPixmap::QPixmap(picPath(i18n("nocaption.xpm"))));
}

