#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>

#include <kiconloader.h>
#include <kfiledialog.h>
#include <kcombo.h>
#include <kmsgbox.h>

#include <qdialog.h>
#include <qfile.h>
#include <qmsgbox.h>
#include <qkeycode.h>
#include <qlistbox.h>
#include <qdialog.h>
#include <qpixmap.h>
#include <qlineedit.h>
#include <qframe.h>
#include <qcheckbox.h>
#include <qtooltip.h>
#include <qstring.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qstrlist.h>

#include "movies.h"
#include "kvideodb.h"
#include "options.h"
#include "cass.h"

extern char *rcPath();
extern Config config;
extern cassWindow *kassette;


int gIndex=-1;

// Function to change a configuration-setting
void changeOptions(const char *entry,QString subject)
{
}

// Function to preset all config-entries which are empty after startup
void presetEmptyConfig()
{
  if (config.category.isEmpty()){
    config.category.append("Abenteuer");
    config.category.append("Action");
    config.category.append("Cartoon");
    config.category.append("Drama");
    config.category.append("Erotik");
    config.category.append("Fantasy");
    config.category.append("Gericht");
    config.category.append("Groteske");
    config.category.append("Horror");
    config.category.append("Katastrophe");
    config.category.append("Komdie");
    config.category.append("Krieg");
    config.category.append("Krimi");
    config.category.append("Monumental");
    config.category.append("Musical");
    config.category.append("Psycho");
    config.category.append("Romanze");
    config.category.append("Satire");
    config.category.append("Science-Fiction");
    config.category.append("Thriller");
    config.category.append("Trickfilm");
    config.category.append("Western");
  }
  if (config.country.isEmpty()){
    config.country.append("USA");
    config.country.append("D");
    config.country.append("BRD");
    config.country.append("GB");
    config.country.append("ENG");
    config.country.append("F");
    config.country.append("FRA");
    config.country.append("I");
    config.country.append("ITA");
    config.country.append("EU");
    config.country.append("ESP");
    config.country.append("SPA");
    config.country.append("JP");
    config.country.append("CAN");
  }
  if (config.sound.isEmpty()){
    config.sound.append("THX");
    config.sound.append("Surround");
    config.sound.append("Stereo");
    config.sound.append("Zweikanal");
    config.sound.append("Mono");
  }
  if (config.speed.isEmpty()){
    config.speed.append("SP");
    config.speedFac.append("1.0");
    config.speed.append("LP");
    config.speedFac.append("0.5");
    config.speed.append("EP");
    config.speedFac.append("0.33");
  }
  if (config.source.isEmpty()){
    config.source.append("Video");
    config.source.append("TV");
    config.source.append("Pay-TV");
    config.source.append("Camcorder");
    config.source.append("Original");
  }
  if (config.videonorm.isEmpty()){
    config.videonorm.append("Pal");
    config.videonorm.append("NTSC");
    config.videonorm.append("Secam-F");
    config.videonorm.append("Secam-Ost");
  }
  if (config.fsk.isEmpty()){
    config.fsk.append("FSK 0");
    config.fsk.append("FSK 6");
    config.fsk.append("FSK 12");
    config.fsk.append("FSK 16");
    config.fsk.append("FSK 18");
    config.fsk.append("Index");
  }
  if (config.tapeType.isEmpty()){
    config.tapeType.append("BASF");
    config.tapeType.append("Fuji");
    config.tapeType.append("JVC");
    config.tapeType.append("Maxell");
    config.tapeType.append("Philips");
    config.tapeType.append("Scotch");
    config.tapeType.append("Sony");
    config.tapeType.append("TDK");
  }
  if (config.tapeLength.isEmpty()){
    config.tapeLength.append("180");
    config.tapeLength.append("240");
    config.tapeLength.append("300");
  }
  if (config.recType.isEmpty()){
    config.recType.append("keep it");
    config.recType.append("not seen");
    config.recType.append("delete");
  }
  if (config.defIcons.isEmpty())
    config.defIcons = "Yes";
  if (config.showC.isEmpty())
    config.showC = "Yes";
  if (config.swallowC.isEmpty())
    config.swallowC = "No";
  if (config.askDelete.isEmpty())
    config.askDelete = "Yes";
}


// Function to add a subject to an entry in the local config file
void addToRCFile(const char *entry,QStrList subject)
{
  KConfig *kconfig = KApplication::getKApplication()->getConfig();
  
  if (kconfig){
    kconfig->setGroup("entries");
    kconfig->writeEntry(entry,subject);
  }
}

// Constructor for the Config-Window
configWindow::configWindow(KVideoDB *parent,const char *name):QDialog(parent,0,TRUE){
  
  gIndex=-1;
  
  setFixedSize(300,325);
  setCaption(i18n("Configure Application"));

    // build a tabDialog
  tDialog = new QTabDialog(this,"topDialog");
  tDialog->setGeometry(0,0,300,325);
  tDialog->setCancelButton(i18n("Cancel"));
  tDialog->setOkButton(i18n("OK"));

  connect(tDialog, SIGNAL(cancelButtonPressed()), SLOT(slotCancel()));
  connect(tDialog, SIGNAL(applyButtonPressed()), SLOT(slotOK()));
  
  page1 = new QWidget(tDialog,"p1");
  page2 = new QWidget(tDialog,"p2");

  // A Frame all around the window
  QGroupBox *insertFrame = new QGroupBox(page1,"");
  insertFrame->setGeometry(10,10,265,80);
  insertFrame->setFrameStyle(QFrame::Box|QFrame::Sunken);
  insertFrame->setTitle(i18n("Cassette-Window"));

  QGroupBox *frame1 = new QGroupBox(page1,"");
  frame1->setGeometry(10,95,265,145);
  frame1->setFrameStyle(QFrame::Box|QFrame::Sunken);
  frame1->setTitle(i18n("General Options"));
  
  // CheckBoxes for the possibilities of configuring the program
  defIcoCheck = new QCheckBox(page1,"defIcoCheck");
  defIcoCheck->setGeometry(20,115,210,25);
  defIcoCheck->setText(i18n("Show all Properties"));
  if(config.defIcons == "Yes")
    defIcoCheck->setChecked(TRUE);
  else
    defIcoCheck->setChecked(FALSE);

  showCassCheck = new QCheckBox(page1,"showCassWin");
  showCassCheck->setGeometry(20,30,210,25);
  showCassCheck->setText(i18n("Show Cassette Window"));
  if (config.showC == "Yes")
    showCassCheck->setChecked(TRUE);
  else
    showCassCheck->setChecked(FALSE);
  
  swallowCassCheck = new QCheckBox(page1,"swallowCassWin");
  swallowCassCheck->setGeometry(20,55,210,25);
  swallowCassCheck->setText(i18n("Swallow Cassette Window"));
  if (config.swallowC == "Yes")
    swallowCassCheck->setChecked(TRUE);
  else
    swallowCassCheck->setChecked(FALSE);
  
  askDelete = new QCheckBox(page1,"askDel");
  askDelete->setGeometry(20,140,210,25);
  askDelete->setText(i18n("Ask when deleting"));
  if (config.askDelete == "Yes")
    askDelete->setChecked(TRUE);
  else
    askDelete->setChecked(FALSE);

  // If the User wants to add a subject to an entry in the config-file
  confButtons = new QButtonGroup(page2);
  confButtons->setGeometry(10,10,265,230);
  connect(confButtons,SIGNAL(clicked(int)),SLOT(slotBClicked(int)));
  
  QRadioButton *cat = new QRadioButton(i18n("Category"),confButtons,"cat");
  cat->setGeometry(10,10,180,25);
  QRadioButton *sou = new QRadioButton(i18n("Sound"),confButtons,"sou");
  sou->setGeometry(10,35,180,25);
  QRadioButton *spe = new QRadioButton(i18n("Speed"),confButtons,"spe");
  spe->setGeometry(10,60,180,25);
  QRadioButton *fsk = new QRadioButton(i18n("Rated"),confButtons,"fsk");
  fsk->setGeometry(10,85,180,25);
  QRadioButton *vid = new QRadioButton(i18n("Videonorm"),confButtons,"vid");
  vid->setGeometry(10,110,180,25);
  QRadioButton *cou = new QRadioButton(i18n("Country"),confButtons,"cou");
  cou->setGeometry(10,135,180,25);
  QRadioButton *src = new QRadioButton(i18n("Source"),confButtons,"src");
  src->setGeometry(10,160,180,25);

  entry = new QLineEdit(page2,"entry");
  entry->setGeometry(20,205,155,25);
  QToolTip::add(confButtons,i18n("Select an Entry to which you want to add the specified Subject.\nIt is added by pressing the Add-Button."));

  addButton = new QPushButton(i18n("Add"),page2,"addb");
  addButton->setGeometry(185,205,80,25);
  connect(addButton, SIGNAL(clicked()), SLOT(slotAddClicked()));

  tDialog->addTab(page1,i18n("&Options"));
  tDialog->addTab(page2,i18n("&Properties"));
  
  // OK- and Cancel-Buttons
 //  QPushButton *okButton = new QPushButton(i18n("OK"),this,"okb");
//   okButton->setGeometry(230,285,100,25);
//   okButton->setAccel(Key_Return);
//   connect(okButton, SIGNAL(clicked()), SLOT(slotOK()));
//   okButton->setDefault(TRUE);

//   QPushButton *canButton = new QPushButton(i18n("Cancel"),this,"okb");
//   canButton->setGeometry(330,285,100,25);
//   canButton->setAccel(Key_Escape);
//   connect(canButton, SIGNAL(clicked()), SLOT(slotCancel()));

  papa = parent;
}

void configWindow::slotOK()
{
  if(defIcoCheck->isChecked()){
    this->papa->options->setItemChecked( this->papa->options->idAt( 0 ), TRUE );
    config.defIcons="Yes";
  }else {
    this->papa->options->setItemChecked( this->papa->options->idAt( 0 ), FALSE );
    config.defIcons="No";
  }
  
  if (showCassCheck->isChecked()){
    this->papa->options->setItemChecked( this->papa->options->idAt( 2 ), TRUE );
    config.showC="Yes";
    if (config.swallowC == "No")
      kassette->show();
    else{
      this->papa->movies->resize(250,290);
      this->papa->movies->centerCurrentItem();
    }
  } else {
    this->papa->options->setItemChecked( this->papa->options->idAt( 2 ), FALSE );
    config.showC="No";
    if (config.swallowC == "No")
      kassette->hide();
    else
      this->papa->movies->resize(250,455);
  }
  
  if (swallowCassCheck->isChecked()){
    this->papa->options->setItemChecked( this->papa->options->idAt( 3 ), TRUE );
    config.swallowC="Yes";
    kassette->hide();
    if (config.showC == "Yes"){
      this->papa->movies->resize(250,290);
      this->papa->movies->centerCurrentItem();
    }
  } else {
    this->papa->options->setItemChecked( this->papa->options->idAt( 3 ), FALSE );
    config.swallowC="No";
    if (config.showC=="Yes")
      kassette->show();
    this->papa->movies->resize(250,455);
  }

  if (askDelete->isChecked()){
    this->papa->options->setItemChecked( this->papa->options->idAt( 5 ), TRUE );
    config.askDelete="Yes";
  } else {
    this->papa->options->setItemChecked( this->papa->options->idAt( 5 ), FALSE );
    config.askDelete="No";
  }
  
  this->close();
  if (this->papa->movies->count() && (this->papa->movies->currentItem() > -1))
    this->papa->slotListClicked();
  return;
}

void configWindow::slotCancel()
{
  this->close();
  return;
}

void configWindow::slotAddClicked()
{
  bool OK=TRUE;
  
  if (gIndex > -1){
    if (strcmp(this->entry->text(),"")){
      switch (gIndex){
      case 0:
	// Category
	if (!config.category.contains(this->entry->text()))
	  config.category.inSort(this->entry->text());
	else{
	  OK=FALSE;
	  KMsgBox::message(this,i18n("Error"),i18n("Subject exists already"),0,"OK");
	}
	break;
      case 1:
	// Sound
	if (!config.sound.contains(this->entry->text()))
	  config.sound.append(this->entry->text());
	else{
	  OK=FALSE;
	  KMsgBox::message(this,i18n("Error"),i18n("Subject exists already"),0,"OK");
	}
	break;
      case 2:
	// Speed
	if (!config.speed.contains(this->entry->text()))
	  config.speed.append(this->entry->text());
	else{
	  OK=FALSE;
	  KMsgBox::message(this,i18n("Error"),i18n("Subject exists already"),0,"OK");
	}
	break;
      case 3:
	// FSK
	if (!config.fsk.contains(this->entry->text()))
	  config.fsk.append(this->entry->text());
	else{
	  OK=FALSE;
	  KMsgBox::message(this,i18n("Error"),i18n("Subject exists already"),0,"OK");
	}
	break;
      case 4:
	// Videonorm
	if (!config.videonorm.contains(this->entry->text()))
	  config.videonorm.append(this->entry->text());
	else{
	  OK=FALSE;
	  KMsgBox::message(this,i18n("Error"),i18n("Subject exists already"),0,"OK");
	}
	break;
      case 5:
	// Country
	if (!config.country.contains(this->entry->text()))
	  config.country.append(this->entry->text());
	else{
	  OK=FALSE;
	  KMsgBox::message(this,i18n("Error"),i18n("Subject exists already"),0,"OK");
	}
	break;
      case 6:
	// Source
	if (!config.source.contains(this->entry->text()))
	  config.source.append(this->entry->text());
	else{
	  OK=FALSE;
	  KMsgBox::message(this,i18n("Error"),i18n("Subject exists already"),0,"OK");
	}
	break;
      default:
	break;
      }
      // get the actual Configuration
      KConfig *kconfig = KApplication::getKApplication()->getConfig();
      // goto the Entries Group
      kconfig->setGroup("entries");
      // write the new Configuration
      kconfig->writeEntry("category",config.category);
      kconfig->writeEntry("country",config.country);
      kconfig->writeEntry("sound",config.sound);
      kconfig->writeEntry("speed",config.speed);
      kconfig->writeEntry("source",config.source);
      kconfig->writeEntry("videonorm",config.videonorm);
      kconfig->writeEntry("fsk",config.fsk);
      // write the RC-File
      kconfig->sync();
      if (OK)
	this->entry->setText("");
      else
	this->entry->setSelection(0,strlen(this->entry->text()));
    } else {
      KMsgBox::message(this,i18n("Error"),i18n("First type the subject you want to add"),0,"OK");
    }
  } else {
    KMsgBox::message(this,i18n("Error"),i18n("First select the entry you want to add a subject to"),0,"OK");
  }
}

void configWindow::slotBClicked(int index)
{
  gIndex = index;
}
