/*
 *   kvideolist - a database for home-movie collections 
 *   Copyright (C) 1998  Holger Hetterich
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */




#ifdef HAVE_CONFIG_H
#include <config.h>
#endif



#include <stdio.h>


#include <qfiledlg.h>

#include "KVideolist.moc"

#include <qmsgbox.h>
#include <qkeycode.h>
#include <kiconloader.h>
#include <qpushbt.h>
#include <qlistbox.h>
// #include <kbutton.h>
#include <kkeydata.h>
#include <qcombo.h>
#include <qlined.h>
#include <qpainter.h>
#include <qlabel.h>

#include <kmenubar.h>
#include <ktoolbar.h>
#include <kfiledialog.h>
#include "moviedialog.h"
#include "searchdialog.h"
#include "genredisplay.h"
#include "statistics.h"
#include "dbconfig.h"
#include "convert.h"
#include "urlcheck.h"
#include "about.h"
#include "printlist.h"
#include "export.h"
#include "setattrib.h"
#include "importer.h"





          





        






KVL::KVL() {



this->setCaption(klocale->translate("KVideolist - Empty List"));
this->Anker=0;
strcpy(DATEINAME,"\0");


PROCESS = new KVLProcess(0,"Process");
PROCESS->hide();



KMenuBar *menubar = new KMenuBar(this,"menubar");

KToolBar *toolBar=new KToolBar(this);

dropZone = new KDNDDropZone(this,DndURL);

connect( new KDNDDropZone(this,DndURL),SIGNAL(dropAction(KDNDDropZone *)),SLOT(slotDropEvent(KDNDDropZone *)));
SubClassF = new QComboBox(FALSE,this,"SubClass");
SubClassF->move(445-4,100);
SubClassF->resize(140,20);
SubClassF->setFont(QFont("Times",12));




Genre1C= new QComboBox(FALSE,this,"Genrechoose");
Genre1C->move(450+152-14-4,100);
Genre1C->resize(48+17,20);
Genre1C->setFont(QFont("Times",12));
connect(Genre1C,SIGNAL(activated(int)),SLOT(slotQuickGenreChange()));




QLabel *ChooseNumberL = new QLabel(klocale->translate("Goto Tape:"),this);
ChooseNumberL->adjustSize();
ChooseNumberL->move(305,100);

ChooseNumber = new QLineEdit(this,"nummer");
ChooseNumber->resize(50,20);
ChooseNumber->move(390,100);
connect( ChooseNumber,SIGNAL(returnPressed()),SLOT(slotChooseNumber()));
OriginalName= new QLineEdit(this,"original");
OriginalName->move(390,79+4);
OriginalName->resize(278,16);
OriginalNameL = new QLabel(klocale->translate("Original:"),this);
OriginalNameL->move(305,79+4);
OriginalNameL->adjustSize();
OriginalNameL->setFont(LabelFont);



QPixmap Hintergrund;
char Filename[90];
strcpy(Filename,kapp->kde_htmldir());
strcat(Filename,"/en/kvideolist/backgr.xpm");
 KConfig *config= KApplication::getKApplication()->getConfig();

/*
// KVIDEOLIST RELEASE NOTES
QMessageBox::information(this,"Release notes...","This snapshot of KVideolist comes with some new features (read ChangeLog) that made it \nnecessary to change some internals of the database. Therefore, KVideolist uses a new \nfileformat. If You have an older database, it MUST be converted using 'File->Convert...' to the new \nversion, otherwise KVideolist will crash. It is also highly recommended to \ndelete the KVideolist-configuration file in Your home directory \n(normally that's rm ./kde/share/config/kvideolistrc ) and restart KVideolist.");

*/




// FIRST TIME CONFIGURATION FOR KVIDEOLIST

if (config->readBoolEntry("CONFIGURED")==FALSE || config->readBoolEntry("0.92CONFIGURED")==FALSE ) {

if (config->readBoolEntry("CONFIGURED")==FALSE && config->readBoolEntry("0.92CONFIGURED")==FALSE) {
QMessageBox::information(this,klocale->translate("First start..."),klocale->translate("Setting standart configuration settings for KVideolist."));} else
{
	QMessageBox::information(this,klocale->translate("Upgrade to release 0.92"),klocale->translate("

It seems like You already used an older version of KVideolist. Please note that by clicking on OK, Your configuration
settings will be deleted and a new default configuration for version 0.92 will be installed. That means, that  
Your subclasses and some other settings are lost and You need to redefine them. 

The file-format has changed and You will need to convert an older database to version 0.92.
The most uptodate documentation is only the english one.

Thanks.
"));};



                             
			// Setting standart values
			
		config->writeEntry("Recorder",0);
		config->writeEntry("Stereo",TRUE);
		config->writeEntry("Surround",FALSE);
		config->writeEntry("MovieText",FALSE);
		config->writeEntry("Color",TRUE);
		config->writeEntry("LongPlay",FALSE);
		config->writeEntry("AutoShow",FALSE);
		config->writeEntry("Resort",TRUE);
		config->writeEntry("AutoIndexing",TRUE);
		config->writeEntry("0.92CONFIGURED",TRUE);	
		char ENDIR[255];

		strcpy(ENDIR,kapp->kde_htmldir());
strcat(ENDIR,"/en/kvideolist/backgr.xpm");        		
		config->writeEntry("BackgroundDisable",FALSE);


		config->writeEntry("BackgroundLine",ENDIR);
		config->writeEntry("IMDBProducer",TRUE);
		config->writeEntry("IMDBGenres",TRUE);
		config->writeEntry("IMDBDirector",TRUE);
		config->writeEntry("IMDBCast",TRUE);
		config->writeEntry("IMDBCountry",TRUE);
		config->writeEntry("IMDBYear",TRUE);
		config->writeEntry("IMDBAskOnline",TRUE);
		config->writeEntry("IMDBAutoFetchGenres",TRUE);
                config->writeEntry("Sortmode",0);
		config->writeEntry("TapeView",FALSE);
		config->writeEntry("CONFIGURED",TRUE);
		config->writeEntry("SUBCLASS1","Al Bundy");
		config->writeEntry("SUBCLASS2","Stephen King's");
		config->writeEntry("SUBCLASS3","The Muppets");
		config->writeEntry("SUBCLASS4","Derrick");
		config->writeEntry("SUBCLASS5","Sendungen mit der Maus");
		config->writeEntry("LOADLASTUSED",FALSE);
		config->writeEntry("ASCIIIMPORT","T12345D");
		config->writeEntry("SEPARATOR",",");
		config->writeEntry("LABELFONT","helvetica,12,5,iso-8859-1,50,0");
		config->writeEntry("TITLEFONT","helvetica,12,5,iso-8859-1,50,0");
		config->writeEntry("ORIGINALTITLEFONT","helvetica,12,5,iso-8859-1,50,0");
		config->writeEntry("OTHERFONT","helvetica,12,5,iso-8859-1,50,0");



	
	
		};



LabelFont=config->readFontEntry("LABELFONT");
TitleFont=config->readFontEntry("TITLEFONT");
OriginalTitleFont=config->readFontEntry("ORIGINALTITLEFONT");
OtherFont=config->readFontEntry("OTHERFONT");











CHANGED=FALSE;
SORTMODE = config->readNumEntry("Sortmode")+1;
SubClassF->insertItem(klocale->translate("No Subclass"),0);
SubClassF->insertItem(config->readEntry("SUBCLASS1"),1);
SubClassF->insertItem(config->readEntry("SUBCLASS2"),2);
SubClassF->insertItem(config->readEntry("SUBCLASS3"),3);
SubClassF->insertItem(config->readEntry("SUBCLASS4"),4);
SubClassF->insertItem(config->readEntry("SUBCLASS5"),5);
BATCHMODE=0;
SubClassF->setBackgroundPixmap(Hintergrund);
RANKINGDELAY= config->readNumEntry("RANKINGDELAY");

NAMECLICKED=0;
QUICKNAMEFIND=0;
SORTDIR = 0;
SELECTION=0;
GENRE1=-1; 
GENRE2=-1; 
SFIRST=1;
SSECOND=1;
SQUERY=1;
SEARCHMODE=2; 

if (config->readBoolEntry("TapeView")==FALSE) { TAPEVIEW=1; } else {TAPEVIEW=0;};




Tapeliste= new SplitList(this,"tapeliste");
Tapeliste->setFrameStyle(QFrame::Box | QFrame::Sunken);
Tapeliste->setAutoUpdate(true);





Filmliste= new SplitList(this,"liste");
Filmliste->setFrameStyle(QFrame::Box | QFrame::Sunken);
Filmliste->setAutoUpdate(true);
if (config->readBoolEntry("BackgroundDisable")==0) {
                                        Hintergrund.load(config->readEntry("BackgroundLine"));
                                        this->setBackgroundPixmap(Hintergrund);
					

 };
                 
ChooseNumberL->setBackgroundPixmap(Hintergrund);
OriginalNameL->setBackgroundPixmap(Hintergrund);

QPixmap RatingBarMap;
strcpy(Filename,kapp->kde_htmldir());

RatingBarMap.load(strcat(Filename,"/en/kvideolist/ratingbar.xpm"));
QLabel* RatingBar= new QLabel(" ",this);
RatingBar->setPixmap(RatingBarMap);
RatingBar->move(315,350);
RatingBar->resize(319,30);

// Loading the New Ranking Bar
int Zaehler=0;
// initializing LEDs
while (Zaehler<=9) { LED[Zaehler]=new QLabel(" ",this);
		     LED[Zaehler]->move(325+(Zaehler*31),357);
		     LED[Zaehler]->resize(25,16);
		     Zaehler++;
			};


QPixmap RatingBarLow;
strcpy(Filename,kapp->kde_htmldir());
printf("OK");
RatingBarLow.load(strcat(Filename,"/en/kvideolist/ratinglow.xpm"));  
QPixmap RatingBarMiddle;
strcpy(Filename,kapp->kde_htmldir());  
RatingBarMiddle.load(strcat(Filename,"/en/kvideolist/ratingmiddle.xpm"));
QPixmap RatingBarHigh;
strcpy(Filename,kapp->kde_htmldir());  
RatingBarHigh.load(strcat(Filename,"/en/kvideolist/ratinghigh.xpm"));
QPixmap RatingBarBest;
strcpy(Filename,kapp->kde_htmldir());  
RatingBarBest.load(strcat(Filename,"/en/kvideolist/ratingbest.xpm"));
Zaehler=0;

while (Zaehler<=9) { 	
	if (Zaehler>=0 && Zaehler<=2) LED[Zaehler]->setPixmap(RatingBarLow);
	if (Zaehler>=3 && Zaehler<=5) LED[Zaehler]->setPixmap(RatingBarMiddle);
	if (Zaehler>=6 && Zaehler<=8) LED[Zaehler]->setPixmap(RatingBarHigh);
	if (Zaehler==9) LED[Zaehler]->setPixmap(RatingBarBest);
	Zaehler++;
};

		



TView= new TapeView(0,"TapeView");
	



//


UpdateList(Anker);
this->resize(650,550);
this->setMaximumSize(650,550);
this->setMinimumSize(650,550);


QPixmap RatingLeftMap;
strcpy(Filename,kapp->kde_htmldir());

 RatingLeftMap.load(strcat(Filename,"/en/kvideolist/ratingleft.xpm"));
 QLabel* RatingBarLeft= new QLabel(" ",this);
 RatingBarLeft->setPixmap(RatingLeftMap);
 RatingBarLeft->move(330,340);
RatingBarLeft->resize(32,32);
QPixmap RatingRightMap;
strcpy(Filename,kapp->kde_htmldir());

RatingRightMap.load(strcat(Filename,"/en/kvideolist/ratingright.xpm"));
QPixmap TitleMap;
strcpy(Filename,kapp->kde_htmldir());
RatingBarLeft->hide();




TitleMap.load(strcat(Filename,"/en/kvideolist/title.xpm"));
Title= new QLabel(" ",this);
Title->setPixmap(TitleMap);
Title->resize(300,400);
Title->move(0,150);









QLabel* RatingBarRight = new QLabel(" ",this);
RatingBarRight->setPixmap(RatingRightMap);
RatingBarRight->move(350+245,340);
RatingBarRight->resize(32,32);
RatingBarRight->hide();

Rating = new QLabel(" ",this);
QPixmap RatingArrow;
strcpy(Filename,kapp->kde_htmldir());
RatingArrow.load(strcat(Filename,"/en/kvideolist/ratingarrow.xpm"));
Rating->setPixmap(RatingArrow);
Rating->resize(25,20);
Rating->move(350+ (245 / 2) , 363);
Rating->hide();


// QLabel* SortMode = new QLabel(klocale->translate("Current sort-mode:"),this);
// SortMode->move(5,50);
SProducer = new QLabel(klocale->translate("produced by: "),this);
SProducer->move(305,100+28);

SProducer->resize(100,20);
SProducer->setBackgroundPixmap(Hintergrund);
SProducer->setFont(LabelFont);

SDirector = new QLabel(klocale->translate("directed by: "),this);
SDirector->move(305,120+30);
SDirector->resize(100,20);
SDirector->setBackgroundPixmap(Hintergrund);
SDirector->setFont(LabelFont);
SCast1 = new QLabel(klocale->translate("cast 1:"),this);
SCast1->move(305,40+120+25);
SCast1->setBackgroundPixmap(Hintergrund);
SCast1->setFont(LabelFont);

SCast2 = new QLabel(klocale->translate("cast 2:"),this);
SCast2->move(305,40+145+25);
SCast2->setBackgroundPixmap(Hintergrund);
SCast2->setFont(LabelFont);
SCast3 = new QLabel(klocale->translate("cast 3:"),this);
SCast3->move(305,40+170+25);
SCast3->setBackgroundPixmap(Hintergrund);
SCast3->setFont(LabelFont);
SCast4 = new QLabel(klocale->translate("cast 4:"),this);
SCast4->move(305,40+195+25);
SCast4->setBackgroundPixmap(Hintergrund);
SCast4->setFont(LabelFont);

SCast5 = new QLabel(klocale->translate("cast 5:"),this);
SCast5->move(305,40+220+25);
SCast5->setBackgroundPixmap(Hintergrund);
SCast5->setFont(LabelFont);
QLabel* SAge = new QLabel(klocale->translate("released :"),this);
SAge->setBackgroundPixmap(Hintergrund);
SAge->setFont(LabelFont);
QLabel* PlayTime = new QLabel(klocale->translate("Play time"),this);
QLabel* MovieNumber= new QLabel(klocale->translate("Movie No."),this);
MovieNr= new QLCDNumber(this,"Mnumber");
QLabel* StartTime = new QLabel(klocale->translate("Start time"),this);
SStartTime1= new QLCDNumber(this,"hours");
SStartTime2= new QLCDNumber(this,"minutes");
QLabel* PTDoppel1 = new QLabel(" :",this);
SPlayTime1= new QLCDNumber(this,"hours");
SPlayTime2= new QLCDNumber(this,"minutes");
QLabel* PTDoppel = new QLabel(" :",this);


Genre1 = new QLabel(klocale->translate(" "),this);
Genre2 = new QLabel(klocale->translate(" "),this);
Stereo= new QLabel(klocale->translate("Stereo"),this);

PreTaped = new QLabel(klocale->translate("Pretaped"),this);


Surround= new QLabel(klocale->translate("Surround"),this);
MovieText= new QLabel(klocale->translate("MovieText"),this);
Comments=new QMultiLineEdit(this,"Comment");
Comments->setReadOnly(TRUE);
Comments->resize(360,50);
Comments->move(305,410);


LinkURLButton = new QPushButton(klocale->translate("URL"),this);
LinkURLButton->resize(120,20);
LinkURLButton->move(305,470);
LinkURLButton->setFont(QFont("Times",12));
LinkURLButton->setBackgroundPixmap(Hintergrund);
BatchMode = new QPushButton(klocale->translate("Single selection"),this);
BatchMode->resize(150,20);
BatchMode->move(430,520);
BatchMode->setFont(QFont("Times",12));
connect(BatchMode,SIGNAL(clicked()),SLOT(slotChangeBatchMode()));

QPushButton *ResetSearch = new QPushButton(klocale->translate("Reset Searchmode"),this);
ResetSearch->resize(150,20);
ResetSearch->move(430,470);
ResetSearch->setFont(QFont("Times",12));

QPushButton *ResetGenre = new QPushButton(klocale->translate("Reset Genre"),this);
ResetGenre->resize(150,20);
ResetGenre->move(430,495);
ResetGenre->setFont(QFont("Times",12));

connect(ResetSearch,SIGNAL(clicked()),SLOT(slotResetSearch()));
connect(ResetGenre,SIGNAL(clicked()),SLOT(slotResetGenre()));

        Genre1C->insertItem(klocale->translate("Nothing"),0);
	Genre1C->insertItem(klocale->translate("Horror"),1);
        Genre1C->insertItem(klocale->translate("Comedy"),2);
        Genre1C->insertItem(klocale->translate("SciFi"),3);
        Genre1C->insertItem(klocale->translate("Thriller"),4);
        Genre1C->insertItem(klocale->translate("Action"),5);
        Genre1C->insertItem(klocale->translate("Crimi"),6);
        Genre1C->insertItem(klocale->translate("Documentation"),7);
        Genre1C->insertItem(klocale->translate("Cartoon"),8);
        Genre1C->insertItem(klocale->translate("Drama"),9);
        Genre1C->insertItem(klocale->translate("Monumental"),10);
        Genre1C->insertItem(klocale->translate("Western"),11);
        Genre1C->insertItem(klocale->translate("Erotic"),12);
        Genre1C->insertItem(klocale->translate("Adventure"),13);
        Genre1C->insertItem(klocale->translate("Musical"),14);
        Genre1C->insertItem(klocale->translate("War"),15);
        Genre1C->insertItem(klocale->translate("Catastrophe"),16);
        Genre1C->insertItem(klocale->translate("Psycho"),17);
        Genre1C->insertItem(klocale->translate("Satire"),18);
        Genre1C->insertItem(klocale->translate("Fantasy"),19);
        Genre1C->insertItem(klocale->translate("Traditional"),20);
        Genre1C->insertItem(klocale->translate("Theatre"),21);
        Genre1C->insertItem(klocale->translate("Other"),22);                               
                                 


Color= new QLabel(klocale->translate("Color"),this);
Color->setFont(QFont("Times",10));
PreTaped->setFont(QFont("Times",10));
Surround->setFont(QFont("Times",10));
Stereo->setFont(QFont("Times",10));
MovieText->setFont(QFont("Times",10));

Genre1->setFont(QFont("Times",10));
Genre2->setFont(QFont("Times",10));




SAge->move(305,40+230+40);
SProducerD= new QPushButton("\0",this);
SProducerD->setFont(OtherFont);

SDirectorD= new QPushButton(this,"\0");
SDirectorD->setFont(OtherFont);

SNameD= new QLineEdit(this,"\0");
connect(SNameD,SIGNAL(textChanged(const char *)),SLOT(slotQuickNameFind()));
connect(SNameD,SIGNAL(returnPressed()),SLOT(slotQuickNameFind2()));


SCast1D= new QPushButton("\0",this);
SCast1D->setBackgroundPixmap(Hintergrund);

SCast2D= new QPushButton("\0",this);
SCast3D= new QPushButton("\0",this);
SCast4D= new QPushButton("\0",this);
SCast5D = new QPushButton("\0",this);        
SCast1D->setFont(OtherFont);
SCast2D->setFont(OtherFont);
SCast3D->setFont(OtherFont);
SCast4D->setFont(OtherFont);
SCast5D->setFont(OtherFont);
SCast1D->setBackgroundPixmap(Hintergrund);








SAgeD=new QPushButton("\0",this);
SNrD= new QLCDNumber(this,"Age");
SNrD->move(10,76);
MovieNr->move(10,125);
QLabel* SNr = new QLabel(klocale->translate("Tape Number"),this);
LP = new QLabel(klocale->translate("LP"),this);
RatingNr = new QLabel(klocale->translate("Rating ?"),this);
RatingNr->move(350+(245/2)-20,385);

MovieNr->setSegmentStyle(QLCDNumber::Flat);


SNrD->setSegmentStyle(QLCDNumber::Flat);
SPlayTime1->setSegmentStyle(QLCDNumber::Flat);
SPlayTime1->move(100,76);
SStartTime1->setSegmentStyle(QLCDNumber::Flat);
SStartTime1->move(100,125);

SPlayTime2->setSegmentStyle(QLCDNumber::Flat);
SPlayTime2->move(140,76);

SStartTime2->setSegmentStyle(QLCDNumber::Flat);
SStartTime2->move(140,125);


SPlayTime1->resize(30,23);
SPlayTime2->resize(30,23);

SStartTime1->resize(30,23);
SStartTime2->resize(30,23);


PTDoppel->resize(10,23);
PTDoppel->move(130,76);
PTDoppel->setFont(QFont("Times",12,QFont::Bold));

PTDoppel1->resize(10,23);
PTDoppel1->move(130,125);
PTDoppel1->setFont(QFont("Times",12,QFont::Bold));

SPlayTime1->setNumDigits(2);
SPlayTime2->setNumDigits(2);
SStartTime1->setNumDigits(2);
SStartTime2->setNumDigits(2);
Genre1->move(230+8,60);
Genre2->move(230+8,80);
SNrD->resize(85,23);
MovieNr->resize(85,23);

Color->move(230+8,100);
Stereo->move(165+8,100);
Surround->move(165+8,118);
MovieText->move(230+8,118);
PreTaped->move(230+8,134);

SNr->move(10,55);
MovieNumber->move(10,103);
PlayTime->move(100,55);
PlayTime->resize(70,20);
PlayTime->setFrameStyle(QFrame :: Box | QFrame :: Raised);
StartTime->move(100,103);
StartTime->resize(70,20);
StartTime->setFrameStyle(QFrame :: Box | QFrame :: Raised);

LP->move(180,60);
LP->resize(25,20);
LP->setFrameStyle(QFrame :: Box | QFrame :: Raised);

RatingNr->setFrameStyle(QFrame:: Box | QFrame :: Raised);
RatingNr->resize(80,15);

SNr->setFrameStyle(QFrame :: Box | QFrame :: Raised);
SNr->resize(85,20);

SNr->setFrameStyle(QFrame :: Box | QFrame :: Raised);
SNrD->setNumDigits(4);
MovieNumber->resize(85,20);

MovieNumber->setFrameStyle(QFrame :: Box | QFrame :: Raised);
MovieNr->setNumDigits(2);


SProducerD->move(410,100+25);
SDirectorD->move(410,120+30);
SCast1D->move(410,40+120+25);
SCast2D->move(410,40+145+25);
SCast3D->move(410,40+170+25);
SCast4D->move(410,40+195+25);
SCast5D->move(410,40+220+25);
SAgeD->move(410,40+230+40);
SNameD->setFont(TitleFont);
OriginalName->setFont(OriginalTitleFont);

SNameD->move(300,60);
SNameD->resize(350,20);
// SNameD->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
// SProducerD->setFrameStyle(QFrame::Box | QFrame::Sunken);
// SDirectorD->setFrameStyle(QFrame::Box | QFrame::Sunken);

// SCast1D->setFrameStyle(QFrame::Box | QFrame::Sunken);
// SCast2D->setFrameStyle(QFrame::Box | QFrame::Sunken);
// SCast3D->setFrameStyle(QFrame::Box | QFrame::Sunken);
// SCast4D->setFrameStyle(QFrame::Box | QFrame::Sunken);
// SCast5D->setFrameStyle(QFrame::Box | QFrame::Sunken);
Genre1->setFrameStyle(QFrame::Box | QFrame::Raised);


Genre2->setFrameStyle(QFrame::Box | QFrame::Raised);


Stereo->setFrameStyle(QFrame::Box | QFrame::Raised);



Surround->setFrameStyle(QFrame::Box | QFrame::Raised);


Color->setFrameStyle(QFrame::Box | QFrame::Raised);

MovieText->setFrameStyle(QFrame::Box | QFrame::Raised);


PreTaped->setFrameStyle(QFrame::Box | QFrame::Raised);



// SAgeD->setFrameStyle(QFrame::Box | QFrame::Sunken);
SProducerD->resize(240,25);
SCast1D->resize(240,25);
SCast2D->resize(240,25);
SCast3D->resize(240,25);
SCast4D->resize(240,25);
SCast5D->resize(240,25);
SDirectorD->resize(240,25),


Genre1->resize(60,15);
Genre2->resize(60,15);
Stereo->resize(60,15);
Surround->resize(60,15);
Color->resize(60,15);
PreTaped->resize(60,15);

MovieText->resize(60,15);
Filmliste->setMultiSelection(FALSE);
Filmliste->resize(300,550-150);
Filmliste->move(0,150);
Tapeliste->resize(60,550-150);
Tapeliste->move(0,150);
Tapeliste->hide();
    QPopupMenu* file = new QPopupMenu;
    QPopupMenu* edit = new QPopupMenu;
    sort = new QPopupMenu;

connect(Filmliste,SIGNAL(selected(int)),SLOT(slotEditVideo()) );
connect(Filmliste,SIGNAL(highlighted(int)),SLOT(slotShowVideo()) );
connect(LinkURLButton,SIGNAL(clicked()),SLOT(slotLinkURL()) );
connect(SubClassF,SIGNAL(activated(int)),SLOT(slotSubClassChanged()));

connect(SAgeD,SIGNAL(clicked()),SLOT(slotQSearchAge()));
connect(SDirectorD,SIGNAL(clicked()),SLOT(slotQSearchDirector()));
connect(SProducerD,SIGNAL(clicked()),SLOT(slotQSearchProducer()));
connect(SCast1D,SIGNAL(clicked()),SLOT(slotQSearchCast1()));
connect(SCast2D,SIGNAL(clicked()),SLOT(slotQSearchCast2()));
connect(SCast3D,SIGNAL(clicked()),SLOT(slotQSearchCast3()));
connect(SCast4D,SIGNAL(clicked()),SLOT(slotQSearchCast4()));
connect(SCast5D,SIGNAL(clicked()),SLOT(slotQSearchCast5()));




//  file->insertItem(klocale->translate("&New Window"),this,SLOT(slotNewWindow()),CTRL+Key_N);
file->insertItem(klocale->translate("New L&ist"),this,SLOT(slotNewList()),CTRL+Key_I);  
file->insertSeparator();
file->insertItem(klocale->translate("&Configure database..."),this,SLOT(saveConfiguration()),CTRL+Key_C);
file->insertSeparator();
file->insertItem(klocale->translate("&File conversion..."),this,SLOT(slotConversion()),CTRL+Key_F);
file->insertSeparator();
file->insertItem(klocale->translate("Export..."),this,SLOT(slotExport()));
file->insertItem(klocale->translate("Import... <NOT FULLY IMPLEMENTED!>"),this,SLOT(slotASCIIIMPORT()));

file->insertSeparator();
file->insertItem(klocale->translate("Print list"),this,SLOT(slotPrintList()));
file->insertSeparator();
file->insertItem(klocale->translate("Load"),this,SLOT(slotLoadFile()),CTRL+Key_L);
file->insertItem(klocale->translate("Save"),this,SLOT(slotSaveKnownFile()));

  file->insertItem(klocale->translate("Save as"),this,SLOT(slotSaveFile()),CTRL+Key_S);
  
  file->insertSeparator();
  file->insertItem(klocale->translate("&Quit"),this,SLOT(slotQuit()),CTRL+Key_Q);
 
  menubar->insertItem(klocale->translate("&File"),file);


  edit->insertItem(klocale->translate("&Add"),this,SLOT(slotAddVideo()),CTRL+Key_A);
  edit->insertItem(klocale->translate("&Edit"),this,SLOT(slotEditVideo()),CTRL+Key_E);
  edit->insertItem(klocale->translate("&Delete"),this,SLOT(DeleteAMovie()),CTRL+Key_D);
  edit->insertItem(klocale->translate("Duplicate"),this,SLOT(slotDuplicateMovie()),CTRL+Key_U);

  edit->insertSeparator();

  edit->insertItem(klocale->translate("Sea&rch"),this,SLOT(slotSearch()),CTRL+Key_R);
  edit->insertItem(klocale->translate("Choose &Genre"),this,SLOT(slotGenre()),CTRL+Key_G);
  edit->insertSeparator();
  edit->insertItem("Internet &Movie Database",this,SLOT(slotIMDBmain()),CTRL+Key_M);
 
  menubar->insertItem(klocale->translate("&Movies"),edit);
sort->insertItem(klocale->translate("Sort by &Name"),this,SLOT(sortbyName()),CTRL+Key_N);
sort->insertItem(klocale->translate("Sort by &Release Date"),this,SLOT(sortbyAge()),CTRL+Key_R);
sort->insertItem(klocale->translate("Sort by Tape-&Number"),this,SLOT(sortbyNumber()),CTRL+Key_N);
sort->insertItem(klocale->translate("Sort by R&ating"),this,SLOT(sortbyRating()),CTRL+Key_A);
sort->insertItem(klocale->translate("Sort by &Playtime"),this,SLOT(sortbyPlayTime()),CTRL+Key_P);
sort->insertSeparator();
sort->insertItem(klocale->translate("C&hange sort direction"),this,SLOT(slotChangeSortDir()),CTRL+Key_C);
sort->insertSeparator();
sort->insertItem(klocale->translate("&Statistics"),this,SLOT(slotStatistics()),CTRL+Key_S);
sort->setCheckable(TRUE);
sort->setId(0,0);sort->setId(1,1);sort->setId(2,2);sort->setId(3,3);sort->setId(4,4);sort->setId(5,5);

menubar->insertItem(klocale->translate("&Sort"),sort);
QPopupMenu* online = new QPopupMenu;
online->insertItem(klocale->translate("&Internet Movie Database (IMDB)"),this,SLOT(slotIMDBmain()),CTRL+Key_I);
online->insertItem(klocale->translate("KVideolist's &Homepage"),this,SLOT(slotKVLHome()),CTRL+Key_H);
menubar->insertItem(klocale->translate("Online"),online);
tools= new QPopupMenu;
tools->setCheckable(TRUE);

tools->insertItem(klocale->translate("File conversion..."),this,SLOT(slotConversion()),CTRL+Key_C);
tools->insertItem(klocale->translate("Check URLs..."),this,SLOT(slotCheckURL()),CTRL+Key_U);
tools->insertSeparator();
tools->insertItem(klocale->translate("Tape-View window"),this,SLOT(slotTapeView()),CTRL+Key_U);
tools->setId(3,1);
menubar->insertItem(klocale->translate("Tools"),tools);
QPopupMenu* Batchmode= new QPopupMenu;
Batchmode->insertItem(klocale->translate("Toggle selection mode"),this,SLOT(slotChangeBatchMode()));
Batchmode->insertItem(klocale->translate("Select all"),this,SLOT(slotSelectAll()));

Batchmode->insertSeparator();
Batchmode->insertItem(klocale->translate("Set attributes"),this,SLOT(slotSetAttributes()));
Batchmode->insertItem(klocale->translate("Delete movies"),this,SLOT(slotDeleteMovies()));
Batchmode->insertSeparator();

Batchmode->insertItem(klocale->translate("IMDb Autofill <NOT FULLY IMPLEMENTED!>"),this,SLOT(slotAutoFillSelMovies()));

Batchmode->setId(4,1);
menubar->insertItem(klocale->translate("Multiselection"),Batchmode);



  menubar->insertSeparator();




  QPopupMenu* help = new QPopupMenu;
	help->insertItem(klocale->translate("&About KVideolist..."),this,SLOT(slotAbout()),CTRL+Key_A);
	help->insertItem(klocale->translate("&Contents"),this,SLOT(slotContents()),CTRL+Key_C);


 menubar->insertItem(klocale->translate("&Help"),help); 



// KVIDEOLIST'S TOOLBAR
toolBar->insertButton(Icon("fileopen.xpm"),1,true,klocale->translate("Open File"));
connect(toolBar,SIGNAL(clicked(int)),SLOT(slotToolbarClicked(int)));
toolBar->insertButton(Icon("filefloppy.xpm"),2,true,klocale->translate("Save File"));
toolBar->insertButton(Icon("contents.xpm"),3,true,klocale->translate("Edit a movie"));   
toolBar->insertButton(Icon("filenew.xpm"),11,true,klocale->translate("Add a new movie"));
toolBar->insertSeparator();
toolBar->insertButton(Icon("reload.xpm"),4,true,klocale->translate("Change the sort direction"));
toolBar->insertSeparator();
toolBar->insertButton(Icon("back.xpm"),5,true,klocale->translate("Previous Movie"));

toolBar->insertButton(Icon("start.xpm"),6,true,klocale->translate("Beginning of list"));
toolBar->insertButton(Icon("finish.xpm"),7,true,klocale->translate("End of List")); 
toolBar->insertButton(Icon("forward.xpm"),8,true,klocale->translate("Next Movie"));
toolBar->insertSeparator();

toolBar->insertButton(Icon("viewmag.xpm"),9,true,klocale->translate("Search"));   
toolBar->insertButton(Icon("lock.xpm"),10,true,klocale->translate("Genre selection"));
toolBar->insertButton(Icon("flag.xpm"),12,true,klocale->translate("Statistics"));
setMenu(menubar);
addToolBar(toolBar);                 


if (TAPEVIEW==0) {tools->setItemChecked(1,TRUE);        TView->show(); TAPEVIEW=1;  }
else  {      TView->hide(); TAPEVIEW=0; tools->setItemChecked(1,FALSE);};
                                                                           


if (config->readBoolEntry("LOADLASTUSED")==TRUE) { 
			int z;
			

			char LoadName[255];
			strcpy(LoadName,config->readEntry("LASTUSEDDB"));
			printf("%s",LoadName);
			ClearList(&Anker);
			z=LoadMovies(LoadName,&Anker); 
			UpdateList(Anker);
			Filmliste->setCurrentItem(0);
			char Caption[255];
			strcpy(Caption,"KVideolist - ");
			strcat(Caption,LoadName);
			this->setCaption(Caption);
			};


config->sync();





};

void KVL::slotSelectAll() {
int z=0;Filmliste->setMultiSelection(true);BATCHMODE=1;
BatchMode->setText(klocale->translate("Multi selection"));

	while (z<=(signed) Filmliste->count()-1) { Filmliste->setSelected(z,true);z++; }; };


void KVL::slotAutoFillSelMovies() {

Afsstatus *AutoFillStatus = new Afsstatus(0,"autofill");
KConfig *config = KApplication::getKApplication()->getConfig();
AutoFillStatus->show();

AutoFillStatus->Status->setText(klocale->translate("Launching KFM..."));
AutoFillStatus->Status->resize(300,20);
AutoFillStatus->update();
    int Text;
        char BigString[100000];
        char *Needle;
   FILE *Url; 
char Result[80];
char Pattern[80];
char Caption[255];
Element Daten;
KFM *kfm = new KFM();
char urlName[255];
char Filmname[255];
int x=0;
char THISMOVIE[80];
char SEARCHSTRING[255];
QString u;
kfm->allowKFMRestart(true);


AutoFillStatus->FailedList->setFrameStyle(QFrame::Box | QFrame::Sunken);
AutoFillStatus->FailedList->setAutoUpdate(true);     
int Counter=0;

int MovieCount=0;

while (MovieCount<=(signed) Filmliste->count()) {


// do this only if Movie is selected

if (Filmliste->isSelected(MovieCount)==true) {

	// This is the code from moviedialog.cpp:slotIMDBFill()

	// Make an URL out of the movie name
	AutoFillStatus->Status->setText(klocale->translate("Generating URL..."));
	AutoFillStatus->update();

        strcpy(Filmname,Filmliste->text(MovieCount));
	x=0;
        while (x<(signed) strlen(Filmname)) {
                if (Filmname[x]==' ') { Filmname[x]='+'; };
                x++;
                };


        strcpy(urlName,"http://us.imdb.com/M/title-substring?title=");
        strcat(urlName,Filmname);
        strcat(urlName,"&tv=both");

    //    kfm->openURL(urlName);
        strcpy(SEARCHSTRING,urlName);                                                                                                                                                                    

	QString s;
        if (KFM::download(SEARCHSTRING,s)) { 
	// Now The Movie is downloaded. 
	// Check if it's a direct hit:
	AutoFillStatus->Status->setText(klocale->translate("Sending IMDb request..."));
	AutoFillStatus->update();

	Url=fopen(s,"r");


	printf("Check");
	Counter=0;
	while (((Text=getc(Url))!=-1) && (Counter<100000)) { BigString[Counter]=Text;Counter++;};fclose(Url);
	strcpy(Pattern,"Directed by");
	Needle=strstr(BigString,Pattern);
	if (Needle==NULL) { // No Direct Hit. Add Movie to Failedlist.
				AutoFillStatus->FailedList->insertItem(Filmliste->text(MovieCount),0);
				AutoFillStatus->update(); };


	if (Needle!=NULL) { printf("ISDIRECTHIT!"); 
			// Ok, we have a direct hit, autofill it.
			AutoFillStatus->Status->setText(klocale->translate("Direct hit, parsing data..."));
	AutoFillStatus->update();
	
 	// Getting data element from internal database
	

	

        strcpy(THISMOVIE,Filmliste->text(MovieCount));
	EditMovie(THISMOVIE,Anker,&Daten);
	


        strcpy(Caption,s);


        // Fetching Producer
/*
if (config->readBoolEntry("IMDBProducer")==TRUE) {
        strcpy(Pattern,"production-companies");
        IMDbMovieEntry->setText(Name->text());
        Parse(Caption,Pattern,Result);

        strcpy(Daten.Producer,Result);
        };
*/

        // Fetching Director

if (config->readBoolEntry("IMDBDirector")==TRUE) {

        Parse2(Caption,"directors","Name",Result,1);
        strcpy(Daten.Director,Result);
        };


if (config->readBoolEntry("IMDBCast")==TRUE) {
        // Fetching Cast
        Parse2(Caption,"cast","Name",Result,1);
        strcpy(Daten.Cast1,Result);

        Parse2(Caption,"cast","Name",Result,2);
        strcpy(Daten.Cast2,Result);

        Parse2(Caption,"cast","Name",Result,3);
	strcpy(Daten.Cast3,Result);

        Parse2(Caption,"cast","Name",Result,4);
	strcpy(Daten.Cast4,Result);


        Parse2(Caption,"cast","Name",Result,5);
	strcpy(Daten.Cast5,Result);

       };

if (config->readBoolEntry("IMDBCast")==TRUE) {
        // Fetching Release Year
        Parse(Caption,"TITLE",Result);
        char *Date;
        Date=strstr(Result,"(");
        Date++;
        Date[4]='\0';
	strcpy(Daten.Age,Date);


    };

if (config->readBoolEntry("IMDBCountry")==TRUE) {
        // Fetching Country

        Parse(Caption,"/Sections/Countries/",Result);
	strcpy(Daten.MadeIn,Result);


        };

// Let's hope it's autofilled here, so we can delete, then add...
	DeleteMovie(THISMOVIE,&Anker);
	strcpy(Daten.Name,THISMOVIE);
	AddMovie(&Anker,Daten);

};

// At this point, it's either not found, or more to choose





        KFM::removeTempFile(s);


        };
	KFM::removeTempFile(s);

	};
// KFM::removeTempFile(s);

MovieCount++;
	};

AutoFillStatus->show();
UpdateList(Anker);
};
 











void KVL::Parse(char *Filename,char *Pattern,char *Result) {

        FILE *Url;
        char BigString[100000];
        char *Needle;
        int Text;
        int Counter=0;
        Url=fopen(Filename,"r");

        while (((Text=getc(Url))!=-1) && (Counter<100000)) { BigString[Counter]=Text;Counter++; };

        // Searching for the Pattern
        Needle=strstr(BigString,Pattern);
        if (Needle==NULL) { Result[0]='\0'; return; };

        Needle=strstr(Needle,">");
        Counter=1;
        while (Needle[Counter]!='<') {Result[Counter-1]=Needle[Counter];
                                        Counter++;};Result[Counter-1]='\0';

	fclose(Url);
	};


void KVL::Parse2(char *Filename,char *Pattern1,char *Pattern2,char *Result,int n) {

        FILE *Url;
        char BigString[100000];
        char *Needle;
        int Text;
        int Counter=0;
        Url=fopen(Filename,"r");

        while (((Text=getc(Url))!=-1) && (Counter<100000)) { BigString[Counter]=Text;Counter++; };

        // Searching for the Pattern1
        Needle=strstr(BigString,Pattern1);
        if (Needle==NULL) { Result[0]='\0'; return; };

        // Searching n times for Pattern2
        Counter=0;
        while (Counter<n) {
        Needle=strstr(Needle,Pattern2);Needle++;Counter ++; };Needle--;


        Needle=strstr(Needle,">");
        Counter=1;
        while (Needle[Counter]!='<') {Result[Counter-1]=Needle[Counter];
                                        Counter++;};Result[Counter-1]='\0';



        fclose(Url);
};

   


                                                                                         





void KVL::slotDeleteMovies() {

	if (BATCHMODE==0) return;

	if (!QMessageBox::warning(0,klocale->translate("One moment"),klocale->translate("This will delete all selected movies. Do You want to proceed?"),klocale->translate("No"),klocale->translate("Yes"))) return; 

	int z=0;
	char FName[80];


	while (z<=(signed) Filmliste->count()-1) {
		
		strcpy(FName,Filmliste->text(z));

		 if (Filmliste->isSelected(z)==TRUE) DeleteMovie(FName,&Anker);
		z++;

      				}; 
		UpdateList(Anker);

};
 
        




void KVL::slotASCIIIMPORT() {
	Importer *IMPORT = new Importer(this,"test");
		
	KConfig *config= KApplication::getKApplication()->getConfig();
	char Pattern[2000];
	strcpy(Pattern,config->readEntry("ASCIIIMPORT"));
	IMPORT->show();
	};

		

void KVL::slotSetAttributes() {

	if (BATCHMODE==0) return;
	Attributes *Attrib= new Attributes(this,"test");
	 KConfig *config= KApplication::getKApplication()->getConfig();
 	Element Daten;
	char FName[80];
	char ERSATZNAME[80];

	int z=0;
	int A,B,C,D,E,F,G,H=0;
	
	Attrib->SetSubClass->insertItem(config->readEntry("SUBCLASS1"),2);
	Attrib->SetSubClass->insertItem(config->readEntry("SUBCLASS2"),3);
	Attrib->SetSubClass->insertItem(config->readEntry("SUBCLASS3"),4);
	Attrib->SetSubClass->insertItem(config->readEntry("SUBCLASS4"),5);
	Attrib->SetSubClass->insertItem(config->readEntry("SUBCLASS5"),6);
	
	Attrib->exec();

	printf("TEST2");


				  A=Attrib->SetStereo->currentItem();
                               B=Attrib->SetSurround->currentItem();
                               C=Attrib->SetMovieText->currentItem();
                             D=Attrib->SetLongPlay->currentItem();
                           E=Attrib->SetColor->currentItem();
                         F=Attrib->SetSubClass->currentItem();
                       G=Attrib->SetAutoURL->currentItem();
        		H=Attrib->SetRanking->currentItem();                       

				

			
				while (z<=(signed) Filmliste->count()-1) {

				strcpy(FName,Filmliste->text(  z));

				EditMovie(FName,Anker,&Daten);
		
				if (Filmliste->isSelected( z)==TRUE) {

			



			   	   if (A==1) Daten.Stereo=TRUE;
				   if (A==2) Daten.Stereo=FALSE;
			

				   if (B==1) Daten.Surround=TRUE;
				   if (B==2) Daten.Surround=FALSE;
						   
				   if (C==1) Daten.MovieText=TRUE;
				   if (C==2) Daten.MovieText=FALSE;


	
	
				   if (D==1) Daten.LP=TRUE;
				   if (D==2) Daten.LP=FALSE;
		
			           if (E==1) Daten.Color=TRUE;
				   if (E==2) Daten.Color=FALSE;


	 			   if (F>0) Daten.SubClass=F-1;




				   if (G==1) Daten.AutoShow=TRUE;
				   if (G==2) Daten.AutoShow=FALSE;

				  if (H==1) strcpy(Daten.Rating,"1");
				  if (H==2) strcpy(Daten.Rating,"2");
				  if (H==3) strcpy(Daten.Rating,"3");
				  if (H==4) strcpy(Daten.Rating,"4");
				  if (H==5) strcpy(Daten.Rating,"5");
				  if (H==6) strcpy(Daten.Rating,"6");
				  if (H==7) strcpy(Daten.Rating,"7");
			          if (H==8) strcpy(Daten.Rating,"8");
			          if (H==9) strcpy(Daten.Rating,"9");
				  if (H==10) strcpy(Daten.Rating,"10");
 


					strcpy(ERSATZNAME,Daten.Name);
					DeleteMovie(ERSATZNAME,&Anker);
				 	AddMovie(&Anker,Daten);
		
				
					};
		

				z++;
				};

				UpdateList(Anker);



	};
	








void KVL::slotChangeBatchMode() { 
	if (BATCHMODE==1) { BatchMode->setText(klocale->translate("Single selection"));BATCHMODE=0;Filmliste->setMultiSelection(FALSE);return;};
	if (BATCHMODE==0) { BatchMode->setText(klocale->translate("Multi selection"));BATCHMODE=1;Filmliste->setMultiSelection(TRUE);return;};

};


void KVL::slotQSearchProducer() { strcpy(SuchString,SProducerD->text());SEARCHMODE=1;SFIRST=2;UpdateList(Anker); };
void KVL::slotQSearchCast1() { strcpy(SuchString,SCast1D->text());SEARCHMODE=1;SFIRST=3; UpdateList(Anker);};
void KVL::slotQSearchCast2() { strcpy(SuchString,SCast2D->text());SEARCHMODE=1;SFIRST=3;UpdateList(Anker);};
void KVL::slotQSearchCast3() { strcpy(SuchString,SCast3D->text());SEARCHMODE=1;SFIRST=3;UpdateList(Anker);};
void KVL::slotQSearchCast4() { strcpy(SuchString,SCast4D->text());SEARCHMODE=1;SFIRST=3;UpdateList(Anker);};
void KVL::slotQSearchCast5() { strcpy(SuchString,SCast5D->text());SEARCHMODE=1;SFIRST=3;UpdateList(Anker);};

void KVL::slotQSearchAge() { strcpy(SuchString,SAgeD->text());SEARCHMODE=1;SFIRST=4; UpdateList(Anker);};
void KVL::slotQSearchDirector() { strcpy(SuchString,SDirectorD->text());SEARCHMODE=1;SFIRST=5; UpdateList(Anker);};

void KVL::slotQuickNameFind2() {
		SNameD->setText(Filmliste->text(Filmliste->currentItem()));
				};



void KVL::slotQuickNameFind() {
		char Find1[80];
		if (NAMECLICKED==1) { NAMECLICKED=0; return;};


		int y=0;
		strcpy(Find1,SNameD->text());
		
		while (y<=(signed) Filmliste->count()-1) {
		if (strncasecmp(Filmliste->text(y),Find1,strlen(Find1))==0) {Filmliste->setCurrentItem(y);Filmliste->centerCurrentItem();QUICKNAMEFIND=1;return;};
		y++;};
	};

						

void KVL::slotChooseNumber() {

	// Find the first movie with the number

	int zz=0;
	Element Daten;
        char Name[50];
	char Number[20];
        	
	while (zz<=(signed) Filmliste->count()) {  strcpy(Name,Filmliste->text(zz));
					  EditMovie(Name,Anker,&Daten);
					  strcpy(Number,ChooseNumber->text());
					
					  if ( strcmp(Daten.Nr,Number ) == 0 ) { Filmliste->setCurrentItem(zz); Filmliste->centerCurrentItem(); slotShowVideo();                                                   
               if (TAPEVIEW==FALSE) { TAPEVIEW=TRUE; };
		TView->show();


			 };

						
					  zz++;
					  };
		};



void KVL::slotExport() {

Export *Ex = new Export(this,"export");

Ex->show();

};









void KVL::resizeEvent( QResizeEvent *)
{
/* int x;
x=(this->width()-300) / 2;

printf("%d",x);
Comments->move( 300+ (x-(Comments->width()/2)),410);
RatingBar->move( 300+(x-(RatingBar->width()/2)),350);

*/
};









void KVL::slotDuplicateMovie() {

int f;
char Name[80];
Element Data;
if (Filmliste->count()==0) return;


        f=Filmliste->currentItem();


        strcpy(Name,Filmliste->text(f));


EditMovie(Name,Anker,&Data);    	
strcat(Name," *");
strcpy(Data.Name,Name);

AddMovie(&Anker,Data);
UpdateList(Anker);


};





void KVL::slotTapeView() {


if (TAPEVIEW==0) {tools->setItemChecked(1,TRUE);	TView->show(); TAPEVIEW=1;  }
else  {      TView->hide(); TAPEVIEW=0; tools->setItemChecked(1,FALSE);};

};



void KVL::slotCheckURL() {

	CheckURL* Check = new CheckURL(this,"URL-Check");
	Check->show();
};

KVL::~KVL() { };

void KVL::slotConversion() {
Convert* Conv = new Convert(this,"File Conversion");
	Conv->show();
};


void KVL::slotConfigure() {
Configure* Conf = new Configure(this,"Database Configuration");
	Conf->show();
};


void KVL::slotLinkURL() {

 int f;
        Element Data;
        char Name[50];
        if (Filmliste->count()==0) {

                        Title->show(); } else Title->hide();



        f=Filmliste->currentItem();                                                     strcpy(Name,Filmliste->text(f));                    


EditMovie(Name,Anker,&Data);  
        KFM *url= new KFM;
        url->allowKFMRestart(TRUE);
        url->openURL(Data.LinkURL);      
};


// KVL::slotDropEvent code is mainly from kless inside the kdesdk package

void KVL::slotDropEvent(KDNDDropZone *zone) {
	QString u = zone->getURLList().first(),s;
	if (KFM::download(u,s)) {
	char Caption[255];
	strcpy(Caption,"KVideolist - ");
	strcat(Caption,u);
	setCaption(Caption);
	ClearList(&Anker);
	strcpy(Caption,s);

	LoadMovies(Caption,&Anker);
	UpdateList(Anker);
	Filmliste->setCurrentItem(0);
	KFM::removeTempFile(s);
	CHANGED=0;
	}; 
};



void KVL::slotNewList() {
		
if (CHANGED==TRUE) { 

	if (!QMessageBox::warning(0,klocale->translate("One moment"),klocale->translate("The current videolist has been modified. \n Do You want to discard Your changes?"),klocale->translate("No"),klocale->translate("Yes"))) return; }


ClearList(&Anker);
this->setCaption(klocale->translate("KVideolist - Empty List"));

CHANGED=0;


UpdateList(Anker);
			};




		
		

void KVL::slotQuit() {
	if (CHANGED==TRUE) { 
		if (!QMessageBox::warning(0,klocale->translate("One moment"),klocale->translate("The current videolist has been modified. \n Do You want to discard Your changes?"),klocale->translate("No"),klocale->translate("Yes"))) return;
	} ClearList(&Anker); kapp->quit();
                  };

	
void KVL::saveConfiguration()
{
	KConfig *config= KApplication::getKApplication()->getConfig();

	Configure *Conf = new Configure(this,"config");
	Conf->AutoLoad->setChecked(config->readBoolEntry("LOADLASTUSED"));
	
	Conf->Recorder->setCurrentItem(config->readNumEntry("Recorder"));
	Conf->DefStereo->setChecked(config->readBoolEntry("Stereo"));
	Conf->DefSurround->setChecked(config->readBoolEntry("Surround"));
	Conf->DefMovieText->setChecked(config->readBoolEntry("MovieText"));
	Conf->DefColor->setChecked(config->readBoolEntry("Color"));
	Conf->DefLongPlay->setChecked(config->readBoolEntry("LongPlay"));
	Conf->DefAutoShow->setChecked(config->readBoolEntry("AutoShow"));
	Conf->Resort->setChecked(config->readBoolEntry("Resort"));
	Conf->AutoIndexing->setChecked(config->readBoolEntry("AutoIndexing"));
	Conf->BackgroundDisable->setChecked(config->readBoolEntry("BackgroundDisable"));
        Conf->BackgroundLine->setText(config->readEntry("BackgroundLine"));

// IMDB Settings
	Conf->FetchProducer->setChecked(config->readBoolEntry("IMDBProducer"));
	Conf->FetchGenres->setChecked(config->readBoolEntry("IMDBGenres"));
	Conf->FetchDirector->setChecked(config->readBoolEntry("IMDBDirector"));
	Conf->FetchCast->setChecked(config->readBoolEntry("IMDBCast"));
	Conf->FetchCountry->setChecked(config->readBoolEntry("IMDBCountry"));
	Conf->FetchYear->setChecked(config->readBoolEntry("IMDBYear"));
	Conf->AskOnline->setChecked(config->readBoolEntry("IMDBAskOnline"));
	Conf->AutoFetchGenres->setChecked(config->readBoolEntry("IMDBAutoFetchGenres"));

	Conf->CSFField->setText(config->readEntry("ASCIIIMPORT"));
            

		
if (strlen(Conf->BackgroundLine->text())==0) Conf->BackgroundDisable->setChecked(TRUE);
	Conf->SortMode->setCurrentItem(config->readNumEntry("Sortmode"));
	Conf->TapeView->setChecked(config->readBoolEntry("TapeView"));
	Conf->SubClass1->setText(config->readEntry("SUBCLASS1"));
	Conf->SubClass2->setText(config->readEntry("SUBCLASS2"));
	Conf->SubClass3->setText(config->readEntry("SUBCLASS3"));
	Conf->SubClass4->setText(config->readEntry("SUBCLASS4"));
	Conf->SubClass5->setText(config->readEntry("SUBCLASS5"));
	Conf->ChangeTitleFont->setFont(config->readFontEntry("TITLEFONT"));
	Conf->ChangeOriginalTitleFont->setFont(config->readFontEntry("ORIGINALTITLEFONT"));
	Conf->ChangeLabelFont->setFont(config->readFontEntry("LABELFONT"));
	Conf->ChangeOtherFont->setFont(config->readFontEntry("OTHERFONT"));
	Conf->ChangeLabelFont->adjustSize();
	Conf->ChangeTitleFont->adjustSize();
	Conf->ChangeOtherFont->adjustSize();
	Conf->ChangeOriginalTitleFont->adjustSize();
	Conf->LabelFont=config->readFontEntry("LABELFONT");
	Conf->OtherFont=config->readFontEntry("OTHERFONT");
	Conf->TitleFont=config->readFontEntry("TITLEFONT");
	Conf->OriginalTitleFont=config->readFontEntry("ORIGINALTITLEFONT");


	if (Conf->exec()) { 
		config->writeEntry("LOADLASTUSED",Conf->AutoLoad->isChecked());
		config->writeEntry("SEPARATOR",Conf->CSFSeparator->currentText());

		config->writeEntry("SUBCLASS1",Conf->SubClass1->text());
		config->writeEntry("SUBCLASS2",Conf->SubClass2->text());
		config->writeEntry("SUBCLASS3",Conf->SubClass3->text());
		config->writeEntry("SUBCLASS4",Conf->SubClass4->text());
		config->writeEntry("SUBCLASS5",Conf->SubClass5->text());

		// IMDB Configuration
		config->writeEntry("IMDBAskOnline",Conf->AskOnline->isChecked());
		config->writeEntry("IMDBCountry",Conf->FetchCountry->isChecked());
		config->writeEntry("IMDBProducer",Conf->FetchProducer->isChecked());
		config->writeEntry("IMDBDirector",Conf->FetchDirector->isChecked());
		config->writeEntry("IMDBGenres",Conf->FetchGenres->isChecked());
		config->writeEntry("IMDBCast",Conf->FetchCast->isChecked());
		config->writeEntry("IMDBYear",Conf->FetchYear->isChecked());
		config->writeEntry("IMDBAutoFetchGenres",Conf->AutoFetchGenres->isChecked());



		config->writeEntry("Recorder",Conf->Recorder->currentItem());
		config->writeEntry("Stereo",Conf->DefStereo->isChecked());
		config->writeEntry("Surround",Conf->DefSurround->isChecked());
		config->writeEntry("MovieText",Conf->DefMovieText->isChecked());
		config->writeEntry("Color",Conf->DefColor->isChecked());
		config->writeEntry("LongPlay",Conf->DefLongPlay->isChecked());
		config->writeEntry("AutoShow",Conf->DefAutoShow->isChecked());
		config->writeEntry("Resort",Conf->Resort->isChecked());
		config->writeEntry("AutoIndexing",Conf->AutoIndexing->isChecked());
		config->writeEntry("BackgroundDisable",Conf->BackgroundDisable->isChecked());
		config->writeEntry("BackgroundLine",Conf->BackgroundLine->text());
		config->writeEntry("Sortmode",Conf->SortMode->currentItem());
		config->writeEntry("TITLEFONT",Conf->TitleFont);
		config->writeEntry("ORIGINALTITLEFONT",Conf->OriginalTitleFont);
		config->writeEntry("LABELFONT",Conf->LabelFont);
		config->writeEntry("OTHERFONT",Conf->OtherFont);

		SORTMODE=Conf->SortMode->currentItem()+1;
		UpdateList(Anker);
		config->writeEntry("TapeView",Conf->TapeView->isChecked());

		if (Conf->BackgroundDisable->isChecked()==false) {
				QPixmap Hintergrund;
				Hintergrund.load(Conf->BackgroundLine->text());
				this->setBackgroundPixmap(Hintergrund);};
		SubClassF->clear();
		SubClassF->insertItem(klocale->translate("No Subclass"),0);
		SubClassF->insertItem(config->readEntry("SUBCLASS1"),1);
		SubClassF->insertItem(config->readEntry("SUBCLASS2"),2);
		SubClassF->insertItem(config->readEntry("SUBCLASS3"),3);
		SubClassF->insertItem(config->readEntry("SUBCLASS4"),4);
		SubClassF->insertItem(config->readEntry("SUBCLASS5"),5);
					
		SCast1->setFont(config->readFontEntry("LABELFONT"));
		SCast2->setFont(config->readFontEntry("LABELFONT"));
		SCast3->setFont(config->readFontEntry("LABELFONT"));
		SCast4->setFont(config->readFontEntry("LABELFONT"));
		SCast5->setFont(config->readFontEntry("LABELFONT"));
		SProducer->setFont(config->readFontEntry("LABELFONT"));
		SDirector->setFont(config->readFontEntry("LABELFONT"));
		OriginalNameL->setFont(config->readFontEntry("LABELFONT"));
		SNameD->setFont(config->readFontEntry("TITLEFONT"));
		OriginalName->setFont(config->readFontEntry("ORIGINALTITLEFONT"));
		SCast1D->setFont(config->readFontEntry("OTHERFONT"));
		SCast2D->setFont(config->readFontEntry("OTHERFONT"));
		SCast3D->setFont(config->readFontEntry("OTHERFONT"));
		SCast4D->setFont(config->readFontEntry("OTHERFONT"));
		SCast5D->setFont(config->readFontEntry("OTHERFONT"));
		SDirectorD->setFont(config->readFontEntry("OTHERFONT"));
		SProducerD->setFont(config->readFontEntry("OTHERFONT"));
		
										


			};
};



void KVL::slotStatistics() {
	Statistics *Statwindow = new Statistics(this,"stat");
	StatPointer Stat; 
        Stat= (StatPointer) malloc(sizeof(StatStruct));	

	Statistik(&Stat,&Anker);
        printf("%i\n",Stat->TotalMovies);
	Statwindow->TotalNR->display(Stat->TotalMovies);
	
       
	Statwindow->TotalLPNR->display(Stat->TotalLP);	
        int Zaehler=0;
	while (Zaehler<21) { Statwindow->T[Zaehler]->display( Stat->Percent[Zaehler] ); Zaehler++; };
 

	if (Statwindow->exec() ) { };
	};


void KVL::slotGenre() {
      GenreDisplay* Genre = new GenreDisplay(this,"genre"); 	
      if (Genre->exec() ) { GENRE1=Genre->getGenre1(); SELECTION=1;
				GENRE2=Genre->getGenre2(); if (GENRE2==22) { GENRE2=-1; };
		UpdateList(Anker);			
		 } else {SELECTION=0;UpdateList(Anker);};

};
        

void KVL::slotQuickGenreChange() {
	if (Genre1C->currentItem()==0) { SELECTION=0;slotResetGenre();UpdateList(Anker);return;};

	GENRE1=Genre1C->currentItem()-1; SELECTION=1;UpdateList(Anker);
		};






 
void KVL::slotResetGenre() {
	Genre1C->setCurrentItem(0);

	SELECTION=0;UpdateList(Anker);};


void KVL::slotAbout() {

About* AboutDlg= new About(this,"about");
AboutDlg->show();


};


	


void KVL::sortbyName() { 
sort->setItemChecked(0,TRUE);
sort->setItemChecked(1,FALSE);
sort->setItemChecked(2,FALSE);
sort->setItemChecked(3,FALSE);
sort->setItemChecked(4,FALSE);
SORTREQUEST=1;SORTMODE=1; UpdateList(Anker);};
void KVL::sortbyAge() {
sort->setItemChecked(0,FALSE); 
sort->setItemChecked(1,TRUE);
sort->setItemChecked(2,FALSE);
sort->setItemChecked(3,FALSE);
sort->setItemChecked(4,FALSE);                                   


SORTREQUEST=1;SORTMODE=2; UpdateList(Anker);};
void KVL::sortbyNumber() {
sort->setItemChecked(0,FALSE);
sort->setItemChecked(1,FALSE);
sort->setItemChecked(2,TRUE);
sort->setItemChecked(3,FALSE);
sort->setItemChecked(4,FALSE);                                          

SORTREQUEST=1;SORTMODE=3;UpdateList(Anker);};
void KVL::sortbyPlayTime() {
sort->setItemChecked(0,FALSE);
sort->setItemChecked(1,FALSE);
sort->setItemChecked(2,FALSE);
sort->setItemChecked(3,FALSE);
sort->setItemChecked(4,TRUE);                                          
SORTREQUEST=1;SORTMODE=5; UpdateList(Anker); };
void KVL::sortbyRating() {
sort->setItemChecked(0,FALSE);
sort->setItemChecked(1,FALSE);
sort->setItemChecked(2,FALSE);
sort->setItemChecked(3,TRUE);
sort->setItemChecked(4,FALSE);                                         

SORTREQUEST=1;SORTMODE=4; UpdateList(Anker); };


void KVL::slotContents(){
	KApplication::getKApplication()->invokeHTMLHelp("","");
};

void KVL::slotToolbarClicked(int item){
 switch (item) {
	case 1:
	slotLoadFile();  // OPEN A FILE
	break;
	case 2:
	slotSaveFile(); // SAVE A FILE
	break;
	case 3: 
	slotEditVideo(); // EDIT A FILE
	break;
        case 4:
	slotChangeSortDir(); // CHANGE SORT DIRECTION
	break;
        case 5:
	if (Filmliste->currentItem()>0) {
		Filmliste->setCurrentItem( (Filmliste->currentItem()-1 ));};

         
	break;
	case 6:
	Filmliste->setCurrentItem(0);
	break;
	case 7: 
	Filmliste->setCurrentItem((int) Filmliste->count()-1);
	case 8:
	 if (Filmliste->currentItem()<(int) Filmliste->count()) {
		Filmliste->setCurrentItem( (Filmliste->currentItem()+1 ));};
	 
	break;
        case 9:
	slotSearch();
        break;
	case 10:
	slotGenre();
	break; 
	case 11:
	slotAddVideo();
	break;
	case 12:
	slotStatistics();
	break;

};
};
void KVL::slotChangeSortDir() {
if (SORTDIR==0) {SORTDIR=1;} else {SORTDIR=0;}
UpdateList(Anker);

};
	
void KVL::slotShowVideo(){
	int f;
	Element Data;
	char Name[50];
	NAMECLICKED=1;

        if (Filmliste->count()==0) {

			Title->show(); } else Title->hide();

        				

	f=Filmliste->currentItem();
	strcpy(Name,Filmliste->text(f));
	strcpy(NAME,Name);
	EditMovie(Name,Anker,&Data);
	SNrD->setNumDigits(4);
	SNrD->display(atoi(Data.Nr));
	SProducerD->setText(Data.Producer);
        SDirectorD->setText(Data.Director);
	SCast1D->setText(Data.Cast1);
	SCast2D->setText(Data.Cast2);
	SCast3D->setText(Data.Cast3);
	SCast4D->setText(Data.Cast4);
	SCast5D->setText(Data.Cast5);
        OriginalName->setText(Data.OriginalName);

	if (QUICKNAMEFIND==0) SNameD->setText(Data.Name);
	QUICKNAMEFIND=0;

	SAgeD->setText(Data.Age);
	SPlayTime1->display(atoi(Data.Hours));
	SPlayTime2->display(atoi(Data.Minutes));
        MovieNr->display(Data.Number+1);	
        SStartTime1->display(atoi(Data.BeginHours));
	SStartTime2->display(atoi(Data.BeginMinutes));
	Comments->setText(Data.Comments);
	if (strlen(Data.Comments)==0) { Comments->setText("No Comment."); };
	LinkURLButton->show();
	Genre2->show();
        LP->show();PreTaped->show();
	Surround->show();
        MovieText->show();
        if (Data.Genre1==0) Genre1->setText(klocale->translate("Horror"));
	if (Data.Genre2==0) Genre2->setText(klocale->translate("Horror"));

	if (Data.Genre1==1) Genre1->setText(klocale->translate("Comedy"));
	if (Data.Genre2==1) Genre2->setText(klocale->translate("Comedy"));

	if (Data.Genre1==2) Genre1->setText(klocale->translate("SciFi"));
	if (Data.Genre2==2) Genre2->setText(klocale->translate("SciFi"));
	
	if (Data.Genre1==3) Genre1->setText(klocale->translate("Thriller"));
	if (Data.Genre2==3) Genre2->setText(klocale->translate("Thriller"));
	
	if (Data.Genre1==4) Genre1->setText(klocale->translate("Action"));
	if (Data.Genre2==4) Genre2->setText(klocale->translate("Action"));
	
	if (Data.Genre1==5) Genre1->setText(klocale->translate("Crimi"));
	if (Data.Genre2==5) Genre1->setText(klocale->translate("Crimi"));

	if (Data.Genre1==6) Genre1->setText(klocale->translate("Documentation"));
	if (Data.Genre2==6) Genre2->setText(klocale->translate("Documentation"));
	
	if (Data.Genre1==7) Genre1->setText(klocale->translate("Cartoon"));
	if (Data.Genre2==7) Genre2->setText(klocale->translate("Cartoon"));
	
	if (Data.Genre1==8) Genre1->setText(klocale->translate("Drama"));
	if (Data.Genre2==8) Genre2->setText(klocale->translate("Drama"));

	if (Data.Genre1==9) Genre1->setText(klocale->translate("Monumental"));
	if (Data.Genre2==9) Genre2->setText(klocale->translate("Monumental"));
	
	if (Data.Genre1==10) Genre1->setText(klocale->translate("Western"));
	if (Data.Genre2==10) Genre2->setText(klocale->translate("Western"));

	if (Data.Genre1==11) Genre1->setText(klocale->translate("Erotic"));
	if (Data.Genre2==11) Genre2->setText(klocale->translate("Erotic"));
	
	if (Data.Genre1==12) Genre1->setText(klocale->translate("Adventure"));
	if (Data.Genre2==12) Genre2->setText(klocale->translate("Adventure"));
	
	if (Data.Genre1==13) Genre1->setText(klocale->translate("Music"));
	if (Data.Genre2==13) Genre2->setText(klocale->translate("Music"));

	if (Data.Genre1==14) Genre1->setText(klocale->translate("War"));
	if (Data.Genre2==14) Genre2->setText(klocale->translate("War"));
	
	if (Data.Genre1==15) Genre1->setText(klocale->translate("Catastrophe"));
	if (Data.Genre2==15) Genre2->setText(klocale->translate("Catastrophe"));
	
	if (Data.Genre1==16) Genre1->setText(klocale->translate("Psycho"));
	if (Data.Genre2==16) Genre2->setText(klocale->translate("Psycho"));

	if (Data.Genre1==17) Genre1->setText(klocale->translate("Satire"));
	if (Data.Genre2==17) Genre2->setText(klocale->translate("Satire"));
	
	if (Data.Genre1==18) Genre1->setText(klocale->translate("Fantasy"));
	if (Data.Genre2==18) Genre2->setText(klocale->translate("Fantasy"));
	
	if (Data.Genre1==19) Genre1->setText(klocale->translate("Traditional"));
	if (Data.Genre2==19) Genre2->setText(klocale->translate("Traditional"));

	if (Data.Genre1==20) Genre1->setText(klocale->translate("Theatre"));
	if (Data.Genre2==20) Genre2->setText(klocale->translate("Theatre"));

	if (Data.Genre1==21) Genre1->setText(klocale->translate("Other"));
	if (Data.Genre2==21) Genre2->setText(klocale->translate("Other"));

        if (Data.Genre2==22) Genre2->hide();
	if (Data.LP==FALSE) { LP->hide(); };
	if (Data.Stereo==FALSE) { Stereo->setText("Mono"); } else { Stereo->setText("Stereo"); };
	if ( (Data.AutoShow==TRUE) || (strlen(Data.LinkURL)==0)) { LinkURLButton->hide(); }; 
	if ( (Data.AutoShow==TRUE) ) { slotLinkURL(); };
	if (Data.Surround==FALSE) { Surround->hide(); };
	if (Data.Color==FALSE) { Color->setText("Black/White"); } else { Color->setText("Color"); };
        if (Data.MovieText==FALSE) { MovieText->hide(); };
	Rating->show();
	if (Data.Rating==0) Rating->hide();
	if (Data.PreTaped==FALSE) PreTaped->hide();

// Test
Rating->hide();
int h=0;
while (h<=9) { LED[h]->hide();h++; };
h=0;
while (h<=atoi(Data.Rating)-1) { LED[h]->show();this->update();  h++;};
 
	


	if ( atoi(Data.Rating)>0) {RatingNr->setText(Data.Rating);} else {RatingNr->setText(klocale->translate("No Ranking"));};
	RatingNr->adjustSize();
	RatingNr->move(325+ ( (atoi(Data.Rating)-1)* 31),384);
	TView->showTape(atoi(Data.Nr),Anker,Data.Name);
this->update();





	};













void KVL::slotIMDBmain(){
	
	KFM *url= new KFM;
	url->allowKFMRestart(TRUE);
        url->openURL("http://www.imdb.com/");
	};
void KVL::slotKVLHome(){
	KFM *url= new KFM;
	url->allowKFMRestart(TRUE);
	url->openURL("http://www.bamberg.baynet.de/home/ba1005/kde/kvlist.html");
	};

void KVL::slotLoadFile(){

if (CHANGED==TRUE) { 

	if (!QMessageBox::warning(0,klocale->translate("One moment"),klocale->translate("The current videolist has been modified. \n Do You want to discard Your changes?"),klocale->translate("No"),klocale->translate("Yes"))) return; }

QString s= QFileDialog::getOpenFileName(0,"*.kvl",this);
char Name[255];            

strcpy(Name,s);

strcpy(DATEINAME,s);

int f;
ClearList(&Anker);

f=LoadMovies(Name,&Anker);
char Caption[255];
strcpy(Caption,"KVideolist - ");
strcat(Caption,Name);

if (f!=-1) {this -> setCaption( Caption);CHANGED=0;};



		UpdateList(Anker);
Filmliste->setCurrentItem(0);
   KConfig *config= KApplication::getKApplication()->getConfig();       
	config->writeEntry("LASTUSEDDB",Name);


};

void KVL::slotSaveFile(){
QString s= QFileDialog::getSaveFileName(0,"*.kvl",this);
int f;
char Name[255];
strcpy(Name,s);


f=SaveMovies(Name,&Anker);
char Caption[255];
strcpy(Caption,"KVideolist - ");
strcat(Caption,Name);


if (f!=-1) {this->setCaption(Caption);CHANGED=0;};
   KConfig *config= KApplication::getKApplication()->getConfig();
        config->writeEntry("LASTUSEDDB",Name);
 

};

void KVL::slotSaveKnownFile() {
int f;
char Name[255];
strcpy(Name,DATEINAME);
if (strlen(Name)==0) { slotSaveFile(); return; };


f=SaveMovies(Name,&Anker);
   KConfig *config= KApplication::getKApplication()->getConfig();
        config->writeEntry("LASTUSEDDB",Name);
 
};


 
void KVL::slotNewWindow(){
     KVL* kvl = new KVL;
     kvl->show();
    
};

void KVL::slotResetSearch() { SFIRST=0;SEARCHMODE=2;UpdateList(Anker); };


void KVL::slotSearch(){
	SearchDialog* Neu = new SearchDialog(this,"searchdialog");
	if (Neu->exec()) { strcpy(SuchString,Neu->Contains->text());
			   SEARCHMODE=1;
			SFIRST=Neu->First->currentItem();
		if (SFIRST==0) SEARCHMODE=2;

	UpdateList(Anker);
	
			 
			  	
				}; };


void KVL::slotAddVideo(){

	MovieDialog* Neu = new MovieDialog(0,"Adding a Video");
    KConfig *config= KApplication::getKApplication()->getConfig();  
	Neu->EDITING=false;

	Neu->AutoShow->setChecked(config->readBoolEntry("AutoShow"));
	Neu->Stereo->setChecked(config->readBoolEntry("Stereo"));
	Neu->Surround->setChecked(config->readBoolEntry("Surround"));
	Neu->MovieText->setChecked(config->readBoolEntry("MovieText"));
	Neu->Color->setChecked(config->readBoolEntry("Color"));
	Neu->LP->setChecked(config->readBoolEntry("LongPlay"));
	
// IMDB Settings

	Neu->FETCHPRODUCER=config->readBoolEntry("IMDBProducer");
	Neu->FETCHDIRECTOR=config->readBoolEntry("IMDBDirector");
	Neu->FETCHCAST=config->readBoolEntry("IMDBCast");
	Neu->FETCHYEAR=config->readBoolEntry("IMDBYear");
	Neu->FETCHCOUNTRY=config->readBoolEntry("IMDBCountry");
	Neu->ASKONLINE=config->readBoolEntry("IMDBAskOnline");



  Neu->SubClass->insertItem(klocale->translate("No Subclass"),0);
        Neu->SubClass->insertItem(config->readEntry("SUBCLASS1"),1);
        Neu->SubClass->insertItem(config->readEntry("SUBCLASS2"),2);
        Neu->SubClass->insertItem(config->readEntry("SUBCLASS3"),3);
        Neu->SubClass->insertItem(config->readEntry("SUBCLASS4"),4);
        Neu->SubClass->insertItem(config->readEntry("SUBCLASS5"),5);
                      











Neu->setAnker(Anker);


	
if (Neu->exec())  { 

QString Name= Neu->Name->text();


QString Producer = Neu->Producer->text();
QString Cast1 = Neu->Cast1->text();
QString Cast2 = Neu->Cast2->text();
QString Cast3 = Neu->Cast3->text();
QString Cast4 = Neu->Cast4->text();
QString Cast5 = Neu->Cast5->text();
QString Age = Neu->Age->text();
QString Number= Neu->Number->text();
QString Hours= Neu->Hours->text();
QString Minutes= Neu->Minutes->text();
QString Rating= Neu->Rating->text();
QString Director= Neu->Director->text();
QString SHours= Neu->OnTapeHours->text();
QString SMinutes= Neu->OnTapeMinutes->text();
QString Comments=Neu->Comments->text();
QString LinkURL=Neu->LinkURL->text();

strcpy(Data.Name,Neu->Name->text());
strcpy(Data.Producer,Neu->Producer->text());
strcpy(Data.Cast1,Neu->Cast1->text());
strcpy(Data.Cast2,Neu->Cast2->text());
strcpy(Data.Cast3,Neu->Cast3->text());
strcpy(Data.Cast4,Neu->Cast4->text());
strcpy(Data.Cast5,Neu->Cast5->text());
strcpy(Data.Nr,Neu->Number->text());
strcpy(Data.Age,Neu->Age->text());
strcpy(Data.Director,Neu->Director->text());
strcpy(Data.Comments,Neu->Comments->text());
strcpy(Data.LinkURL,Neu->LinkURL->text());
strcpy(Data.MadeIn,Neu->MadeIn->text());




strcpy(Data.Hours,Neu->Hours->text());

strcpy(Data.Minutes,Neu->Minutes->text());
strcpy(Data.Rating,Neu->Rating->text());
strcpy(Data.BeginHours,Neu->OnTapeHours->text());
strcpy(Data.BeginMinutes,Neu->OnTapeMinutes->text());
Data.MovieText=Neu->MovieText->isChecked();
Data.Genre1=Neu->Genre1->currentItem();
Data.Genre2=Neu->Genre2->currentItem();
Data.SubClass=Neu->SubClass->currentItem();
strcpy(Data.OriginalName,Neu->OriginalName->text());


Data.LP=Neu->LP->isChecked();
Data.Number=Neu->PlayNumber->currentItem();
Data.Stereo=Neu->Stereo->isChecked();
Data.Surround=Neu->Surround->isChecked();
Data.Color=Neu->Color->isChecked();
Data.AutoShow=Neu->AutoShow->isChecked();
Data.PreTaped=Neu->PreTaped->isChecked();

AddMovie(&Anker,Data);


strcpy(NAME,Data.Name);

UpdateList(Anker);
Filmliste->setCurrentItem(0);
	


CHANGED=TRUE; 


     

 };
};

void KVL::slotEditVideo()
{
if (Filmliste->count()==0) return;
       
int Index;
char Name[50];
char ErsatzName[50];
Element Data;
MovieDialog *Add=new MovieDialog(0,"Editing a Video");
       Index=Filmliste->currentItem();
       strcpy(Name,Filmliste->text(Index));
	strcpy(ErsatzName,Filmliste->text(Index));
	Add->Name->setText(Filmliste->text(Index));
	EditMovie(Name,Anker,&Data);
   Add->EDITING=true;

  KConfig *config= KApplication::getKApplication()->getConfig();   




// IMDB Settings

        Add->FETCHPRODUCER=config->readBoolEntry("IMDBProducer");
        Add->FETCHDIRECTOR=config->readBoolEntry("IMDBDirector");
        Add->FETCHCAST=config->readBoolEntry("IMDBCast");
        Add->FETCHYEAR=config->readBoolEntry("IMDBYear");
        Add->FETCHCOUNTRY=config->readBoolEntry("IMDBCountry");
        
	Add->ASKONLINE=config->readBoolEntry("IMDBAskOnline");
        Add->SubClass->insertItem(klocale->translate("No Subclass"),0);
	Add->SubClass->insertItem(config->readEntry("SUBCLASS1"),1);
	Add->SubClass->insertItem(config->readEntry("SUBCLASS2"),2);
	Add->SubClass->insertItem(config->readEntry("SUBCLASS3"),3);
	Add->SubClass->insertItem(config->readEntry("SUBCLASS4"),4);
	Add->SubClass->insertItem(config->readEntry("SUBCLASS5"),5);
                                                                          
Add->Name->setText(Data.Name);
Add->Producer->setText(Data.Producer);
Add->Cast1->setText(Data.Cast1);
Add->Cast2->setText(Data.Cast2);
Add->Cast3->setText(Data.Cast3);
Add->Cast4->setText(Data.Cast4);
Add->Cast4->setText(Data.Cast5);
Add->Number->setText(Data.Nr);
Add->Age->setText(Data.Age); 	
Add->Genre1->setCurrentItem(Data.Genre1);
Add->Genre2->setCurrentItem(Data.Genre2);
Add->Hours->setText(Data.Hours);
Add->Minutes->setText(Data.Minutes);
Add->Rating->setText(Data.Rating);
Add->Director->setText(Data.Director);
Add->LP->setChecked(Data.LP);
Add->PlayNumber->setCurrentItem(Data.Number);
Add->OnTapeHours->setText(Data.BeginHours);
Add->OnTapeMinutes->setText(Data.BeginMinutes);
Add->Stereo->setChecked(Data.Stereo);
Add->Surround->setChecked(Data.Surround);
Add->Color->setChecked(Data.Color);
Add->MovieText->setChecked(Data.MovieText);
Add->Comments->setText(Data.Comments);
Add->LinkURL->setText(Data.LinkURL);
Add->AutoShow->setChecked(Data.AutoShow);	
Add->SubClass->setCurrentItem(Data.SubClass);
Add->PreTaped->setChecked(Data.PreTaped);
Add->OriginalName->setText(Data.OriginalName);
Add->MadeIn->setText(Data.MadeIn);
Add->setAnker(Anker);

    Add->show(); { // DeleteMovie(ErsatzName,&Anker);
			
			QString Name= Add->Name->text();

if (Name.length()==0) {QMessageBox::information(this,"KVIDEOLIST","You must enter a Video name!"); return;};

QString Producer = Add->Producer->text();
QString Cast1 = Add->Cast1->text();
QString Cast2 = Add->Cast2->text();
QString Cast3 = Add->Cast3->text();
QString Cast4 = Add->Cast4->text();
QString Cast5 = Add->Cast5->text();
QString Age = Add->Age->text();
QString Number= Add->Number->text();
QString Hours = Add->Hours->text();
QString Minutes = Add->Minutes->text();
QString Rating = Add->Rating->text();
QString Director = Add->Director->text();
QString BHours=Add->OnTapeHours->text();
QString BMinutes=Add->OnTapeMinutes->text();
QString Comments=Add->Comments->text();
QString LinkURL=Add->LinkURL->text();

if (Number.length()==0) {QMessageBox::information(this,"KVIDEOLIST","You must enter a video number!");return;};
strcpy(Data.OriginalName,Add->OriginalName->text());

strcpy(Data.Comments,Add->Comments->text());
strcpy(Data.LinkURL,Add->LinkURL->text());
strcpy(Data.Name,Add->Name->text());
strcpy(Data.Producer,Add->Producer->text());
strcpy(Data.Cast1,Add->Cast1->text());
strcpy(Data.Cast2,Add->Cast2->text());
strcpy(Data.Cast3,Add->Cast3->text());
strcpy(Data.Cast4,Add->Cast4->text());
strcpy(Data.Cast5,Add->Cast5->text());
strcpy(Data.Nr,Add->Number->text());
strcpy(Data.Age,Add->Age->text());
strcpy(Data.Hours,Add->Hours->text());
strcpy(Data.Minutes,Add->Minutes->text());
strcpy(Data.Rating,Add->Rating->text());
strcpy(Data.Director,Add->Director->text());
strcpy(Data.BeginHours,Add->OnTapeHours->text());
strcpy(Data.BeginMinutes,Add->OnTapeMinutes->text());
strcpy(Data.MadeIn,Add->MadeIn->text());

Data.Genre1=Add->Genre1->currentItem();
Data.Genre2=Add->Genre2->currentItem();
Data.LP = Add->LP->isChecked();
Data.Number=Add->PlayNumber->currentItem();
Data.Stereo=Add->Stereo->isChecked();
Data.Surround=Add->Surround->isChecked();
Data.Color=Add->Color->isChecked();
Data.MovieText=Add->MovieText->isChecked();
Data.AutoShow=Add->AutoShow->isChecked();
Data.SubClass=Add->SubClass->currentItem();
Data.PreTaped=Add->PreTaped->isChecked();

DeleteMovie(ErsatzName,&Anker);                                                                         	
AddMovie(&Anker,Data);
strcpy(NAME,Data.Name);

UpdateList(Anker);
CHANGED=TRUE;
					 };
};
	
void KVL::slotSubClassChanged() {
SFIRST=10;
SEARCHMODE=1;
if (SubClassF->currentItem()==0) SEARCHMODE=2;

UpdateList(Anker);
};

   

void KVL::UpdateList(Pointer Anker)


{   
	Filmliste->hide();	
         Pointer Hilf=Anker;
        unsigned int Zaehler=1;
        Filmliste->clear();
        Element Data1;
	Element Data2;


int SortFlag=1;
int SearchFlag;
char Str1[50];
char Str2[50];
       Zaehler=0;
        while( Hilf!=NULL ) {    
SearchFlag=1;
// SUPPORT FOR SEARCHING
if (SEARCHMODE==1) {   // Only NORMAL Search is supported right now
		
	
	// Search for NAME (SFIRST=1)
	
	if (SFIRST==1) { 
		
		if (strstr(Hilf->Name,SuchString)==NULL) { SearchFlag=0;};
		};
	
	// Search for Producer (SFIRST=2)
	
	if (SFIRST==2) {
		if (strstr(Hilf->Producer,SuchString)==NULL) SearchFlag=0;
		};

	// Search in CASTING (SFIRST=3)
	if (SFIRST==3) {
		int CastingFlag=0;
	if (strstr(Hilf->Cast1,SuchString)!=NULL) CastingFlag++;
	if (strstr(Hilf->Cast2,SuchString)!=NULL) CastingFlag++;
	if (strstr(Hilf->Cast3,SuchString)!=NULL) CastingFlag++;
	if (strstr(Hilf->Cast4,SuchString)!=NULL) CastingFlag++;
	if (strstr(Hilf->Cast5,SuchString)!=NULL) CastingFlag++;
	if (CastingFlag==0) SearchFlag=0;
		};	
           	
	// Search in Release Date (SFIRST=4);
	if (SFIRST==4) {
		if (strstr(Hilf->Age,SuchString)==NULL) SearchFlag=0;
		       	
		};
		
        // Search in Director (SFIRST=5)
	if (SFIRST==5) {
		if (strstr(Hilf->Director,SuchString)==NULL) SearchFlag=0;
		};

	// Search the SubClasses (SFIRST=10) (6-9 for future updates)
	// SFIRST=10 is set by slotSubClassChange()
        if (SFIRST==10) { 
		if (Hilf->SubClass!=SubClassF->currentItem()) SearchFlag=0;
		};

		

	 };

if ( (SEARCHMODE==1 && SearchFlag==1) || (SEARCHMODE==2) ) {


 
// SUPPORT FOR GENRE SELECTION
if  (SELECTION==0) Filmliste->insertItem(Hilf->Name,0);

if ( (SELECTION==1) && ((Hilf->Genre1==GENRE1) || (Hilf->Genre2==GENRE1)) ) {

		Filmliste->insertItem(Hilf->Name,0); };

         };
	 
        Hilf=Hilf->next;                                                                Zaehler++;
        }

	Hilf=Anker;

     Zaehler=0;
    
// Doing a Bubblesort




if (Filmliste->count()<=1) { Filmliste->show();  return;};
  KConfig *config= KApplication::getKApplication()->getConfig();  
if ( config->readBoolEntry("Resort")==0 && SORTREQUEST==0   ) {Filmliste->show(); return;}; 
QApplication::setOverrideCursor( waitCursor);   

SORTREQUEST=0;


   while (SortFlag==1) {

	SortFlag=0;
       while (Zaehler<=Filmliste->count()-2) {
		strcpy(Str1,Filmliste->text(Zaehler));
		strcpy(Str2,Filmliste->text(Zaehler+1));
		EditMovie(Str1,Anker,&Data1);
		EditMovie(Str2,Anker,&Data2);

		// Solange bis nichts mehr gewechselt wurde
		if (SORTMODE==3) { 
	





	if (SORTDIR==1) { 
	if (atoi(Data1.Nr)<atoi(Data2.Nr)) { 
                strcpy(Str1,Data1.Name);
		strcpy(Str2,Data2.Name);
		Filmliste->changeItem(Str2,Zaehler);

                Filmliste->changeItem(Str1,Zaehler+1);
				 SortFlag=1;
	



				};};
	if (SORTDIR==0) {
	if (atoi(Data1.Nr)>atoi(Data2.Nr)) {
		strcpy(Str1,Data1.Name);
		strcpy(Str2,Data2.Name);
		Filmliste->changeItem(Str2,Zaehler);
		Filmliste->changeItem(Str1,Zaehler+1);
		SortFlag=1;
		};

			}; };

	if (SORTMODE==2) {       
	if (SORTDIR==1) {
	if (atoi(Data1.Age)<atoi(Data2.Age)) {
			strcpy(Str1,Data1.Name);
			strcpy(Str2,Data2.Name);
			Filmliste->changeItem(Str2,Zaehler);
			Filmliste->changeItem(Str1,Zaehler+1);
			SortFlag=1;
			}; };
	if (SORTDIR==0) {
	if (atoi(Data1.Age)>atoi(Data2.Age)) {
			strcpy(Str1,Data1.Name);
			strcpy(Str2,Data2.Name);
			Filmliste->changeItem(Str2,Zaehler);
			Filmliste->changeItem(Str1,Zaehler+1);
			SortFlag=1;
			}; };

			};

	if (SORTMODE==1) {  
	if (SORTDIR==1) {
	if (Data1.Name[0]<Data2.Name[0]) {
			strcpy(Str1,Data1.Name);
			strcpy(Str2,Data2.Name);
			Filmliste->changeItem(Str2,Zaehler);
			Filmliste->changeItem(Str1,Zaehler+1);
			SortFlag=1;
			}; };
	if (SORTDIR==0) {
	if (Data1.Name[0]>Data2.Name[0]) {
			strcpy(Str1,Data1.Name);
			strcpy(Str2,Data2.Name);
			Filmliste->changeItem(Str2,Zaehler);
			Filmliste->changeItem(Str1,Zaehler+1);
			SortFlag=1;
			};
			};
			};

        if (SORTMODE==4) {
	if (SORTDIR==1) {
	if (atoi(Data1.Rating)>atoi(Data2.Rating)) {
			strcpy(Str1,Data1.Name);
			strcpy(Str2,Data2.Name);
			Filmliste->changeItem(Str2,Zaehler);
			Filmliste->changeItem(Str1,Zaehler+1);
			SortFlag=1;
			}; };
	if (SORTDIR==0) {
	if (atoi(Data1.Rating)<atoi(Data2.Rating)) {
			strcpy(Str1,Data1.Name);
			strcpy(Str2,Data2.Name);
			Filmliste->changeItem(Str2,Zaehler);
			Filmliste->changeItem(Str1,Zaehler+1);
			SortFlag=1;
			}; };
			};

	if (SORTMODE==5) {
	if (SORTDIR==1) {
	if ( ( (atoi(Data1.Hours)*60)+ atoi(Data1.Minutes)  ) > ((atoi(Data2.Hours)*60)+atoi(Data2.Minutes))) {
			strcpy(Str1,Data1.Name);
			strcpy(Str2,Data2.Name);
			Filmliste->changeItem(Str2,Zaehler);
			Filmliste->changeItem(Str1,Zaehler+1);
			SortFlag=1;
			};
			};

	if (SORTDIR==0) {
	if (( (atoi(Data1.Hours)*60)+atoi(Data1.Minutes) ) < ((atoi(Data2.Hours)*60)+atoi(Data2.Minutes))) {
			strcpy(Str1,Data1.Name);
			strcpy(Str2,Data2.Name);
			Filmliste->changeItem(Str2,Zaehler);
			Filmliste->changeItem(Str1,Zaehler+1);
			SortFlag=1;
			};
			};
			};












	Zaehler++;
		}; Zaehler=0; 







};
Filmliste->show();  
if (Filmliste->count()>0) Title->hide();
QApplication::restoreOverrideCursor();

// Setting the current name saved in NAME to the currentItem

Zaehler=0;
while (Zaehler<=Filmliste->count()) {
		if (strcmp(NAME,Filmliste->text(Zaehler))==0) {
							Filmliste->setCurrentItem(Zaehler);
							Filmliste->centerCurrentItem();
								};
Zaehler++;
};

                                
   }; 
void KVL::DeleteAMovie() {
	int Index;
	char Name[50];

	Index=Filmliste->currentItem();
	if (Index==-1) {return;};
	strcpy(Name,Filmliste->text(Index));
	DeleteMovie(Name,&Anker);
        UpdateList(Anker);	

};

void KVL::slotPrintList() {

// Prints the sorted list
PrintList *Drucken= new PrintList(this,klocale->translate("Printing movie-lists"));

if (Anker==NULL) { QMessageBox::information(this,klocale->translate("Hmm..."),klocale->translate("Please load a movielist before printing.")); return;};

      if (QMessageBox::warning(0,klocale->translate("One moment"),klocale->translate("KVideolist needs to save Your database before printing.\n Shall I do this now and enter the print-dialog?"),klocale->translate("Save and go on"),klocale->translate("Do not save and cancel"))) return;


                               




SaveMovies(DATEINAME,&Anker);

FILE *Film;
char Filmname[255];
strcpy(Filmname,DATEINAME);
strcat(Filmname,"x");
Film=fopen(Filmname,"wb");
int x=0;
Namen Daten;
while (x<=(int) Filmliste->count()) {
			strcpy(Daten.Name,Filmliste->text(x));
			fwrite(&Daten,sizeof(Namen),1,Film);
			x++;
			};
fclose(Film);
strcpy(Drucken->Filename,DATEINAME);


KConfig *config= KApplication::getKApplication()->getConfig();
if ( config->readBoolEntry("PLConfigured") == TRUE ) {  
Drucken->Stereo->setChecked(config->readBoolEntry("PLStereo"));
Drucken->Surround->setChecked(config->readBoolEntry("PLSurround"));
Drucken->MovieText->setChecked(config->readBoolEntry("PLMovieText"));
Drucken->Genres->setChecked(config->readBoolEntry("PLGenres"));
Drucken->PlayTime->setChecked(config->readBoolEntry("PLPlayTime"));
Drucken->StartTime->setChecked(config->readBoolEntry("PLStartTime"));
Drucken->Color->setChecked(config->readBoolEntry("PLColor"));
Drucken->f=config->readFontEntry("PLFont");
Drucken->LongPlay->setChecked(config->readBoolEntry("PLLP"));
Drucken->LineWidth->setValue(config->readNumEntry("PLLineSpacing"));
Drucken->LinesPage->setText(config->readEntry("PLLinesPage"));
/* 
Drucken->PosName->move(config->readNumEntry("PLPosName"),350);
Drucken->PosLongPlay->move(config->readNumEntry("PLPosLongPlay"),350);
Drucken->PosTapeNr->move(config->readNumEntry("PLPosTapeNr"),350);
*/
Drucken->PosMovieNr->setFont(Drucken->f);
Drucken->PosTapeNr->setFont(Drucken->f);
Drucken->PosName->setFont(Drucken->f);
Drucken->PosLongPlay->setFont(Drucken->f);
Drucken->PosSurround->setFont(Drucken->f);
Drucken->PosStereo->setFont(Drucken->f);
Drucken->PosColor->setFont(Drucken->f);
Drucken->PosStartTime->setFont(Drucken->f);
Drucken->PosPlayTime->setFont(Drucken->f);
Drucken->PosGenre1->setFont(Drucken->f);
Drucken->PosGenre2->setFont(Drucken->f);
Drucken->PosMovieText->setFont(Drucken->f);
Drucken->slotSetupPos();

// Positioning the Widgets

Drucken->PosName->move(config->readPointEntry("PLNamePos"));
Drucken->PosTapeNr->move(config->readPointEntry("PLTapePos"));
Drucken->PosLongPlay->move(config->readPointEntry("PLLongPlayPos"));
Drucken->PosStereo->move(config->readPointEntry("PLStereoPos"));
Drucken->PosSurround->move(config->readPointEntry("PLSurroundPos"));
Drucken->PosMovieText->move(config->readPointEntry("PLMovieText"));
Drucken->PosColor->move(config->readPointEntry("PLColor"));
Drucken->PosGenre1->move(config->readPointEntry("PLGenre1"));
Drucken->PosGenre2->move(config->readPointEntry("PLGenre2"));
Drucken->PosStartTime->move(config->readPointEntry("PLStartTime"));
Drucken->PosPlayTime->move(config->readPointEntry("PLPlayTime"));
Drucken->PosMovieNr->move(config->readPointEntry("PLMovieNr"));
} else { 
QMessageBox::information(this,klocale->translate("Advice"),klocale->translate("You did not saved a own layout for\n Your movielist till now. \n KVideolist will use the 'Advanced' Layout."));
Drucken->Standarts->setCurrentItem(1);
Drucken->slotStandarts();

	};








if (Drucken->exec()) {

if (Drucken->CONFIGME==TRUE) {
		config->writeEntry("PLStereo",Drucken->Stereo->isChecked());
		config->writeEntry("PLSurround",Drucken->Surround->isChecked());
		config->writeEntry("PLMovieText",Drucken->MovieText->isChecked());
		config->writeEntry("PLGenres",Drucken->Genres->isChecked());
		config->writeEntry("PLPlayTime",Drucken->PlayTime->isChecked());
		config->writeEntry("PLStartTime",Drucken->StartTime->isChecked());
		config->writeEntry("PLColor",Drucken->Color->isChecked());
		config->writeEntry("PLFont",Drucken->f);
		config->writeEntry("PLLP",Drucken->LongPlay->isChecked());
		config->writeEntry("PLLineSpacing",Drucken->LineWidth->value());
		config->writeEntry("PLLinesPage",Drucken->LinesPage->text());
	
		// Saving Positions PL= PrintList
		config->writeEntry("PLNamePos",Drucken->PosName->pos());
		config->writeEntry("PLTapePos",Drucken->PosTapeNr->pos());
		config->writeEntry("PLSurroundPos",Drucken->PosSurround->pos());
		config->writeEntry("PLStereoPos",Drucken->PosStereo->pos());	
		config->writeEntry("PLLongPlayPos",Drucken->PosLongPlay->pos());
		config->writeEntry("PLColor",Drucken->PosColor->pos());
		config->writeEntry("PLMovieText",Drucken->PosMovieText->pos());
		config->writeEntry("PLStartTime",Drucken->PosStartTime->pos());
		config->writeEntry("PLPlayTime",Drucken->PosPlayTime->pos());
		config->writeEntry("PLGenre1",Drucken->PosGenre1->pos());
		config->writeEntry("PLGenre2",Drucken->PosGenre2->pos());
		config->writeEntry("PLMovieNr",Drucken->PosMovieNr->pos());
		bool Configured=TRUE;
		config->writeEntry("PLConfigured",Configured);
			
			};

			};

};


	







	












  



                      
int main(int argc, char* argv[]) {



	 KApplication Movies(argc,argv);
	
  
KVLProcess PROCESS(0,"Test");
PROCESS.show();
if (Movies.isRestored()){     
	RESTORE(KVL);	}
    
  else {  
    // no session management: just create one window
 
	 KVL *kvl= new KVL();
	PROCESS.hide();


kvl->Configuration=0;
	
    if (argc > 1) {
       
       char Caption[255];
	strcpy(Caption,"KVideolist - ");
	strcat(Caption,argv[1]); 
	 
      if ( LoadMovies(argv[1],&kvl->Anker)!=-1) kvl->setCaption(Caption);
	kvl->UpdateList(kvl->Anker);
        kvl->Filmliste->setCurrentItem(0);			
		
	};	

printf("TEST");
Movies.setMainWidget(kvl);
kvl->show();
};	


Movies.exec();
};




                     	
