/*
 *   kvideolist - a database for home-movie collections
 *   Copyright (C) 1998  Holger Hetterich
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or           *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
                                       
#include <stdio.h>
#include <qfiledlg.h>
#include "mlist.h"
#include "urlcheck.moc"
#include "kfiledialog.h"


CheckURL::CheckURL(QWidget *parent, const char *name):QDialog(parent,name,TRUE) {
	this->setCaption(klocale->translate("URL-Check..."));
	this->resize(580,300);

	QLabel *Help = new QLabel(this,klocale->translate("This will check the URLs You \n have entered into a database."),this);
	Help->move(20,50);
	Help->resize(400,60);






	
	QPushButton *Filechange = new QPushButton(klocale->translate("Filename..."),this);
	Filechange->resize(214,20);Filechange->move(31,135);
	Filename = new QLineEdit(this,"filename");
	Filename->resize(214,25);Filename->move(31,154);
	
	QPushButton *OK = new QPushButton(klocale->translate("Check URLs"),this);
	QPushButton *Cancel = new QPushButton(klocale->translate("Cancel"),this);
	OK->move(20,255);
	Cancel->move(300,255);

	connect(OK,SIGNAL(clicked()),SLOT(slotOKPressed()));
	connect(Cancel,SIGNAL(clicked()),SLOT(slotCancelPressed()));
	connect(Filechange,SIGNAL(clicked()),SLOT(slotFileChange()));
	connect(Filename,SIGNAL(textChanged(const char *)),SLOT(slotTextChanged()));
};

void CheckURL::slotFileChange() {
	QString s=QFileDialog::getOpenFileName(0,"*.kvl",this);
	Filename->setText(s);
	};
void CheckURL::slotTextChanged() {
	char Dummy[255];
	strcpy(Dummy,"NEW");


	};
void CheckURL::slotOKPressed() {
	FILE *Test;
		if ((Test=fopen(Filename->text(),"rb"))==NULL) { QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("The file You selected does not exist."));return;};
	
	if (strlen(Filename->text())==0) {QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("No filename given."));return;};


QApplication::setOverrideCursor(waitCursor);


	char File[255];

	strcpy(File,Filename->text());
	if (URLCheck(File)!=-100) {
					FILE *Checkout;
					Element Name;
					int Position=URLCheck(File);
					char Output[255];
					strcpy(Output,klocale->translate("The URL linked within the movie "));

					Checkout=fopen(File,"rb");
					int Count=0;
					while(Count<=Position) {
					fread(&Name, sizeof(Element),1,Checkout);
					Count++;
					};
					strcat(Output,Name.Name);
					strcat(Output,klocale->translate(" is not valid."));
					QMessageBox::information(this,klocale->translate("URL-Check"),Output);
			
					} else
					{ 
					
QApplication::restoreOverrideCursor();
QMessageBox::information(this,klocale->translate("URL-Check"),klocale->translate("No invalid URLs found."));
					};
 

			
				




QApplication::restoreOverrideCursor();
	
	accept();
	};
void CheckURL::slotCancelPressed() {
	reject();
	};


	
