// kvncauthwdg.h
// Author: Markus Wuebben <markus.wuebben@kde.org>
// This code is published under the GPL.

#ifndef KVNCAUTH_H
#define KVNCAUTH_H

#include <qwidget.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qgrpbox.h>
#include <qstring.h>
#include <qchkbox.h>

class KVNCCanvas;


class KVNCConnectDlg : public QDialog {

Q_OBJECT;

 public: 
  KVNCConnectDlg(QWidget *parent = 0, const char *name = 0, KVNCCanvas *wid = 0 );
  
 private:
  QLineEdit *hostNameLdt;
  QLineEdit *displayNumberLdt;
  QPushButton *ok;
  QPushButton *cancel;
  QPushButton *options;
  KVNCCanvas *viewer;
  


 private slots: 
  void slotOkPressed();
  void slotOptionsPressed();
  void slotCancelPressed();
  

};

class KVNCOptionsWdg : public QDialog {

Q_OBJECT

public:
 KVNCOptionsWdg(QWidget *parent = 0, const char *name = 0, KVNCCanvas *wid = 0);

private:
 KVNCCanvas *canvas; 
 QGroupBox *groupBox;
 QCheckBox *hex;
 QCheckBox *corre;
 QCheckBox *rre;
 QCheckBox *raw;
 QCheckBox *copyRect;
 QCheckBox *deIconify;
 QCheckBox *bit;
 QCheckBox *shared;
 QCheckBox *deep;
 
 QPushButton *ok;
 QPushButton *cancel;

 bool _hextile, _corre, _rre , _raw , _copyrect, _deiconify, _restrict, _shared;
 int _encodings; 


public slots:
 void okPressed();
 void cancelPressed(); 

 private slots:
  void readConfig();
 void writeConfig();

};

class KVNCAuthWdg : public QDialog {

Q_OBJECT

public: 
 KVNCAuthWdg(QWidget *parent = 0, const char *name = 0, KVNCCanvas *v = 0);
 
public slots:
  void retry();

private slots:
  void slotOkPressed();
  void slotCancelPressed();

private:
 QLineEdit *loginNameLdt;
 QLineEdit *passwdLdt;
 QPushButton *ok;
 QPushButton *cancel;
 KVNCCanvas *view;


};
#endif
