/***************************************************************************
                          chart.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
    kweather - a program for recording weather events
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    
#include "dlgdata.h"
#include "chart.h"
#include "toplevel.h"
#include "dlgedit.h"
#include "globals.h"
#include "griddlg.h"
#include "dlgnew.h"

char* MonName[12] = {"January","February","March","April","May","June","July",
                    "August","September","October","November","December"};

extern DataDlg *ddlg;
extern EditDlg *edlg;
extern struct GridSettingsType GridDefaults;
extern PixPtr SmallWetterIcon[256];
extern PixPtr WetterIcon[256];

int sign(double x) {  // Vorzeichen
   if (x<0.0) return -1;
   else return 1;
}

QPixmap CalcWetterImage(int Code) {
KIconLoader iconLoader;
QPixmap Pix;
QImage Loader,Work;
QRgb Back;
int x,y,Lauf;
QPixmap RetImg;   // Rckgabe
char Names[8][30] = {"","","","","","","",""};  // BildNamen

   strcpy(Names[0], "kweather//leer.xpm");
   if ((Code & 0x007F) == 1)
      strcpy(Names[0], "kweather//sonne.xpm");  // nur Sonne
   else {
      if ((Code & 0x0001) != 0)
         strcpy(Names[0], "kweather//sonne2.xpm");  // kleine Sonne
      if ((Code & 0x0040) != 0) {
         if ((Code & 0x0002) != 0)
            strcpy(Names[1], "kweather//gewitter1.xpm");// kleine Gewitterwolke
         else
         if ((Code & 0x0004) != 0)
            strcpy(Names[1], "kweather//gewitter2.xpm");// groe Gewitterwolke
      } else {
         if ((Code & 0x0002) != 0)
            strcpy(Names[1], "kweather//wolke1.xpm");  // kleine Wolke
         else
         if ((Code & 0x0004) != 0)
            strcpy(Names[1], "kweather//wolke2.xpm");  // groe Wolke
      }
      if ((Code & 0x0020) != 0) {  // Schnee
         switch (Code & 0x0018) {
            case  0 : // SONDER: Schneeregen
                      strcpy(Names[2], "kweather//schneereg.xpm");
                      break;
            case  8 : strcpy(Names[2], "kweather//schnee1.xpm");
                      break;  // Schneegriesel
            case 16 : strcpy(Names[2], "kweather//schnee2.xpm");
                      break;  // wenig Schnee
            case 24 : strcpy(Names[2], "kweather//schnee3.xpm");
                      break;  // wiel Schnee
         }
      } else {  // Regen
         switch (Code & 0x0018) {
           case  8 : strcpy(Names[2], "kweather//regen1.xpm");
                     break;  // Sprhregen
           case 16 : strcpy(Names[2], "kweather//regen2.xpm");
                     break;  // wenig Regen
           case 24 : strcpy(Names[2], "kweather//regen3.xpm");
                     break;  // Pladdern
         }
      }
   }
   if ((Code & 0x0080) != 0)  // Nebel
      strcpy(Names[3], "kweather//nebel.xpm");  // (Boden-)Nebel
   
   //printf("%s\n",Names[1]);
   Pix=iconLoader.loadIcon(Names[0]);
   Work=Pix.convertToImage();
   Back = Work.pixel(0,0);

   for (Lauf=1; Lauf<8; Lauf++) {
      if (strlen(Names[Lauf])==0) continue;  // leeres Bild
      
      Pix=iconLoader.loadIcon(Names[Lauf]);
      Loader=Pix.convertToImage();
  
      for (x=0; x<32; x++)
      for (y=0; y<32; y++) 
      if (Loader.pixel(x,y)!=Back)
         Work.setPixel(x,y,Loader.pixel(x,y));
   }

   RetImg = Work;
   return RetImg;
}


QPixmap CalcSmallWetterImage(int Code) {
KIconLoader iconLoader;
QPixmap Pix;
QImage Loader,Work;
QRgb Back;
int x,y,Lauf;
QPixmap RetImg;   // Rckgabe
char Names[8][30] = {"","","","","","","",""};  // BildNamen

   strcpy(Names[0], "kweather//m_leer.xpm");
   if ((Code & 0x007F) == 1)
      strcpy(Names[0], "kweather//m_sonne.xpm");  // nur Sonne
   else {
      if ((Code & 0x0001) != 0)
         strcpy(Names[0], "kweather//m_sonne2.xpm");  // kleine Sonne
      if ((Code & 0x0040) != 0) {
         if ((Code & 0x0002) != 0)
            strcpy(Names[1], "kweather//m_gewitter1.xpm");// kleine Gewitterwolke
         else
         if ((Code & 0x0004) != 0)
            strcpy(Names[1], "kweather//m_gewitter2.xpm");// groe Gewitterwolke
      } else {
         if ((Code & 0x0002) != 0)
            strcpy(Names[1], "kweather//m_wolke1.xpm");  // kleine Wolke
         else
         if ((Code & 0x0004) != 0)
            strcpy(Names[1], "kweather//m_wolke2.xpm");  // groe Wolke
      }
      if ((Code & 0x0020) != 0) {  // Schnee
         switch (Code & 0x0018) {
            case  0 : // SONDER: Schneeregen
                      strcpy(Names[2], "kweather//m_schneereg.xpm");
                      break;
            case  8 : strcpy(Names[2], "kweather//m_schnee1.xpm");
                      break;  // Schneegriesel
            case 16 : strcpy(Names[2], "kweather//m_schnee2.xpm");
                      break;  // wenig Schnee
            case 24 : strcpy(Names[2], "kweather//m_schnee3.xpm");
                      break;  // wiel Schnee
         }
      } else {  // Regen
         switch (Code & 0x0018) {
           case  8 : strcpy(Names[2], "kweather//m_regen1.xpm");
                     break;  // Sprhregen
           case 16 : strcpy(Names[2], "kweather//m_regen2.xpm");
                     break;  // wenig Regen
           case 24 : strcpy(Names[2], "kweather//m_regen3.xpm");
                     break;  // Pladdern
         }
      }
   }
   if ((Code & 0x0080) != 0)  // Nebel
      strcpy(Names[3], "kweather//m_nebel.xpm");  // (Boden-)Nebel
   
   //printf("%s\n",Names[1]);
   Pix=iconLoader.loadIcon(Names[0]);
   Work=Pix.convertToImage();
   Back = Work.pixel(0,0);

   for (Lauf=1; Lauf<8; Lauf++) {
      if (strlen(Names[Lauf])==0) continue;  // leeres Bild
      
      Pix=iconLoader.loadIcon(Names[Lauf]);
      Loader=Pix.convertToImage();
  
      for (x=0; x<16; x++)
      for (y=0; y<16; y++) 
      if (Loader.pixel(x,y)!=Back)
         Work.setPixel(x,y,Loader.pixel(x,y));
   }

   RetImg = Work;
   return RetImg;
}



TChart::TChart( QWidget* parent=0, const char* name=0, WFlags f=0)
        : QWindow( parent, name, f )
{
QDate date;
char* WdNamen[16] = {"s.xpm","sso.xpm","so.xpm","oso.xpm","o.xpm","ono.xpm","no.xpm","nno.xpm","n.xpm","nnw.xpm","nw.xpm","wnw.xpm","w.xpm","wsw.xpm","sw.xpm","ssw.xpm"};
KIconLoader iconLoader;
int Lauf;
QString Prefix = "kweather//";

  debug("TChart init");
  FileActive = FALSE;
  DispMode = DISP_TAG;
  date = QDate::currentDate();
  CurMon = date.month();
  CurJahr = date.year();
  fMonate = 0;
  fCurrent = 0;
  tp = parent;
  DispTag = 0;
  NoIconUpdate=FALSE;
  DF=NULL;
  for (Lauf=0; Lauf<16; Lauf++)
    WdIco[Lauf] = iconLoader.loadIcon(Prefix+WdNamen[Lauf]);

  memset(WetterIcon, 0, sizeof(WetterIcon));
  memset(SmallWetterIcon, 0, sizeof(SmallWetterIcon));

  //GridY = 12;   // Y-Einteilungen
  //GridN = 5;    // Nulllinie

  Paint = new QPainter();
  ddlg=NULL;    // Datenazeige-Dialog
  edlg=NULL;    // Dateneditier-Dialog

  Config=KApplication::getKApplication()->getConfig();
  LoadConfig();
}

TChart::~TChart() {
  debug("TChart.delete");
  if (Paint->isActive())
    Paint->end();
  delete Paint;
  Paint=NULL;
  debug("TChart.delete - 1");
  CloseFile();
  debug("TChart.delete - 2");
  // Freigeben der global allokierten Icons
  for (int i=1; i<255; i++) {
    if (WetterIcon[i])      delete(WetterIcon[i]);
    if (SmallWetterIcon[i]) delete(SmallWetterIcon[i]);
  }
  debug("TChart.delete - Ende");
}

void TChart::paintEvent( QPaintEvent *) {
   //debug("TChart.paintEvent");
   Paint->begin(this);
   
   PaintGrid();
   Paint->end();
}

void TChart::resizeEvent( QResizeEvent * ) {
   //debug("TChart.resizeEvent");
   dx = width()/33.0;
   dy = (height()-BO-BU)/130.0;
}

void TChart::NewFile()
{

// char Strg[300];
QString S;

   if (FileActive)
      CloseFile();
      
   NewDlg ND(this, i18n("Create new File"));
   ND.exec();
/*   if (ND.exec()) {  // ok
      //debug("dateiname=>%s<",ND.DateiEdit->text());
      if (strlen(ND.DateiEdit->text()) == 0) {
         debug("keine Datei angegeben");
         return;
      }
      if (QFile::exists(ND.DateiEdit->text())) {
         //debug("datei existiert");
         sprintf(Strg, "%s%s", i18n("Overwrite the file "), ND.DateiEdit->text());
         if (QMessageBox::information(this, i18n("File Overwrite"),
            Strg, i18n("Yes"), i18n("No"), 0, 1)!=0) {
            //debug("nicht berschreiben");
            return;
         }
      }
      // neue Datei anlegen ok
      // Datenblock initialisieren
      monat.MonName = ND.MonatCombo->currentItem()+1;
      monat.Jahr = ND.JahrSpin->getValue();
      Clear();
      monat.Kennung[0]='F';
      monat.Kennung[1]='I';
      monat.Kennung[2]='K';
      monat.Kennung[3]='\0';
      
      // Datei erzeugen
      S = ND.DateiEdit->text();
      if (S.right(4) != ".fik")
         S += ".fik";
      strcpy(dateiName, S.data());
      //debug ("%s",dateiName);
      F = fopen(dateiName, "w+b");
      if (!F) {  // Fehler, Datei nicht angelegt
         QMessageBox::critical(this, i18n("File Creation Error"),
            i18n("Error creating new file"));
         return;
      }
      fwrite(&monat, sizeof(struct MonTyp), 1, F); // einen DS speichern
      fCurrent=0;
      fMonate=1;
      FileActive=TRUE;
   }
*/
}

void TChart::OpenFile() {
int Res;

   QString f = KFileDialog::getOpenFileName(dateiName, "*.kwd", this);
   if (!f.isEmpty()) {
      CloseFile();
      DF=new DataFile(f);
      Res=DF->Open(&GridDefaults);
      if (Res!=DTA_OK) {
         QMessageBox::warning(this,i18n("Open Error"), i18n("Error while opening file"),
                              i18n("Ok") );
//         return;
         delete DF;
         DF=NULL;
         return;
      }
      strcpy(dateiName,f.data());
      fMonate=DF->RecCount();
      fCurrent=0;
      
      //DF->Seek(CurMon,CurJahr);
      //DF->Read();
      DF->Seek(0);
      DF->Read();
      CurMon=DF->GetCurrentMon();
      CurJahr=DF->GetCurrentYear();
      //DF->Seek(DF->RecCount()-1);
      //DF->Read();
      FileActive=TRUE;
      
      ddlg = new DataDlg(DF, this);
      ddlg->show();
      debug("this=%p",this);
      debug("visible=%d",ddlg->isVisible());
   }
}

/*void TChart::OpenFile()
{
MonTyp data;
FILE* d;

   if (FileActive)
      fclose(F);

   FileActive=FALSE;
   QString f = KFileDialog::getOpenFileName(dateiName, "*.fik", this);
   if (!f.isEmpty()) {
      if (QFile::exists(f.data())) {   // Datei existiert
         d = fopen(f.data(),"rb");
         if (d) {
         //debug ("sizeof(d)=%d",sizeof(data));
            fread(&data, sizeof(data),1, d);  // probeweise lesen
            //debug("%c%c%c", data.Kennung[0],data.Kennung[1],data.Kennung[2]);
            if (data.Kennung[0]=='F' && data.Kennung[1]=='I' && data.Kennung[2]=='K') {
               strcpy(dateiName, f.data());
               //debug("Dateiname=%s",dateiName);
               // QMessageBox::message("ok","datei ok");
               FileActive=TRUE;
               F = fopen(dateiName, "r+b");
               //fread(&monat, sizeof(monat),1, F);  // 1. Block lesen
               fseek(F, 0, SEEK_END);
               fMonate = ftell(F) / sizeof(struct MonTyp);
               fCurrent = fMonate-1;
               LoadMon();
               //debug("Pos=%d",fMonate);
            } else
               QMessageBox::message(f.data(), "No '.FIK'-File");
            fclose(d);
         } else
            QMessageBox::message(f.data(), "Open Error");
      }
   }
}*/

void TChart::CloseFile()
{
debug("TChart::CloseFile");
   if (FileActive) {
debug("TChart::CloseFile - 1");
      if (ddlg) {
debug("TChart::CloseFile - 1.1");
         delete ddlg;
debug("TChart::CloseFile - 1.2");
         ddlg=NULL;
debug("TChart::CloseFile - 1.3");
      }
debug("TChart::CloseFile - 2");
      if (edlg) {
         delete edlg;
         edlg=NULL;
      }
debug("TChart::CloseFile - 3");
      DF->Close();
      delete DF;
      DF=NULL;
   }
debug("TChart::CloseFile - 4");
   update();
   FileActive=FALSE;
debug("TChart::CloseFile - Ende");
}

int TChart::CalcX(int Tag, int Zeit) {
int w=width()-BL-BR;
   return (int)(BL + w*(Tag+Zeit/1440.0)/(MonTage(CurMon, CurJahr)));
}

void TChart::LoadMon(void) {

   if (FileActive) {
      DF->Seek(fCurrent);
      DF->Read();
      CurMon=DF->GetCurrentMon();
      CurJahr=DF->GetCurrentYear();

      int M=MonTage(CurMon, CurJahr);
      if (DispTag>=M)
        DispTag=M-1;
   }
}

void TChart::SaveMon(void) {
   if (FileActive) {
      //fseek(F, fCurrent*sizeof(struct MonTyp), SEEK_SET);
      //fwrite(&monat, sizeof(struct MonTyp), 1, F);
      //debug("SPEICHERN");
   }
}

void TChart::PaintScales(void) {
// Skalen links und rechts zeichnen
int Lauf,y;
char Strg[20];
int LineFlg=0,PrsFlg=0,LevelFlg=0;
QColor LineCol=QColor(0,0,0);
QColor PrsCol=QColor(0,0,0);
QColor LevelCol=QColor(0,0,0);

  // Farben bei aktiver Datei bestimmem
  if (FileActive) {
    for (Lauf=0; Lauf<MAXDATA; Lauf++)
    if (DF->DataArr[Lauf] != NULL) {
      switch(DF->DataArr[Lauf]->Type) {
        case TYP_LINE     : if (GridDefaults.ColorFlags & 0x0001)
                            if (!LineFlg) {
                              LineCol=DF->DataArr[Lauf]->Farbe;
                              LineFlg=1;
                            }
                            break;
        case TYP_PRESSURE : if (GridDefaults.ColorFlags & 0x0002)
                            if (!PrsFlg) {
                              PrsCol=DF->DataArr[Lauf]->Farbe;
                              PrsFlg=1;
                            }
                            break;
        case TYP_LEVEL    : if (GridDefaults.ColorFlags & 0x0004)
                            if (!LevelFlg) {
                              LevelCol=DF->DataArr[Lauf]->Farbe;
                              LevelFlg=1;
                            }
                            break;
      }
    }
  }

  // --- links
  // Temp
  if (GridDefaults.LineDspLeft) {
    // Anzeige der Temperatureinheiten links
    for (Lauf=0; Lauf<=GridDefaults.Grid; Lauf++) {
       y=BO+(height()-BO-BU)*Lauf/GridDefaults.Grid;
       Paint->setPen(LineCol);
       sprintf(Strg, "%0.0f", GridDefaults.LineGrids*(GridDefaults.Grid-Lauf-GridDefaults.ZeroLine)+GridDefaults.LineZero);
       Paint->drawText(BL-5, y-5, 20,15, AlignRight+DontClip, Strg);
    }
    Paint->drawText(BL-5, height()-15, 20,15, AlignRight+DontClip, GridDefaults.LineUnits);
    BL+=25;
  }
  // Pressure
  if (GridDefaults.PrsDspLeft) {
    // Anzeige der Luftdruckeinheiten links
    for (Lauf=0; Lauf<=GridDefaults.Grid; Lauf++) {
       y=BO+(height()-BO-BU)*Lauf/GridDefaults.Grid;
       Paint->setPen(PrsCol);
       sprintf(Strg, "%0.0f", GridDefaults.PrsGrids*(GridDefaults.Grid-Lauf-GridDefaults.ZeroLine)+GridDefaults.PrsZero);
       Paint->drawText(BL, y-5, 20,15, AlignRight+DontClip, Strg);
    }
    Paint->drawText(BL, height()-15, 20,15, AlignRight+DontClip, GridDefaults.PrsUnits);
    BL+=30;
  }
  // Level
  if (GridDefaults.LevelDspLeft) {
    // Anzeige der Pegeleinheiten links
    for (Lauf=0; Lauf<=GridDefaults.Grid; Lauf++) {
       y=BO+(height()-BO-BU)*Lauf/GridDefaults.Grid;
       Paint->setPen(LevelCol);
       sprintf(Strg, "%0.0f", GridDefaults.LevelGrids*(GridDefaults.Grid-Lauf/*-GridDefaults.ZeroLine*/)+GridDefaults.LevelZero);
       Paint->drawText(BL-3, y-5, 20,15, AlignRight+DontClip, Strg);
    }
    Paint->drawText(BL-3, height()-15, 20,15, AlignRight+DontClip, GridDefaults.LevelUnits);
    BL+=25;
  }

  // --- rechts
  // Level
  if (GridDefaults.LevelDspRight) {
    // Anzeige der Pegeleinheiten rechts
    for (Lauf=0; Lauf<=GridDefaults.Grid; Lauf++) {
       y=BO+(height()-BO-BU)*Lauf/GridDefaults.Grid;
       Paint->setPen(LevelCol);
       sprintf(Strg, "%0.0f", GridDefaults.LevelGrids*(GridDefaults.Grid-Lauf/*-GridDefaults.ZeroLine*/)+GridDefaults.LevelZero);
       Paint->drawText(width()-BR-13, y-5, 20,15, AlignRight+DontClip, Strg);
    }
    Paint->drawText(width()-BR-13, height()-15, 20,15, AlignRight+DontClip, GridDefaults.LevelUnits);
    BR+=25;
  }
  // Pressure
  if (GridDefaults.PrsDspRight) {
    // Anzeige der Luftdruckeinheiten rechts
    for (Lauf=0; Lauf<=GridDefaults.Grid; Lauf++) {
       y=BO+(height()-BO-BU)*Lauf/GridDefaults.Grid;
       Paint->setPen(PrsCol);
       sprintf(Strg, "%0.0f", GridDefaults.PrsGrids*(GridDefaults.Grid-Lauf-GridDefaults.ZeroLine)+GridDefaults.PrsZero);
       Paint->drawText(width()-BR-15, y-5, 20,15, AlignRight+DontClip, Strg);
    }
    Paint->drawText(width()-BR-15, height()-15, 20,15, AlignRight+DontClip, GridDefaults.PrsUnits);
    BR+=30;
  }
  // Temp
  if (GridDefaults.LineDspRight) {
    // Anzeige der Temperatureinheiten rechts
    for (Lauf=0; Lauf<=GridDefaults.Grid; Lauf++) {
       y=BO+(height()-BO-BU)*Lauf/GridDefaults.Grid;
       Paint->setPen(LineCol);
       sprintf(Strg, "%0.0f", GridDefaults.LineGrids*(GridDefaults.Grid-Lauf-GridDefaults.ZeroLine)+GridDefaults.LineZero);
       Paint->drawText(width()-BR-15, y-5, 20,15, AlignRight+DontClip, Strg);
    }
    Paint->drawText(width()-BR-15, height()-15, 20,15, AlignRight+DontClip, GridDefaults.LineUnits);
    BR+=25;
  }
}

void TChart::PaintGrid(void) {
//int bl=BL, br=width()-BR;
int Max, Lauf,Tag,Messung, x,y, xx, xa,ya, Null;
int AvgTime;    // Zeitpunkt,Wert bei CalcAvg
double AvgValue;
char Strg[20];
int h=height()-BO-BU;
ShortDataType* SD;
LongDataType* LD;
FloatDataType* FD;
double Help;
int FirstPoint;          // erster Punkt der Linie, nur berechnen, nicht zeichnen
int Valid, ValidAlt;
int VisibleCount=0;      // Anzahl der sichtbaren Iconzeilen
int IconYPos;            // Y-Position der Iconzeile (Wetter/Wind)

  Paint->setFont(QFont("Helvetica",10));
  // Rnder links und rechts
  BL = 10;
  BR = 10;
  BO = 10;
  BU = 25;
  IconYPos = BO-5;

  // Berechnung des Abstandes fr die Icons
  if (DF)
  for (Lauf=0; Lauf<MAXDATA; Lauf++) {
    if (DF->DataArr[Lauf]==NULL) break;
    if ( (DF->DataArr[Lauf]->Type == TYP_WEATHER) || (DF->DataArr[Lauf]->Type == TYP_WIND) )
    if (DF->IsVisible(Lauf)) {
      VisibleCount+=DF->DataArr[Lauf]->Count;
    }
  }
  BO = BO + VisibleCount*16;
  h=height()-BO-BU;
debug("VisibleCount=%d",VisibleCount);

  PaintScales();

  Max = MonTage(CurMon, CurJahr);

  // aktuellen Tag hervorheben
  {
  int h,s,v,x1,x2;
  QColor C = this->backgroundColor();
    // Farbe bestimmen
    C.hsv(&h,&s,&v);
    if (v<128)
      v+=20;
    else
      v-=20;
    C.setHsv(h,s,v);

    //Paint->setPen(C); // normale Linie
    x1=BL+(width()-BL-BR)*DispTag/Max;
    x2=BL+(width()-BL-BR)*(DispTag+1)/Max;
    Paint->fillRect(x1,BO,x2-x1,height()-BO-BU, C);
  }
  // waagerechte Linien
  for (Lauf=1; Lauf<GridDefaults.Grid; Lauf++) {
    y=BO+(height()-BO-BU)*Lauf/GridDefaults.Grid;
    if (Lauf==GridDefaults.Grid-GridDefaults.ZeroLine)
      Paint->setPen(QColor(0,0,0));     // Nulllinie
    else
      Paint->setPen(QColor(128,128,128)); // normale Linie
    Paint->drawLine(BL, y, width()-BR, y);
  }
   
   // senkrechte Linien
   for (Lauf=0; Lauf<Max; Lauf++) {
      x=BL+(width()-BL-BR)*Lauf/Max;
      y=height()-BU+5;
      if (Lauf<Max) {
         // Tag ausgeben
         xx = (int)(BL+(width()-BL-BR)*((0.5+1.0*Lauf)/Max));
         Paint->setPen(QColor(0,0,0));
         sprintf(Strg, "%d", Lauf+1);
         Paint->drawText(xx-10, y, 20,15, AlignCenter+DontClip, Strg);
      }
      if (Lauf==0) continue;      // Erste und letzte Linie
      if (Lauf==Max) continue;    // nicht ausgeben
      //if ((Lauf==DispTag) || (Lauf==DispTag+1) )
      //   Paint->setPen(QColor(255,255,255));
      //else
         Paint->setPen(QColor(128,128,128));
      Paint->drawLine(x, BO, x, height()-BU);
   }

   if (FileActive)
   for (Lauf=0; Lauf<MAXDATA; Lauf++)
   if (DF->DataArr[Lauf] != NULL)
   //if (!(DF->DataArr[Lauf]->Flags1 & FLG_NODISPLAY) )
   if (DF->IsVisible(Lauf))
   {
      Null= height()-BU-(h*GridDefaults.ZeroLine)/GridDefaults.Grid-1;
//      Paint->setPen(DF->DataArr[Lauf]->Farbe);
//      Paint->setPen(QPen(QColor(255,0,0),2));
      Paint->setPen(QPen(DF->DataArr[Lauf]->Farbe,2));
      FirstPoint=TRUE;
      x=0;   y=0;
      xa=0;  ya=0;
      AvgTime=0;
      Valid=0;
      ValidAlt=0;
      // mittlere Uhrzeit fr die (Mittelwert-)Anzeige
      if (DF->DataArr[Lauf]->CalcAvg) {
         AvgTime=0;
         for (Messung=0; Messung<DF->DataArr[Lauf]->Count; Messung++)
            AvgTime+=DF->DataArr[Lauf]->Times[Messung];
         AvgTime/=DF->DataArr[Lauf]->Count;
      }
      switch(DF->DataArr[Lauf]->Type) {
         case TYP_LINE :   
         case TYP_PRESSURE:
         case TYP_LEVEL :  {
                           float Zero,Scale;
                           if (DF->DataArr[Lauf]->Flags1 & FLG_OWNSCALING) {
                             // eigene Skalierungsdaten verwenden
                             Zero = DF->DataArr[Lauf]->Zero;
                             Scale = DF->DataArr[Lauf]->Scale;
			                     } else {
                             // Skalierung aus Griddefaults verwenden
                             switch (DF->DataArr[Lauf]->Type) {
                               case TYP_LINE :    Zero = GridDefaults.LineZero;
                                                  Scale = GridDefaults.LineGrids;
                                                  break;
         					             case TYP_PRESSURE: Zero = GridDefaults.PrsZero;
                                                  Scale = GridDefaults.PrsGrids;
                                                  break;
         											 case TYP_LEVEL :   Zero = GridDefaults.LevelZero;
                                                  Scale = GridDefaults.LevelGrids;
                                                  break;
                               default :          Zero = 0;
                                                  Scale = 5.0;
                             }
                           }
                           if (Scale==0) Scale=1.0;//sicherheitshalber........

                           for (Tag=0; Tag<MonTage(CurMon,CurJahr); Tag++) {
                              if (DF->DataArr[Lauf]->CalcAvg) 
                              {  // Mittelwert berechnen
                                 AvgValue=0;
                                 Valid=1;
                                 for (Messung=0; Messung<DF->DataArr[Lauf]->Count; Messung++) {
                                    if (DF->GetValid(DF->VDTA[Messung][Lauf][0],Tag)) {
                                       FD=(FloatDataType*)(DF->DPTR[Messung][Lauf]);
                                       AvgValue+=(*FD)[Tag];
                                    } else {
                                       Valid=0;
                                       break;
                                    }
                                 }
                                 AvgValue/=DF->DataArr[Lauf]->Count;
                                 
                                 x=CalcX(Tag, AvgTime);
                                 Help = AvgValue - Zero;
                                 Help = Help/Scale;
                                 Help = (h*Help)/GridDefaults.Grid;
                                 y = (int)(Null - Help);
                                 //if (!FirstPoint)
                                 //   Paint->drawLine(xa, ya, x, y);
                                 //FirstPoint=FALSE;
                                 if (Valid) {
                                    Paint->drawLine(x-1, y, x+1, y);
                                    if (ValidAlt) {
                                       Paint->drawLine(xa, ya, x, y);
                                    }
                                 }
                                 xa=x;   ya=y;
                                 ValidAlt=Valid;
                              } else {  // jeden Wert anzeigen
                                 for (Messung=0; Messung<DF->DataArr[Lauf]->Count; Messung++) {
                                    x=CalcX(Tag, DF->DataArr[Lauf]->Times[Messung]);
                                    FD=(FloatDataType*)(DF->DPTR[Messung][Lauf]);
                                    switch (DF->DataArr[Lauf]->Type) {
                                       case TYP_LINE : Help = (*FD)[Tag] - Zero;
                                                       Help = Help/Scale;
                                                       Help = (h*Help)/GridDefaults.Grid;
                                                       y = (int)(Null - Help);
//if (Tag==1)
//  debug("Zero=%0.3f  Scale=%0.3f",Zero,Scale);
                                                       break;
                                       case TYP_PRESSURE:
                                                       Help = ((*FD)[Tag]	)- Zero;
                                                       Help = Help/Scale;
                                                       Help = (h*Help)/GridDefaults.Grid;
                                                       y = (int)(Null - Help);
//if (Tag==1)
//  debug("Zero=%0.3f  Scale=%0.3f",Zero,Scale);
                                                       break;
                                       case TYP_LEVEL:
                                                       Help = (*FD)[Tag]- Zero;
                                                       Help = Help/Scale;
                                                       Help = (h*Help)/GridDefaults.Grid;
                                                       y = (int)(height()-BU-Help);
//if (Tag==1)
//  debug("Zero=%0.3f  Scale=%0.3f",Zero,Scale);
                                                       break;
                                    }
                                    Valid=DF->GetValid(DF->VDTA[Messung][Lauf][0],Tag);
                                    if (Valid) {
                                       Paint->drawLine(x-1, y, x+1, y);
                                       if (ValidAlt) {
                                          Paint->drawLine(xa, ya, x, y);
                                       }
                                    }
                                    FirstPoint=FALSE;
                                    xa=x;   ya=y;
                                    ValidAlt=Valid;
                                 }
                              }
                           }
                           break;
                           }
         case TYP_WEATHER: {
                           int T;
                             if (!NoIconUpdate) {
                               Messung=0;
                               //Bezeichnung ausgeben
                               Paint->setPen(QPen(QColor(0,0,0),2));
                               // Itembezeichnung ausgeben
                               if (BR<BL)
                                 Paint->drawText(1, IconYPos, 100,15, AlignLeft+DontClip, DF->DataArr[Lauf]->Name);
                               else
                                 Paint->drawText(width()-101, IconYPos, 100,15, AlignRight+DontClip, DF->DataArr[Lauf]->Name);

                               for (Messung=0; Messung< DF->DataArr[Lauf]->Count; Messung++) {
                                 for (Tag=0; Tag<MonTage(CurMon,CurJahr); Tag++) {
                                   Valid=DF->GetValid(DF->VDTA[Messung][Lauf][0],Tag);
                                   if (Valid) {
                                     SD=(ShortDataType*)(DF->DPTR[Messung][Lauf]);
                                     T=(*SD)[Tag];
                                     if ( (T>0) && (T<=255) ) {
                                       if (SmallWetterIcon[T] == NULL) {
                                         SmallWetterIcon[T] = new QPixmap(CalcSmallWetterImage(T));
                                       }
                                     }
                                     if (SmallWetterIcon[T])
                                     if (!SmallWetterIcon[T]->isNull()) {
                                       x=CalcX(Tag, DF->DataArr[Lauf]->Times[Messung]);
                                       Paint->eraseRect(x-8,IconYPos,8,16);
                                       Paint->drawPixmap(x-8,IconYPos,*(SmallWetterIcon[T]));
                                     }
                                   }
                                 }
                                 // Zeit ausgeben (auf der gegebberliegenden Seite von Item)
                                 {
                                 char Time[10];
                                   sprintf(Time,"%2d:%02d", DF->DataArr[Lauf]->Times[Messung]/60 , DF->DataArr[Lauf]->Times[Messung]%60);
                                   if (BR>=BL)
                                     Paint->drawText(1, IconYPos, 100,15, AlignLeft+DontClip,Time);
                                   else
                                     Paint->drawText(width()-101, IconYPos, 100,15, AlignRight+DontClip, Time);
                                 }
                                 IconYPos += 16;
                               }
                             }
                           }
                           break;
         case TYP_WIND :   {
                           long T;

                             if (!NoIconUpdate) {
                               Messung=0;
                               //Bezeichnung ausgeben
                               Paint->setPen(QPen(QColor(0,0,0),2));
                               if (BR<BL)
                                 Paint->drawText(1, IconYPos, 100,15, AlignLeft+DontClip, DF->DataArr[Lauf]->Name);
                               else
                                 Paint->drawText(width()-101, IconYPos, 100,15, AlignRight+DontClip, DF->DataArr[Lauf]->Name);

                               for (Messung=0; Messung< DF->DataArr[Lauf]->Count; Messung++) {
                                 for (Tag=0; Tag<MonTage(CurMon,CurJahr); Tag++) {
                                   Valid=DF->GetValid(DF->VDTA[Messung][Lauf][1],Tag);
                                   if (Valid) {
                                     LD=(LongDataType*)(DF->DPTR[Messung][Lauf]);
                                     T=(*LD)[Tag];
                                     T = T & 0x0000FFFF;  // Windrichtung in den unteren 16 Bit
                                     //T = (int)((0.1*T+22.5)/45.0);
                                     T = (int)((0.1*T+11.25)/22.5);
                                     T=16-T;
                                     if (T==16) T=0;
                                     if ( (T>=0) && (T<16) ) {
                                       x=CalcX(Tag, DF->DataArr[Lauf]->Times[Messung]);
                                       Paint->eraseRect(x-8,IconYPos,8,16);
                                       Paint->drawPixmap(x-8,IconYPos,WdIco[T]);
                                     } else
                                       debug(" T out of range Tag:%d Val=%ld",Tag,T);
                                   }
                                 }
                                 // Zeit ausgeben (auf der gegebberliegenden Seite von Item)
                                 {
                                 char Time[10];
                                   sprintf(Time,"%2d:%02d", DF->DataArr[Lauf]->Times[Messung]/60 , DF->DataArr[Lauf]->Times[Messung]%60);
                                   if (BR>=BL)
                                     Paint->drawText(1, IconYPos, 100,15, AlignLeft+DontClip,Time);
                                   else
                                     Paint->drawText(width()-101, IconYPos, 100,15, AlignRight+DontClip, Time);
                                 }
                                 IconYPos += 16;
                               }
                             }
                           }

                           break;
         case TYP_TEXT :
                           break;
         case TYP_DIV :
                           break;
      }
   }
   NoIconUpdate=FALSE;

   // Rahmen um das Grid
   Paint->setPen(QColor(0,0,0));
   Paint->drawRect(BL,BO, width()-BL-BR+1,height()-BO-BU+1);
   if (FileActive)

   {  // Statusbar aktualisieren
      TopLevel *t;
      
      t =(TopLevel*)tp;
      t->statusbar->changeItem(i18n(MonName[CurMon]), ST_MONAT);
      sprintf(Strg,"%d", CurJahr);
      t->statusbar->changeItem(Strg, ST_JAHR);
   }
}


int TChart::MTage(void) {
   return MonTage(CurMon, CurJahr);
}

void TChart::MoveFirst() {
   CurMon=DF->GetFirstMon();
   CurJahr=DF->GetFirstYear();
   fCurrent=0;
   LoadMon();
   update();
   SetButtons();
   UpdateTag(DispTag);
}

void TChart::MoveLast() {
   fCurrent = fMonate-1;
   LoadMon();
   update();
   SetButtons();
   UpdateTag(DispTag);
}

void TChart::MovePrev() {
   fCurrent--;
   if (fCurrent<0)
      fCurrent=0;
   LoadMon();
   update();
   SetButtons();
   UpdateTag(DispTag);
}

void TChart::MoveNext() {
   fCurrent++;
   if (fCurrent>=fMonate)
      fCurrent=fMonate-1;
   LoadMon();
   update();
   SetButtons();
   UpdateTag(DispTag);
}

void TChart::MovePrevF() {
   fCurrent-=12;
   if (fCurrent<0)
      fCurrent=0;
   LoadMon();
   update();
   SetButtons();
   UpdateTag(DispTag);
}

void TChart::MoveNextF() {
//debug("MoveNextF");
   fCurrent+=12;
   if (fCurrent>=fMonate)
      fCurrent=fMonate-1;
   LoadMon();
   update();
   SetButtons();
   UpdateTag(DispTag);
}

void TChart::EditNew() {

  if (!FileActive) return;  //tsch

  // letzten Monat lesen, um das Datum zu bhstimmen
  fCurrent=fMonate-1;
  DF->Seek(fCurrent);
  DF->Read();
  CurMon=DF->GetCurrentMon();
  CurJahr=DF->GetCurrentYear();
  fCurrent=fMonate;  // erster freier Eintrag
  CurMon++;
  if (CurMon>=12) {
    CurMon=0;
    CurJahr++;
  }
  DF->Clear();   // Datensatz initialisieren
  FirstDay();    // ersten Tag whlen
  update();
  UpdateTag(DispTag);

  if (edlg==NULL)// {
    //debug("edlg-create");
    edlg = new EditDlg(DF, this);
  //}
  if (edlg->exec()) {  // ok, speichern
    fMonate++;   // einen Monat mehr
    DF->Seek(fCurrent);
    DF->Write();
  } else {  // Abbruch, verwerfen
    fCurrent=fMonate-1; // letzen Monat whlen
    DF->Seek(fCurrent);
    DF->Read();
  }
  delete edlg;
  edlg=NULL;
  update();
  UpdateTag(DispTag);
  SetButtons();
}

void TChart::EditModify() {
   debug("EditModify");

   if (edlg==NULL)// {
      //debug("edlg-create");
      edlg = new EditDlg(DF, this);
   //}
   if (edlg->exec()) {  // ok, speichern
      DF->Seek(fCurrent);
      DF->Write();
   } else {  // Abbruch, verwerfen
      DF->Seek(fCurrent);
      DF->Read();
   }
   delete edlg;
   edlg=NULL;
   update();
   UpdateTag(DispTag);
}

void TChart::mousePressEvent( QMouseEvent * mev) {
int x;
int mt= MonTage(CurMon, CurJahr);  // Tage+1,da 24Std Anzeige
int w = width()-BL-BR;  // Breite des Gitters
int Tag;

   x=mev->x();
   if ((x<BL) || (x>width()-BR)) return;  // auerhalb
   //Tag = (int)((x-BL+(0.5*w/mt))*mt/w);
   Tag = (int)((x-BL)*mt/w);
   if (Tag>=mt)
      Tag=mt-1;
   UpdateSelection(DispTag);
   UpdateTag(Tag);
   UpdateSelection(DispTag);
}

void TChart::UpdateTag(int Neu) {
int UpdX,UpdXA;

   if (!FileActive) return;
   
   UpdXA=CalcX(DispTag,0)-1;  // Position alte Linie

   DispTag=Neu;
   
   //Paint->begin(this);
   //ShowDetails();
   //Paint->end();
   
   UpdX=CalcX(DispTag,0)-1;
   update(UpdXA,BO,3,height()-BO-BU);  // alte Linie lschen
   update(UpdX,BO,3,height()-BO-BU);   // neue Linie zeichnen
   
   ddlg->Aktualisieren(DispTag);

   debug("click!  %d\n",DispTag);
}

void TChart::ShowDetails(void) {
//char* Richtungen[9] = {"","N","NW","W","SW","S","SO","O","NO"};
//char Strg[10];
//int ws,wr;

   if (DispTag<0) return;
   if (DispTag>MonTage(CurMon,CurJahr)-1) return;
   //debug("ShowDetails  %d\n",DispTag);

/*   if ( (monat.Werte[DispTag].W>=0) && (monat.Werte[DispTag].W<256) ) {
      if (WetterIcon[monat.Werte[DispTag].W].isNull())
         WetterIcon[monat.Werte[DispTag].W] = CalcWetterImage(monat.Werte[DispTag].W);
   
      if (!WetterIcon[monat.Werte[DispTag].W].isNull()) {
         Paint->eraseRect(200,0,100,45); // -17, Wettericons nicht lschen
         Paint->eraseRect(380,0,100,45);
         Paint->drawPixmap(250,2,WetterIcon[monat.Werte[DispTag].W]);
      }
   }

   Paint->setFont(QFont("Helvetica",10));
   Paint->setPen(QPen(QColor(255,0,0),2));
   sprintf(Strg,"%0.1f", 0.1*monat.Werte[DispTag].M);
   Paint->drawText(200, 12, Strg);
   sprintf(Strg,"%0.1f", 0.1*monat.Werte[DispTag].A);
   Paint->setPen(QPen(QColor(0,0,255),2));
   Paint->drawText(200, 24, Strg);
   sprintf(Strg,"%d", monat.Werte[DispTag].L);
   Paint->setPen(QPen(QColor(0,128,0),2));
   Paint->drawText(200, 36, Strg);
   sprintf(Strg,"%d", monat.Werte[DispTag].P);
   Paint->setPen(QPen(QColor(0,160,160),2));
   Paint->drawText(380, 12, Strg);
   // Wind
   wr = (monat.Werte[DispTag].WD & 0x00FF) >> 2;
   ws = monat.Werte[DispTag].WD >> 8;
   if (wr) {
      Paint->setPen(QPen(QColor(0,0,0),2));
      sprintf(Strg,"%s  %d",Richtungen[wr], ws);
      Paint->drawText(380, 24, Strg);
   }
*/
}

void TChart::SetButtons(void) {
TopLevel* tl;

   tl =(TopLevel*)tp;
   tl->SetButtons();
}

void TChart::UpdateSelection(int Tach) {
// Selektion (akt. Tag) ndern
int x1,x2,Max;

  Max = MonTage(CurMon, CurJahr);
  x1=BL+(width()-BL-BR)*Tach/Max;
  x2=BL+(width()-BL-BR)*(Tach+1)/Max;
  update(x1,BO,x2-x1,height()-BO-BU);
}

void TChart::PrevDay(void) {
   if (DispTag>0) {
      NoIconUpdate=TRUE;
      UpdateSelection(DispTag);
      UpdateTag(DispTag-1);
      UpdateSelection(DispTag);
   }
}

void TChart::NextDay(void) {
   if (DispTag<MonTage(CurMon,CurJahr)-1) {
      NoIconUpdate=TRUE;

      UpdateSelection(DispTag);
      UpdateTag(DispTag+1);
      UpdateSelection(DispTag);
   }
}

void TChart::FirstDay(void) {
// Ersten Tag in der Detailansicht whlen
  NoIconUpdate=TRUE;
  UpdateSelection(DispTag);
  UpdateTag(0);
  UpdateSelection(DispTag);
}

void TChart::LastDay(void) {
// Letzten Tag whlen

  NoIconUpdate=TRUE;

  UpdateSelection(DispTag);
  UpdateTag(MonTage(CurMon,CurJahr)-1);
  UpdateSelection(DispTag);
}

void TChart::Clear(void) {
//int i;

/*   for (i=0; i<31; i++) {    // Initialisierung
      monat.Werte[i].M=0;
      monat.Werte[i].A=0;
      monat.Werte[i].L=1000;
      monat.Werte[i].W=0;
      monat.Werte[i].P=0;
      monat.Werte[i].WD=0;  // Windrichtung 'West'
      monat.Werte[i].X3=0;
      monat.Werte[i].X4=0;
   }
*/
}

void TChart::GridSettings() {
GridDlg gsdlg(this);
/*GridSettingsDlg gsdlg;
long int B;
int i;*/

  if (gsdlg.exec()) {
    SaveConfig();
    debug("OK");
  }

  /*B=0x80000001;

  DF->SetValid(&B,2,TRUE);
  DF->SetValid(&B,0,FALSE);
  DF->SetValid(&B,31,FALSE);
  for (i=31;i>=0;i--)
    printf("%d",DF->GetValid(B,i)!=0);
  printf("\n");*/
}

void TChart::LoadConfig() {
// Konfiguration einlesen

  Config->setGroup("GridSettings");
  GridDefaults.Grid = Config->readNumEntry("Grid", 12);
  GridDefaults.ZeroLine = Config->readNumEntry("ZeroLine", 5);

  strcpy(GridDefaults.LineUnits, Config->readEntry("LineUnits", "K"));
  GridDefaults.LineGrids = Config->readDoubleNumEntry("LineGrid", 5);
  GridDefaults.LineZero = Config->readDoubleNumEntry("LineZero", 0);
  GridDefaults.LineDspLeft = Config->readNumEntry("LineDspLeft", 1);
  GridDefaults.LineDspRight = Config->readNumEntry("LineDspRight", 0);

  strcpy(GridDefaults.PrsUnits, Config->readEntry("PrsUnits", "mB"));
  GridDefaults.PrsGrids = Config->readDoubleNumEntry("PrsGrid", 10);
  GridDefaults.PrsZero = Config->readDoubleNumEntry("PrsZero", 1000);
  GridDefaults.PrsDspLeft = Config->readNumEntry("PrsDspLeft", 0);
  GridDefaults.PrsDspRight = Config->readNumEntry("PrsDspRight", 1);

  strcpy(GridDefaults.LevelUnits, Config->readEntry("LevelUnits", "cm"));
  GridDefaults.LevelGrids = Config->readDoubleNumEntry("LevelGrid", 10);
  GridDefaults.LevelZero = Config->readDoubleNumEntry("LevelZero", 0);
  GridDefaults.LevelDspLeft = Config->readNumEntry("LevelDspLeft", 0);
  GridDefaults.LevelDspRight = Config->readNumEntry("LevelDspRight", 1);

  strcpy(GridDefaults.WindDirUnits, Config->readEntry("WindDirUnits", ""));
  strcpy(GridDefaults.WindStrengthUnits, Config->readEntry("WindStrengthUnits", "Bft"));
}

void TChart::SaveConfig() {
// Konfiguration speichern

  Config->setGroup("GridSettings");
  Config->writeEntry("Grid",GridDefaults.Grid);
  Config->writeEntry("ZeroLine",GridDefaults.ZeroLine);

  Config->writeEntry("LineUnits",GridDefaults.LineUnits);
  Config->writeEntry("LineGrid",GridDefaults.LineGrids);
  Config->writeEntry("LineZero",GridDefaults.LineZero);
  Config->writeEntry("LineDspLeft",GridDefaults.LineDspLeft);
  Config->writeEntry("LineDspRight",GridDefaults.LineDspRight);

  Config->writeEntry("PrsUnits",GridDefaults.PrsUnits);
  Config->writeEntry("PrsGrid",GridDefaults.PrsGrids);
  Config->writeEntry("PrsZero",GridDefaults.PrsZero);
  Config->writeEntry("PrsDspLeft",GridDefaults.PrsDspLeft);
  Config->writeEntry("PrsDspRight",GridDefaults.PrsDspRight);

  Config->writeEntry("LevelUnits",GridDefaults.LevelUnits);
  Config->writeEntry("LevelGrid",GridDefaults.LevelGrids);
  Config->writeEntry("LevelZero",GridDefaults.LevelZero);
  Config->writeEntry("LevelDspLeft",GridDefaults.LevelDspLeft);
  Config->writeEntry("LevelDspRight",GridDefaults.LevelDspRight);

  Config->writeEntry("WindDirUnits",GridDefaults.WindDirUnits);
  Config->writeEntry("WindStrengthUnits",GridDefaults.WindStrengthUnits);
//  Config->sync();
debug("Cfg.sync %d %0.2f",GridDefaults.Grid,GridDefaults.LineGrids);
}
