/***************************************************************************
                          dlgdata.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
    kweather - a program for recording weather events
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    
#include <iostream.h>
#include <qpainter.h>
#include <qimage.h>
#include <kwr.h>
#include "dlgdata.h"
#include "chart.h"
#include "dlgedit.h"
#include "globals.h"

#define D_FIRST 1
#define D_LEFT  2
#define D_RIGHT 3
#define D_LAST  4

// Wei
#define COL1FORE  QColor(0,0,0)
#define COL1BACK  QColor(0xE0,0xE0,0xE0)
#define COL1LIGHT QColor(0xFF,0xFF,0xFF)
#define COL1MED   QColor(0xE0,0xE0,0xE0)
#define COL1DARK  QColor(0xA0,0xA0,0xA0)
#define COL1TEXT  QColor(0,0,0)
#define COL1BASE  QColor(0xE0,0xE0,0xE0)
// Blau
#define COL2FORE  QColor(0x00,0x00,0x00)
#define COL2BACK  QColor(0x80,0x80,0xFF)
#define COL2LIGHT QColor(0xA0,0xA0,0xFF)
#define COL2MED   QColor(0x80,0x80,0xFF)
#define COL2DARK  QColor(0x50,0x50,0xE0)
#define COL2TEXT  QColor(0x00,0x00,0x00)
#define COL2BASE  QColor(0xA0,0xA0,0xFF)

#define ITEMWIDTH  50
#define ITEMHEIGHT 85
#define FRAMEHEIGHT1 16
#define FRAMEHEIGHT2 12

// Indexpositionen in 'Handles' fr die einzelen Labels
#define DATALAB 0
#define UNITLAB 1
#define COLORLAB 2
#define HIDEFRM 3

typedef QWidget* WidPtr;
WidPtr Handles[MAXCOUNT][MAXDATA][4];
DataDlg* ddlg;
int CurTag;
extern QPixmap CalcWetterImage(int Code);
extern EditDlg *edlg;   // Verweis auf den Editdialog
extern char* MonName[12];
extern PixPtr WetterIcon[256];

// Globale Mausposition
int MPosX,MPosY;

MyLabel::MyLabel ( const char * text, QWidget * parent=0, const char * name=0, WFlags f=0 ):
  QLabel(text,parent,name,f)
{  }

void MyLabel::mousePressEvent ( QMouseEvent * m) {
debug("Label-Click");

  MPosX = m->globalX();
  MPosY = m->globalY();
  emit clicked();
}


void MyFrame::mousePressEvent ( QMouseEvent * m) {
debug("Click");

  MPosX = m->globalX();
  MPosY = m->globalY();
  emit clicked();
}
MyFrame::MyFrame(QWidget* parent=0, const char* name=0, WFlags f=0, bool allowLines=TRUE):
     QFrame (parent, name, f, allowLines)
{
  Caption=NULL;
}

void MyFrame::setText(char* NewText) {
  if (!Caption) {
    Caption= new MyLabel(NewText, this, "Caption");
    Caption->setGeometry(1,2,width()-2,height()-3);
    connect(Caption, SIGNAL(clicked()), this, SLOT(LabelClicked()));
  } else
    Caption->setText(NewText);
}

void MyFrame::LabelClicked() {
  //MPosX = Caption->MPosX;
  //MPosY = Caption->MPosY;
  emit clicked();
}

DataItem::DataItem(DataFile* DFile, int Nummer, int ILfdNr, void* vDLG, QWidget* parent=0, const char* name, WFlags f, bool allowLines):
     QFrame (parent, name, f, allowLines)
{
DataDlg* DLG;

   debug("DataItem::DataItem");
   DLG = (DataDlg*)vDLG;
   Pal = new QPalette();
   setPalettePropagation(AllChildren);
   DF=DFile;
   Nr=Nummer;
   LfdNr=ILfdNr;
   ItemCount=0;
   Minimized=FALSE;

   if (DF->DataArr[Nr]!=NULL) {
      HeaderFrame = new MyFrame(this, DF->DataArr[Nr]->Name);
      HeaderFrame->setFrameStyle( QFrame::Panel | QFrame::Raised );
      HeaderFrame->setLineWidth(1);
      HeaderFrame->setGeometry(0,0,200,FRAMEHEIGHT1);
      HeaderFrame->setPalettePropagation(AllChildren);
      HeaderFrame->setPalette(*Pal);
      
      NameLab = new MyLabel(DF->DataArr[Nr]->Name, HeaderFrame, "NameLab");
      NameLab->setGeometry(1+FRAMEHEIGHT1,1,80,FRAMEHEIGHT1-2);
      NameLab->setFont( QFont("Helvetica", 10, QFont::Bold));
      NameLab->setPalette(*Pal);

      MinimizeBtn = new QPushButton("-", HeaderFrame, "MinimizeBtn");
      MinimizeBtn->setGeometry(1,1,FRAMEHEIGHT1-2,FRAMEHEIGHT1-2);
      DLG->MinimizeMapper->setMapping(MinimizeBtn, LfdNr);
      connect(MinimizeBtn, SIGNAL(clicked()), DLG->MinimizeMapper, SLOT(map()));

      DescLab = new MyLabel(DF->DataArr[Nr]->Description, HeaderFrame, "DescLab");
      DescLab->setGeometry(80+FRAMEHEIGHT1,1,100,FRAMEHEIGHT1-2);
      DescLab->setFont( QFont("Helvetica", 10));
      DescLab->setPalette(*Pal);

      DLG->MenueMapper->setMapping(HeaderFrame, Nr);
      connect(HeaderFrame, SIGNAL(clicked()), DLG->MenueMapper, SLOT(map()));
      DLG->MenueMapper->setMapping(NameLab, Nr);
      connect(NameLab, SIGNAL(clicked()), DLG->MenueMapper, SLOT(map()));
      DLG->MenueMapper->setMapping(DescLab, Nr);
      connect(DescLab, SIGNAL(clicked()), DLG->MenueMapper, SLOT(map()));
   } else
      debug("DataItem::DataItem: Invalid Datanumber %d",Nr);
}

void DataItem::SetColor (int ColNr) {
QColorGroup CG1(COL1FORE, COL1BACK,   COL1LIGHT, COL1DARK, COL1MED, COL1TEXT, COL1BASE);
QColorGroup CG2(COL2FORE, COL2BACK,   COL2LIGHT, COL2DARK, COL2MED, COL2TEXT, COL2BASE);

   debug("DataItem::SetColor");
   if (ColNr==1)
      Pal->setNormal(CG1);
   else
      Pal->setNormal(CG2);
   setPalette(*Pal);
   
//   QFrame::setBackgroundColor(Col);
//   NameLab->setBackgroundColor(Col);
//   DescLab->setBackgroundColor(Col);
}

void DataItem::resizeEvent ( QResizeEvent * rev) {
//   QFrame::resizeEvent(rev);
   HeaderFrame->resize(width(), FRAMEHEIGHT1);
}

int DataItem::AddItem(void* DLG, int Nr) {
// Ein neues Item zu der Liste hinzufgen
// Rckgabe ist die Breite der GESAMTEN Itemliste
int Lauf;
char TimeStrg[10];
ShortDataType *SD;
FloatDataType *FD;
LongDataType *LD;
int Valid1,Valid2;
DataDlg* D;

   debug("Dataitem::AddItem");
   
   if (DF->DataArr[Nr]==NULL) {
      debug("DataItem::AddItem NULL-Pointer");
      return 0;
   }

   D = (DataDlg*)DLG;

   // Titel des Dataitems setzen
   MyFrame *Frame = new MyFrame(this);
   Frame->setFrameStyle( QFrame::Panel | QFrame::Raised );
   Frame->setLineWidth(1);
   Frame->setGeometry(ItemCount*ITEMWIDTH,FRAMEHEIGHT1, DF->DataArr[Nr]->Count*ITEMWIDTH,FRAMEHEIGHT2);
   Frame->setPalettePropagation(AllChildren);
   Frame->setPalette(*Pal);

   D->DisplayMapper->setMapping(Frame, Nr);
   connect(Frame, SIGNAL(clicked()), D->DisplayMapper, SLOT(map()));


   MyLabel* Caption = new MyLabel(DF->DataArr[Nr]->Name, Frame);
   Caption->setGeometry(1+FRAMEHEIGHT2,1, DF->DataArr[Nr]->Count*ITEMWIDTH-2-FRAMEHEIGHT2,FRAMEHEIGHT2-2);
   Caption->setFont( QFont("Helvetica", 8));
   Caption->setPalette(*Pal);
   D->DisplayMapper->setMapping(Caption, Nr);
   connect(Caption, SIGNAL(clicked()), D->DisplayMapper, SLOT(map()));

   MyFrame* BtnFrm = new MyFrame(Frame);
   BtnFrm->setGeometry(1,1, FRAMEHEIGHT2-2,FRAMEHEIGHT2-2);
   if (DF->IsVisible(Nr)) {
     BtnFrm->setFrameStyle( QFrame::Panel | QFrame::Raised );
     BtnFrm->setText("");
   } else {
     BtnFrm->setFrameStyle( QFrame::Panel | QFrame::Sunken );
     BtnFrm->setText("x");
   }
   Handles[0][Nr][HIDEFRM] = BtnFrm;
   D->DisplayMapper->setMapping(BtnFrm, Nr);
   connect(BtnFrm, SIGNAL(clicked()), D->DisplayMapper, SLOT(map()));

   for (Lauf=0; Lauf<DF->DataArr[Nr]->Count; Lauf++) {
      // Uhrzeit setzen, evtl mehrmals
      QFrame *TimeFrame = new QFrame(this);
      TimeFrame->setFrameStyle( QFrame::Panel | QFrame::Raised );
      TimeFrame->setLineWidth(1);
      TimeFrame->setGeometry((ItemCount+Lauf)*ITEMWIDTH,FRAMEHEIGHT1+FRAMEHEIGHT2, 
                              ITEMWIDTH,FRAMEHEIGHT2);
      TimeFrame->setPalettePropagation(AllChildren);
      TimeFrame->setPalette(*Pal);

      sprintf(TimeStrg,"%02d:%02d",DF->DataArr[Nr]->Times[Lauf]/60,DF->DataArr[Nr]->Times[Lauf]%60);
      QLabel* TimeLab = new QLabel(TimeStrg, TimeFrame);
      TimeLab->setGeometry(1,1, ITEMWIDTH-2,FRAMEHEIGHT2-2);
      TimeLab->setFont( QFont("Helvetica", 8));
      TimeLab->setPalette(*Pal);

      QFrame *Frm = new QFrame(this);
      Frm->setFrameStyle( QFrame::Panel | QFrame::Raised );
      Frm->setLineWidth(1);
      Frm->setGeometry((ItemCount+Lauf)*ITEMWIDTH,
                        FRAMEHEIGHT1+2*FRAMEHEIGHT2, 
                        ITEMWIDTH,
                        ITEMHEIGHT-FRAMEHEIGHT1-2*FRAMEHEIGHT2);
      Frm->setPalettePropagation(AllChildren);
      Frm->setPalette(*Pal);

      // Label mit dem Wert
      
      Valid1 = DF->GetValid(DF->VDTA[Lauf][Nr][0],CurTag);
      Valid2 = DF->GetValid(DF->VDTA[Lauf][Nr][1],CurTag);
      switch (DF->DataArr[Nr]->Type) {
         case TYP_LINE :
         case TYP_PRESSURE :
         case TYP_LEVEL :    {
                             char S[10];

                                //if (DF->GetValid(DF->VDTA[Lauf][Nr][0],CurTag)) {
                                if (Valid1) {
                                   FD=(FloatDataType*)(DF->DPTR[Lauf][Nr]);
                                   //if (DF->DataArr[Nr]->Type==TYP_LEVEL)
                                   //   sprintf(S,"%d", (*SD)[CurTag]);
                                   //else
                                      sprintf(S,"%0.1f", ((*FD)[CurTag]));
                                } else
                                   sprintf(S,"-");
                                QLabel *ValLab = new QLabel("ValLab", Frm);
                                ValLab->setGeometry(1,2,ITEMWIDTH-2, FRAMEHEIGHT1-2);
                                ValLab->setPalette(*Pal);
                                ValLab->setFont( QFont("Helvetica", 12, QFont::Bold));
                                ValLab->setText(S);
                                ValLab->setAlignment(AlignHCenter);
                                
                                QLabel *UnitLab = new QLabel("UnitLab", Frm);
                                UnitLab->setGeometry(1, 18 ,ITEMWIDTH-2, FRAMEHEIGHT1-2);
                                UnitLab->setPalette(*Pal);
                                UnitLab->setText(DF->DataArr[Nr]->Einheit);
                                UnitLab->setAlignment(AlignHCenter);

                                QWidget *ColorFrm = new QWidget(Frm);
                                ColorFrm->setGeometry(1,Frm->height()-10, Frm->width()-2,9);
                                ColorFrm->setBackgroundColor(QRgb(DF->DataArr[Nr]->Farbe));

                                Handles[Lauf][Nr][DATALAB] = ValLab;
                                Handles[Lauf][Nr][UNITLAB] = UnitLab;
                                Handles[Lauf][Nr][COLORLAB] = ColorFrm;
                             }
                             break;
         case TYP_WEATHER :  {
                             int T=0;
                                debug("display - Wetter");
                                if (Valid1) {
                                  SD=(ShortDataType*)(DF->DPTR[Lauf][Nr]);
                                  T=(*SD)[CurTag];
                                  if (WetterIcon[T] == NULL) {
                                    WetterIcon[T] = new QPixmap(CalcWetterImage(T));
                                  }
                                }
                                QLabel *ValLab = new QLabel("ValLab", Frm);
                                ValLab->setGeometry(1,5,ITEMWIDTH-2,33);
                                if (Valid1)
                                  ValLab->setPixmap(*(WetterIcon[T]));
                                else
                                  ValLab->setText("");
                                ValLab->setAlignment(AlignHCenter);

                                Handles[Lauf][Nr][DATALAB] = ValLab;
                                Handles[Lauf][Nr][UNITLAB] = 0;
                             }
                             break;
         case TYP_WIND :     {
                             KWindRose *KW;
                             char S[32];
                             int W,WS,WR;
                             debug("display - Wind");

                                LD=(LongDataType*)(DF->DPTR[Lauf][Nr]);
                                W=(*LD)[CurTag];
                                WR=W & 0x0000FFFF;
                                WS=(W>>16) & 0x0000FFFF;
                                KW = new KWindRose(Frm);
                                KW->setFrameStyle(QFrame::NoFrame);
                                KW->setGeometry(1,1,ITEMWIDTH-2, ITEMHEIGHT-FRAMEHEIGHT1-3*FRAMEHEIGHT2-2);
                                KW->setPalette(*Pal);
                                KW->setArrowType(KWindRose::ARROW2);
                                KW->setColor(1,qRgb(160,160,255));
                                KW->setEditable(FALSE);
                                KW->setColor(2,qRgb(224,224,224));
                                KW->setDetails(1);

                                if (Valid2) {
                                  if ( (WR>65000) || (WR<0) ) {
                                    KW->setDirection(0);
                                    KW->setValid(KWR_NODIR);
                                  } else {
                                    KW->setDirection(0.1*WR);
                                    KW->setValid(KWR_VALID);
                                  }
                                } else {
                                  KW->setDirection(0);
                                  KW->setValid(KWR_INVALID);
                                }

                                QLabel *UnitLab = new QLabel("UnitLab", Frm);
                                UnitLab->setGeometry(1,Frm->height()-FRAMEHEIGHT2,ITEMWIDTH-2, FRAMEHEIGHT1-5);
                                UnitLab->setPalette(*Pal);
                                UnitLab->setFont( QFont("Helvetica", 8));
                                UnitLab->setAlignment(AlignHCenter);
                                if (Valid1)
                                  sprintf(S, "%d %s",WS,DF->DataArr[Nr]->Einheit2);
                                else
                                  strcpy(S,"-");
                                UnitLab->setText(S);

                                Handles[Lauf][Nr][DATALAB] = KW;
                                Handles[Lauf][Nr][UNITLAB] = UnitLab;
                             }
                             break;
         case TYP_TEXT :     break;
      }
   }

   ItemCount+=DF->DataArr[Nr]->Count;
//   Hdl = Lab->handle();
   return ItemCount*ITEMWIDTH;
}

void DataItem::UpdateData(int Tag) {
   debug("DataItem::UpdateDate, Tag=%d",Tag);
}


DataDlg::DataDlg(DataFile* DFile, TChart *TC, const char* name=0):
     KTMainWindow (name)
{
int Lauf;
int PosX;
char Caption[40];

  Chart=TC;
  setCaption(i18n("Testdlg"));
  SetupToolBar();
  OffsetY = ToolBar->height();
  MaxX=0;
  PosX=0;

  MinimizeMapper = new QSignalMapper(this,"MinimizeMapper");
  connect(MinimizeMapper, SIGNAL(mapped(int)), this, SLOT(MinimizeBtnPressed(int)));
  DisplayMapper = new QSignalMapper(this,"DisplayMapper");
  connect(DisplayMapper, SIGNAL(mapped(int)), this, SLOT(DisplayBtnPressed(int)));
  MenueMapper = new QSignalMapper(this,"MenueMapper");
  connect(MenueMapper, SIGNAL(mapped(int)), this, SLOT(MenueBtnPressed(int)));

  ScrollView = new QScrollView(this, "ScrollView");
  //ScrollView->setVScrollBarMode(QScrollView::AlwaysOn);
  ScrollView->setGeometry(0,OffsetY,width(),height()-OffsetY);
  ScrollView->resizeContents(1000,750);


  DF=DFile;
  DataCount=0;
  for (Lauf=0; Lauf<MAXDATA; Lauf++)
     DI[Lauf]=NULL;
  memset(Handles, 0, sizeof(Handles));

  DataCount=0;
  CurTag=0;
  if (DF) {
    sprintf(Caption,"%d. %s %d",CurTag+1,i18n(MonName[DF->GetCurrentMon()]), DF->GetCurrentYear());
    setCaption(Caption);
    for (Lauf=0; Lauf<MAXDATA; Lauf++) {
      if (DF->DataArr[Lauf]) {
        if (DF->DataArr[Lauf]->Type==TYP_GROUP) {
          DI[DataCount] = new DataItem(DF,Lauf,DataCount,this,ScrollView->viewport(),DF->DataArr[Lauf]->Name);
          DI[DataCount]->setGeometry(0,ITEMHEIGHT*DataCount, width(), ITEMHEIGHT);
          ScrollView->addChild(DI[DataCount],0,ITEMHEIGHT*DataCount);
          if (DataCount%2)
            DI[DataCount]->SetColor(0);
          else
            DI[DataCount]->SetColor(1);
          DataCount++;
        } else {  // Items der Group einfgen
           PosX=DI[DataCount-1]->AddItem(this, Lauf);
           if (PosX>MaxX)
             MaxX=PosX;
        }
      }
    }
  }
  ScrollView->resizeContents(MaxX,ITEMHEIGHT*DataCount);
//   ScrollView->resizeContents(1000,750);

  Popup = new QPopupMenu(NULL,"Popup");
  Popup->insertItem(i18n("Hide all items"), this, SLOT(MenuHideAll()));
  Popup->insertItem(i18n("Show all items"), this, SLOT(MenuShowAll()));
  Popup->insertItem(i18n("Show all items except Weather/Wind"), this, SLOT(MenuShowAllExcept()));
  Popup->insertSeparator();
  Popup->insertItem(i18n("Load this settings"), this, SLOT(MenuLoadDisplayBits()));
  Popup->insertItem(i18n("Save this settings"), this, SLOT(MenuSaveDisplayBits()));

  if (DataCount>5)
    setGeometry(600,0,PosX+ScrollView->verticalScrollBar()->width(), 5*ITEMHEIGHT+OffsetY);
  else
    setGeometry(600,0,PosX, ITEMHEIGHT*DataCount+OffsetY);
  debug("SizeY = %d",ITEMHEIGHT*DataCount+ITEMHEIGHT+OffsetY);
  debug("DC,  Off = %d  %d",DataCount,OffsetY);
  setMinimumSize(100,100);
}

DataDlg::~DataDlg(void) {

   /*for (Lauf=0; Lauf<256; Lauf++)
   if (WetterIcon[Lauf] != NULL) {
      delete WetterIcon[Lauf];
      WetterIcon[Lauf]=NULL;
   }*/
      
   debug("DataDlg::~DataDlg");
   ddlg=NULL;
}

void DataDlg::HideDlg() {
   hide();
}

void DataDlg::resizeEvent ( QResizeEvent * e) {
//int Lauf;
//int PosY;

  //debug("DataDlg::ResizeEvent");
  if (e) {
    KTMainWindow::resizeEvent(e);
    //ScrollView->setGeometry(0,OffsetY,width(),height());
    ScrollView->resize(width(),height()-OffsetY);
    //ScrollView->resizeContents(width(),height());
    ScrollView->updateScrollBars();
  }
/*
  OffsetY = ToolBar->height();
  PosY = OffsetY;

  for (Lauf=0; Lauf<DataCount; Lauf++) {
    if (DI[Lauf]->Minimized) {
      DI[Lauf]->setGeometry(0, PosY, ScrollView->width()-ScrollView->verticalScrollBar()->width(),FRAMEHEIGHT1);
      PosY += FRAMEHEIGHT1;
    } else {
      DI[Lauf]->setGeometry(0, PosY, ScrollView->width()-ScrollView->verticalScrollBar()->width(),ITEMHEIGHT);
      PosY += ITEMHEIGHT;
    }
     //DI[Lauf]->setGeometry(0, OffsetY+Lauf*ITEMHEIGHT, width(),ITEMHEIGHT);
  }*/
}

void DataDlg::SetupToolBar()
{
  KIconLoader iconLoader;
  ToolBar = new KToolBar(this);

  addToolBar(ToolBar);

#define I(f,i,o,s,h) ToolBar->insertButton( iconLoader.loadIcon(f),\
	 i, SIGNAL(clicked()), o, SLOT(s()), TRUE, h);

  I("kt_hide.xpm",  0,       this, HideDlg, i18n("Hide Window"));
  ToolBar->insertSeparator();
  I("kt_edit.xpm",  0,       this, EditModify, i18n("Edit Month"));
  ToolBar->insertSeparator();
  I("pfeil_lf.xpm", D_FIRST, this, MoveFirst, i18n("First"));
  I("pfeil_l.xpm",  D_LEFT , this, MovePrev,  i18n("Prev"));
  I("pfeil_r.xpm",  D_RIGHT, this, MoveNext,  i18n("Next"));
  I("pfeil_rf.xpm", D_LAST , this, MoveLast,  i18n("Last"));

#undef I
}

void DataDlg::Aktualisieren(int Tag) {
// Daten fr den Tag "Tag" anzeigen
int Nr,Lauf;
QLabel *ValLab, *UnitLab;
ShortDataType* SD;
FloatDataType* FD;
LongDataType* LD;
int Valid1,Valid2;
char Caption[40];

  debug("DataDlg.Aktualisieren Tag = %d",Tag);

  if (DF) {
    sprintf(Caption,"%d. %s %d",Tag+1,i18n(MonName[DF->GetCurrentMon()]), DF->GetCurrentYear());
    setCaption(Caption);

    for (Nr=0; Nr<MAXDATA; Nr++) {
      if (DF->DataArr[Nr])
      for (Lauf=0; Lauf<DF->DataArr[Nr]->Count; Lauf++) {

        Valid1 = DF->GetValid(DF->VDTA[Lauf][Nr][0],Tag);
        Valid2 = DF->GetValid(DF->VDTA[Lauf][Nr][1],Tag);
        switch (DF->DataArr[Nr]->Type) {
           case TYP_LINE :
           case TYP_PRESSURE :
           case TYP_LEVEL :    {
                               char S[10];

                                  ValLab = (QLabel*)Handles[Lauf][Nr][DATALAB];
                                  UnitLab = (QLabel*)Handles[Lauf][Nr][UNITLAB];

                                  //if (DF->GetValid(DF->VDTA[Lauf][Nr][0],Tag)) {
                                  if (Valid1) {
                                     FD=(FloatDataType*)(DF->DPTR[Lauf][Nr]);
                                     //if (DF->DataArr[Nr]->Type==TYP_LEVEL)
                                     //   sprintf(S,"%d", (*SD)[Tag]);
                                     //else
                                        sprintf(S,"%0.1f", ((*FD)[Tag]));
                                  } else
                                     sprintf(S,"-");
                                  ValLab->setText(S);
                                  debug("%s",S);

                                  UnitLab->setText(DF->DataArr[Nr]->Einheit);

                               }
                               break;
           case TYP_WEATHER :  {
                                  ValLab = (QLabel*)Handles[Lauf][Nr][DATALAB];
                                  if (Valid1) {
                                    SD=(ShortDataType*)(DF->DPTR[Lauf][Nr]);
                                    int T=(*SD)[Tag];
                                    if (WetterIcon[T] == NULL) {
                                       WetterIcon[T] = new QPixmap(CalcWetterImage(T));
                                    }
                                    ValLab->setPixmap(*(WetterIcon[T]));
                                    debug("display - Wetter Icon=%d  Cut=%d",T,Tag);
                                  } else
                                    ValLab->setText("");
                               }
                               break;
           case TYP_WIND :     {
                               KWindRose *KW;
                               char S[32];
                               int W,WS,WR;
                               debug("display - Wind");

                                  KW = (KWindRose*)Handles[Lauf][Nr][DATALAB];
                                  UnitLab = (QLabel*)Handles[Lauf][Nr][UNITLAB];

                                  LD=(LongDataType*)(DF->DPTR[Lauf][Nr]);
                                  W=(*LD)[Tag];
                                  WR=W & 0x0000FFFF;
                                  WS=(W>>16) & 0x0000FFFF;
                                  if (Valid2) {
                                    if ( (WR>65000) || (WR<0) ) {
                                      KW->setDirection(0);
                                      KW->setValid(KWR_NODIR);
                                    } else {
                                      KW->setDirection(0.1*WR);
                                      KW->setValid(KWR_VALID);
                                    }
                                  } else {
                                    KW->setDirection(0.1*WR);
                                    KW->setValid(KWR_INVALID);
                                  }

                                  if (Valid1)
                                    sprintf(S, "%0.1f %s",0.1*WS,DF->DataArr[Nr]->Einheit2);
                                  else
                                    strcpy(S,"-");
                                  UnitLab->setText(S);
                                  debug("WR=%0.1f   WS=%d",0.1*WR,WS);
                               }
                               break;
           case TYP_TEXT :     break;

        }
      }
    }
  }
}

void DataDlg::EditModify() {
   debug("DataDlg::EditModify");

   if (edlg==NULL) {
      debug("edlg-create");
      edlg = new EditDlg(DF, Chart);
   }
      //edlg = new EditDlg(DF, Chart, i18n("Modify Data"));
   //edlg
   if (edlg->exec()) {  // ok, speichern
      DF->Seek(Chart->FPos());
      DF->Write();
   } else {  // Abbruch, verwerfen
      DF->Seek(Chart->FPos());
      DF->Read();
   }
   delete edlg;
   edlg=NULL;
   Chart->update();
   Chart->UpdateTag(Chart->DispTag);

}

void DataDlg::MoveFirst() {
   Chart->FirstDay();
}

void DataDlg::MovePrev() {
   Chart->PrevDay();
}

void DataDlg::MoveNext() {
   Chart->NextDay();
}

void DataDlg::MoveLast() {
   Chart->LastDay();
}

void DataDlg::closeEvent ( QCloseEvent * e ) {
  e->ignore();
  hide();
}

void DataDlg::MinimizeBtnPressed(int Nr) {
int Lauf, PosY;
  debug("MinimizeBtnPressed Nr=%d  %s",Nr,DF->DataArr[Nr]->Name);


  if (DI[Nr]) {
    debug("DI.Minimized=%d %d   %d",DI[Nr]->Minimized,TRUE,FALSE);
    if (DI[Nr]->Minimized) {   // Alles sichtbar schalten
      DI[Nr]->Minimized = FALSE;
    } else {                  // Minimieren bis auf die Titelzeile
      DI[Nr]->Minimized = TRUE;
    }

    PosY = 0;
    for (Lauf=0; Lauf<DataCount; Lauf++) {
      if (DI[Lauf]->Minimized) {
        DI[Lauf]->setGeometry(0, PosY, 3000,FRAMEHEIGHT1);
        ScrollView->moveChild(DI[Lauf],0,PosY);
        PosY += FRAMEHEIGHT1;
      } else {
        DI[Lauf]->setGeometry(0, PosY, 3000,ITEMHEIGHT);
        ScrollView->moveChild(DI[Lauf],0,PosY);
        PosY += ITEMHEIGHT;
      }
    }
    ScrollView->resizeContents(MaxX,PosY);
    resizeEvent(NULL);
  }
}

void DataDlg::DisplayBtnPressed(int Nr) {
  if (!DF->DataArr[Nr]) return;

  if (DF->IsVisible(Nr))
    SetVisible(Nr,FALSE);
  else
    SetVisible(Nr,TRUE);
}
//QLabel* Lab;
//QFont Font;
//int Lauf;                  // for (Lauf=0; Lauf<DF->DataArr[Nr]->Count;Lauf++)
void DataDlg::SetVisible(int Nr, int Vis) {
// Visible-Status fr Item 'Nr' setzen
MyFrame* MyFrm=NULL;

  debug("DisplayBtnPressed Nr=%d",Nr);
  if (DF->DataArr[Nr]) {
    // Fontdaten vom ersten Label holen
    //Lab = (QLabel*)Handles[0][Nr][DATALAB];
    //Font = Lab->font();
    // Handle auf den Button zum Umschalten
    if (Handles[0][Nr][HIDEFRM])
      MyFrm = (MyFrame*)Handles[0][Nr][HIDEFRM];

        debug("Frameshadow=%X  %X",MyFrm->frameShadow(), QFrame::Sunken);
    //if (DF->DataArr[Nr]->Flags1 & FLG_NODISPLAY) { // Anzeige diesen Items ist ausgeschaltet
    //if (DF->IsVisible(Nr)==FALSE) {
    if (Vis) {
      DF->SetVisible(Nr, TRUE);
      //DF->DataArr[Nr]->Flags1 = DF->DataArr[Nr]->Flags1 & (~FLG_NODISPLAY);
      //Font.setItalic(FALSE);
      //Font.setBold(TRUE);
      if (MyFrm) {
        MyFrm->setText("");
        MyFrm->setFrameStyle(QFrame::Panel | QFrame::Raised);
        MyFrm->update();
      }
    } else {
      DF->SetVisible(Nr, FALSE);
      //DF->DataArr[Nr]->Flags1 |= FLG_NODISPLAY;
      //Font.setItalic(TRUE);
      //Font.setBold(FALSE);
      if (MyFrm) {
        MyFrm->setText("x");
        MyFrm->setFrameStyle(QFrame::Panel | QFrame::Sunken);
        MyFrm->update();
      }
    }
    //Lab->setFont(Font);
    debug("Frameshadow=%X  %X",MyFrm->frameShadow(), QFrame::Sunken);
    Chart->update();
  }
  // debug("D-Ende");
}

void DataDlg::MenueBtnPressed(int Nr) {
  debug("MenueBtnPressed %d",Nr);
  MnuItemNr=Nr;
  Popup->popup(QPoint(MPosX,MPosY));
}

void DataDlg::MenuShowAll() {
int Lauf;
debug("Show all");
  Lauf=MnuItemNr+1;
  while ( (DF->DataArr[Lauf]) && (DF->DataArr[Lauf]->Type!=TYP_GROUP)) {
    SetVisible(Lauf,TRUE);
    Lauf++;
  }
  Chart->update();
}

void DataDlg::MenuHideAll() {
int Lauf;
  Lauf=MnuItemNr+1;
  while ( (DF->DataArr[Lauf]) && (DF->DataArr[Lauf]->Type!=TYP_GROUP)) {
    SetVisible(Lauf,FALSE);
    Lauf++;
  }
  Chart->update();
}

void DataDlg::MenuShowAllExcept() {
int Lauf;
  Lauf=MnuItemNr+1;
  while ( (DF->DataArr[Lauf]) && (DF->DataArr[Lauf]->Type!=TYP_GROUP)) {
    if ( (DF->DataArr[Lauf]->Type==TYP_WEATHER) || (DF->DataArr[Lauf]->Type==TYP_WIND) )
      SetVisible(Lauf,FALSE);
    else
      SetVisible(Lauf,TRUE);
    Lauf++;
  }
  Chart->update();
}

void DataDlg::MenuLoadDisplayBits() {
int Lauf;

  DF->LoadVisibleBits();

  Lauf=0;
  while (Lauf<MAXDATA) {
    if (DF->DataArr[Lauf]==NULL) break;
    if (DF->DataArr[Lauf]->Type != TYP_GROUP) {
      if (DF->IsVisible(Lauf))
        SetVisible(Lauf, TRUE);
      else
        SetVisible(Lauf, FALSE);
    }
    Lauf++;
  }
}

void DataDlg::MenuSaveDisplayBits() {

  DF->SaveVisibleBits();
}
