/***************************************************************************
                          kweboptions.cpp  -  description
                             -------------------
    begin                : Sun Dec 5 1999
    copyright            : (C) 1999 by Troy Ogden
    email                : badger@bookshelves.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// this will get the run time arguments: grab delay, ftp server,
// username, password, uploaded image name, upload directory .......

#include "kweboptions.h"

KWebOptions::KWebOptions(QWidget* parent=0, const char* name=0 )
	: QTabDialog( parent, name, TRUE)
	{
	config = kapp->getConfig();
	readSettings();

	QTabDialog *t = new QTabDialog(0,"top-level dialog");
	setCaption(i18n("Setup"));
	
// ---------------- set up page one of the tab dialog
	tab = new QWidget(t,"page one");

// set up a grid to house the labels and line edits....	
	grid = new QGridLayout(tab,5,2,5);

// set up the labels.......
	QLabel *server = new QLabel(tab);
	QLabel *username = new QLabel(tab);
	QLabel *password = new QLabel(tab);
	QLabel *directory = new QLabel(tab);
	QLabel *imgname = new QLabel(tab);

	server->setText("Server");
	username->setText("Username");
	password->setText("Password");
	directory->setText("Destination Directory");
	imgname->setText("Image Name");
	
	grid->addWidget(server, 0,0);
	grid->addWidget(username,1,0);
	grid->addWidget(password,2,0);
	grid->addWidget(directory,3,0);
	grid->addWidget(imgname,4,0);	

// now line edit thingys
	ed1 = new QLineEdit(tab,"lineEdit1");
	ed1->setFixedHeight(ed1->sizeHint().height());
	grid->addWidget(ed1,0,1);
	ed1->insert(_server);

	ed2 = new QLineEdit(tab,"lineEdit2");
	ed2->setFixedHeight(ed2->sizeHint().height());
	grid->addWidget(ed2,1,1);
	ed2->setText(_username);

	ed3 = new QLineEdit(tab,"lineEdit3");
	ed3->setFixedHeight(ed3->sizeHint().height());
	ed3->setEchoMode(QLineEdit::Password);
	grid->addWidget(ed3,2,1);
	ed3->setText(_password);

	ed4 = new QLineEdit(tab,"lineEdit4");
	ed4->setFixedHeight(ed4->sizeHint().height());
	grid->addWidget(ed4,3,1);
	ed4->setText(_directory);

	ed5 = new QLineEdit(tab,"lineEdit5");
	ed5->setFixedHeight(ed5->sizeHint().height());
	grid->addWidget(ed5,4,1);
	ed5->setText(_imgname);


// fill the entire tab widget with the label and line edits to look full.......
	grid->setColStretch(0,1);
	grid->setColStretch(1,2);

// finally insert page one into the tab dialog and start GM
	addTab(tab,"FTP Options");
	grid->activate();

// ---------------------- page two------------------------------
	tab2 = new QWidget(t,"page two");

// create a groupbox......it's the parent of the rest of it, but a child of tab
	btgroup = new QButtonGroup(tab2,"btgroup");
	btgroup->setTitle("Delay Options");
	
// Create a layout......
	b = new QBoxLayout(btgroup,QBoxLayout::Down,10);

// put the groupbox in the layout.....
	b->addWidget(btgroup);

// create a grid for the radiobuttons.....it seems to show up all by it's self.... :-)
	my_radioLayout = new QGridLayout(btgroup,4,3,10);
	
 	rb0 = new QRadioButton(btgroup);
	rb0->setText("10 Seconds");
	my_radioLayout->addWidget(rb0,1,0);
	rb0->setMinimumSize(rb0->sizeHint());

	rb1 = new QRadioButton(btgroup);
	rb1->setText("20 Seconds");
	my_radioLayout->addWidget(rb1,2,0);
	rb1->setMinimumSize(rb1->sizeHint());

	rb2 = new QRadioButton(btgroup);
	rb2->setText("30 Seconds");
	my_radioLayout->addWidget(rb2,3,0);
	rb2->setMinimumSize(rb2->sizeHint());

	rb3 = new QRadioButton(btgroup);
	rb3->setText("45 Seconds");
	my_radioLayout->addWidget(rb3,1,1);
	rb3->setMinimumSize(rb3->sizeHint());

	rb4 = new QRadioButton(btgroup);
	rb4->setText("60 Seconds");
	my_radioLayout->addWidget(rb4,2,1);
	rb4->setMinimumSize(rb4->sizeHint());

	rb5 = new QRadioButton(btgroup);
	rb5->setText("2 Minutes");
	my_radioLayout->addWidget(rb5,3,1);
	rb5->setMinimumSize(rb5->sizeHint());

	rb6 = new QRadioButton(btgroup);
	rb6->setText("3 Minutes");
	my_radioLayout->addWidget(rb6,1,2);
	rb6->setMinimumSize(rb6->sizeHint());

	rb7 = new QRadioButton(btgroup);
	rb7->setText("5 Minutes");
	my_radioLayout->addWidget(rb7,2,2);
	rb7->setMinimumSize(rb7->sizeHint());

	rb8 = new QRadioButton(btgroup);
	rb8->setText("10 Minutes");
	my_radioLayout->addWidget(rb8,3,2);
	rb8->setMinimumSize(rb8->sizeHint());

// ugly hack to get the id # of the radio button and set the last used button
	int id;
	config = kapp->getConfig();
	config->setGroup("General");
	id = config->readNumEntry("delay");
	btgroup->setButton(id);

// add all of this to the second tab page.......
	addTab(tab2,i18n("Time Delay"));
	
	
// add a cancel and apply button....nicely provided by QTabDialog.......
	setCancelButton();
	setApplyButton();

// connect everything.........
	connect(btgroup, SIGNAL(clicked(int)),SLOT(radioButtonClicked(int)));
	connect(this,SIGNAL(cancelButtonPressed()),SLOT(cancel()));
	connect(this,SIGNAL(applyButtonPressed()),this,SLOT(apply()));

	} // end of setting up the options dialog widget...........


void KWebOptions::cancel()
	{
	}

// set the config file now, don't take but a second...
void KWebOptions::radioButtonClicked(int id)
	{
	config = kapp->getConfig();
	config->setGroup("General");
	config->writeEntry("delay",id);
	}

KWebOptions::~KWebOptions()
	{
	return;
	}

// save all settings except the radio button id....
void KWebOptions::apply()
	{
	config = kapp->getConfig();
	config->setGroup("General");
	config->writeEntry("server",ed1->text());
	config->writeEntry("username",ed2->text());
	config->writeEntry("password",ed3->text());
	config->writeEntry("directory",ed4->text());
	config->writeEntry ("imgname",ed5->text());
	config->sync();
	}

void KWebOptions::readSettings()
	{
	config->setGroup("General");
 	_server = config->readEntry("server");
	_username = config->readEntry("username");
	_password = config->readEntry("password");
	_directory = config->readEntry("directory");
	_imgname = config->readEntry("imgname");
	}

