/***************************************************************************
                          messengerview.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Apr  5 09:53:56 MEST 1999
                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <qstrlist.h>
#include <ktablistbox.h>
#include <messengerview.h>

MessengerView::MessengerView(KApplication* a,QWidget *parent)
              :KTabListBox(parent)

{
	static char *header[]={"No","Type","Message","Time","Sender","Status"};
	int twidth=0;
	int i=0;
	int cols=6;

	setNumCols( cols );
	clear();
	setSeparator('\t');
	// twidth = (int) (this->width() / 5);
  setColumn( 0, i18n(header[0]), (fontMetrics()).width( i18n(header[0]) )+20 );
  setColumn( 1, i18n(header[1]), (fontMetrics()).width( i18n(header[1]) )+20 );
  setColumn( 2, i18n(header[2]), (fontMetrics()).width( i18n(header[2]) )+20 );
  setColumn( 3, i18n(header[3]), (fontMetrics()).width( i18n(header[3]) )+50 );
  setColumn( 4, i18n(header[4]), (fontMetrics()).width( i18n(header[4]) )+100 );
  setColumn( 5, i18n(header[5]), (fontMetrics()).width( i18n(header[5]) )+100 );
	for( i=0; i < cols; i++ )
		twidth+=cellWidth( i );
  // Is there a way to set to fill to right initially
  setColumnWidth( cols-1, ((this->width())-twidth) );
}

MessengerView::~MessengerView(){
}

void MessengerView::slotGotData(struct ModemGeneralInfo moGeneral,
																ModemMessageList moMsgList)
{
	struct ModemMsgInfoStruct *moInfo = 0;
	QString qstr 		= "";
	QString dtime 	= "";
	QString attrib 	= "";
	
  clear();
  // now make a string and append it to the view
  typedef QListIterator<struct ModemMsgInfoStruct> MoListIterator;
  MoListIterator my( moMsgList );
  for ( my.toFirst(); my.current(); ++my )
  {
  	qstr = "";
  	moInfo = my.current();
  	// build dtime
  	if (moInfo->clockValid)
  	{
  		dtime.sprintf("%i:%i:%i",	moInfo->msgDay,moInfo->msgHour,
  															moInfo->msgMinute);
  	} else
  		dtime = "not set";
  	// build status
  	switch (moInfo->msgAttribute)
  	{
  		case UnreleasedUnchecked: attrib = "ur, uc"; 	break;
  		case UnreleasedChecked	:	attrib = "ur, ch"; 	break;
  		case ReleasedChecked		:	attrib = "r, ch"; 	break;
  		default									: attrib = "???";
  	}
   	if ((moInfo->msgType) == Fax)
    {
    	qstr.sprintf("%i\tFax\t%i p\t%s\t%s\t%s\t",moInfo->msgIndex,
    		moInfo->msgSize,dtime.data(),moInfo->callerId.data(),attrib.data());
		} else {
			qstr.sprintf("%i\tVoice\t%i sec\t%s\t%s\t%s\t",moInfo->msgIndex,
				moInfo->msgSize,dtime.data(),moInfo->callerId.data(),attrib.data());
		}
		//debug("Line-> %s",qstr.data());
 		appendItem(qstr);
 	}
}



