/***************************************************************************
                          modemconnector.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Apr 7 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <string.h>
#include <termios.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>

#include <stdlib.h>
#include <errno.h>
//#include <sys/types.h>
//#include <time.h>
//#include <sys/time.h>
#include <sys/signal.h>
//#include <sys/stat.h>


#include "modemconnector.h"

#define _POSIX_SOURCE 1
#define DEFAULT_BAUDRATE B9600
#define MAX_WAIT 1

ModemConnector::ModemConnector(char *device, char *baudrate, char *lockfile)
{
  strcpy(_device,device);
  // set baudrate
  if (strcmp("2400",baudrate) == 0)
  {
  	_baudrate = B2400;
  } else if (strcmp("4800",baudrate) == 0)
  {
  	_baudrate = B4800;
  } else if (strcmp("9600",baudrate) == 0)
  {
  	_baudrate = B9600;
  } else if (strcmp("19200",baudrate) == 0)
  {
  	_baudrate = B19200;
  } else if (strcmp("38400",baudrate) == 0)
  {
  	_baudrate = B38400;
  } else
  	_baudrate = DEFAULT_BAUDRATE;
  	
  strcpy(_lockfile, lockfile);
}

ModemConnector::~ModemConnector()
{
  tcsetattr(_fd,TCSANOW,&_oldtio); /* restore old modem setings */
  close(_fd);
  *_device = 0;
  // delete lockfile
  unlink(_lockfile);
}

bool ModemConnector::setDevice(char *device)
{
  strcpy(_device,device);
  return true;
}

bool ModemConnector::initSerialLine()
{
	if (!lockSerialLine())
		return false;
		
  _fd = open(_device, O_RDWR | O_NOCTTY);
  if (_fd <0) {perror(_device); return false; }
  tcgetattr(_fd,&_oldtio); /* save current modem settings */
  _newtio.c_cflag = _baudrate | CRTSCTS | CS8 | CLOCAL | CREAD;
  _newtio.c_iflag = INPCK | IGNPAR;
  _newtio.c_oflag = 0;
  _newtio.c_lflag = 0;
  _newtio.c_cc[VMIN]=0;
  _newtio.c_cc[VTIME]=10;
  tcflush(_fd, TCIFLUSH);
  tcsetattr(_fd,TCSANOW,&_newtio);
  return true;
}

bool ModemConnector::flushSerialLine()
{
  if (_fd<= 0)
    return false;

  tcflush(_fd, TCIFLUSH);
  return true;
}

bool ModemConnector::lockSerialLine()
{
	int fd;
	char text[256];
	char pidbuf[32];
	int lockpid;

	fprintf(stderr,"Try to create lockfile %s\n",_lockfile);
	fd=open(_lockfile, O_WRONLY|O_CREAT|O_EXCL, 0644);
	if(fd==-1)
	{
		fprintf(stderr,"Couldn't create lockfile %s\n",_lockfile);
		if(errno==EEXIST)
		{
			fd=open(_lockfile,O_RDONLY);
			if(fd==-1)
			{
				fprintf(stderr,"Couldn't open %s : %s\n",_lockfile,strerror(errno));
				return false;
			}
			read(fd,pidbuf,20);
			lockpid=atoi(pidbuf);
			if(kill(lockpid,0)==0)
			{
				//errno=EBUSY;
				close(fd);
				return false;
			}
			close(fd);
			unlink(_lockfile);
			fprintf(stderr,"Removing old lockfile\n");
			fd=open(_lockfile,O_RDWR|O_CREAT|O_EXCL,0644);
			if(fd==-1)
			{
				fprintf(stderr,"Unable to create lockfile %s : %s\n",_lockfile,strerror(errno));
				return false;
			}
		}
		else
		{
			fprintf(stderr,"Unable to create lockfile %s : %s\n",_lockfile,strerror(errno));
			return false;
		}
	}
	sprintf(text,"%10d\n",getpid());
	write(fd,text,strlen(text));
	close(fd);

	return true;
}

/*
bool ModemConnector::readChar(unsigned char *c)
{
  int elapsedTime = MAX_WAIT;

  if (_fd<= 0)
    return false;

  while (true)
  {
    if (read(_fd,c,1) < 1) {
      elapsedTime--;
      usleep(1);
      if (elapsedTime < 1) {
        *c = 0;
        return false;
      }
    } else {
      return true;
    }
  }
}
*/

bool ModemConnector::readChar(unsigned char *c)
{
  if (_fd<= 0)
    return false;

  while (true)
  {
    if (read(_fd,c,1) < 1)
    {
	    *c = 0;
      return false;
    } else {
      return true;
    }
  }
}

/** read char bis ERROR, OK oder VCON */
bool ModemConnector::readCharBlocking(unsigned char *c)
{

	static char buffer[8] = "";
	static int bufpos = 0; // position of last byte filled
	static bool wasEnd = false;
	char tmpbuf[8];
	
  if (_fd<= 0)
    return false;

	if (wasEnd)
	{
		wasEnd = false;
		memset(buffer,0,8);
		bufpos = 0;
		return false;
	}

	read(_fd,c,1);
	
	if (bufpos < 7)
	{
		buffer[bufpos++] 	= *c;
		buffer[bufpos] 		= 0;
	} else {
		// buffer is full, shift left and append
		*tmpbuf = 0;
		strncpy(tmpbuf,&buffer[1],6);
		tmpbuf[6] = 0;
		*buffer = 0;
		strcpy(buffer, tmpbuf);
		buffer[6] = *c;
		buffer[7] = 0;
	}

	// fprintf(stderr,"Buffer: %s\n",buffer);
	if ((strstr(buffer,"\nOK")) ||
			(strstr(buffer,"\nERROR")) ||
			(strstr(buffer,"\nVCON")))
	{
		wasEnd = true;
	}
			
	return true;
}

int ModemConnector::readStr(char *str, const int len)
{
	int cnt = 0;
	unsigned char c = 0;
	*str = 0;

  while (readCharBlocking(&c))
  {
  	if (cnt < len)
	    str[cnt++] = c;
	  else
	  	break;
  }
  str[cnt] = 0;

  return cnt;
}

bool ModemConnector::writeStr(char *c, int len)
{
  if (_fd<= 0)
    return false;

	flushSerialLine();
 	//usleep(100000);
  if (write(_fd,c,len) == -1)
    return false;
  else
  {
  	usleep(200000);
    return true;
	}
}

bool ModemConnector::executeCommand(char *send,char *receive,int rlen, int &len,char *end)
{
	bool success = false;
	struct termios tmptio, newtio;
	
  tcgetattr(_fd,&tmptio); /* save current modem settings */
  newtio.c_cflag = _baudrate | CRTSCTS | CS8 | CLOCAL | CREAD;
  newtio.c_iflag = INPCK | IGNPAR;
  newtio.c_oflag = 0;
  newtio.c_lflag = 0;
  newtio.c_cc[VMIN]=1;
  newtio.c_cc[VTIME]=100;
  tcflush(_fd, TCIFLUSH);
  tcsetattr(_fd,TCSANOW,&newtio);

 	// flush modem line
	//flushSerialLine();
	
 	// Send command
	//fprintf(stderr,"executeCommand(%s,%p,%d,%s)\n",send,receive,len,end);
	writeStr(send,strlen(send));
	
 	// Read result
	len = readStr(receive, rlen);
	if(len > 0)
	{
		if(strstr(receive,end))
		{
			success = true;
		} else
			if(strstr(receive,"\nERROR"))
			{
				success = false;
			} else
				if(strstr(receive,"\nVCON"))
				{
					success = false;
				}
	}
	
	//fprintf(stderr,"Got <%s>(%d)\n",receive,len);
	flushSerialLine();
	
  tcsetattr(_fd,TCSANOW,&tmptio); /* restore old modem settings */

	return success;
}

bool ModemConnector::executeSimpleCommand(char *send, char *end)
{
  char receive[256] = "";
  int len;

	return executeCommand(send, receive, 256, len, end);
}










