/***************************************************************************
                          modemconnector.h  -  description                              
                             -------------------                                         
    begin                : Wed Apr 7 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef MODEMCONNECTOR_H
#define MODEMCONNECTOR_H

#include <termios.h>
#include <qobject.h>

/**This class provides basic low level
functionality to acces a serial
device.
  *@author Torsten Uhlmann
  */

class ModemConnector : public QObject {

	Q_OBJECT
	
public: 
	ModemConnector(char*, char*, char*);
	~ModemConnector();
	
	bool setDevice(char *device);
	bool initSerialLine();
  bool flushSerialLine();
  /** lockSerialLine checks if line is locked and if not, creates
  		a lock file */
  bool lockSerialLine();
	/** readChar either returns one char or 0 for end of stream */
	bool readChar(unsigned char *c);
	/** readCharBlocking either returns one char or 0 for end of stream
			in blocking mode */
	bool readCharBlocking(unsigned char *c);
	/** writeStr write len chars to the serial line */
	bool writeStr(char *c, int len);
	
	bool 	executeCommand(char*,char*,int, int&,char*);
	bool 	executeSimpleCommand(char*,char*);
	int 	readStr(char*, const int);
	
private:
  char 			_device[20];
  char			_lockfile[255];
  tcflag_t 	_baudrate;

  struct termios _oldtio, _newtio;

  int _fd;

};

#endif














