/*
 *   mkkdelnk - a small utility for creating kdelnk files
 *   Copyright (C) 1998  Thomas Tanghus
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include <../config.h>
#endif

#include <qdir.h>
#include <qfile.h>
#include <qfileinf.h>
#include <qtstream.h>
#include <kfm.h>

enum { ERROR_NON, ERROR_SYNTAX, ERROR_TARGET, ERROR_DESTINATION, ERROR_UNKNOWN };

void showUsage()
{
  debug("\nUsage:\nmkkdelnk target [destination]\n");
}

int installKdeLnk(int argc, char **argv)
{
  QString target, destination, icon = "unknown.xpm", t_options = "";
  QFile f_t, f_d;
  QFileInfo fi_t, fi_d;
  bool terminal = false;

  if(argc < 2 || argc > 3)
  {
    showUsage();
    return ERROR_SYNTAX;
  }

  target = argv[1];

  fi_t.setFile(target.data());
  f_t.setName(fi_t.absFilePath());

  // The following not implemented 'cause I didn't want to search the
  // entire path. Is there an easy way of doing that.
  //if(!fi_t.exists())     // the target didn't exist
    //return ERROR_TARGET;

  if(fi_t.isDir())
  {
    target = "kfmclient openURL " + fi_t.absFilePath();
    icon = "folder.xpm";
  }
  else if(fi_t.isExecutable())
  {
    target = fi_t.absFilePath();
    icon = "exec.xpm";
  }
  else if(f_t.open(IO_ReadOnly))
  {
    QString line;
    QTextStream t(&f_t);

    line = t.readLine();
    if(line.left(3) == "#!/")
    { // a script without execute bit
      target = line.right(line.length()-2) + " " + fi_t.absFilePath();
      terminal = true;
      t_options = "-caption " + fi_t.fileName();
      icon = "terminal.xpm";
    }
    else
      target = "kfmclient openURL " + fi_t.absFilePath();
    f_t.close();
  }
  else
    target = "kfmclient openURL " + fi_t.absFilePath();
    
  debug("Target: %s", target.data());

  if(argc < 3)  // no destination
    destination = QDir::homeDirPath() + "/Desktop/" + fi_t.baseName() + ".kdelnk";
  else if(argc == 3)
  {
    destination = argv[2];
    fi_d.setFile(destination.data());
    if(fi_d.isDir())
      destination = fi_d.absFilePath() + "/" + fi_t.baseName() + ".kdelnk";
    else if(destination.left(7) != ".kdelnk")
      destination += ".kdelnk";
  }

  debug("Destination: %s", destination.data());

  f_d.setName(destination.data());
  if(f_d.open(IO_WriteOnly))
  {
    QTextStream t(&f_d);
    t << "# KDE Config File\n";
    t << "[KDE Desktop Entry]\n";
    t << "BinaryPattern=" << fi_t.fileName() << ";\n";
    t << "Exec=" << target.data() << "\n";
    t << "Terminal=" << terminal << "\n";
    t << "TerminalOptions=" << t_options.data() << "\n";
    t << "Name=" << fi_t.fileName() << "\n";
    t << "Type=Application\n";
    t << "Icon=" << icon.data() << "\n";
    f_d.close();

    KFM *kfm = new KFM;
    if(kfm->isKFMRunning())
    {
      kfm->refreshDesktop();
      kfm->openProperties(destination.data());
    }
    delete kfm;
  }
  else
    return ERROR_DESTINATION;

  return ERROR_NON;
}


int main(int argc, char **argv)
{
  return(installKdeLnk(argc, argv));
}


