#ifndef DB_ENTRY_H
#define DB_ENTRY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// stdlib includes
#include <qstring.h>
#include <qdatetime.h>

#include <stdlib.h>

/** This is the storage class for a contact. It will basically be a way to get data to and
 * from the database. The prgram using this should create their own Entry class which can swallow
 * this object and use whatever fields needed.
 *
 * @author Mike Pilone
 */
class DBEntry
{
public:
  DBEntry() 
    {
      fModified = false;
      fDeleteMe = false;

      fLastname = "New";
      fFirstname = "Entry";

      fTitle = "";
      fCompany = "";
      
      fAddress = "";
      fCity = "";
      fState = "";
      fZip = "";
      fCountry = "";

      fPhone1 = "";
      fPhone2 = "";
      fPhone3 = "";
      fPhone4 = "";
      fPhone5 = "";

      fCustom1 = "";
      fCustom2 = "";
      fCustom3 = "";
      fCustom4 = "";

      fComment = "";

      fReferredBy = "";

      fRecordCreator = getenv("USER");

      fEditDate.setYMD(1999, 01, 01);
      fMergeDate.setYMD(1999, 01, 01);
      fLastReach.setYMD(1999, 01, 01);
      fLastAttempt.setYMD(1999, 01, 01);
      fLastMeeting.setYMD(1999, 01, 01);
      fCreateDate = QDate::currentDate();

      fGroup = 2;
      
      fCustom1Label = "Custom1:";
      fCustom2Label = "Custom2:";
      fCustom3Label = "Custom3:";
      fCustom4Label = "Custom4:";

      fPhone1Type = 0;
      fPhone2Type = 1;
      fPhone3Type = 2;
      fPhone4Type = 3;
      fPhone5Type = 4;

      fKey = "0";
    };

  ~DBEntry() {};
  
  /** Stores whether something has been modified in this entry or not.
   */
  bool fModified;

  /** Stores whether this entry should be deleted as of next perge or not
   */
  bool fDeleteMe;

  // These are the fields of an entry
  QString fLastname;
  QString fFirstname;
  
  QString fTitle;
  QString fCompany;
  
  QString fAddress;
  QString fCity;
  QString fState;
  QString fZip;
  QString fCountry;
  
  QString fPhone1;
  QString fPhone2;
  QString fPhone3;
  QString fPhone4;
  QString fPhone5;
  
  QString fCustom1;
  QString fCustom2;
  QString fCustom3;
  QString fCustom4;
  
  QString fComment;
  
  QString fReferredBy;
  
  QDate fEditDate;
  QDate fMergeDate;
  QDate fLastReach;
  QDate fLastAttempt;
  QDate fLastMeeting;
  
  QString fRecordCreator;
  QDate fCreateDate;
  
  //QList<NoteStruct> fNotes;
  
  int fGroup;
  
  QString fCustom1Label;
  QString fCustom2Label;
  QString fCustom3Label;
  QString fCustom4Label;
  
  int fPhone1Type;
  int fPhone2Type;
  int fPhone3Type;
  int fPhone4Type;
  int fPhone5Type;

  QString fKey;

};  

#endif
