// Local includes
#include "errordialog.h"

// Stdlib includes
#include <string.h>
#include <iostream.h>

// QT includes
#include <qpushbt.h> 
#include <qmultilinedit.h>
#include <qdatetime.h>

// KDE includes
#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>

CErrorDialog::CErrorDialog(QWidget* parent, const char* name) : QDialog(parent, name, FALSE)
{
  setCaption(i18n("PeopleSpace Error Report"));
  setGeometry(200, 200, 300, 205);

  fErrorMessageField = new QMultiLineEdit(this, "ErrorMessageField");
  fErrorMessageField->setGeometry(5, 5, 290, 160);
  fErrorMessageField->setReadOnly( TRUE );


  fCloseButton = new QPushButton(i18n("&Close"), this, "CloseButton");
  fCloseButton->setGeometry(125, 175, 50, 25);

  connect(fCloseButton, SIGNAL(clicked()), this, SLOT(slotClose()));

  this->hide();
}

CErrorDialog::~CErrorDialog()
{
  disconnect(fCloseButton, SIGNAL(clicked()), this, SLOT( slotClose() ));

  delete(fErrorMessageField);
  delete(fCloseButton);
}

void CErrorDialog::displayError(QString errorMessage, bool forceDisplay)
{
  QTime time;
  QString string;
  int spacePos = 0;

  time.start();
  string = "---- ";
  string += time.toString();
  string += " --------------------";

  fErrorMessageField->append(string);

 

  while (errorMessage.length() > 35)
    {
      spacePos = errorMessage.find(" ", 30, FALSE);
      if (spacePos == -1)
	{
	fErrorMessageField->append(i18n(errorMessage.left(35)));
	errorMessage.remove(0, 35);
	}

      else
	{
	fErrorMessageField->append(i18n(errorMessage.left(spacePos)));
	errorMessage.remove(0, spacePos+1);
	}
     
    }

  // now insert the rest of the string
  if (!errorMessage.isEmpty())
    fErrorMessageField->append(i18n(errorMessage.left(errorMessage.length())));

  string = "-------------------------------";
  fErrorMessageField->append(string);

  // Get it back down to 30 lines. This helps to conserve memory
  while (fErrorMessageField->numLines() > 30)
    fErrorMessageField->removeLine(0);
		
  // set the view back at the bottom
  fErrorMessageField->setCursorPosition(fErrorMessageField->numLines() -1, 0);

  KConfig* config = kapp->getConfig();
  config->setGroup("NOTIFICATION");

  if ((forceDisplay) || config->readBoolEntry("ShowErrors", FALSE))
    {
      kapp->beep();
      this->show();
    }
    
 
}


//////////////////////////////////////////////
///////// SLOTS /////////////////////////////

void CErrorDialog::slotClose()
{
  this->hide();
}


#include "errordialog.moc"
