// Local includes
#include "lowerwidget.h"
#include "psentry.h"
#include "resource.h"
#include "databaseresource.h"
#include "datepickerdialog.h"
#include "splitter.h"
#include "listview.h"

// QT includes
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qsplitter.h>

// KDE includes
#include <ktreelist.h>
#include <kiconloader.h>
#include <kapp.h>
#include <klocale.h>

LowerWidget::LowerWidget(QWidget* parent, const char* name) : QWidget(parent, name)
{
  init();

  connectChangedSignal();
}

LowerWidget::~LowerWidget()
{
}

void LowerWidget::resizeEvent(QResizeEvent *e)
{
   QWidget::resizeEvent(e);

   fSplitter->setGeometry(0,0, this->width(), this->height());
}

void LowerWidget::init()
{
  initSplitter();
  initLeftWidget();
  initRightWidget();
  initWidgetTree();
  initCustomWidget();
  initDatesWidget();
  initMiscWidget();
  initCommentWidget();
  initNotesListWidget();
  initNotesAddWidget();
}

void LowerWidget::initRightWidget()
{
  fRightWidget = new QWidget(fSplitter, "RightWidget");
}

void LowerWidget::initLeftWidget()
{
  fLeftWidget = new QWidget(fSplitter, "LeftWidget");
  fLeftWidget->resize(32, fSplitter->height());

  fGroup = new QComboBox(FALSE, fLeftWidget, "GroupCombo");
  fGroup->setGeometry(0, fLeftWidget->height()-20, fLeftWidget->width(), 20);
  fGroup->insertItem(i18n("Personal"),PSEntry::groupPersonal);
  fGroup->insertItem(i18n("Business"), PSEntry::groupBusiness);
  fGroup->insertItem(i18n("Unfiled"), PSEntry::groupUnfiled);
  fGroup->setCurrentItem(PSEntry::groupUnfiled);
}

void LowerWidget::initCustomWidget()
{
  int yPos;

  fCustomsWidget = new QWidget(fRightWidget, "CustomsWidget");
  fCustomsWidget->setGeometry(0, 0, fRightWidget->width(), fRightWidget->height());

  yPos = 20;
  fCustom1Label = new QLabel(i18n("Custom1:"), fCustomsWidget, "Custom1Label");
  fCustom1Label->setGeometry(COL_1_LABEL_X_POS, yPos, 80, 20);
  fCustom1Label->setFrameStyle(QFrame::Box | QFrame::Sunken);
  fCustom1Label->setLineWidth(1);
  fCustom1 = new QLineEdit(fCustomsWidget, "Custom1");
  fCustom1->setGeometry(COL_1_FIELD_X_POS, yPos, 130, 20);
  yPos += 24;

  fCustom2Label = new QLabel(i18n("Custom2:"), fCustomsWidget, "Custom2Label");
  fCustom2Label->setGeometry(COL_1_LABEL_X_POS, yPos, 80, 20);
  fCustom2Label->setFrameStyle(QFrame::Box | QFrame::Sunken);
  fCustom2Label->setLineWidth(1);
  fCustom2 = new QLineEdit(fCustomsWidget, "Custom2");
  fCustom2->setGeometry(COL_1_FIELD_X_POS, yPos, 130, 20);

  // New Column
  yPos = 20;
  fCustom3Label = new QLabel(i18n("Custom3:"), fCustomsWidget, "Custom3Label");
  fCustom3Label->setGeometry(COL_2_LABEL_X_POS, yPos, 80, 20);
  fCustom3Label->setFrameStyle(QFrame::Box | QFrame::Sunken);
  fCustom3Label->setLineWidth(1);
  fCustom3 = new QLineEdit(fCustomsWidget, "Custom3");
  fCustom3->setGeometry(COL_2_FIELD_X_POS, yPos, 130, 20);
  yPos += 24;

  fCustom4Label = new QLabel(i18n("Custom4:"), fCustomsWidget, "Custom4Label");
  fCustom4Label->setGeometry(COL_2_LABEL_X_POS, yPos, 80, 20);
  fCustom4Label->setFrameStyle(QFrame::Box | QFrame::Sunken);
  fCustom4Label->setLineWidth(1);
  fCustom4 = new QLineEdit(fCustomsWidget, "Custom4");
  fCustom4->setGeometry(COL_2_FIELD_X_POS, yPos, 130, 20);
}

void LowerWidget::initDatesWidget()
{
   int yPos;
  QLabel* label;

  fDatesWidget = new QWidget(fRightWidget, "DatesWidget");
  fDatesWidget->setGeometry(0, 0, fRightWidget->width(), fRightWidget->height());

  yPos = 20;
  label = new QLabel(i18n("Last Reach:"), fDatesWidget, "LastReachLabel");
  label->setGeometry(COL_1_LABEL_X_POS, yPos, 80, 20);
  fLastReach = new QLabel(i18n("00/00/00"), fDatesWidget, "LastReach");
  fLastReach->setGeometry(COL_1_FIELD_X_POS, yPos, 100, 20);
  fLastReach->setFrameStyle(QFrame::Box | QFrame::Sunken);
  fLastReach->setLineWidth(1);

  QPushButton *pushButton = new QPushButton("...", fDatesWidget);
  pushButton->setGeometry(COL_1_FIELD_X_POS+100, yPos, 25, 20);
  connect(pushButton, SIGNAL( clicked() ), this, SLOT( slotEditLastReachDate() ));
  yPos += 24;

  label = new QLabel(i18n("Last Attempt:"), fDatesWidget, "LastAttemptLabel");
  label->setGeometry(COL_1_LABEL_X_POS, yPos, 80, 20);
  fLastAttempt = new QLabel(i18n("00/00/00"), fDatesWidget, "LastAttempt");
  fLastAttempt->setGeometry(COL_1_FIELD_X_POS, yPos, 100, 20);
  fLastAttempt->setFrameStyle(QFrame::Box | QFrame::Sunken);
  fLastAttempt->setLineWidth(1);

  pushButton = new QPushButton("...", fDatesWidget);
  pushButton->setGeometry(COL_1_FIELD_X_POS+100, yPos, 25, 20);
  connect(pushButton, SIGNAL( clicked() ), this, SLOT( slotEditLastAttemptDate() ));
  yPos += 24;

  label = new QLabel(i18n("Last Meeting:"), fDatesWidget, "LastMeetingLabel");
  label->setGeometry(COL_1_LABEL_X_POS, yPos, 80, 20);
  fLastMeeting = new QLabel(i18n("00/00/00"), fDatesWidget, "LastMeeting");
  fLastMeeting->setGeometry(COL_1_FIELD_X_POS, yPos, 100, 20);
  fLastMeeting->setFrameStyle(QFrame::Box | QFrame::Sunken);
  fLastMeeting->setLineWidth(1);

  pushButton = new QPushButton("...", fDatesWidget);
  pushButton->setGeometry(COL_1_FIELD_X_POS+100, yPos, 25, 20);
  connect(pushButton, SIGNAL( clicked() ), this, SLOT( slotEditLastMeetingDate() ));

  // NEW COLUMN
  yPos = 20;
  label = new QLabel(i18n("Create Date:"), fDatesWidget, "CreateDateLabel");
  label->setGeometry(COL_2_LABEL_X_POS, yPos, 80, 20);
  fCreateDate = new QLabel("00/00/00", fDatesWidget, "CreateDate");
  fCreateDate->setGeometry(COL_2_FIELD_X_POS, yPos, 130, 20);
  yPos += 24;

  label = new QLabel(i18n("Edit Date:"), fDatesWidget, "EditDateLabel");
  label->setGeometry(COL_2_LABEL_X_POS, yPos, 80, 20);
  fEditDate = new QLabel(i18n("00/00/00"), fDatesWidget, "EditDate");
  fEditDate->setGeometry(COL_2_FIELD_X_POS, yPos, 130, 20);
  //fEditDate->setFrameStyle(QFrame::Box | QFrame::Sunken);
  fEditDate->setLineWidth(1);
  yPos += 24;

  label = new QLabel(i18n("Merge Date:"), fDatesWidget, "MergeDateLabel");
  label->setGeometry(COL_2_LABEL_X_POS, yPos, 80, 20);
  fMergeDate = new QLabel(i18n("00/00/00"), fDatesWidget, "MergeDate");
  fMergeDate->setGeometry(COL_2_FIELD_X_POS, yPos, 130, 20);
  //fMergeDate->setFrameStyle(QFrame::Box | QFrame::Sunken);
  fMergeDate->setLineWidth(1);
}

void LowerWidget::initMiscWidget()
{
   int yPos;
  QLabel* label;

  fMiscWidget = new QWidget(fRightWidget, "MiscWidget");
  fMiscWidget->setGeometry(0, 0, fRightWidget->width(), fRightWidget->height());

  yPos = 20;
  label = new QLabel(i18n("Referred By:"), fMiscWidget, "ReferredByLabel");
  label->setGeometry(COL_1_LABEL_X_POS, yPos, 80, 20);
  fReferredBy = new QLineEdit(fMiscWidget, "ReferredBy");
  fReferredBy->setGeometry(COL_1_FIELD_X_POS, yPos, 130, 20);

  // NEW COLUMN
  yPos = 20;
  label = new QLabel(i18n("Creator:"), fMiscWidget, "CreatorLabel");
  label->setGeometry(COL_2_LABEL_X_POS, yPos, 80, 20);
  fRecordCreator = new QLineEdit(fMiscWidget, "RecordCreator");
  fRecordCreator->setGeometry(COL_2_FIELD_X_POS, yPos, 130, 20);
  yPos += 23;
}

void LowerWidget::initNotesListWidget()
{
   int yPos;
  QLabel* label;

  fNotesListWidget = new QWidget(fRightWidget, "NotesListWidget");
  fNotesListWidget->setGeometry(0, 0, fRightWidget->width(), fRightWidget->height());

  yPos = 20;
  label = new QLabel(i18n("Filter:"), fNotesListWidget, "FilterLabel");
  label->setGeometry(COL_1_LABEL_X_POS, yPos, 60, 20);
  fFilter = new QComboBox(FALSE, fNotesListWidget, "FilterCombo");
  fFilter->setGeometry(COL_1_FIELD_X_POS, yPos, 130, 20);
  fFilter->insertItem(i18n("Todo"), PSEntry::noteTodo);
  fFilter->insertItem(i18n("Reminder"), PSEntry::noteReminder);
  fFilter->insertItem(i18n("Note"), PSEntry::noteNote);
  fFilter->insertItem(i18n("All"), PSEntry::noteNote+1);
  fFilter->setCurrentItem(PSEntry::noteNote+1);

  fNewButton = new QPushButton(i18n("&New"), fNotesListWidget, "NewButton");
  fNewButton->setGeometry(COL_2_LABEL_X_POS, yPos, 80, 20);
  
  fDeleteButton = new QPushButton(i18n("&Delete"), fNotesListWidget, "DeleteButton");
  fDeleteButton->setGeometry(COL_2_LABEL_X_POS+80, yPos, 80, 20);

  fNotesListView = new CListView(fNotesListWidget, "NotesListView");
  fNotesListView->addColumn(i18n(""), 30);
  fNotesListView->addColumn(i18n("Date"), 90);
  fNotesListView->addColumn(i18n("Time"), 90);
  fNotesListView->addColumn(i18n("Type"), 100);
  fNotesListView->addColumn(i18n("Description"), 200);
  fNotesListView->setGeometry(0, 50, fNotesListWidget->width(), fNotesListWidget->height() -50);
}

void LowerWidget::initNotesAddWidget()
{
  //int yPos;
  //QLabel* label;

  fNotesAddWidget = new QWidget(fRightWidget, "NotesAddWidget");
  fNotesAddWidget->setGeometry(0, 0, fRightWidget->width(), fRightWidget->height());
}

void LowerWidget::initCommentWidget()
{
  //int yPos;
  QLabel* label;

  fCommentWidget = new QWidget(fRightWidget, "CommentWidget");
  fCommentWidget->setGeometry(0, 0, fRightWidget->width(), fRightWidget->height());

  label = new QLabel(i18n("Comment:"), fCommentWidget, "CommentLabel");
  label->setGeometry(COL_1_FIELD_X_POS, 20, 80, 20);

  fComment = new QMultiLineEdit(fCommentWidget, "Comment");
  fComment->setGeometry(COL_1_FIELD_X_POS, 40, 300, 100);

  
}

void LowerWidget::initWidgetTree()
{
  QPixmap* icon = new QPixmap;
  *icon = Icon("mini-book.xpm");

  fWidgetTree = new KTreeList(fLeftWidget, "WidgetTree");
  fWidgetTree->insertItem(i18n("Extended Data"), icon, 0);

  icon = new QPixmap;
  *icon = Icon("mini-info.xpm");
  fWidgetTree->addChildItem(i18n("Customs"), icon, 0);
  
  icon = new QPixmap;
  *icon = Icon("mini-info.xpm");
  fWidgetTree->addChildItem(i18n("Dates"), icon, 0);

  icon = new QPixmap;
  *icon = Icon("mini-info.xpm");
  fWidgetTree->addChildItem(i18n("Comment"), icon, 0);

  icon = new QPixmap;
  *icon = Icon("mini-info.xpm");
  fWidgetTree->addChildItem(i18n("Misc"), icon, 0);

  icon = new QPixmap;
  *icon = Icon("mini-notes.xpm");
  fWidgetTree->insertItem(i18n("Notes"), icon, 1);

   icon = new QPixmap;
  *icon = Icon("mini-info.xpm");
  fWidgetTree->addChildItem(i18n("List"), icon, 1);
  
  icon = new QPixmap;
  *icon = Icon("mini-info.xpm");
  fWidgetTree->addChildItem(i18n("Add"), icon, 1);

  connect(fWidgetTree, SIGNAL( singleSelected(int)), this, SLOT( slotWidgetSelectionSingleClicked(int)));
  connect(fWidgetTree, SIGNAL( selected(int)), this, SLOT( slotWidgetSelectionDoubleClicked(int)));

  fWidgetTree->setCurrentItem(0);
}

void LowerWidget::initSplitter()
{
  fSplitter = new Splitter(this, "VertSplitter");
  connect(fSplitter, SIGNAL( resized() ), this, SLOT( slotSplitterResized() ));
}


void LowerWidget::saveCurrentlyViewedEntry(PSEntry* entry)
{
  entry->setGroup(fGroup->currentItem());

  entry->setCustom1(fCustom1->text(), fCustom1Label->text());
  entry->setCustom2(fCustom2->text(), fCustom2Label->text());
  entry->setCustom3(fCustom3->text(), fCustom3Label->text());
  entry->setCustom4(fCustom4->text(), fCustom4Label->text());

  entry->setReferredBy(fReferredBy->text());

  entry->setComment(fComment->text());
  
  entry->setEditDate(Convert::stringToDate(fEditDate->text()));
  entry->setMergeDate(Convert::stringToDate(fMergeDate->text()));
  entry->setLastReach(Convert::stringToDate(fLastReach->text()));
  entry->setLastAttempt(Convert::stringToDate(fLastAttempt->text()));
  entry->setLastMeeting(Convert::stringToDate(fLastMeeting->text()));

  entry->setRecordCreator(fRecordCreator->text());
  
  
}

void LowerWidget::setCurrentlyViewedEntry(PSEntry* entry)
{
  disconnectChangedSignal();

  QString custom, customLabel;
  
  entry->custom1(custom, customLabel);
  fCustom1->setText(custom);
  fCustom1Label->setText(customLabel);
  entry->custom2(custom, customLabel);
  fCustom2->setText(custom);
  fCustom2Label->setText(customLabel);
  entry->custom3(custom, customLabel);
  fCustom3->setText(custom);
  fCustom3Label->setText(customLabel);
  entry->custom4(custom, customLabel);
  fCustom4->setText(custom);
  fCustom4Label->setText(customLabel);

  fComment->setText(entry->comment());

  fReferredBy->setText(entry->referredBy());

  fEditDate->setText(Convert::dateToString(entry->editDate()));
  fMergeDate->setText(Convert::dateToString(entry->mergeDate()));
  fLastReach->setText(Convert::dateToString(entry->lastReach()));
  fLastAttempt->setText(Convert::dateToString(entry->lastAttempt()));
  fLastMeeting->setText(Convert::dateToString(entry->lastMeeting()));

  fRecordCreator->setText(entry->recordCreator());
  fCreateDate->setText(Convert::dateToString(entry->createDate()));

  fGroup->setCurrentItem(entry->group());
  
  connectChangedSignal();
}

void LowerWidget::connectChangedSignal()
{
  connect(fGroup, SIGNAL( activated(int) ), this, SLOT( slotViewedEntryChanged() ));

  connect(fCustom1, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fCustom2, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fCustom3, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fCustom4, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));

  connect(fComment, SIGNAL( textChanged() ), this, SLOT( slotViewedEntryChanged() ));

  connect(fReferredBy, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));

  connect(fRecordCreator, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
}

void LowerWidget::disconnectChangedSignal()
{
  disconnect(fGroup, SIGNAL( activated(int) ), this, SLOT( slotViewedEntryChanged() ));

  disconnect(fCustom1, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fCustom2, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fCustom3, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fCustom4, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));

  disconnect(fComment, SIGNAL( textChanged() ), this, SLOT( slotViewedEntryChanged() ));

  disconnect(fReferredBy, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));

  disconnect(fRecordCreator, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
}

void LowerWidget::thereIsASelectedEntry(bool state)
{
  if (!state)
    {
      fWidgetTree->setEnabled(false);
      fGroup->setEnabled(false);
      fRightWidget->hide();
    }

  else
    {
      fWidgetTree->setEnabled(true);
      fGroup->setEnabled(true);
      fRightWidget->show();
    }

}

////////////////////////////////////////////////////
//////////////////// SLOTS /////////////////////////

void LowerWidget::slotViewedEntryChanged()
{
  emit unsavedDataExists();
  
  gViewedEntryChanged = TRUE;
}

void LowerWidget::slotEditLastReachDate()
{
  fDatePickerDialog = new DatePickerDialog(this, "DatePicker", Convert::stringToDate(fLastReach->text()));
  
  if(fDatePickerDialog->exec()) // Means the user pressed OK
    {
      fLastReach->setText(Convert::dateToString(fDatePickerDialog->selectedDate()));
      slotViewedEntryChanged();
    }

  delete (fDatePickerDialog);
}

void LowerWidget::slotEditLastAttemptDate()
{
  fDatePickerDialog = new DatePickerDialog(this, "DatePicker", Convert::stringToDate(fLastAttempt->text()));
  
  if(fDatePickerDialog->exec()) // Means the user pressed OK
    {
       fLastAttempt->setText(Convert::dateToString(fDatePickerDialog->selectedDate()));
       slotViewedEntryChanged();
    }

  delete (fDatePickerDialog);
}

void LowerWidget::slotEditLastMeetingDate()
{
  fDatePickerDialog = new DatePickerDialog(this, "DatePicker", Convert::stringToDate(fLastMeeting->text()));
  
  if(fDatePickerDialog->exec()) // Means the user pressed OK
    {
      fLastMeeting->setText(Convert::dateToString(fDatePickerDialog->selectedDate()));
      slotViewedEntryChanged();
    }

  delete (fDatePickerDialog);
}

void LowerWidget::slotSplitterResized()
{
  fWidgetTree->setGeometry(0, 0, fLeftWidget->width(), fLeftWidget->height()-20);
  fGroup->setGeometry(0, fLeftWidget->height()-20, fLeftWidget->width(), 20);
  fCustomsWidget->setGeometry(0, 0, fRightWidget->width(), fRightWidget->height());
  fDatesWidget->setGeometry(0, 0, fRightWidget->width(), fRightWidget->height());
  fCommentWidget->setGeometry(0, 0, fRightWidget->width(), fRightWidget->height());
  fMiscWidget->setGeometry(0, 0, fRightWidget->width(), fRightWidget->height());
  fNotesListWidget->setGeometry(0, 0, fRightWidget->width(), fRightWidget->height());
  fNotesAddWidget->setGeometry(0, 0, fRightWidget->width(), fRightWidget->height());
  fNotesListView->setGeometry(0, 50, fNotesListWidget->width(), fNotesListWidget->height() -50);
}

void LowerWidget::slotWidgetSelectionSingleClicked(int id)
{
  //cout << "ID: " << id << endl;

  QString text;
  KTreeListItem* item;

  fCustomsWidget->hide();
  fDatesWidget->hide();
  fCommentWidget->hide();
  fMiscWidget->hide();
  fNotesListWidget->hide();
  fNotesAddWidget->hide();

  item = fWidgetTree->itemAt(id);

  if (item->hasChild())
    return;
  
  text = item->getText();

  if (text == "Customs")
    fCustomsWidget->show();
  else if (text == "Dates")
    fDatesWidget->show();
  else if (text == "Comment")
    fCommentWidget->show();
  else if (text == "Misc")
    fMiscWidget->show();
  else if (text == "List")
    fNotesListWidget->show();
  else if (text == "Add")
    fNotesAddWidget->show();
  
}

void LowerWidget::slotWidgetSelectionDoubleClicked(int id)
{
  KTreeListItem* item;

  fCustomsWidget->hide();
  fDatesWidget->hide();
  fCommentWidget->hide();
  fMiscWidget->hide();
  fNotesListWidget->hide();
  fNotesAddWidget->hide();

  item = fWidgetTree->itemAt(id);

  if (item->hasChild())
    fWidgetTree->expandOrCollapseItem(id);
  else
    slotWidgetSelectionSingleClicked(id);
}

#include "lowerwidget.moc"
