#ifndef LOWERWIDGET_H 
#define LOWERWIDGET_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// QT includes
#include <qwidget.h>
class QLineEdit;
class QMultiLineEdit;
class QComboBox;
class QLabel;
class QPushButton;
class QListView;

// Local includes
class PSEntry;
class DatePickerDialog;
class Splitter;
class CListView;

// KDE includes
class KTreeList;

class LowerWidget : public QWidget
{
  Q_OBJECT

public:
  /** Constructor
   */
  LowerWidget(QWidget* parent, const char* name);
  
  /** Destructor
   */
  ~LowerWidget();

  /** saves the currently viewed entry into 'entry'.
   */
  void saveCurrentlyViewedEntry(PSEntry* entry);
  
  /** sets the currently viewed entry to 'entry' by setting all the fields to
   * the proper values
   */
  void setCurrentlyViewedEntry(PSEntry* entry);

  /** Truns everything on or off, depending on state
   */
  void thereIsASelectedEntry(bool state);

protected:
  /** Overloads the resize event
   */
  void resizeEvent(QResizeEvent*);

  /** Connects all the changed signals to the correct slot
   */
  void connectChangedSignal();
  void disconnectChangedSignal();

  void init();
  void initRightWidget();
  void initLeftWidget();
  void initCustomWidget();
  void initDatesWidget();
  void initMiscWidget();
  void initNotesListWidget();
  void initNotesAddWidget();
  void initCommentWidget();
  void initWidgetTree();
  void initSplitter();

private:
  /** The panner widget that allows the view to be split into two 
   * pieces with a devider in the middle
   */
  Splitter *fSplitter;

  /** This is one of the lower halves of the panner. This widget will be the parent of
   * all the extended data fields
   */
  QWidget *fRightWidget;

  /** This is one of the lower halves of the panner. This widget will be the parent of
   * all the note elements
   */
  QWidget *fLeftWidget;

  QWidget *fCustomsWidget;
  QWidget *fDatesWidget;
  QWidget *fMiscWidget;
  QWidget *fCommentWidget;
  QWidget *fNotesListWidget;
  QWidget *fNotesAddWidget;

  KTreeList* fWidgetTree;

  /** Used to pick the dates for a field
   */
  DatePickerDialog* fDatePickerDialog;
  
  // The extended data items
  QLineEdit* fCustom1;
  QLineEdit* fCustom2;
  QLineEdit* fCustom3;
  QLineEdit* fCustom4;

  QLabel* fCustom1Label;
  QLabel* fCustom2Label;
  QLabel* fCustom3Label;
  QLabel* fCustom4Label;

  QLineEdit* fReferredBy;
  
  QLabel* fEditDate;
  QLabel* fMergeDate;
  QLabel* fLastReach;
  QLabel* fLastAttempt;
  QLabel* fLastMeeting;

  QLineEdit* fRecordCreator;
  QLabel *fCreateDate;

  QComboBox* fGroup;

  QMultiLineEdit* fComment;

  // The widgets for the notes screen
  QComboBox *fFilter;
  
  CListView *fNotesListView;
  
  QPushButton *fNewButton;
  QPushButton *fDeleteButton;

public slots:
  /** Called whenever a field changes in the view
   */
  void slotViewedEntryChanged();

  /** Called when the datepicker needs to be displayed
   */
  void slotEditLastReachDate();
  void slotEditLastMeetingDate();
  void slotEditLastAttemptDate();
  
  void slotSplitterResized();
  void slotWidgetSelectionSingleClicked(int id);
  void slotWidgetSelectionDoubleClicked(int id);

signals:
  /** Emitted when something changes and the gUnsavedData flag isn't set
   */
  void unsavedDataExists();
};

#endif
