#include "modstartdatabase.h"

// QT includes
#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qradiobutton.h>

// KDE includes
#include <kapp.h>
#include <klocale.h>

ModStartDatabase::ModStartDatabase(QWidget* parent, const char* name) : ConfigModuleBase("Database", "Startup", parent, name)
{
  KConfig* config = kapp->getConfig();
  config->setGroup("STARTUP");

  fOpenDBButtonGroup = new QButtonGroup(i18n("At startup, PeopleSpace should..."), this, "OpenDBButtonGroup");
  fOpenDBButtonGroup->setGeometry(10, 5, 270, 100);
  //  connect(fOpenDBAtStartup, SIGNAL(clicked(int)), this, SLOT(slotOpenDBAtStartupClicked(int)));

  QRadioButton* radioButton;

  radioButton = new QRadioButton(i18n("Auto open the last database used."), fOpenDBButtonGroup);
  radioButton->setGeometry(15, 20, 230, 15);
  fOpenDBButtonGroup->insert(radioButton);
  radioButton =  new QRadioButton(i18n("Never auto open a database."), fOpenDBButtonGroup);
  radioButton->setGeometry(15, 35, 230, 15);
  fOpenDBButtonGroup->insert(radioButton);
  radioButton =  new QRadioButton(i18n("Auto open the database located at:"), fOpenDBButtonGroup);
  radioButton->setGeometry(15, 50, 230, 15);
  fOpenDBButtonGroup->insert(radioButton);
  
  fOpenDBPath = new QLineEdit(fOpenDBButtonGroup, "OpenDBPath");
  fOpenDBPath->setGeometry(25, 70, 230, 20);
  fOpenDBPath->setText(config->readEntry("OpenDBPath", ""));

  fOpenDB = config->readNumEntry("OpenDB", 1);
  fOpenDBButtonGroup->setButton(fOpenDB);
  slotOpenDBChanged(fOpenDB);
  connect(fOpenDBButtonGroup, SIGNAL(clicked(int)), this, SLOT(slotOpenDBChanged(int)));
  
}

ModStartDatabase::~ModStartDatabase()
{
}

void ModStartDatabase::saveOptions()
{
  KConfig* config = kapp->getConfig();

  config->setGroup("STARTUP");
  config->writeEntry("OpenDB", fOpenDB);
  config->writeEntry("OpenDBPath", fOpenDBPath->text());

  config->sync();
}

//////////////////////////////////////////////
///////////////// SLOTS //////////////////////
void ModStartDatabase::slotOpenDBChanged(int id)
{
  fOpenDB = id;
}

#include "modstartdatabase.moc"
