#ifndef PSASSOCIATE_H 
#define PSASSOCIATE_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

//QT includes
#include <qwidget.h>
#include <qevent.h>
#include <qlist.h>
#include <qdialog.h>
#include <qlistview.h>

// Local Includes
#include "listview.h"
class PSDatabaseManager;

/**
 * This class is the main view for PSAssociate.  Most non-menu, non-toolbar,
 * and non-status bar GUI code should go here.
 *
 * @short Main view
 * @author Mike Pilone <mpilone@slac.com>
 * @version 0.1
 */
class PSAssociate : public QDialog
{
	Q_OBJECT
public:
	/**
	 * Default constructor
	 */
	PSAssociate(PSDatabaseManager* psDatabaseManager, QWidget *parent = 0, const char *name = 0);

	/**
	 * Destructor
	 */
	virtual ~PSAssociate();

  /** Clears the list view
   */
  void clearList();

  /** sets the four columns of the list view
   */
  void setListView( QList<QString>* field1List,  
		       QList<QString>* field2List,  
		       QList<QString>* field3List,  
		       QList<QString>* keyFieldList);

  void changeSelectedEntry(int direction);

  /** Returns the key of the selected entry, or -1 if it doesn't exist
   */
  int selectedEntry();

protected:
  CListView* fContactListView;

  PSDatabaseManager* fPSDatabaseManager;

  void addItem(QString, QString, QString, QString);

  void resizeEvent(QResizeEvent*);

public slots:
  void slotGroupFilterApplied(int, 
			      QList<QString>*,  
			      QList<QString>*,  
			      QList<QString>*,  
			      QList<QString>*);
 /** Called whenever the dtabase manager emits a darabase has opend signal.
   * This function maks sure all the proper options are turned back on and
   * the status bar shows the proper text
   */
  void slotDatabaseHasOpened(QString pathWithFile, int flag);
  void slotDatabaseHasClosed();

  void slotSelectionChanged ( QListViewItem * );

signals:
  void entrySelected(int key, bool first, bool last);
};

#endif // PSASSOCIATE_H 
