// Local includes
#include "psdatabasemanager.h"
#include "databaseinterface.h"
#include "listdialog.h"
#include "databaseentry.h"
#include "resource.h"

// KDE includes
#include <kapp.h>
#include <kconfig.h>
#include <kstatusbar.h>

// Stdlib includes
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>


PSDatabaseManager::PSDatabaseManager()
{
  KConfig* config = kapp->getConfig();

  fDBInterface = new DBInterface;
  config->setGroup("DEFAULTS");
  fDBInterface->setStoragePolicy((storagePolicy)config->readNumEntry("StoragePolicy", 0));

  fColumn1 = new QList<QString>;
  fColumn2 = new QList<QString>;
  fColumn3 = new QList<QString>;
  fColumn4 = new QList<QString>;

  fColumn1->setAutoDelete( TRUE );
  fColumn2->setAutoDelete( TRUE );
  fColumn3->setAutoDelete( TRUE );
  fColumn4->setAutoDelete( TRUE );

}

PSDatabaseManager::~PSDatabaseManager()
{
  delete( fColumn1 );
  delete( fColumn2 );
  delete( fColumn3 );
  delete( fColumn4 );

  delete(fDBInterface);
}

void PSDatabaseManager::applyGroupFilter(int groupFilter)
{
  int key = 100;

  int largestKey = fDBInterface->largestKey();

  fColumn1->clear();
  fColumn2->clear();
  fColumn3->clear();
  fColumn4->clear();
  
  // Check to see if this is a search or just a normal group filter
  if (groupFilter == ID_SEARCH_RESULTS)
    {
      applySearchFilter();
      return;
    }
     
  // Check the group filter
  if (groupFilter != (PSEntry::groupUnfiled+1))
    {
      while (key <= largestKey)
	{
	  if ((fDBInterface->exists(key)) && (fDBInterface->fetchInt(key+field_group) == groupFilter))
	    {
	      addEntryToColumnLists(key);
	    }
	  key += 100;
	}
    }
  
  else
    {
      
      while (key <= largestKey)
	{
	  if (fDBInterface->exists(key))
	    {
	      addEntryToColumnLists(key);
	    }
	  key += 100;
	}
      
    }

  emit groupFilterApplied(groupFilter, fColumn1, fColumn2, fColumn3, fColumn4);
}

void PSDatabaseManager::applySearchFilter(int fieldOffset, QString param1, QString param2)
{
  KConfig* config = kapp->getConfig();

  if (fieldOffset == -1)
    {
      // We need to load the search fields from config
      config->setGroup("SEARCHFILTER");
      if (!config->hasKey("FieldOffset"))
	{
	  emit groupFilterApplied(ID_SEARCH_RESULTS, fColumn1, fColumn2, fColumn3, fColumn4);
	  return;
	}
      fieldOffset = config->readNumEntry("FieldOffset", -1);
      param1 = config->readEntry("Param1", "");
      param2 = config->readEntry("Param2", "");
    }
  else
    {
       config->setGroup("SEARCHFILTER");
       config->writeEntry("FieldOffset", fieldOffset);
       config->writeEntry("Param1", param1);
       config->writeEntry("Param2", param2);
    }
  
  fColumn1->clear();
  fColumn2->clear();
  fColumn3->clear();
  fColumn4->clear();

  int key = 100;
  int largestKey = fDBInterface->largestKey();

  // Now search the database
  while (key <= largestKey)
    {
      if ((fDBInterface->exists(key)) && (fDBInterface->fetchString(key+fieldOffset) == param1))
	{
	  addEntryToColumnLists(key);
	}
      key += 100;
    }

  emit groupFilterApplied(ID_SEARCH_RESULTS, fColumn1, fColumn2, fColumn3, fColumn4);
}

bool PSDatabaseManager::openDB(QString pathWithFile, dbOpenType flag)
{
  bool success = FALSE;

  success = fDBInterface->openDB(pathWithFile, flag);

  if (success)
    emit databaseHasOpened(pathWithFile, flag);

  else
    emit databaseHasOpened("", -1);

  return success;
}

void PSDatabaseManager::closeDB()
{
  if (fDBInterface->closeDB())
    emit databaseHasClosed();
}

int PSDatabaseManager::createNewEntry()
{
  PSEntry* psEntry = new PSEntry(NULL);
 
  storeEntry(psEntry);
  
  fLoadedEntryList.append(psEntry);

  return psEntry->key();
}

void PSDatabaseManager::storeEntry(PSEntry* psEntry)
{
 
  fDBInterface->storeEntry(psEntry->getDBEntry());

  psEntry->sync();

  // Once stored we can reset it to unmodified
  psEntry->setModified( FALSE );
}


void PSDatabaseManager::storeEntryList()
{
  
  int largestKey = fDBInterface->largestKey();

  
  PSEntry *entry = fLoadedEntryList.first();
  
  while (entry != NULL)
    {
      if (entry->modified())
	{
	  if (entry->deleteMe())
	    {
	      //cout << "Deleting entry: " << entry->key() << endl;
	      fDBInterface->deleteEntry(entry->key());
	      if (entry->key() == largestKey)
		{
		  //cout << "Entry does equal largest Key" << endl;
		  largestKey = getNextLargestKey();
		  fDBInterface->setLargestKey(largestKey);
		} 
	      
 	      fLoadedEntryList.remove(entry);
 	      delete(entry);
 	      entry = fLoadedEntryList.current();
 	    }
  	  
	  else
	    {
	      fDBInterface->storeEntry(entry->getDBEntry());
 	      entry->setModified( FALSE );
 	      entry = fLoadedEntryList.next();
 	    }
 	}
      
      else
 	{
 	  entry = fLoadedEntryList.next();
 	}
    }  
}

PSEntry* PSDatabaseManager::fetchEntry(int key)
{
  bool found = false;
  // Check to see if the desired entry is loaded
  PSEntry* entry = fLoadedEntryList.first();
  
  while ((entry != NULL) && (!found))
    {
      if (entry->key() == key)
	found = TRUE;
      
      else
	entry = fLoadedEntryList.next();
    }
  
  if (!found)
    {
      entry = new PSEntry(fDBInterface->fetchEntry(key));
      fLoadedEntryList.append(entry);
    }

  return entry;
}

void PSDatabaseManager::addEntryToColumnLists(int key)
{
  QString *field1 = new QString; 
  QString *field2 = new QString;
  QString *field3 = new QString;
  QString *keyField = new QString;

  //cout << "LastNAme: " << fDBInterface->fetchString(key+FIELD_LASTNAME) << endl;
  *field1 = fDBInterface->fetchString(key+field_lastname);
  *field1 += ", ";
  *field1 += fDBInterface->fetchString(key+field_firstname);
  
  *field2 = "";//fDBInterface->fetchString(key+3);
  *field3 = "";//fDBInterface->fetchString(key+4);
  
  keyField->sprintf("%d", key);
  
  fColumn1->append(field1);
  fColumn2->append(field2);
  fColumn3->append(field3);
  fColumn4->append(keyField);
}

dbOpenType PSDatabaseManager::openDBType()
{
  return fDBInterface->openDBType();
}

int PSDatabaseManager::getNextLargestKey()
{
  int largestKey = fDBInterface->largestKey() - 100;
  
  while (largestKey >= 100)
    {
      if (fDBInterface->exists(largestKey))
	{
	  return largestKey;
	}

      largestKey -= 100;
    }

  return 0;
}



void PSDatabaseManager::setSelectedEntry(int key, bool isNext, bool isPrev)
{
  bool found = FALSE;

  if (key == -1)
    {
      emit setViewedEntry(NULL, FALSE, FALSE);
    }

  else
    { 
      // Check to see if the desired entry is loaded
      PSEntry* entry = fLoadedEntryList.first();

      while ((entry != NULL) && (!found))
	{
	  if (entry->key() == key)
	    found = TRUE;
	  
	  else
	    entry = fLoadedEntryList.next();
	}
      
      if (found)
	 emit setViewedEntry(entry, isNext, isPrev);

      else
	{
	  entry = fetchEntry(key);
	  fLoadedEntryList.append(entry);
	  
	  emit setViewedEntry(entry, isNext, isPrev);
	}
    }
}

#include "psdatabasemanager.moc"
