#ifndef PS_ENTRYVIEWER_H 
#define PS_ENTRYVIEWER_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// KDE includes
#include <kapp.h>
class KNewPanner;

// QT includes
#include <qwidget.h>
class QLineEdit;
class QMultiLineEdit;
class QComboBox;
class QSplitter;

// Local includes
#include "resource.h"
class UpperWidget;
class LowerWidget;
class PSEntry;
class PSDatabaseManager;
class DatePickerDialog;

/**
 * This class serves as the main view for PeopleSpace.  It handles the contents of
 * the main window.
 *
 * @short Main view class
 * @author Mike Pilone <mpilone@slac.com>
 */
class PSEntryViewer : public QWidget
{
  Q_OBJECT

public:
  /** Constructor
   */
  PSEntryViewer(PSDatabaseManager* databaseManager, QWidget *parent = 0, const char *name = 0);

  /** Destructor
   */
  ~PSEntryViewer();

  /** Saves any options having to do with the view. This should be called
   * when the program exits
   */
  void saveYourself();

  /** Disables or enables the widgets depending on the param
   */
  void thereIsASelectedEntry(bool state);

  /** saves the currently viewed entry into 'entry'. If 'entry' is NULL
   * the method returns assuming there was not a viewed entry
   */
  void saveCurrentlyViewedEntry();

  /** sets the currently viewed entry to 'entry' by setting all the fields to
   * the proper values
   */
  void setCurrentlyViewedEntry(PSEntry* entry);

 /** sets the current entry marked for deletion. This basically just toggles
   * the palette color of the delete button
   */
  void setCurrentlyViewedEntryDeleted();

  /** Returns the currently viewed entry. This could be NULL
   */
  PSEntry* currentlyViewedEntry() { return fViewedEntry; };

protected:
  void resizeEvent ( QResizeEvent * ) ;

private:
  /** The panner widget that allows the view to be split into two 
   * pieces with a devider in the middle
   */
  //  KNewPanner *fPanner;
  QSplitter* fSplitter;

  /** This is the upper half of the panner. This widget will be the parent of all the
   * individual field widgets.
   */
  UpperWidget *fUpperWidget;

  /** This the lower half of the panner. This widget will be the parent of
   * the individual lower halves.
   */
  LowerWidget *fLowerWidget;

  PSDatabaseManager* fPSDatabaseManager;

  PSEntry *fViewedEntry;

  bool fViewedEntryModified;

public slots:
  /** called whenever one of the widget emits a unsavedDataExists()
   */
  void slotUnsavedDataExists();

  void slotSetViewedEntry(PSEntry*, bool, bool);


signals:
  /** Emitted whenever something in the view changes. This means something on
   * the screen has changed
   */
  void unsavedDataExists();

};

#endif // PS_ENTRYVIEWER_H
