#ifndef UPPERWIDGET_H 
#define UPPERWIDGET_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// QT includes
#include <qwidget.h>
class QLineEdit;
class QMultiLineEdit;
class QComboBox;
class QLabel;

// Local includes
class PSEntry;

class UpperWidget : public QWidget
{
  Q_OBJECT

public:
  /** Constructor
   */
  UpperWidget(QWidget* parent, const char* name);
  
  /** Destructor
   */
  ~UpperWidget();

  /** saves the currently viewed entry into 'entry'.
   */
  void saveCurrentlyViewedEntry(PSEntry* entry);

  /** sets the currently viewed entry to 'entry' by setting all the fields to
   * the proper values
   */
  void setCurrentlyViewedEntry(PSEntry* entry);

  /** sets the current entry marked for deletion. This basically just toggles
   * the palette color of the delete button
   */
  void setCurrentlyViewedEntryDeleted(bool state);

  void setCurrentlyViewedEntryModified();

   /** Truns everything on or off, depending on state
   */
  void thereIsASelectedEntry(bool state);

protected:
  /** Overloads the resize event
   */
  void resizeEvent(QResizeEvent*);

 /** Adds all the fields and sets the correct flag for the 
   * combo box to work correctly.
   */
  void initPhoneTypeComboBox(QComboBox* phoneType, int fieldNum);

  /** Connects the textChanged signal in all the fields to the proper slot
   */
  void connectChangedSignal();
  void disconnectChangedSignal();

private:

  ////////////////////////////////////////////////////////
  // The entry fields
  QLineEdit* fLastName;
  QLineEdit* fFirstName;
  
  QLineEdit* fTitle;
  QLineEdit* fCompany;

  QLineEdit* fAddress;
  QLineEdit* fCity;
  QLineEdit* fState;
  QLineEdit* fZip;
  QLineEdit* fCountry;

  QLineEdit* fPhone1;
  QLineEdit* fPhone2;
  QLineEdit* fPhone3;
  QLineEdit* fPhone4;
  QLineEdit* fPhone5;

  QComboBox* fPhone1Type;
  QComboBox* fPhone2Type;
  QComboBox* fPhone3Type;
  QComboBox* fPhone4Type;
  QComboBox* fPhone5Type;

  QLabel* fModified;
  QLabel* fDeleteMe;

public slots:
 /** Called whenever a field changes in the view
   */
  void slotViewedEntryChanged();

signals:
  /** Emitted when something changes and the gUnsavedData flag isn't set
   */
  void unsavedDataExists();
};

#endif
